/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFYearDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFYearString;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFYearTimestamp;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="year", value="_FUNC_(param) - Returns the year component of the date/timestamp/interval", extended="param can be one of:\n1. A string in the format of 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'.\n2. A date value\n3. A timestamp value\n4. A year-month interval valueExample:\n   > SELECT _FUNC_('2009-07-30') FROM src LIMIT 1;\n  2009")
@VectorizedExpressions(value={VectorUDFYearDate.class, VectorUDFYearString.class, VectorUDFYearTimestamp.class})
public class UDFYear
extends UDF {
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private final Calendar calendar = Calendar.getInstance();
    private final IntWritable result = new IntWritable();

    public IntWritable evaluate(Text dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            Date date = this.formatter.parse(dateString.toString());
            this.calendar.setTime(date);
            this.result.set(this.calendar.get(1));
            return this.result;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public IntWritable evaluate(DateWritable d) {
        if (d == null) {
            return null;
        }
        this.calendar.setTime(d.get(false));
        this.result.set(this.calendar.get(1));
        return this.result;
    }

    public IntWritable evaluate(TimestampWritable t) {
        if (t == null) {
            return null;
        }
        this.calendar.setTime(t.getTimestamp());
        this.result.set(this.calendar.get(1));
        return this.result;
    }

    public IntWritable evaluate(HiveIntervalYearMonthWritable i) {
        if (i == null) {
            return null;
        }
        this.result.set(i.getHiveIntervalYearMonth().getYears());
        return this.result;
    }
}

