/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;

public class HSQLDBDDLGenerator
extends GenericDDLGenerator {
    public static final String GENERATOR_VERSION = "$Revision: 2933 $";
    private final String REGEX_CRLF = "(\r\n|\n\r|\r|\n)";

    @Override
    public String getName() {
        return "HSQLDB";
    }

    @Override
    public String getCatalogTerm() {
        return null;
    }

    @Override
    public String getSchemaTerm() {
        return "Schema";
    }

    @Override
    public String columnType(SQLColumn c) {
        if (c.isAutoIncrement()) {
            return "IDENTITY";
        }
        return super.columnType(c);
    }

    @Override
    protected String getPlatformName() {
        return "HSQLDB";
    }

    @Override
    public String getDeferrabilityClause(SQLRelationship r) {
        if (this.supportsDeferrabilityPolicy(r)) {
            return "";
        }
        throw new UnsupportedOperationException(this.getName() + " does not support " + r.getName() + "'s deferrability policy (" + r.getDeferrability() + ").");
    }

    @Override
    public boolean supportsDeferrabilityPolicy(SQLRelationship r) {
        if (!Arrays.asList(SQLRelationship.Deferrability.values()).contains(r.getDeferrability())) {
            throw new IllegalArgumentException("Unknown deferrability policy: " + r.getDeferrability());
        }
        return r.getDeferrability() == SQLRelationship.Deferrability.NOT_DEFERRABLE;
    }

    @Override
    protected void createTypeMap() throws SQLException {
        this.typeMap = new HashMap();
        this.typeMap.put(-5, new GenericTypeDescriptor("BIGINT", -5, 1000L, null, null, 1, true, false));
        this.typeMap.put(-2, new GenericTypeDescriptor("BINARY", -2, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(-7, new GenericTypeDescriptor("BIT", -7, 1L, null, null, 1, true, false));
        this.typeMap.put(2004, new GenericTypeDescriptor("LONGVARBINARY", 2004, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(16, new GenericTypeDescriptor("BOOLEAN", 16, 1L, null, null, 1, false, false));
        this.typeMap.put(1, new GenericTypeDescriptor("CHAR", 1, 4000000000L, "'", "'", 1, true, false));
        this.typeMap.put(2005, new GenericTypeDescriptor("LONGVARCHAR", 2005, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(91, new GenericTypeDescriptor("DATE", 91, 0L, "'", "'", 1, false, false));
        this.typeMap.put(3, new GenericTypeDescriptor("DECIMAL", 3, 1000L, null, null, 1, true, true));
        this.typeMap.put(8, new GenericTypeDescriptor("DOUBLE", 8, 38L, null, null, 1, false, false));
        this.typeMap.put(6, new GenericTypeDescriptor("FLOAT", 6, 38L, null, null, 1, false, false));
        this.typeMap.put(4, new GenericTypeDescriptor("INTEGER", 4, 38L, null, null, 1, false, false));
        this.typeMap.put(-4, new GenericTypeDescriptor("LONGVARBINARY", -4, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(-1, new GenericTypeDescriptor("LONGVARCHAR", -1, 4000000000L, "'", "'", 1, false, false));
        this.typeMap.put(2, new GenericTypeDescriptor("NUMERIC", 2, 1000L, null, null, 1, true, true));
        this.typeMap.put(7, new GenericTypeDescriptor("REAL", 7, 38L, null, null, 1, false, false));
        this.typeMap.put(5, new GenericTypeDescriptor("SMALLINT", 5, 16L, null, null, 1, false, false));
        this.typeMap.put(92, new GenericTypeDescriptor("TIME", 92, 0L, "'", "'", 1, false, false));
        this.typeMap.put(93, new GenericTypeDescriptor("TIMESTAMP", 93, 0L, "'", "'", 1, false, false));
        this.typeMap.put(-6, new GenericTypeDescriptor("TINYINT", -6, 16L, null, null, 1, false, false));
        this.typeMap.put(-3, new GenericTypeDescriptor("VARBINARY", -3, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(12, new GenericTypeDescriptor("VARCHAR", 12, 4000000000L, "'", "'", 1, true, false));
    }

    @Override
    public boolean supportsUpdateAction(SQLRelationship r) {
        return r.getUpdateRule() != SQLRelationship.UpdateDeleteRule.RESTRICT;
    }

    @Override
    public String getUpdateActionClause(SQLRelationship r) {
        if (r.getUpdateRule() == SQLRelationship.UpdateDeleteRule.RESTRICT) {
            throw new IllegalArgumentException("Unsupported update action: " + r.getUpdateRule());
        }
        return super.getUpdateActionClause(r);
    }

    @Override
    public boolean supportsDeleteAction(SQLRelationship r) {
        return r.getDeleteRule() != SQLRelationship.UpdateDeleteRule.RESTRICT;
    }

    @Override
    public String getDeleteActionClause(SQLRelationship r) {
        if (r.getDeleteRule() == SQLRelationship.UpdateDeleteRule.RESTRICT) {
            throw new IllegalArgumentException("Unsupported update action: " + r.getDeleteRule());
        }
        return super.getDeleteActionClause(r);
    }

    public String toString() {
        return "SQL Power HSQLDB DDL Generator $Revision: 2933 $";
    }

    @Override
    public void addComment(SQLTable t, boolean includeColumns) {
        if (t.getRemarks() != null && t.getRemarks().trim().length() > 0) {
            this.print("\n-- Comment for table [" + this.getPhysicalName((SQLObject)t) + "]: ");
            this.print(t.getRemarks().replaceAll("(\r\n|\n\r|\r|\n)", "\n-- "));
            this.endStatement(DDLStatement.StatementType.COMMENT, (SQLObject)t);
            if (includeColumns) {
                this.addColumnComments(t);
            }
        }
    }

    @Override
    public void addComment(SQLColumn c) {
        if (c.getRemarks() == null || c.getRemarks().trim().length() == 0) {
            return;
        }
        this.print("\n-- Comment for column [");
        this.print(c.getName());
        this.print("]: ");
        this.print(c.getRemarks().replaceAll("(\r\n|\n\r|\r|\n)", "\n-- "));
        this.endStatement(DDLStatement.StatementType.COMMENT, (SQLObject)c);
    }

    @Override
    public void renameColumn(SQLColumn oldCol, SQLColumn newCol) {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        this.print("\nALTER TABLE ");
        this.print(this.toQualifiedName(oldCol.getParent()));
        this.print(" ALTER COLUMN ");
        this.print(this.createPhysicalName(colNameMap, (SQLObject)oldCol));
        this.print(" RENAME TO ");
        this.print(this.createPhysicalName(colNameMap, (SQLObject)newCol));
        this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)newCol);
    }
}

