/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.diff.DiffChunk;
import ca.sqlpower.sqlobject.SQLCheckConstraint;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLEnumeration;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.sqlobject.SQLTypePhysicalProperties;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MySqlDDLGenerator
extends GenericDDLGenerator {
    public static final String GENERATOR_VERSION = "$Revision$";
    private static final boolean DOWNCASE_IDENTIFIERS = Boolean.parseBoolean(System.getProperty("ca.sqlpower.architect.ddl.MySqlDDLGenerator.DOWNCASE_IDENTIFIERS", "true"));
    private static final Logger logger = Logger.getLogger(MySqlDDLGenerator.class);
    public static final HashSet<String> RESERVED_WORDS = new HashSet();

    @Override
    public String getName() {
        return "MySQL";
    }

    @Override
    protected void createTypeMap() throws SQLException {
        this.typeMap = new HashMap();
        this.typeMap.put(-5, new GenericTypeDescriptor("BIGINT", -5, 38L, null, null, 1, true, false));
        this.typeMap.put(-7, new GenericTypeDescriptor("TINYINT", -7, 1L, null, null, 1, true, false));
        this.typeMap.put(2004, new GenericTypeDescriptor("LONGBLOB", 2004, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(1, new GenericTypeDescriptor("CHAR", 1, 2000L, "'", "'", 1, true, false));
        this.typeMap.put(2005, new GenericTypeDescriptor("LONGTEXT", 2005, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(16, new GenericTypeDescriptor("BOOLEAN", 16, 1L, null, null, 1, false, false));
        this.typeMap.put(91, new GenericTypeDescriptor("DATE", 91, 0L, "'", "'", 1, false, false));
        this.typeMap.put(3, new GenericTypeDescriptor("DECIMAL", 3, 38L, null, null, 1, true, true));
        this.typeMap.put(8, new GenericTypeDescriptor("DOUBLE PRECISION", 8, 38L, null, null, 1, false, false));
        this.typeMap.put(6, new GenericTypeDescriptor("DOUBLE PRECISION", 6, 38L, null, null, 1, false, false));
        this.typeMap.put(4, new GenericTypeDescriptor("INT", 4, 38L, null, null, 1, true, false));
        this.typeMap.put(2, new GenericTypeDescriptor("NUMERIC", 2, 38L, null, null, 1, true, true));
        this.typeMap.put(7, new GenericTypeDescriptor("DOUBLE PRECISION", 7, 38L, null, null, 1, false, false));
        this.typeMap.put(5, new GenericTypeDescriptor("SMALLINT", 5, 38L, null, null, 1, true, false));
        this.typeMap.put(92, new GenericTypeDescriptor("TIME", 92, 0L, "'", "'", 1, false, false));
        this.typeMap.put(93, new GenericTypeDescriptor("DATETIME", 93, 0L, "'", "'", 1, false, false));
        this.typeMap.put(-6, new GenericTypeDescriptor("TINYINT", -6, 38L, null, null, 1, true, false));
        this.typeMap.put(-2, new GenericTypeDescriptor("BINARY", -2, 65535L, null, null, 1, true, false));
        this.typeMap.put(-4, new GenericTypeDescriptor("VARBINARY", -4, 65535L, null, null, 1, true, false));
        this.typeMap.put(-3, new GenericTypeDescriptor("VARBINARY", -3, 65535L, null, null, 1, true, false));
        this.typeMap.put(-1, new GenericTypeDescriptor("TEXT", -1, 65535L, "'", "'", 1, false, false));
        this.typeMap.put(12, new GenericTypeDescriptor("VARCHAR", 12, 65535L, "'", "'", 1, true, false));
    }

    @Override
    public String toIdentifier(String name) {
        if (name != null && DOWNCASE_IDENTIFIERS) {
            name = name.toLowerCase();
        }
        return super.toIdentifier(name);
    }

    @Override
    public boolean isReservedWord(String word) {
        return RESERVED_WORDS.contains(word.toUpperCase());
    }

    @Override
    public String getCatalogTerm() {
        return "Database";
    }

    @Override
    public String getSchemaTerm() {
        return null;
    }

    @Override
    public void renameTable(SQLTable oldTable, SQLTable newTable) {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>(0);
        this.println("RENAME TABLE " + this.createPhysicalName(colNameMap, (SQLObject)oldTable) + " TO " + this.createPhysicalName(colNameMap, (SQLObject)newTable));
        this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)newTable);
    }

    @Override
    public void renameColumn(SQLColumn oldCol, SQLColumn newCol) {
        HashMap<String, SQLObject> empty = new HashMap<String, SQLObject>(0);
        this.print("ALTER TABLE ");
        this.print(this.createPhysicalName(empty, (SQLObject)oldCol.getParent()));
        this.print(" CHANGE ");
        HashMap<String, SQLObject> cols = new HashMap<String, SQLObject>();
        try {
            for (SQLColumn col : oldCol.getParent().getColumns()) {
                cols.put(this.getPhysicalName((SQLObject)col), (SQLObject)col);
            }
        }
        catch (SQLObjectException e) {
            // empty catch block
        }
        this.print(this.createPhysicalName(cols, (SQLObject)newCol));
        this.print(" ");
        this.print(this.columnDefinition(newCol, cols));
        this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)newCol);
    }

    @Override
    public void renameRelationship(SQLRelationship oldFK, SQLRelationship newFK) {
        this.println("/* Renaming foreign key " + oldFK.getPhysicalName() + " to " + newFK.getPhysicalName() + " */");
        this.dropRelationship(oldFK);
        this.addRelationship(newFK);
    }

    @Override
    public void renameIndex(SQLIndex oldIndex, SQLIndex newIndex) throws SQLObjectException {
        this.println("/* Renaming index " + oldIndex.getPhysicalName() + " to " + newIndex.getPhysicalName() + " */");
        this.dropIndex(oldIndex);
        this.addIndex(newIndex);
    }

    @Override
    protected void writePKConstraintClause(SQLIndex pk) throws SQLObjectException {
        if (!pk.isPrimaryKeyIndex()) {
            throw new IllegalArgumentException("The given index is not a primary key");
        }
        this.createPhysicalName(this.topLevelNames, (SQLObject)pk);
        this.print("PRIMARY KEY (");
        boolean firstCol = true;
        for (SQLIndex.Column col : pk.getChildren(SQLIndex.Column.class)) {
            if (!firstCol) {
                this.print(", ");
            }
            this.print(this.getPhysicalName((SQLObject)col));
            firstCol = false;
        }
        this.print(")");
    }

    @Override
    public void dropPrimaryKey(SQLTable t) {
        this.print("\nALTER TABLE " + this.toQualifiedName(t.getName()) + " DROP PRIMARY KEY");
        this.endStatement(DDLStatement.StatementType.DROP, (SQLObject)t);
    }

    @Override
    public void dropRelationship(SQLRelationship r) {
        this.print("\nALTER TABLE ");
        this.print(this.toQualifiedName(r.getFkTable()));
        this.print(" DROP FOREIGN KEY ");
        this.print(r.getName());
        this.endStatement(DDLStatement.StatementType.DROP, (SQLObject)r);
    }

    @Override
    protected String columnDefinition(SQLColumn c, Map<String, SQLObject> colNameMap) {
        StringBuffer def = new StringBuffer();
        def.append(this.createPhysicalName(colNameMap, (SQLObject)c));
        def.append(" ");
        def.append(this.columnType(c));
        UserDefinedSQLType type = c.getUserDefinedSQLType();
        String defaultValue = type.getDefaultValue(this.getPlatformName());
        if (defaultValue != null && !defaultValue.equals("")) {
            def.append(" ");
            def.append("DEFAULT ");
            def.append(defaultValue);
        }
        def.append(this.columnNullability(c));
        logger.debug((Object)("column definition " + def.toString()));
        return def.toString();
    }

    @Override
    public String columnType(SQLColumn c) {
        UserDefinedSQLType udt = c.getUserDefinedSQLType();
        String type = udt.getConstraintType(this.getPlatformName()) == SQLTypePhysicalProperties.SQLTypeConstraint.ENUM ? this.columnEnumeration(c, udt.getEnumerations(this.getPlatformName())) : super.columnType(c);
        if (c.isAutoIncrement()) {
            type = type + " AUTO_INCREMENT";
        }
        return type;
    }

    @Override
    protected String columnCheckConstraint(SQLColumn c, List<SQLCheckConstraint> checkConstraints) {
        return "";
    }

    @Override
    protected String columnEnumToCheckConstraint(SQLColumn c, List<SQLEnumeration> enumerations) {
        return "";
    }

    @Override
    protected String columnEnumeration(SQLColumn c, List<SQLEnumeration> enumerations) {
        if (enumerations == null || enumerations.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (SQLEnumeration enumeration : enumerations) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'" + enumeration.getName() + "'");
        }
        return "ENUM(" + sb.toString() + ")";
    }

    @Override
    public boolean supportsCheckConstraint() {
        return false;
    }

    @Override
    public boolean supportsEnumeration() {
        return true;
    }

    @Override
    protected String getPlatformName() {
        return "MySQL";
    }

    @Override
    public void addIndex(SQLIndex index) throws SQLObjectException {
        this.createPhysicalName(this.topLevelNames, (SQLObject)index);
        this.println("");
        this.print("CREATE ");
        if (index.isUnique()) {
            this.print("UNIQUE ");
        }
        this.print("INDEX ");
        this.print(this.toIdentifier(index.getName()));
        if (index.getType() != null) {
            this.print(" USING " + index.getType());
        }
        this.print("\n ON ");
        this.print(this.toQualifiedName(index.getParent()));
        this.print("\n ( ");
        boolean first = true;
        for (SQLIndex.Column c : index.getChildren(SQLIndex.Column.class)) {
            if (!first) {
                this.print(", ");
            }
            if (c.getColumn() != null) {
                this.print(this.getPhysicalName((SQLObject)c.getColumn()));
            } else {
                this.print(c.getName());
            }
            this.print(c.getAscendingOrDescending() == SQLIndex.AscendDescend.ASCENDING ? " ASC" : "");
            this.print(c.getAscendingOrDescending() == SQLIndex.AscendDescend.DESCENDING ? " DESC" : "");
            first = false;
        }
        this.print(" )");
        this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)index);
    }

    @Override
    public String getDeferrabilityClause(SQLRelationship r) {
        if (this.supportsDeferrabilityPolicy(r)) {
            return "";
        }
        throw new UnsupportedOperationException(this.getName() + " does not support " + r.getName() + "'s deferrability policy (" + r.getDeferrability() + ").");
    }

    @Override
    public boolean supportsDeferrabilityPolicy(SQLRelationship r) {
        if (!Arrays.asList(SQLRelationship.Deferrability.values()).contains(r.getDeferrability())) {
            throw new IllegalArgumentException("Unknown deferrability policy: " + r.getDeferrability());
        }
        return r.getDeferrability() == SQLRelationship.Deferrability.NOT_DEFERRABLE;
    }

    @Override
    public boolean supportsDeleteAction(SQLRelationship r) {
        return r.getDeleteRule() != SQLRelationship.UpdateDeleteRule.SET_DEFAULT;
    }

    @Override
    public String getDeleteActionClause(SQLRelationship r) {
        if (r.getDeleteRule() == SQLRelationship.UpdateDeleteRule.SET_DEFAULT) {
            throw new IllegalArgumentException("Unsupported delete action: " + r.getDeleteRule());
        }
        return super.getDeleteActionClause(r);
    }

    @Override
    public boolean supportsUpdateAction(SQLRelationship r) {
        return r.getUpdateRule() != SQLRelationship.UpdateDeleteRule.SET_DEFAULT;
    }

    @Override
    public String getUpdateActionClause(SQLRelationship r) {
        if (r.getUpdateRule() == SQLRelationship.UpdateDeleteRule.SET_DEFAULT) {
            throw new IllegalArgumentException("Unsupported update action: " + r.getUpdateRule());
        }
        return super.getUpdateActionClause(r);
    }

    @Override
    public void addComment(SQLTable t, boolean includeColumns) {
        if (t.getRemarks() != null && t.getRemarks().trim().length() > 0) {
            this.print("\nALTER TABLE ");
            this.print(this.toQualifiedName(t));
            this.print(" COMMENT '");
            this.print(t.getRemarks().replaceAll("'", "''"));
            this.print("'");
            this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)t);
        }
        if (includeColumns) {
            this.addColumnComments(t);
        }
    }

    @Override
    public void addComment(SQLColumn c) {
        if (c.getRemarks() != null && c.getRemarks().trim().length() > 0) {
            this.print("\nALTER TABLE ");
            this.print(this.toQualifiedName(c.getParent()));
            this.print(" MODIFY COLUMN ");
            this.print(this.getPhysicalName((SQLObject)c));
            this.print(" ");
            this.print(c.getTypeName());
            this.print(" COMMENT '");
            this.print(c.getRemarks().replaceAll("'", "''"));
            this.print("'");
            this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)c);
        }
    }

    @Override
    public void addColumn(SQLColumn c) {
        block4: {
            HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
            this.print("\nALTER TABLE ");
            this.print(this.toQualifiedName(c.getParent()));
            this.print(" ADD COLUMN ");
            this.print(this.columnDefinition(c, colNameMap));
            try {
                int colPosition = c.getParent().getChildren().indexOf(c);
                if (colPosition == 0) {
                    this.print(" FIRST");
                    break block4;
                }
                if (colPosition > 0) {
                    SQLObject precedingColumn = c.getParent().getChild(colPosition - 1);
                    this.print(" AFTER " + this.getPhysicalName(precedingColumn));
                    break block4;
                }
                throw new IllegalStateException("Column " + c + " is not a child of its parent!" + " Children are: " + c.getParent().getChildren());
            }
            catch (SQLObjectException ex) {
                throw new SQLObjectRuntimeException(ex);
            }
        }
        this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)c);
    }

    @Override
    public void modifyColumn(SQLColumn c, DiffChunk<SQLObject> diffChunk) {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        SQLTable t = c.getParent();
        this.print("\nALTER TABLE ");
        this.print(this.toQualifiedName(t));
        this.print(" MODIFY COLUMN ");
        this.print(this.columnDefinition(c, colNameMap));
        this.endStatement(DDLStatement.StatementType.MODIFY, (SQLObject)c);
    }

    @Override
    public boolean supportsRollback() {
        return false;
    }

    static {
        RESERVED_WORDS.add("ADD");
        RESERVED_WORDS.add("ALL");
        RESERVED_WORDS.add("ALTER");
        RESERVED_WORDS.add("ANALYZE");
        RESERVED_WORDS.add("AND");
        RESERVED_WORDS.add("AS");
        RESERVED_WORDS.add("ASC");
        RESERVED_WORDS.add("ASENSITIVE");
        RESERVED_WORDS.add("BEFORE");
        RESERVED_WORDS.add("BETWEEN");
        RESERVED_WORDS.add("BIGINT");
        RESERVED_WORDS.add("BINARY");
        RESERVED_WORDS.add("BLOB");
        RESERVED_WORDS.add("BOTH");
        RESERVED_WORDS.add("BY");
        RESERVED_WORDS.add("CALL");
        RESERVED_WORDS.add("CASCADE");
        RESERVED_WORDS.add("CASE");
        RESERVED_WORDS.add("CHANGE");
        RESERVED_WORDS.add("CHAR");
        RESERVED_WORDS.add("CHARACTER");
        RESERVED_WORDS.add("CHECK");
        RESERVED_WORDS.add("COLLATE");
        RESERVED_WORDS.add("COLUMN");
        RESERVED_WORDS.add("CONDITION");
        RESERVED_WORDS.add("CONNECTION");
        RESERVED_WORDS.add("CONSTRAINT");
        RESERVED_WORDS.add("CONTINUE");
        RESERVED_WORDS.add("CONVERT");
        RESERVED_WORDS.add("CREATE");
        RESERVED_WORDS.add("CROSS");
        RESERVED_WORDS.add("CURRENT_DATE");
        RESERVED_WORDS.add("CURRENT_TIME");
        RESERVED_WORDS.add("CURRENT_TIMESTAMP");
        RESERVED_WORDS.add("CURRENT_USER");
        RESERVED_WORDS.add("CURSOR");
        RESERVED_WORDS.add("DATABASE");
        RESERVED_WORDS.add("DATABASES");
        RESERVED_WORDS.add("DAY_HOUR");
        RESERVED_WORDS.add("DAY_MICROSECOND");
        RESERVED_WORDS.add("DAY_MINUTE");
        RESERVED_WORDS.add("DAY_SECOND");
        RESERVED_WORDS.add("DEC");
        RESERVED_WORDS.add("DECIMAL");
        RESERVED_WORDS.add("DECLARE");
        RESERVED_WORDS.add("DEFAULT");
        RESERVED_WORDS.add("DELAYED");
        RESERVED_WORDS.add("DELETE");
        RESERVED_WORDS.add("DESC");
        RESERVED_WORDS.add("DESCRIBE");
        RESERVED_WORDS.add("DETERMINISTIC");
        RESERVED_WORDS.add("DISTINCT");
        RESERVED_WORDS.add("DISTINCTROW");
        RESERVED_WORDS.add("DIV");
        RESERVED_WORDS.add("DOUBLE");
        RESERVED_WORDS.add("DROP");
        RESERVED_WORDS.add("DUAL");
        RESERVED_WORDS.add("EACH");
        RESERVED_WORDS.add("ELSE");
        RESERVED_WORDS.add("ELSEIF");
        RESERVED_WORDS.add("ENCLOSED");
        RESERVED_WORDS.add("ESCAPED");
        RESERVED_WORDS.add("EXISTS");
        RESERVED_WORDS.add("EXIT");
        RESERVED_WORDS.add("EXPLAIN");
        RESERVED_WORDS.add("FETCH");
        RESERVED_WORDS.add("FLOAT");
        RESERVED_WORDS.add("FLOAT4");
        RESERVED_WORDS.add("FLOAT8");
        RESERVED_WORDS.add("FOR");
        RESERVED_WORDS.add("FORCE");
        RESERVED_WORDS.add("FOREIGN");
        RESERVED_WORDS.add("FROM");
        RESERVED_WORDS.add("FULLTEXT");
        RESERVED_WORDS.add("GRANT");
        RESERVED_WORDS.add("GROUP");
        RESERVED_WORDS.add("HAVING");
        RESERVED_WORDS.add("HIGH_PRIORITY");
        RESERVED_WORDS.add("HOUR_MICROSECOND");
        RESERVED_WORDS.add("HOUR_MINUTE");
        RESERVED_WORDS.add("HOUR_SECOND");
        RESERVED_WORDS.add("IF");
        RESERVED_WORDS.add("IGNORE");
        RESERVED_WORDS.add("IN");
        RESERVED_WORDS.add("INDEX");
        RESERVED_WORDS.add("INFILE");
        RESERVED_WORDS.add("INNER");
        RESERVED_WORDS.add("INOUT");
        RESERVED_WORDS.add("INSENSITIVE");
        RESERVED_WORDS.add("INSERT");
        RESERVED_WORDS.add("INT");
        RESERVED_WORDS.add("INT1");
        RESERVED_WORDS.add("INT2");
        RESERVED_WORDS.add("INT3");
        RESERVED_WORDS.add("INT4");
        RESERVED_WORDS.add("INT8");
        RESERVED_WORDS.add("INTEGER");
        RESERVED_WORDS.add("INTERVAL");
        RESERVED_WORDS.add("INTO");
        RESERVED_WORDS.add("IS");
        RESERVED_WORDS.add("ITERATE");
        RESERVED_WORDS.add("JOIN");
        RESERVED_WORDS.add("KEY");
        RESERVED_WORDS.add("KEYS");
        RESERVED_WORDS.add("KILL");
        RESERVED_WORDS.add("LEADING");
        RESERVED_WORDS.add("LEAVE");
        RESERVED_WORDS.add("LEFT");
        RESERVED_WORDS.add("LIKE");
        RESERVED_WORDS.add("LIMIT");
        RESERVED_WORDS.add("LINES");
        RESERVED_WORDS.add("LOAD");
        RESERVED_WORDS.add("LOCALTIME");
        RESERVED_WORDS.add("LOCALTIMESTAMP");
        RESERVED_WORDS.add("LOCK");
        RESERVED_WORDS.add("LONG");
        RESERVED_WORDS.add("LONGBLOB");
        RESERVED_WORDS.add("LONGTEXT");
        RESERVED_WORDS.add("LOOP");
        RESERVED_WORDS.add("LOW_PRIORITY");
        RESERVED_WORDS.add("MATCH");
        RESERVED_WORDS.add("MEDIUMBLOB");
        RESERVED_WORDS.add("MEDIUMINT");
        RESERVED_WORDS.add("MEDIUMTEXT");
        RESERVED_WORDS.add("MIDDLEINT");
        RESERVED_WORDS.add("MINUTE_MICROSECOND");
        RESERVED_WORDS.add("MINUTE_SECOND");
        RESERVED_WORDS.add("MOD");
        RESERVED_WORDS.add("MODIFIES");
        RESERVED_WORDS.add("NATURAL");
        RESERVED_WORDS.add("NO_WRITE_TO_BINLOG");
        RESERVED_WORDS.add("NOT");
        RESERVED_WORDS.add("NULL");
        RESERVED_WORDS.add("NUMERIC");
        RESERVED_WORDS.add("ON");
        RESERVED_WORDS.add("OPTIMIZE");
        RESERVED_WORDS.add("OPTION");
        RESERVED_WORDS.add("OPTIONALLY");
        RESERVED_WORDS.add("OR");
        RESERVED_WORDS.add("ORDER");
        RESERVED_WORDS.add("OUT");
        RESERVED_WORDS.add("OUTER");
        RESERVED_WORDS.add("OUTFILE");
        RESERVED_WORDS.add("PRECISION");
        RESERVED_WORDS.add("PRIMARY");
        RESERVED_WORDS.add("PROCEDURE");
        RESERVED_WORDS.add("PURGE");
        RESERVED_WORDS.add("RAID0");
        RESERVED_WORDS.add("READ");
        RESERVED_WORDS.add("READS");
        RESERVED_WORDS.add("REAL");
        RESERVED_WORDS.add("REFERENCES");
        RESERVED_WORDS.add("REGEXP");
        RESERVED_WORDS.add("RELEASE");
        RESERVED_WORDS.add("RENAME");
        RESERVED_WORDS.add("REPEAT");
        RESERVED_WORDS.add("REPLACE");
        RESERVED_WORDS.add("REQUIRE");
        RESERVED_WORDS.add("RESTRICT");
        RESERVED_WORDS.add("RETURN");
        RESERVED_WORDS.add("REVOKE");
        RESERVED_WORDS.add("RIGHT");
        RESERVED_WORDS.add("RLIKE");
        RESERVED_WORDS.add("SCHEMA");
        RESERVED_WORDS.add("SCHEMAS");
        RESERVED_WORDS.add("SECOND_MICROSECOND");
        RESERVED_WORDS.add("SELECT");
        RESERVED_WORDS.add("SENSITIVE");
        RESERVED_WORDS.add("SEPARATOR");
        RESERVED_WORDS.add("SET");
        RESERVED_WORDS.add("SHOW");
        RESERVED_WORDS.add("SMALLINT");
        RESERVED_WORDS.add("SONAME");
        RESERVED_WORDS.add("SPATIAL");
        RESERVED_WORDS.add("SPECIFIC");
        RESERVED_WORDS.add("SQL");
        RESERVED_WORDS.add("SQL_BIG_RESULT");
        RESERVED_WORDS.add("SQL_CALC_FOUND_ROWS");
        RESERVED_WORDS.add("SQL_SMALL_RESULT");
        RESERVED_WORDS.add("SQLEXCEPTION");
        RESERVED_WORDS.add("SQLSTATE");
        RESERVED_WORDS.add("SQLWARNING");
        RESERVED_WORDS.add("SSL");
        RESERVED_WORDS.add("STARTING");
        RESERVED_WORDS.add("STRAIGHT_JOIN");
        RESERVED_WORDS.add("TABLE");
        RESERVED_WORDS.add("TERMINATED");
        RESERVED_WORDS.add("THEN");
        RESERVED_WORDS.add("TINYBLOB");
        RESERVED_WORDS.add("TINYINT");
        RESERVED_WORDS.add("TINYTEXT");
        RESERVED_WORDS.add("TO");
        RESERVED_WORDS.add("TRAILING");
        RESERVED_WORDS.add("TRIGGER");
        RESERVED_WORDS.add("UNDO");
        RESERVED_WORDS.add("UNION");
        RESERVED_WORDS.add("UNIQUE");
        RESERVED_WORDS.add("UNLOCK");
        RESERVED_WORDS.add("UNSIGNED");
        RESERVED_WORDS.add("UPDATE");
        RESERVED_WORDS.add("USAGE");
        RESERVED_WORDS.add("USE");
        RESERVED_WORDS.add("USING");
        RESERVED_WORDS.add("UTC_DATE");
        RESERVED_WORDS.add("UTC_TIME");
        RESERVED_WORDS.add("UTC_TIMESTAMP");
        RESERVED_WORDS.add("VALUES");
        RESERVED_WORDS.add("VARBINARY");
        RESERVED_WORDS.add("VARCHAR");
        RESERVED_WORDS.add("VARCHARACTER");
        RESERVED_WORDS.add("VARYING");
        RESERVED_WORDS.add("WHEN");
        RESERVED_WORDS.add("WHERE");
        RESERVED_WORDS.add("WHILE");
        RESERVED_WORDS.add("WITH");
        RESERVED_WORDS.add("WRITE");
        RESERVED_WORDS.add("X509");
        RESERVED_WORDS.add("XOR");
        RESERVED_WORDS.add("YEAR_MONTH");
        RESERVED_WORDS.add("ZEROFILL");
    }
}

