/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.diff.DiffChunk;
import ca.sqlpower.diff.PropertyChange;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLSequence;
import ca.sqlpower.sqlobject.SQLTable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class OracleDDLGenerator
extends GenericDDLGenerator {
    public static final String GENERATOR_VERSION = "$Revision$";
    private static final Logger logger = Logger.getLogger(OracleDDLGenerator.class);
    public static final HashSet<String> RESERVED_WORDS = new HashSet();

    @Override
    public String getName() {
        return "Oracle 8i";
    }

    @Override
    public void writeHeader() {
        this.println("-- Created by SQLPower Oracle 8i/9i/10g DDL Generator $Revision$ --");
    }

    @Override
    protected void createTypeMap() throws SQLException {
        this.typeMap = new HashMap();
        this.typeMap.put(-5, new GenericTypeDescriptor("NUMBER", -5, 38L, null, null, 1, true, false));
        this.typeMap.put(-2, new GenericTypeDescriptor("RAW", -2, 2000L, null, null, 1, true, false));
        this.typeMap.put(-7, new GenericTypeDescriptor("NUMBER", -7, 1L, null, null, 1, true, false));
        this.typeMap.put(2004, new GenericTypeDescriptor("BLOB", 2004, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(16, new GenericTypeDescriptor("NUMBER", 2, 1L, null, null, 1, true, true));
        this.typeMap.put(1, new GenericTypeDescriptor("CHAR", 1, 2000L, "'", "'", 1, true, false));
        this.typeMap.put(2005, new GenericTypeDescriptor("CLOB", 2005, 4000000000L, null, null, 1, false, false));
        this.typeMap.put(91, new GenericTypeDescriptor("DATE", 91, 0L, "'", "'", 1, false, false));
        this.typeMap.put(3, new GenericTypeDescriptor("NUMBER", 3, 38L, null, null, 1, true, true));
        this.typeMap.put(8, new GenericTypeDescriptor("NUMBER", 8, 38L, null, null, 1, false, false));
        this.typeMap.put(6, new GenericTypeDescriptor("FLOAT", 6, 38L, null, null, 1, false, false));
        this.typeMap.put(4, new GenericTypeDescriptor("NUMBER", 4, 38L, null, null, 1, false, false));
        this.typeMap.put(-4, new GenericTypeDescriptor("LONG RAW", -4, 2000000000L, null, null, 1, false, false));
        this.typeMap.put(2, new GenericTypeDescriptor("NUMBER", 2, 38L, null, null, 1, true, true));
        this.typeMap.put(7, new GenericTypeDescriptor("NUMBER", 7, 38L, null, null, 1, false, false));
        this.typeMap.put(5, new GenericTypeDescriptor("NUMBER", 5, 38L, null, null, 1, true, false));
        this.typeMap.put(92, new GenericTypeDescriptor("DATE", 92, 0L, "'", "'", 1, false, false));
        this.typeMap.put(93, new GenericTypeDescriptor("DATE", 93, 0L, "'", "'", 1, false, false));
        this.typeMap.put(-6, new GenericTypeDescriptor("NUMBER", -6, 38L, null, null, 1, true, false));
        this.typeMap.put(-1, new GenericTypeDescriptor("LONG", -1, 2000000000L, null, null, 1, false, false));
        this.typeMap.put(-3, new GenericTypeDescriptor("LONG RAW", -3, 2000000000L, null, null, 1, false, false));
        this.typeMap.put(12, new GenericTypeDescriptor("VARCHAR2", 12, 4000L, "'", "'", 1, true, false));
    }

    private String toIdentifier(String logicalName, String physicalName) {
        if (logicalName == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getting physical name for: " + logicalName));
        }
        String ident = logicalName.replace(' ', '_').toUpperCase();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("after replace of spaces: " + ident));
        }
        ident = ident.replaceAll("[^a-zA-Z0-9_]", "_");
        if (physicalName == null) {
            if (ident.length() < 31) {
                return ident;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("truncating identifier: " + ident));
            }
            String base = ident.substring(0, 27);
            int tiebreaker = (ident.hashCode() % 1000 + 1000) % 1000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("new identifier: " + base + tiebreaker));
            }
            return base + tiebreaker;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("physical idenfier is not unique, regenerating: " + physicalName));
        }
        String base = ident;
        if (ident.length() > 27) {
            base = ident.substring(0, 27);
        }
        int tiebreaker = ((ident + physicalName).hashCode() % 1000 + 1000) % 1000;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("regenerated identifier is: " + base + tiebreaker));
        }
        return base + tiebreaker;
    }

    @Override
    public boolean isReservedWord(String word) {
        return RESERVED_WORDS.contains(word.toUpperCase());
    }

    @Override
    public String toIdentifier(String name) {
        return this.toIdentifier(name, null);
    }

    @Override
    public String getCatalogTerm() {
        return null;
    }

    @Override
    public String getSchemaTerm() {
        return "Schema";
    }

    @Override
    public String makeDropForeignKeySQL(String fkTable, String fkName) {
        return "\nALTER TABLE " + this.toQualifiedName(fkTable) + " DROP CONSTRAINT " + fkName;
    }

    @Override
    public void modifyColumn(SQLColumn c, DiffChunk<SQLObject> diffChunk) {
        boolean alter = false;
        for (PropertyChange change : diffChunk.getPropertyChanges()) {
            if (!change.getPropertyName().equals("nullable")) continue;
            alter = true;
            break;
        }
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        SQLTable t = c.getParent();
        this.print("\nALTER TABLE ");
        this.print(this.toQualifiedName(this.getPhysicalName((SQLObject)t)));
        this.print(" MODIFY ");
        this.print(this.columnDefinition(c, colNameMap, alter));
        this.endStatement(DDLStatement.StatementType.MODIFY, (SQLObject)c);
    }

    protected String columnNullability(SQLColumn c, boolean alterNullability) {
        GenericTypeDescriptor td = this.failsafeGetTypeDescriptor(c);
        if (c.isDefinitelyNullable()) {
            if (!td.isNullable()) {
                throw new UnsupportedOperationException("The data type " + td.getName() + " is not nullable on the target database platform.");
            }
            return " NULL";
        }
        return " NOT NULL";
    }

    @Override
    public void addColumn(SQLColumn c) {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        this.print("\nALTER TABLE ");
        this.print(this.toQualifiedName(c.getParent()));
        this.print(" ADD ");
        this.print(this.columnDefinition(c, colNameMap));
        this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)c);
    }

    @Override
    public void addIndex(SQLIndex index) throws SQLObjectException {
        boolean isBitmapIndex;
        this.createPhysicalName(this.topLevelNames, (SQLObject)index);
        this.println("");
        this.print("CREATE ");
        if (index.isUnique()) {
            this.print("UNIQUE ");
        }
        boolean bl = isBitmapIndex = index.getType() != null && index.getType().equals("BITMAP");
        if (isBitmapIndex) {
            this.print("BITMAP ");
        }
        this.print("INDEX ");
        this.print(this.toQualifiedName(index.getName()));
        this.print("\n ON ");
        this.print(this.toQualifiedName(index.getParent()));
        this.print("\n ( ");
        boolean first = true;
        for (SQLIndex.Column c : index.getChildren(SQLIndex.Column.class)) {
            if (!first) {
                this.print(", ");
            }
            this.print(this.getPhysicalName((SQLObject)c.getColumn()));
            if (!isBitmapIndex) {
                this.print(c.getAscendingOrDescending() == SQLIndex.AscendDescend.ASCENDING ? " ASC" : "");
                this.print(c.getAscendingOrDescending() == SQLIndex.AscendDescend.DESCENDING ? " DESC" : "");
            }
            first = false;
        }
        this.print(" )");
        if (index.getType() != null && index.getType().equals("CTXCAT")) {
            this.print("\n INDEXTYPE IS " + index.getType());
        }
        this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)index);
    }

    @Override
    public void addTable(SQLTable t) throws SQLException, SQLObjectException {
        for (SQLColumn c : t.getColumns()) {
            if (!c.isAutoIncrement()) continue;
            SQLSequence seq = new SQLSequence(this.toIdentifier(c.getAutoIncrementSequenceName()));
            this.print("\nCREATE SEQUENCE ");
            this.print(seq.getName());
            this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)seq);
        }
        super.addTable(t);
    }

    @Override
    public boolean supportsDeleteAction(SQLRelationship r) {
        SQLRelationship.UpdateDeleteRule action = r.getDeleteRule();
        return action != SQLRelationship.UpdateDeleteRule.SET_DEFAULT;
    }

    @Override
    public String getDeleteActionClause(SQLRelationship r) {
        SQLRelationship.UpdateDeleteRule action = r.getDeleteRule();
        if (action == SQLRelationship.UpdateDeleteRule.CASCADE) {
            return "ON DELETE CASCADE";
        }
        if (action == SQLRelationship.UpdateDeleteRule.SET_NULL) {
            return "ON DELETE SET NULL";
        }
        if (action == SQLRelationship.UpdateDeleteRule.RESTRICT) {
            return "";
        }
        if (action == SQLRelationship.UpdateDeleteRule.NO_ACTION) {
            return "";
        }
        throw new IllegalArgumentException("Oracle does not support this delete action: " + action);
    }

    @Override
    public boolean supportsUpdateAction(SQLRelationship r) {
        SQLRelationship.UpdateDeleteRule action = r.getUpdateRule();
        return action == SQLRelationship.UpdateDeleteRule.NO_ACTION || action == SQLRelationship.UpdateDeleteRule.RESTRICT;
    }

    @Override
    public String getUpdateActionClause(SQLRelationship r) {
        SQLRelationship.UpdateDeleteRule action = r.getUpdateRule();
        if (!this.supportsUpdateAction(r)) {
            throw new IllegalArgumentException("This update action is not supported in Oracle: " + action);
        }
        return "";
    }

    @Override
    public boolean supportsRollback() {
        return false;
    }

    static {
        RESERVED_WORDS.add("ACCESS");
        RESERVED_WORDS.add("ADD");
        RESERVED_WORDS.add("ALL");
        RESERVED_WORDS.add("ALTER");
        RESERVED_WORDS.add("AND");
        RESERVED_WORDS.add("ANY");
        RESERVED_WORDS.add("ARRAYLEN");
        RESERVED_WORDS.add("AS");
        RESERVED_WORDS.add("ASC");
        RESERVED_WORDS.add("AUDIT");
        RESERVED_WORDS.add("BETWEEN");
        RESERVED_WORDS.add("BY");
        RESERVED_WORDS.add("CHAR");
        RESERVED_WORDS.add("CHECK");
        RESERVED_WORDS.add("CLUSTER");
        RESERVED_WORDS.add("COLUMN");
        RESERVED_WORDS.add("COMMENT");
        RESERVED_WORDS.add("COMPRESS");
        RESERVED_WORDS.add("CONNECT");
        RESERVED_WORDS.add("CREATE");
        RESERVED_WORDS.add("CURRENT");
        RESERVED_WORDS.add("DATE");
        RESERVED_WORDS.add("DECIMAL");
        RESERVED_WORDS.add("DEFAULT");
        RESERVED_WORDS.add("DELETE");
        RESERVED_WORDS.add("DESC");
        RESERVED_WORDS.add("DISTINCT");
        RESERVED_WORDS.add("DROP");
        RESERVED_WORDS.add("ELSE");
        RESERVED_WORDS.add("EXCLUSIVE");
        RESERVED_WORDS.add("EXISTS");
        RESERVED_WORDS.add("FILE");
        RESERVED_WORDS.add("FLOAT");
        RESERVED_WORDS.add("FOR");
        RESERVED_WORDS.add("FROM");
        RESERVED_WORDS.add("GRANT");
        RESERVED_WORDS.add("GROUP");
        RESERVED_WORDS.add("HAVING");
        RESERVED_WORDS.add("IDENTIFIED");
        RESERVED_WORDS.add("IMMEDIATE");
        RESERVED_WORDS.add("IN");
        RESERVED_WORDS.add("INCREMENT");
        RESERVED_WORDS.add("INDEX");
        RESERVED_WORDS.add("INITIAL");
        RESERVED_WORDS.add("INSERT");
        RESERVED_WORDS.add("INTEGER");
        RESERVED_WORDS.add("INTERSECT");
        RESERVED_WORDS.add("INTO");
        RESERVED_WORDS.add("IS");
        RESERVED_WORDS.add("LEVEL");
        RESERVED_WORDS.add("LIKE");
        RESERVED_WORDS.add("LOCK");
        RESERVED_WORDS.add("LONG");
        RESERVED_WORDS.add("MAXEXTENTS");
        RESERVED_WORDS.add("MINUS");
        RESERVED_WORDS.add("MODE");
        RESERVED_WORDS.add("MODIFY");
        RESERVED_WORDS.add("NOAUDIT");
        RESERVED_WORDS.add("NOCOMPRESS");
        RESERVED_WORDS.add("NOT");
        RESERVED_WORDS.add("NOTFOUND");
        RESERVED_WORDS.add("NOWAIT");
        RESERVED_WORDS.add("NULL");
        RESERVED_WORDS.add("NUMBER");
        RESERVED_WORDS.add("OF");
        RESERVED_WORDS.add("OFFLINE");
        RESERVED_WORDS.add("ON");
        RESERVED_WORDS.add("ONLINE");
        RESERVED_WORDS.add("OPTION");
        RESERVED_WORDS.add("OR");
        RESERVED_WORDS.add("ORDER");
        RESERVED_WORDS.add("PCTFREE");
        RESERVED_WORDS.add("PRIOR");
        RESERVED_WORDS.add("PRIVILEGES");
        RESERVED_WORDS.add("PUBLIC");
        RESERVED_WORDS.add("RAW");
        RESERVED_WORDS.add("RENAME");
        RESERVED_WORDS.add("RESOURCE");
        RESERVED_WORDS.add("REVOKE");
        RESERVED_WORDS.add("ROW");
        RESERVED_WORDS.add("ROWID");
        RESERVED_WORDS.add("ROWLABEL");
        RESERVED_WORDS.add("ROWNUM");
        RESERVED_WORDS.add("ROWS");
        RESERVED_WORDS.add("START");
        RESERVED_WORDS.add("SELECT");
        RESERVED_WORDS.add("SESSION");
        RESERVED_WORDS.add("SET");
        RESERVED_WORDS.add("SHARE");
        RESERVED_WORDS.add("SIZE");
        RESERVED_WORDS.add("SMALLINT");
        RESERVED_WORDS.add("SQLBUF");
        RESERVED_WORDS.add("SUCCESSFUL");
        RESERVED_WORDS.add("SYNONYM");
        RESERVED_WORDS.add("SYSDATE");
        RESERVED_WORDS.add("TABLE");
        RESERVED_WORDS.add("THEN");
        RESERVED_WORDS.add("TO");
        RESERVED_WORDS.add("TRIGGER");
        RESERVED_WORDS.add("UID");
        RESERVED_WORDS.add("UNION");
        RESERVED_WORDS.add("UNIQUE");
        RESERVED_WORDS.add("UPDATE");
        RESERVED_WORDS.add("USER");
        RESERVED_WORDS.add("VALIDATE");
        RESERVED_WORDS.add("VALUES");
        RESERVED_WORDS.add("VARCHAR");
        RESERVED_WORDS.add("VARCHAR2");
        RESERVED_WORDS.add("VIEW");
        RESERVED_WORDS.add("WHENEVER");
        RESERVED_WORDS.add("WHERE");
        RESERVED_WORDS.add("WITH");
    }
}

