/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl;

import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPResolverRegistry;
import ca.sqlpower.object.SPVariableHelper;
import ca.sqlpower.object.SPVariableResolver;
import ca.sqlpower.sqlobject.SQLCheckConstraint;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLEnumeration;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.sqlobject.SQLTypePhysicalProperties;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class SQLServerDDLGenerator
extends GenericDDLGenerator {
    public static final String GENERATOR_VERSION = "$Revision$";
    private static final Logger logger = Logger.getLogger(SQLServerDDLGenerator.class);
    private final String REGEX_CRLF = "(\r\n|\n\r|\r|\n)";
    public static final HashSet<String> RESERVED_WORDS = new HashSet();

    @Override
    public String getName() {
        return "Microsoft SQL Server";
    }

    @Override
    public boolean isReservedWord(String word) {
        return RESERVED_WORDS.contains(word.toUpperCase());
    }

    @Override
    public void writeHeader() {
        this.println("-- Created by SQLPower SQLServer (all versions) DDL Generator $Revision$ --");
    }

    @Override
    public void writeDDLTransactionBegin() {
    }

    @Override
    public void writeDDLTransactionEnd() {
        this.println("GO");
    }

    @Override
    public String getStatementTerminator() {
        return "";
    }

    @Override
    protected void createTypeMap() throws SQLException {
        this.typeMap = new HashMap();
        this.typeMap.put(-5, new GenericTypeDescriptor("BIGINT", -5, 38L, null, null, 1, false, false));
        this.typeMap.put(-2, new GenericTypeDescriptor("BINARY", -2, 2000L, "0x", null, 1, true, false));
        this.typeMap.put(-7, new GenericTypeDescriptor("BIT", -7, 1L, null, null, 1, false, false));
        this.typeMap.put(2004, new GenericTypeDescriptor("IMAGE", 2004, Integer.MAX_VALUE, "0x", null, 1, false, false));
        this.typeMap.put(16, new GenericTypeDescriptor("TINYINT", -6, 3L, null, null, 1, false, false));
        this.typeMap.put(1, new GenericTypeDescriptor("CHAR", 1, 8000L, "'", "'", 1, true, false));
        this.typeMap.put(2005, new GenericTypeDescriptor("TEXT", 2005, Integer.MAX_VALUE, "'", "'", 1, false, false));
        this.typeMap.put(91, new GenericTypeDescriptor("DATETIME", 91, 23L, "'", "'", 1, false, false));
        this.typeMap.put(3, new GenericTypeDescriptor("DECIMAL", 3, 38L, null, null, 1, true, true));
        this.typeMap.put(8, new GenericTypeDescriptor("REAL", 8, 38L, null, null, 1, false, false));
        this.typeMap.put(6, new GenericTypeDescriptor("FLOAT", 6, 38L, null, null, 1, false, false));
        this.typeMap.put(4, new GenericTypeDescriptor("INT", 4, 10L, null, null, 1, false, false));
        this.typeMap.put(-4, new GenericTypeDescriptor("IMAGE", -4, Integer.MAX_VALUE, "0x", null, 1, false, false));
        this.typeMap.put(-1, new GenericTypeDescriptor("TEXT", -1, Integer.MAX_VALUE, "'", "'", 1, false, false));
        this.typeMap.put(2, new GenericTypeDescriptor("NUMERIC", 2, 38L, null, null, 1, true, true));
        this.typeMap.put(7, new GenericTypeDescriptor("REAL", 7, 38L, null, null, 1, false, false));
        this.typeMap.put(5, new GenericTypeDescriptor("SMALLINT", 5, 5L, null, null, 1, false, false));
        this.typeMap.put(92, new GenericTypeDescriptor("DATETIME", 92, 23L, "'", "'", 1, false, false));
        this.typeMap.put(93, new GenericTypeDescriptor("DATETIME", 93, 23L, "'", "'", 1, false, false));
        this.typeMap.put(-6, new GenericTypeDescriptor("TINYINT", -6, 3L, null, null, 1, false, false));
        this.typeMap.put(-3, new GenericTypeDescriptor("VARBINARY", -3, 8000L, null, null, 1, true, false));
        this.typeMap.put(12, new GenericTypeDescriptor("VARCHAR", 12, 8000L, "'", "'", 1, true, false));
        this.typeMap.put(-9, new GenericTypeDescriptor("NVARCHAR", -9, 4000L, "'", "'", 1, true, false));
        this.typeMap.put(-15, new GenericTypeDescriptor("NCHAR", -15, 4000L, "'", "'", 1, true, false));
        this.typeMap.put(2011, new GenericTypeDescriptor("NCLOB", 2011, Integer.MAX_VALUE, "'", "'", 1, true, false));
    }

    @Override
    public String getCatalogTerm() {
        return "Database";
    }

    @Override
    public String getSchemaTerm() {
        return "Owner";
    }

    private String toIdentifier(String logicalName, String physicalName) {
        if (logicalName == null) {
            return null;
        }
        logger.debug((Object)("getting physical name for: " + logicalName));
        String ident = logicalName.replace(' ', '_');
        logger.debug((Object)("after replace of spaces: " + ident));
        ident = ident.replaceAll("[^a-zA-Z0-9_@$#]", "_");
        if (physicalName == null) {
            if (ident.length() < 129) {
                return ident;
            }
            logger.debug((Object)("truncating identifier: " + ident));
            String base = ident.substring(0, 125);
            int tiebreaker = (ident.hashCode() % 1000 + 1000) % 1000;
            logger.debug((Object)("new identifier: " + base + tiebreaker));
            return base + tiebreaker;
        }
        logger.debug((Object)("physical identifier is not unique, regenerating: " + physicalName));
        String base = ident;
        if (ident.length() > 125) {
            base = ident.substring(0, 125);
        }
        int tiebreaker = ((ident + physicalName).hashCode() % 1000 + 1000) % 1000;
        logger.debug((Object)("regenerated identifier is: " + base + tiebreaker));
        return base + tiebreaker;
    }

    @Override
    public void addComment(SQLTable t, boolean includeColumns) {
        if (t.getRemarks() != null && t.getRemarks().trim().length() > 0) {
            this.print("\n-- Comment for table [" + this.getPhysicalName((SQLObject)t) + "]: ");
            this.print(t.getRemarks().replaceAll("(\r\n|\n\r|\r|\n)", "\n-- "));
            this.endStatement(DDLStatement.StatementType.COMMENT, (SQLObject)t);
            if (includeColumns) {
                this.addColumnComments(t);
            }
        }
    }

    @Override
    public void addComment(SQLColumn c) {
        if (c.getRemarks() == null || c.getRemarks().trim().length() == 0) {
            return;
        }
        this.print("\n-- Comment for column [");
        this.print(c.getName());
        this.print("]: ");
        this.print(c.getRemarks().replaceAll("(\r\n|\n\r|\r|\n)", "\n-- "));
        this.endStatement(DDLStatement.StatementType.COMMENT, (SQLObject)c);
    }

    @Override
    public String toIdentifier(String name) {
        return this.toIdentifier(name, null);
    }

    @Override
    public String columnType(SQLColumn c) {
        String type = super.columnType(c);
        if (c.isAutoIncrement()) {
            type = type + " IDENTITY";
        }
        return type;
    }

    @Override
    public void addColumn(SQLColumn c) {
        this.print("\nALTER TABLE ");
        this.print(this.toQualifiedName(c.getParent()));
        this.print(" ADD ");
        this.print(this.columnDefinition(c, new HashMap<String, SQLObject>()));
        this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)c);
    }

    @Override
    public void addIndex(SQLIndex index) throws SQLObjectException {
        if (logger.isDebugEnabled()) {
            String parentTableName = null;
            String parentFolder = null;
            if (index.getParent() != null) {
                parentTableName = index.getParent().getName();
            }
            if (index.getParent() != null) {
                parentFolder = index.getParent().getName();
            }
            logger.debug((Object)("Adding index: " + index + " (parent table " + parentTableName + ") (parentFolder " + parentFolder + ")"));
        }
        this.createPhysicalName(this.topLevelNames, (SQLObject)index);
        this.print("CREATE ");
        if (index.isUnique()) {
            this.print("UNIQUE ");
        }
        if (index.isClustered()) {
            this.print(" CLUSTERED ");
        } else {
            this.print(" NONCLUSTERED ");
        }
        this.print("INDEX ");
        this.print(DDLUtils.toQualifiedName(null, null, index.getName()));
        this.print("\n ON ");
        this.print(this.toQualifiedName(index.getParent()));
        this.print("\n ( ");
        boolean first = true;
        for (SQLIndex.Column c : index.getChildren(SQLIndex.Column.class)) {
            if (!first) {
                this.print(", ");
            }
            if (c.getColumn() != null) {
                this.print(this.getPhysicalName((SQLObject)c.getColumn()));
            } else {
                this.print(c.getName());
            }
            first = false;
        }
        this.print(" )\n");
        this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)index);
    }

    @Override
    public String getDeferrabilityClause(SQLRelationship r) {
        if (this.supportsDeferrabilityPolicy(r)) {
            return "";
        }
        throw new UnsupportedOperationException(this.getName() + " does not support " + r.getName() + "'s deferrability policy (" + r.getDeferrability() + ").");
    }

    @Override
    public boolean supportsDeferrabilityPolicy(SQLRelationship r) {
        if (!Arrays.asList(SQLRelationship.Deferrability.values()).contains(r.getDeferrability())) {
            throw new IllegalArgumentException("Unknown deferrability policy: " + r.getDeferrability());
        }
        return r.getDeferrability() == SQLRelationship.Deferrability.NOT_DEFERRABLE;
    }

    @Override
    public void dropPrimaryKey(SQLTable t) {
        SQLIndex pk = t.getPrimaryKeyIndex();
        this.print("\nALTER TABLE " + this.toQualifiedName(t.getName()) + " DROP " + this.getPhysicalName((SQLObject)pk));
        this.endStatement(DDLStatement.StatementType.DROP, (SQLObject)t);
    }

    @Override
    public String makeDropForeignKeySQL(String fkTable, String fkName) {
        return "\nALTER TABLE " + this.toQualifiedName(fkTable) + " DROP CONSTRAINT " + fkName;
    }

    @Override
    public void renameColumn(SQLColumn oldCol, SQLColumn newCol) {
        HashMap<String, SQLObject> empty = new HashMap<String, SQLObject>(0);
        this.print("sp_rename @objname='");
        this.print(this.toQualifiedName(oldCol.getParent()));
        this.print(".");
        this.print(this.createPhysicalName(empty, (SQLObject)oldCol));
        this.print("', @newname='");
        this.print(this.createPhysicalName(empty, (SQLObject)newCol));
        this.print("', @objtype='COLUMN'");
        this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)newCol);
    }

    @Override
    public void renameIndex(SQLIndex oldIndex, SQLIndex newIndex) throws SQLObjectException {
        this.print("sp_rename @objname='");
        this.print(this.toQualifiedName(oldIndex));
        this.print("', @newname='");
        this.print(this.toQualifiedName(newIndex));
        this.print("', @objtype='INDEX'");
        this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)newIndex);
    }

    @Override
    public void renameRelationship(SQLRelationship oldFK, SQLRelationship newFK) {
        HashMap<String, SQLObject> empty = new HashMap<String, SQLObject>(0);
        this.print("sp_rename @objname='");
        this.print(this.createPhysicalName(empty, (SQLObject)oldFK));
        this.print("', @newname='");
        this.print(this.createPhysicalName(empty, (SQLObject)newFK));
        this.println("', @objtype='OBJECT'");
        this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)newFK);
    }

    @Override
    public void renameTable(SQLTable oldTable, SQLTable newTable) {
        HashMap<String, SQLObject> empty = new HashMap<String, SQLObject>(0);
        this.print("sp_rename @objname='");
        this.print(this.createPhysicalName(empty, (SQLObject)oldTable));
        this.print("', @newname='");
        this.print(this.createPhysicalName(empty, (SQLObject)newTable));
        this.println("'");
        this.endStatement(DDLStatement.StatementType.ALTER, (SQLObject)newTable);
    }

    @Override
    protected String columnDefinition(SQLColumn c, Map<String, SQLObject> colNameMap) {
        String columnEnumeration;
        List enumerations;
        StringBuffer def = new StringBuffer();
        def.append(this.createPhysicalName(colNameMap, (SQLObject)c));
        def.append(" ");
        def.append(this.columnType(c));
        UserDefinedSQLType type = c.getUserDefinedSQLType();
        String defaultValue = type.getDefaultValue(this.getPlatformName());
        if (defaultValue != null && !defaultValue.equals("")) {
            def.append(" ");
            def.append("DEFAULT ");
            def.append(defaultValue);
        }
        def.append(this.columnNullability(c));
        SQLTypePhysicalProperties.SQLTypeConstraint constraintType = type.getConstraintType(this.getPlatformName());
        if (constraintType == null) {
            constraintType = type.getDefaultPhysicalProperties().getConstraintType();
            enumerations = type.getDefaultPhysicalProperties().getChildrenWithoutPopulating(SQLEnumeration.class);
        } else {
            enumerations = type.getEnumerations(this.getPlatformName());
        }
        if (constraintType == SQLTypePhysicalProperties.SQLTypeConstraint.ENUM && (columnEnumeration = this.columnEnumeration(c, enumerations)) != null && columnEnumeration.length() > 0) {
            def.append(" " + columnEnumeration);
        }
        logger.debug((Object)("column definition " + def.toString()));
        return def.toString();
    }

    @Override
    public void addTable(SQLTable t) throws SQLException, SQLObjectException {
        HashMap<String, SQLObject> colNameMap = new HashMap<String, SQLObject>();
        this.createPhysicalName(this.topLevelNames, (SQLObject)t);
        this.print("\nCREATE TABLE ");
        this.print(this.toQualifiedName(t));
        this.println(" (");
        boolean firstCol = true;
        List columns = t.getColumns();
        for (SQLColumn c : columns) {
            if (!firstCol) {
                this.println(",");
            }
            this.print("                ");
            this.print(this.columnDefinition(c, colNameMap));
            firstCol = false;
        }
        SQLIndex pk = t.getPrimaryKeyIndex();
        if (pk.getChildCount() > 0) {
            this.print(",\n");
            this.print("                ");
            this.writePKConstraintClause(pk);
        }
        for (SQLColumn c : columns) {
            List checkConstraints;
            UserDefinedSQLType type = c.getUserDefinedSQLType();
            SQLTypePhysicalProperties.SQLTypeConstraint constraintType = type.getConstraintType(this.getPlatformName());
            if (constraintType == null) {
                constraintType = type.getDefaultPhysicalProperties().getConstraintType();
                checkConstraints = type.getDefaultPhysicalProperties().getCheckConstraints();
            } else {
                checkConstraints = type.getCheckConstraints(this.getPlatformName());
            }
            if (constraintType != SQLTypePhysicalProperties.SQLTypeConstraint.CHECK) continue;
            this.print(",\n");
            this.print(this.columnCheckConstraint(c, checkConstraints));
        }
        this.print("\n)");
        this.endStatement(DDLStatement.StatementType.CREATE, (SQLObject)t);
        this.addComment(t, true);
    }

    @Override
    protected String columnCheckConstraint(SQLColumn c, List<SQLCheckConstraint> checkConstraints) {
        if (!this.supportsCheckConstraint() || c == null || checkConstraints == null || checkConstraints.isEmpty()) {
            return "";
        }
        SPVariableResolver resolver = c.getVariableResolver();
        SPVariableHelper helper = new SPVariableHelper((SPObject)c);
        SPResolverRegistry.register((SPObject)c, (SPVariableResolver)resolver);
        StringBuilder sb = new StringBuilder();
        for (SQLCheckConstraint constraint : checkConstraints) {
            if (sb.length() > 0) {
                sb.append(",\n");
            }
            sb.append("                ");
            sb.append(String.format("CONSTRAINT %s CHECK (%s)", constraint.getName(), helper.substitute(constraint.getConstraint())));
        }
        SPResolverRegistry.deregister((SPObject)c, (SPVariableResolver)resolver);
        return sb.toString();
    }

    static {
        RESERVED_WORDS.add("ADD");
        RESERVED_WORDS.add("ALL");
        RESERVED_WORDS.add("ALTER");
        RESERVED_WORDS.add("AND");
        RESERVED_WORDS.add("ANY");
        RESERVED_WORDS.add("AS");
        RESERVED_WORDS.add("ASC");
        RESERVED_WORDS.add("AUTHORIZATION");
        RESERVED_WORDS.add("BACKUP");
        RESERVED_WORDS.add("BEGIN");
        RESERVED_WORDS.add("BETWEEN");
        RESERVED_WORDS.add("BREAK");
        RESERVED_WORDS.add("BROWSE");
        RESERVED_WORDS.add("BULK");
        RESERVED_WORDS.add("BY");
        RESERVED_WORDS.add("CASCADE");
        RESERVED_WORDS.add("CASE");
        RESERVED_WORDS.add("CHECK");
        RESERVED_WORDS.add("CHECKPOINT");
        RESERVED_WORDS.add("CLOSE");
        RESERVED_WORDS.add("CLUSTERED");
        RESERVED_WORDS.add("COALESCE");
        RESERVED_WORDS.add("COLLATE");
        RESERVED_WORDS.add("COLUMN");
        RESERVED_WORDS.add("COMMIT");
        RESERVED_WORDS.add("COMPUTE");
        RESERVED_WORDS.add("CONSTRAINT");
        RESERVED_WORDS.add("CONTAINS");
        RESERVED_WORDS.add("CONTAINSTABLE");
        RESERVED_WORDS.add("CONTINUE");
        RESERVED_WORDS.add("CONVERT");
        RESERVED_WORDS.add("CREATE");
        RESERVED_WORDS.add("CROSS");
        RESERVED_WORDS.add("CURRENT");
        RESERVED_WORDS.add("CURRENT_DATE");
        RESERVED_WORDS.add("CURRENT_TIME");
        RESERVED_WORDS.add("CURRENT_TIMESTAMP");
        RESERVED_WORDS.add("CURRENT_USER");
        RESERVED_WORDS.add("CURSOR");
        RESERVED_WORDS.add("DATABASE");
        RESERVED_WORDS.add("DBCC");
        RESERVED_WORDS.add("DEALLOCATE");
        RESERVED_WORDS.add("DECLARE");
        RESERVED_WORDS.add("DEFAULT");
        RESERVED_WORDS.add("DELETE");
        RESERVED_WORDS.add("DENY");
        RESERVED_WORDS.add("DESC");
        RESERVED_WORDS.add("DISK");
        RESERVED_WORDS.add("DISTINCT");
        RESERVED_WORDS.add("DISTRIBUTED");
        RESERVED_WORDS.add("DOUBLE");
        RESERVED_WORDS.add("DROP");
        RESERVED_WORDS.add("DUMMY");
        RESERVED_WORDS.add("DUMP");
        RESERVED_WORDS.add("ELSE");
        RESERVED_WORDS.add("END");
        RESERVED_WORDS.add("ERRLVL");
        RESERVED_WORDS.add("ESCAPE");
        RESERVED_WORDS.add("EXCEPT");
        RESERVED_WORDS.add("EXEC");
        RESERVED_WORDS.add("EXECUTE");
        RESERVED_WORDS.add("EXISTS");
        RESERVED_WORDS.add("EXIT");
        RESERVED_WORDS.add("FETCH");
        RESERVED_WORDS.add("FILE");
        RESERVED_WORDS.add("FILLFACTOR");
        RESERVED_WORDS.add("FOR");
        RESERVED_WORDS.add("FOREIGN");
        RESERVED_WORDS.add("FREETEXT");
        RESERVED_WORDS.add("FREETEXTTABLE");
        RESERVED_WORDS.add("FROM");
        RESERVED_WORDS.add("FULL");
        RESERVED_WORDS.add("FUNCTION");
        RESERVED_WORDS.add("GOTO");
        RESERVED_WORDS.add("GRANT");
        RESERVED_WORDS.add("GROUP");
        RESERVED_WORDS.add("HAVING");
        RESERVED_WORDS.add("HOLDLOCK");
        RESERVED_WORDS.add("IDENTITY");
        RESERVED_WORDS.add("IDENTITY_INSERT");
        RESERVED_WORDS.add("IDENTITYCOL");
        RESERVED_WORDS.add("IF");
        RESERVED_WORDS.add("IN");
        RESERVED_WORDS.add("INDEX");
        RESERVED_WORDS.add("INNER");
        RESERVED_WORDS.add("INSERT");
        RESERVED_WORDS.add("INTERSECT");
        RESERVED_WORDS.add("INTO");
        RESERVED_WORDS.add("IS");
        RESERVED_WORDS.add("JOIN");
        RESERVED_WORDS.add("KEY");
        RESERVED_WORDS.add("KILL");
        RESERVED_WORDS.add("LEFT");
        RESERVED_WORDS.add("LIKE");
        RESERVED_WORDS.add("LINENO");
        RESERVED_WORDS.add("LOAD");
        RESERVED_WORDS.add("NATIONAL");
        RESERVED_WORDS.add("NOCHECK");
        RESERVED_WORDS.add("NONCLUSTERED");
        RESERVED_WORDS.add("NOT");
        RESERVED_WORDS.add("NULL");
        RESERVED_WORDS.add("NULLIF");
        RESERVED_WORDS.add("OF");
        RESERVED_WORDS.add("OFF");
        RESERVED_WORDS.add("OFFSETS");
        RESERVED_WORDS.add("ON");
        RESERVED_WORDS.add("OPEN");
        RESERVED_WORDS.add("OPENDATASOURCE");
        RESERVED_WORDS.add("OPENQUERY");
        RESERVED_WORDS.add("OPENROWSET");
        RESERVED_WORDS.add("OPENXML");
        RESERVED_WORDS.add("OPTION");
        RESERVED_WORDS.add("OR");
        RESERVED_WORDS.add("ORDER");
        RESERVED_WORDS.add("OUTER");
        RESERVED_WORDS.add("OVER");
        RESERVED_WORDS.add("PERCENT");
        RESERVED_WORDS.add("PLAN");
        RESERVED_WORDS.add("PRECISION");
        RESERVED_WORDS.add("PRIMARY");
        RESERVED_WORDS.add("PRINT");
        RESERVED_WORDS.add("PROC");
        RESERVED_WORDS.add("PROCEDURE");
        RESERVED_WORDS.add("PUBLIC");
        RESERVED_WORDS.add("RAISERROR");
        RESERVED_WORDS.add("READ");
        RESERVED_WORDS.add("READTEXT");
        RESERVED_WORDS.add("RECONFIGURE");
        RESERVED_WORDS.add("REFERENCES");
        RESERVED_WORDS.add("REPLICATION");
        RESERVED_WORDS.add("RESTORE");
        RESERVED_WORDS.add("RESTRICT");
        RESERVED_WORDS.add("RETURN");
        RESERVED_WORDS.add("REVOKE");
        RESERVED_WORDS.add("RIGHT");
        RESERVED_WORDS.add("ROLLBACK");
        RESERVED_WORDS.add("ROWCOUNT");
        RESERVED_WORDS.add("ROWGUIDCOL");
        RESERVED_WORDS.add("RULE");
        RESERVED_WORDS.add("SAVE");
        RESERVED_WORDS.add("SCHEMA");
        RESERVED_WORDS.add("SELECT");
        RESERVED_WORDS.add("SESSION_USER");
        RESERVED_WORDS.add("SET");
        RESERVED_WORDS.add("SETUSER");
        RESERVED_WORDS.add("SHUTDOWN");
        RESERVED_WORDS.add("SOME");
        RESERVED_WORDS.add("STATISTICS");
        RESERVED_WORDS.add("SYSTEM_USER");
        RESERVED_WORDS.add("TABLE");
        RESERVED_WORDS.add("TEXTSIZE");
        RESERVED_WORDS.add("THEN");
        RESERVED_WORDS.add("TO");
        RESERVED_WORDS.add("TOP");
        RESERVED_WORDS.add("TRAN");
        RESERVED_WORDS.add("TRANSACTION");
        RESERVED_WORDS.add("TRIGGER");
        RESERVED_WORDS.add("TRUNCATE");
        RESERVED_WORDS.add("TSEQUAL");
        RESERVED_WORDS.add("UNION");
        RESERVED_WORDS.add("UNIQUE");
        RESERVED_WORDS.add("UPDATE");
        RESERVED_WORDS.add("UPDATETEXT");
        RESERVED_WORDS.add("USE");
        RESERVED_WORDS.add("USER");
        RESERVED_WORDS.add("VALUES");
        RESERVED_WORDS.add("VARYING");
        RESERVED_WORDS.add("VIEW");
        RESERVED_WORDS.add("WAITFOR");
        RESERVED_WORDS.add("WHEN");
        RESERVED_WORDS.add("WHERE");
        RESERVED_WORDS.add("WHILE");
        RESERVED_WORDS.add("WITH");
        RESERVED_WORDS.add("WRITETEXT");
    }
}

