/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.etl.kettle;

import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.JDBCDataSourceType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;

public class KettleUtils {
    private static final Logger logger = Logger.getLogger(KettleUtils.class);

    public static List<String> retrieveKettleConnectionTypes() {
        ArrayList<String> list = new ArrayList<String>();
        DatabaseInterface[] dbConnectionArray = DatabaseMeta.getDatabaseInterfaces();
        for (int i = 0; i < dbConnectionArray.length; ++i) {
            list.add(dbConnectionArray[i].getDatabaseTypeDescLong());
        }
        return list;
    }

    public static DatabaseMeta createDatabaseMeta(JDBCDataSource target) {
        String database;
        String port;
        String databaseName = target.getName();
        String username = target.getUser();
        String password = target.getPass();
        JDBCDataSourceType targetType = target.getParentType();
        String connectionType = "";
        if (targetType.getKettleNames().size() <= 0) {
            throw new RuntimeException("Error: invalid target datasource (it contains no Kettle names)");
        }
        connectionType = (String)targetType.getKettleNames().get(0);
        Map map = targetType.retrieveURLParsing(target.getUrl());
        String hostname = (String)map.get("Hostname");
        if (hostname == null) {
            hostname = target.get("ca.sqlpower.architect.etl.kettle.hostname");
        }
        if ((port = (String)map.get("Port")) == null) {
            port = target.get("ca.sqlpower.architect.etl.kettle.port");
        }
        if ((database = (String)map.get("Database")) == null) {
            database = (String)map.get("Database Name");
        }
        if (database == null) {
            database = target.get("ca.sqlpower.architect.etl.kettle.database");
        }
        DatabaseMeta databaseMeta = new DatabaseMeta(databaseName, connectionType, "Native", hostname == null ? "" : hostname, database == null ? "" : database, port == null ? "" : port, username, password);
        return databaseMeta;
    }
}

