/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.olap.generated;

import ca.sqlpower.architect.olap.OLAPRootObject;
import ca.sqlpower.architect.olap.generated.OLAPObjectPersisterHelper;
import ca.sqlpower.dao.PersistedSPOProperty;
import ca.sqlpower.dao.PersistedSPObject;
import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.session.SessionPersisterSuperConverter;
import ca.sqlpower.object.SPObject;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OLAPRootObjectPersisterHelper
extends OLAPObjectPersisterHelper<OLAPRootObject> {
    private List<String> persistedPropertiesList = null;

    public OLAPRootObject commitObject(PersistedSPObject pso, Multimap<String, PersistedSPOProperty> persistedProperties, List<PersistedSPObject> persistedObjects, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        OLAPRootObject o;
        String uuid = pso.getUUID();
        try {
            o = new OLAPRootObject();
        }
        catch (Exception e) {
            throw new SPPersistenceException(null, (Throwable)e);
        }
        o.setUUID(uuid);
        pso.setLoaded(true);
        return o;
    }

    @Override
    public void commitProperty(SPObject o, String propertyName, Object newValue, SPPersister.DataType dataType, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        super.commitProperty(o, propertyName, newValue, dataType, converter);
    }

    @Override
    public Object findProperty(SPObject o, String propertyName, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        return super.findProperty(o, propertyName, converter);
    }

    public void persistObject(SPObject o, int index, SPPersister persister, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        OLAPRootObject castedObject = (OLAPRootObject)o;
        String uuid = castedObject.getUUID();
        String parentUUID = null;
        if (castedObject.getParent() != null) {
            parentUUID = castedObject.getParent().getUUID();
        }
        persister.persistObject(parentUUID, "ca.sqlpower.architect.olap.OLAPRootObject", uuid, index);
        ArrayList<String> preProcessedProperties = new ArrayList<String>();
        try {
            this.persistObjectProperties(o, persister, converter, preProcessedProperties);
        }
        catch (Exception e) {
            throw new SPPersistenceException(uuid, (Throwable)e);
        }
    }

    @Override
    public void persistObjectProperties(SPObject o, SPPersister persister, SessionPersisterSuperConverter converter, List<String> staticPreProcessedProps) throws SPPersistenceException {
        ArrayList<String> preProcessedProps = new ArrayList<String>(staticPreProcessedProps);
        super.persistObjectProperties(o, persister, converter, preProcessedProps);
    }

    @Override
    public List<String> getPersistedProperties() throws SPPersistenceException {
        if (this.persistedPropertiesList != null) {
            return this.persistedPropertiesList;
        }
        String[] persistedPropertiesArray = new String[]{};
        this.persistedPropertiesList = new ArrayList<String>(Arrays.asList(persistedPropertiesArray));
        this.persistedPropertiesList.addAll(super.getPersistedProperties());
        return this.persistedPropertiesList;
    }
}

