/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.olap.generated;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.architect.olap.generated.OLAPObjectPersisterHelper;
import ca.sqlpower.dao.PersistedSPOProperty;
import ca.sqlpower.dao.PersistedSPObject;
import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.helper.PersisterHelperFinder;
import ca.sqlpower.dao.helper.SPPersisterHelper;
import ca.sqlpower.dao.session.SessionPersisterSuperConverter;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLDatabase;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OLAPSessionPersisterHelper
extends OLAPObjectPersisterHelper<OLAPSession> {
    private List<String> persistedPropertiesList = null;

    public OLAPSession commitObject(PersistedSPObject pso, Multimap<String, PersistedSPOProperty> persistedProperties, List<PersistedSPObject> persistedObjects, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        OLAPSession o;
        SPPersisterHelper schemaHelper;
        Class<?> classToLoad;
        String uuid = pso.getUUID();
        String schemaUUID = (String)OLAPSessionPersisterHelper.findPropertyAndRemove((String)uuid, (String)"schema", persistedProperties);
        PersistedSPObject schemaPSO = OLAPSessionPersisterHelper.findPersistedSPObject((String)uuid, (String)schemaUUID, persistedObjects);
        try {
            classToLoad = OLAPSession.class.getClassLoader().loadClass(schemaPSO.getType());
        }
        catch (ClassNotFoundException e) {
            throw new SPPersistenceException(null, (Throwable)e);
        }
        try {
            schemaHelper = PersisterHelperFinder.findPersister(classToLoad);
        }
        catch (Exception e) {
            throw new SPPersistenceException(uuid, (Throwable)e);
        }
        MondrianModel.Schema schema = (MondrianModel.Schema)schemaHelper.commitObject(schemaPSO, persistedProperties, persistedObjects, converter);
        try {
            o = new OLAPSession(schema);
        }
        catch (Exception e) {
            throw new SPPersistenceException(null, (Throwable)e);
        }
        o.setUUID(uuid);
        pso.setLoaded(true);
        return o;
    }

    @Override
    public void commitProperty(SPObject o, String propertyName, Object newValue, SPPersister.DataType dataType, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        OLAPSession castedObject = (OLAPSession)o;
        if (propertyName.equals("database")) {
            castedObject.setDatabase((SQLDatabase)converter.convertToComplexType(newValue, SQLDatabase.class));
        } else if (propertyName.equals("parent")) {
            castedObject.setParent((SPObject)converter.convertToComplexType(newValue, SPObject.class));
        } else {
            super.commitProperty(o, propertyName, newValue, dataType, converter);
        }
    }

    @Override
    public Object findProperty(SPObject o, String propertyName, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        OLAPSession castedObject = (OLAPSession)o;
        if (propertyName.equals("parent")) {
            return converter.convertToBasicType((Object)castedObject.getParent(), new Object[0]);
        }
        if (propertyName.equals("database")) {
            return converter.convertToBasicType((Object)castedObject.getDatabase(), new Object[0]);
        }
        return super.findProperty(o, propertyName, converter);
    }

    public void persistObject(SPObject o, int index, SPPersister persister, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        OLAPSession castedObject = (OLAPSession)o;
        String uuid = castedObject.getUUID();
        String parentUUID = null;
        if (castedObject.getParent() != null) {
            parentUUID = castedObject.getParent().getUUID();
        }
        persister.persistObject(parentUUID, "ca.sqlpower.architect.olap.OLAPSession", uuid, index);
        ArrayList<String> preProcessedProperties = new ArrayList<String>();
        try {
            SPPersister.DataType dataType = SPPersister.DataType.REFERENCE;
            persister.persistProperty(uuid, "schema", dataType, converter.convertToBasicType((Object)castedObject.getSchema(), new Object[0]));
            preProcessedProperties.add("schema");
            this.persistObjectProperties(o, persister, converter, preProcessedProperties);
        }
        catch (Exception e) {
            throw new SPPersistenceException(uuid, (Throwable)e);
        }
    }

    @Override
    public void persistObjectProperties(SPObject o, SPPersister persister, SessionPersisterSuperConverter converter, List<String> staticPreProcessedProps) throws SPPersistenceException {
        ArrayList<String> preProcessedProps = new ArrayList<String>(staticPreProcessedProps);
        String uuid = o.getUUID();
        OLAPSession castedObject = (OLAPSession)o;
        try {
            SPPersister.DataType dataType;
            if (!preProcessedProps.contains("parent")) {
                dataType = SPPersister.DataType.REFERENCE;
                persister.persistProperty(uuid, "parent", dataType, converter.convertToBasicType((Object)castedObject.getParent(), new Object[0]));
                preProcessedProps.add("parent");
            }
            if (!preProcessedProps.contains("database")) {
                dataType = SPPersister.DataType.REFERENCE;
                persister.persistProperty(uuid, "database", dataType, converter.convertToBasicType((Object)castedObject.getDatabase(), new Object[0]));
                preProcessedProps.add("database");
            }
        }
        catch (Exception e) {
            throw new SPPersistenceException(uuid, (Throwable)e);
        }
        super.persistObjectProperties(o, persister, converter, preProcessedProps);
    }

    @Override
    public List<String> getPersistedProperties() throws SPPersistenceException {
        if (this.persistedPropertiesList != null) {
            return this.persistedPropertiesList;
        }
        String[] persistedPropertiesArray = new String[]{"database", "parent"};
        this.persistedPropertiesList = new ArrayList<String>(Arrays.asList(persistedPropertiesArray));
        this.persistedPropertiesList.addAll(super.getPersistedProperties());
        return this.persistedPropertiesList;
    }
}

