/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.olap.undo;

import ca.sqlpower.architect.olap.CompoundEditEvent;
import ca.sqlpower.architect.olap.CompoundEditListener;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.olap.undo.OLAPChildEdit;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.undo.NotifyingUndoManager;
import ca.sqlpower.object.undo.PropertyChangeEdit;
import ca.sqlpower.util.TransactionEvent;
import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.apache.log4j.Logger;

public class OLAPUndoManager
extends UndoManager
implements NotifyingUndoManager {
    private static final Logger logger = Logger.getLogger(OLAPUndoManager.class);
    private final UndoableEventHandler eventHandler = new UndoableEventHandler();
    private boolean undoing = false;
    private CompoundEdit currentCompoundEdit;
    private int compoundEditDepth = 0;
    private WeakReference<UndoableEdit> rememberedPosition;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public OLAPUndoManager(OLAPObject root) {
        OLAPUtil.listenToHierarchy(root, this.eventHandler, this.eventHandler);
    }

    public void rememberPosition() {
        this.rememberedPosition = new WeakReference<UndoableEdit>(this.editToBeUndone());
        this.fireChangeEvent();
    }

    public boolean isAtRememberedPosition() {
        return this.rememberedPosition != null && this.rememberedPosition.get() == this.editToBeUndone();
    }

    @Override
    protected void trimEdits(int from, int to) {
        super.trimEdits(from, to);
        if (from == 0 && to > 0 && this.rememberedPosition.get() == null) {
            this.rememberedPosition = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void undoTo(UndoableEdit edit) throws CannotUndoException {
        try {
            this.undoing = true;
            logger.debug((Object)("Undoing to " + edit + "..."));
            super.undoTo(edit);
            logger.debug((Object)("Finished undoing. canUndo=" + this.canUndo() + " canRedo=" + this.canRedo()));
        }
        finally {
            this.undoing = false;
        }
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void redoTo(UndoableEdit edit) throws CannotRedoException {
        try {
            this.undoing = true;
            super.redoTo(edit);
        }
        finally {
            this.undoing = false;
        }
        this.fireChangeEvent();
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit anEdit) {
        if (!this.undoing) {
            boolean added = super.addEdit(anEdit);
            logger.debug((Object)("Added new edit: " + anEdit));
            this.fireChangeEvent();
            return added;
        }
        return true;
    }

    public void startCompoundEdit(final String presentationName) {
        ++this.compoundEditDepth;
        logger.debug((Object)("Starting compound edit. My depth: " + this.compoundEditDepth));
        if (this.compoundEditDepth == 1) {
            logger.debug((Object)("Beginning compound edit \"" + presentationName + "\""));
            this.currentCompoundEdit = new CompoundEdit(){

                @Override
                public String getPresentationName() {
                    return presentationName;
                }
            };
            this.addEdit(this.currentCompoundEdit);
        }
    }

    public void endCompoundEdit() {
        logger.debug((Object)("Ending compound event. My depth: " + this.compoundEditDepth));
        if (this.currentCompoundEdit == null || this.compoundEditDepth <= 0) {
            throw new IllegalStateException("Received a compoundEditEnded but was not in a compound edit state: depth=" + this.compoundEditDepth + "; currentEdit=" + this.currentCompoundEdit);
        }
        --this.compoundEditDepth;
        if (this.compoundEditDepth == 0) {
            logger.debug((Object)("Ending compound edit \"" + this.currentCompoundEdit.getPresentationName() + "\""));
            this.currentCompoundEdit.end();
            this.currentCompoundEdit = null;
            this.fireChangeEvent();
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    private void fireChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
            this.changeListeners.get(i).stateChanged(e);
        }
    }

    private class UndoableEventHandler
    implements SPListener,
    CompoundEditListener {
        private UndoableEventHandler() {
        }

        public void childAdded(SPChildEvent e) {
            OLAPUndoManager.this.addEdit(new OLAPChildEdit(e, false));
            OLAPUtil.listenToHierarchy((OLAPObject)e.getChild(), this, this);
        }

        public void childRemoved(SPChildEvent e) {
            OLAPUndoManager.this.addEdit(new OLAPChildEdit(e, true));
            OLAPUtil.unlistenToHierarchy((OLAPObject)e.getChild(), this, this);
        }

        public void propertyChanged(PropertyChangeEvent e) {
            OLAPUndoManager.this.addEdit((UndoableEdit)new PropertyChangeEdit(e));
        }

        @Override
        public void compoundEditStarted(CompoundEditEvent evt) {
            OLAPUndoManager.this.startCompoundEdit(evt.getPresentationName());
        }

        @Override
        public void compoundEditEnded(CompoundEditEvent evt) {
            OLAPUndoManager.this.endCompoundEdit();
        }

        public void transactionEnded(TransactionEvent e) {
        }

        public void transactionRollback(TransactionEvent e) {
        }

        public void transactionStarted(TransactionEvent e) {
        }
    }
}

