/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ddl.DB2DDLGenerator;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.ddl.HSQLDBDDLGenerator;
import ca.sqlpower.architect.ddl.MySqlDDLGenerator;
import ca.sqlpower.architect.ddl.OracleDDLGenerator;
import ca.sqlpower.architect.ddl.PostgresDDLGenerator;
import ca.sqlpower.architect.ddl.SQLServer2000DDLGenerator;
import ca.sqlpower.architect.ddl.SQLServer2005DDLGenerator;
import ca.sqlpower.architect.ddl.SQLServerDDLGenerator;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ProfileFunctionDescriptor;
import ca.sqlpower.architect.profile.RemoteDatabaseProfileCreator;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLType;
import ca.sqlpower.swingui.AddRemoveIcon;
import ca.sqlpower.swingui.db.DataSourceTypeEditorTabPanel;
import ca.sqlpower.swingui.table.TableUtils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ArchitectPropertiesDataSourceTypeOptionPanel
implements DataSourceTypeEditorTabPanel {
    private JPanel panel;
    private JDBCDataSourceType currentDSType;
    private final JTextField averageSQLFunctionField = new JTextField();
    private final JTextField stringLengthSQLFuncField = new JTextField();
    private final JTextField caseWhenNullSQLFuncField = new JTextField();
    private final JCheckBox updatableRSField = new JCheckBox("Supports Updatable Result Sets");
    private final JCheckBox quotesNameCheckBox = new JCheckBox(Messages.getString("ArchitectPropertiesDataSourceTypeOptionPanel.quotingNameLabel"));
    private final JComboBox ddlGeneratorCombo = new JComboBox<KnownDDLGenerators>(KnownDDLGenerators.values());
    private ProfileFunctionTableModel profileFunctionTableModel;
    private DefaultTableModel indexTableModel;
    private String ddlGeneratorClass;

    public ArchitectPropertiesDataSourceTypeOptionPanel() {
        this.panel = new JPanel(new BorderLayout());
    }

    public void editDsType(JDBCDataSourceType dsType) {
        if (dsType == null) {
            this.panel.removeAll();
            return;
        }
        this.averageSQLFunctionField.setText("");
        this.stringLengthSQLFuncField.setText("");
        this.caseWhenNullSQLFuncField.setText("");
        this.updatableRSField.setSelected(false);
        this.quotesNameCheckBox.setVisible(false);
        this.ddlGeneratorCombo.setSelectedItem((Object)KnownDDLGenerators.GENERIC);
        this.ddlGeneratorClass = dsType.getDDLGeneratorClass();
        this.ddlGeneratorCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (ArchitectPropertiesDataSourceTypeOptionPanel.this.ddlGeneratorClass != null && ArchitectPropertiesDataSourceTypeOptionPanel.this.ddlGeneratorClass.equals(PostgresDDLGenerator.class.getName())) {
                    ArchitectPropertiesDataSourceTypeOptionPanel.this.quotesNameCheckBox.setVisible(true);
                } else {
                    ArchitectPropertiesDataSourceTypeOptionPanel.this.quotesNameCheckBox.setVisible(false);
                    ArchitectPropertiesDataSourceTypeOptionPanel.this.quotesNameCheckBox.setSelected(false);
                }
            }
        });
        this.currentDSType = dsType;
        this.profileFunctionTableModel = new ProfileFunctionTableModel();
        final JTable profileFunctionTable = new JTable(this.profileFunctionTableModel);
        TableUtils.fitColumnWidths((JTable)profileFunctionTable, (int)0);
        profileFunctionTable.setSelectionMode(2);
        profileFunctionTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(new JComboBox<SQLType>(SQLType.getTypes())));
        this.indexTableModel = new DefaultTableModel();
        this.indexTableModel.addColumn("Index Type");
        final JTable indexTypeJTable = new JTable(this.indexTableModel);
        indexTypeJTable.setSelectionMode(2);
        block0: for (String property : dsType.getPropertyNames()) {
            if (property.contains("architect")) {
                if (property.contains("ca.sqlpower.architect.etl.kettle")) continue;
                if (property.contains(ProfileFunctionDescriptor.class.getName())) {
                    String descriptorString = dsType.getProperty(property);
                    ProfileFunctionDescriptor pfd = ProfileFunctionDescriptor.parseDescriptorString(descriptorString);
                    this.profileFunctionTableModel.addProfileFunctionDescriptor(pfd);
                    continue;
                }
                if (property.contains(ColumnProfileResult.class.getName())) {
                    if (property.equals(RemoteDatabaseProfileCreator.propName(RemoteDatabaseProfileCreator.AverageSQLFunction.class))) {
                        this.averageSQLFunctionField.setText(dsType.getProperty(property));
                        continue;
                    }
                    if (property.equals(RemoteDatabaseProfileCreator.propName(RemoteDatabaseProfileCreator.StringLengthSQLFunction.class))) {
                        this.stringLengthSQLFuncField.setText(dsType.getProperty(property));
                        continue;
                    }
                    if (property.equals(RemoteDatabaseProfileCreator.propName(RemoteDatabaseProfileCreator.CaseWhenNullSQLFunction.class))) {
                        this.caseWhenNullSQLFuncField.setText(dsType.getProperty(property));
                        continue;
                    }
                    throw new IllegalStateException("No editor defined for the data source type property " + property);
                }
                if (property.contains(SQLIndex.INDEX_TYPE_DESCRIPTOR)) {
                    this.indexTableModel.addRow(new String[]{dsType.getProperty(property)});
                    continue;
                }
                throw new IllegalStateException("No editor defined for the data source type property " + property);
            }
            if (property.equals("Supports Updatable Result Sets")) {
                this.updatableRSField.setSelected(Boolean.parseBoolean(dsType.getProperty(property)));
                continue;
            }
            if (property.equals("Supports Quoting Name")) {
                this.quotesNameCheckBox.setSelected(Boolean.parseBoolean(dsType.getProperty(property)));
                continue;
            }
            if (!property.equals("DDL Generator")) continue;
            this.ddlGeneratorCombo.setSelectedItem((Object)KnownDDLGenerators.GENERIC);
            for (KnownDDLGenerators ddlg : KnownDDLGenerators.values()) {
                if (!dsType.getProperty(property).equals(ddlg.getDDLClassName())) continue;
                this.ddlGeneratorCombo.setSelectedItem((Object)ddlg);
                continue block0;
            }
        }
        JPanel addRemoveProfileFunctionBar = new JPanel(new FlowLayout(0));
        addRemoveProfileFunctionBar.add(new JButton(new AbstractAction("", (Icon)new AddRemoveIcon(AddRemoveIcon.Type.ADD)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfileFunctionDescriptor pfd = new ProfileFunctionDescriptor("", SQLType.getTypes()[0].getType(), false, false, false, false, false, false, false, false);
                pfd.setArchitectSpecificName("");
                ArchitectPropertiesDataSourceTypeOptionPanel.this.profileFunctionTableModel.addProfileFunctionDescriptor(pfd);
            }
        }));
        addRemoveProfileFunctionBar.add(new JButton(new AbstractAction("", (Icon)new AddRemoveIcon(AddRemoveIcon.Type.REMOVE)){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = profileFunctionTable.getSelectedRows();
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    ArchitectPropertiesDataSourceTypeOptionPanel.this.profileFunctionTableModel.removeProfileFunctionDescriptor(selectedRows[i]);
                }
            }
        }));
        JPanel addRemoveIndexBar = new JPanel(new FlowLayout(0));
        addRemoveIndexBar.add(new JButton(new AbstractAction("", (Icon)new AddRemoveIcon(AddRemoveIcon.Type.ADD)){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArchitectPropertiesDataSourceTypeOptionPanel.this.indexTableModel.addRow(new String[]{""});
            }
        }));
        addRemoveIndexBar.add(new JButton(new AbstractAction("", (Icon)new AddRemoveIcon(AddRemoveIcon.Type.REMOVE)){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = indexTypeJTable.getSelectedRows();
                for (int i = selectedRows.length - 1; i >= 0; --i) {
                    ArchitectPropertiesDataSourceTypeOptionPanel.this.indexTableModel.removeRow(selectedRows[i]);
                }
            }
        }));
        this.panel.removeAll();
        DefaultFormBuilder fb = new DefaultFormBuilder(new FormLayout("4dlu, pref, 4dlu, pref:grow, 4dlu", "pref, 4dlu, pref, 4dlu, pref, 2dlu, pref, 2dlu, pref, 4dlu, fill:min:grow, 2dlu, pref, 4dlu, pref, 2dlu, pref,2dlu, pref"));
        fb.nextColumn();
        fb.append((Component)this.updatableRSField, (Component)this.quotesNameCheckBox);
        fb.nextLine();
        fb.nextLine();
        fb.nextColumn();
        fb.append("DDL Generator", (Component)this.ddlGeneratorCombo);
        fb.nextLine();
        fb.nextLine();
        fb.nextColumn();
        fb.append("Average SQL Function", (Component)this.averageSQLFunctionField);
        fb.nextLine();
        fb.nextLine();
        fb.nextColumn();
        fb.append("String Length SQL Function", (Component)this.stringLengthSQLFuncField);
        fb.nextLine();
        fb.nextLine();
        fb.nextColumn();
        fb.append("Case When Null SQL Function", (Component)this.caseWhenNullSQLFuncField);
        fb.nextLine();
        fb.nextLine();
        fb.nextColumn();
        fb.append((Component)new JScrollPane(profileFunctionTable), 3);
        fb.nextLine();
        fb.nextLine();
        fb.nextColumn();
        fb.append((Component)addRemoveProfileFunctionBar, 3);
        fb.nextLine();
        fb.nextLine();
        fb.nextColumn();
        JScrollPane indexScrollPane = new JScrollPane(indexTypeJTable);
        indexScrollPane.setPreferredSize(new Dimension((int)indexScrollPane.getPreferredSize().getWidth(), indexTypeJTable.getRowHeight() * 5));
        fb.append((Component)indexScrollPane, 3);
        fb.nextLine();
        fb.nextLine();
        fb.nextColumn();
        fb.append((Component)addRemoveIndexBar, 3);
        this.panel.add((Component)fb.getPanel(), "Center");
    }

    public boolean applyChanges() {
        int i;
        if (this.currentDSType == null) {
            return true;
        }
        this.currentDSType.putProperty("DDL Generator", ((KnownDDLGenerators)((Object)this.ddlGeneratorCombo.getSelectedItem())).getDDLClassName());
        this.currentDSType.putProperty("Supports Updatable Result Sets", String.valueOf(this.updatableRSField.isSelected()));
        this.currentDSType.putProperty("Supports Quoting Name", String.valueOf(this.quotesNameCheckBox.isSelected()));
        this.currentDSType.putProperty(RemoteDatabaseProfileCreator.propName(RemoteDatabaseProfileCreator.AverageSQLFunction.class), this.averageSQLFunctionField.getText());
        this.currentDSType.putProperty(RemoteDatabaseProfileCreator.propName(RemoteDatabaseProfileCreator.StringLengthSQLFunction.class), this.stringLengthSQLFuncField.getText());
        this.currentDSType.putProperty(RemoteDatabaseProfileCreator.propName(RemoteDatabaseProfileCreator.CaseWhenNullSQLFunction.class), this.caseWhenNullSQLFuncField.getText());
        for (i = 0; i < this.profileFunctionTableModel.getProfileFunctionDescriptors().size(); ++i) {
            this.currentDSType.putProperty(ProfileFunctionDescriptor.class.getName() + "_" + i, ProfileFunctionDescriptor.createDescriptorString(this.profileFunctionTableModel.getProfileFunctionDescriptors().get(i)));
        }
        for (i = 0; i < this.indexTableModel.getRowCount(); ++i) {
            this.currentDSType.putProperty(SQLIndex.INDEX_TYPE_DESCRIPTOR + "_" + i, (String)this.indexTableModel.getValueAt(i, 0));
        }
        return true;
    }

    public void discardChanges() {
        this.editDsType(this.currentDSType);
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    private class ProfileFunctionTableModel
    implements TableModel {
        private final List<ProfileFunctionDescriptor> descriptors = new ArrayList<ProfileFunctionDescriptor>();
        private final List<TableModelListener> listeners = new ArrayList<TableModelListener>();

        private ProfileFunctionTableModel() {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0 || columnIndex == 1) {
                return String.class;
            }
            if (columnIndex == 2) {
                return JComboBox.class;
            }
            if (columnIndex >= 3 && columnIndex <= 10) {
                return Boolean.class;
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 11;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Architect Name";
            }
            if (columnIndex == 1) {
                return "Data Type Name";
            }
            if (columnIndex == 2) {
                return "Java Code";
            }
            if (columnIndex == 3) {
                return "Count Distinct";
            }
            if (columnIndex == 4) {
                return "Max Value";
            }
            if (columnIndex == 5) {
                return "Min Value";
            }
            if (columnIndex == 6) {
                return "Avg Value";
            }
            if (columnIndex == 7) {
                return "Max Length";
            }
            if (columnIndex == 8) {
                return "Min Length";
            }
            if (columnIndex == 9) {
                return "Avg Length";
            }
            if (columnIndex == 10) {
                return "Sum Decode";
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.descriptors.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ProfileFunctionDescriptor pfd = this.descriptors.get(rowIndex);
            if (columnIndex == 0) {
                return pfd.getArchitectSpecificName();
            }
            if (columnIndex == 1) {
                return pfd.getDataTypeName();
            }
            if (columnIndex == 2) {
                return SQLType.getType((int)pfd.getDataTypeCode());
            }
            if (columnIndex == 3) {
                return pfd.isCountDist();
            }
            if (columnIndex == 4) {
                return pfd.isMaxValue();
            }
            if (columnIndex == 5) {
                return pfd.isMinValue();
            }
            if (columnIndex == 6) {
                return pfd.isAvgValue();
            }
            if (columnIndex == 7) {
                return pfd.isMaxLength();
            }
            if (columnIndex == 8) {
                return pfd.isMinLength();
            }
            if (columnIndex == 9) {
                return pfd.isAvgLength();
            }
            if (columnIndex == 10) {
                return pfd.isSumDecode();
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ProfileFunctionDescriptor pfd = this.descriptors.get(rowIndex);
            if (columnIndex == 0) {
                pfd.setArchitectSpecificName((String)value);
            } else if (columnIndex == 1) {
                pfd.setDataTypeName((String)value);
            } else if (columnIndex == 2) {
                pfd.setDataTypeCode(((SQLType)value).getType());
            } else if (columnIndex == 3) {
                pfd.setCountDist((Boolean)value);
            } else if (columnIndex == 4) {
                pfd.setMaxValue((Boolean)value);
            } else if (columnIndex == 5) {
                pfd.setMinValue((Boolean)value);
            } else if (columnIndex == 6) {
                pfd.setAvgValue((Boolean)value);
            } else if (columnIndex == 7) {
                pfd.setMaxLength((Boolean)value);
            } else if (columnIndex == 8) {
                pfd.setMinLength((Boolean)value);
            } else if (columnIndex == 9) {
                pfd.setAvgLength((Boolean)value);
            } else if (columnIndex == 10) {
                pfd.setSumDecode((Boolean)value);
            }
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                this.listeners.get(i).tableChanged(new TableModelEvent(this, rowIndex));
            }
        }

        public void addProfileFunctionDescriptor(ProfileFunctionDescriptor pfd) {
            this.descriptors.add(pfd);
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                this.listeners.get(i).tableChanged(new TableModelEvent(this));
            }
        }

        public ProfileFunctionDescriptor removeProfileFunctionDescriptor(int rowIndex) {
            ProfileFunctionDescriptor pfd = this.descriptors.remove(rowIndex);
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                this.listeners.get(i).tableChanged(new TableModelEvent(this));
            }
            return pfd;
        }

        public List<ProfileFunctionDescriptor> getProfileFunctionDescriptors() {
            return Collections.unmodifiableList(this.descriptors);
        }
    }

    private static enum KnownDDLGenerators {
        GENERIC("Generic", GenericDDLGenerator.class.getName()),
        DB2("DB2", DB2DDLGenerator.class.getName()),
        HSQLDB("HSQLDB", HSQLDBDDLGenerator.class.getName()),
        MY_SQL("My SQL", MySqlDDLGenerator.class.getName()),
        ORACLE("Oracle", OracleDDLGenerator.class.getName()),
        POSTGRES("Postgres", PostgresDDLGenerator.class.getName()),
        SQL_SERVER_2000("SQL Server 2000", SQLServer2000DDLGenerator.class.getName()),
        SQL_SERVER_2005("SQL Server 2005", SQLServer2005DDLGenerator.class.getName()),
        SQL_SERVER("SQL Server", SQLServerDDLGenerator.class.getName());

        private String name;
        private String ddlClassName;

        private KnownDDLGenerators(String name, String ddlClassName) {
            this.name = name;
            this.ddlClassName = ddlClassName;
        }

        public String getName() {
            return this.name;
        }

        public String getDDLClassName() {
            return this.ddlClassName;
        }

        public String toString() {
            return this.name;
        }
    }
}

