/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ArchitectSessionImpl;
import ca.sqlpower.architect.CoreUserSettings;
import ca.sqlpower.architect.ProjectLoader;
import ca.sqlpower.architect.ProjectSettings;
import ca.sqlpower.architect.UserSettings;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.LiquibaseSettings;
import ca.sqlpower.architect.enterprise.ArchitectClientSideSession;
import ca.sqlpower.architect.etl.kettle.KettleJob;
import ca.sqlpower.architect.olap.OLAPRootObject;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.ProfileManagerImpl;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectStatusBar;
import ca.sqlpower.architect.swingui.ArchitectSwingProject;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionContext;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionContextImpl;
import ca.sqlpower.architect.swingui.CompareDMSettings;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.DomainCategorySnapshotIconFilter;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.PreferencesEditor;
import ca.sqlpower.architect.swingui.PrintSettings;
import ca.sqlpower.architect.swingui.ProfileManagerView;
import ca.sqlpower.architect.swingui.RelationalPlayPenFactory;
import ca.sqlpower.architect.swingui.SwingUIProjectLoader;
import ca.sqlpower.architect.swingui.action.AboutAction;
import ca.sqlpower.architect.swingui.action.AddDataSourceAction;
import ca.sqlpower.architect.swingui.action.NewDataSourceAction;
import ca.sqlpower.architect.swingui.action.OpenProjectAction;
import ca.sqlpower.architect.swingui.action.PreferencesAction;
import ca.sqlpower.architect.swingui.dbtree.DBTreeCellRenderer;
import ca.sqlpower.architect.swingui.olap.OLAPEditSession;
import ca.sqlpower.architect.swingui.olap.OLAPSchemaManager;
import ca.sqlpower.architect.undo.ArchitectUndoManager;
import ca.sqlpower.enterprise.AbstractNetworkConflictResolver;
import ca.sqlpower.object.AbstractPoolingSPListener;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPObjectSnapshot;
import ca.sqlpower.object.undo.SPObjectUndoManager;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.Olap4jDataSource;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRoot;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import ca.sqlpower.swingui.RecentMenu;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.SPSwingWorker;
import ca.sqlpower.swingui.SwingUIUserPrompterFactory;
import ca.sqlpower.swingui.db.DataSourceDialogFactory;
import ca.sqlpower.swingui.db.DataSourceTypeDialogFactory;
import ca.sqlpower.swingui.db.DatabaseConnectionManager;
import ca.sqlpower.swingui.event.SessionLifecycleEvent;
import ca.sqlpower.swingui.event.SessionLifecycleListener;
import ca.sqlpower.util.DefaultUserPrompterFactory;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.apache.log4j.Logger;

public class ArchitectSwingSessionImpl
implements ArchitectSwingSession {
    private static final Logger logger = Logger.getLogger(ArchitectSwingSessionImpl.class);
    private static final Executor saveExecutor = new ScheduledThreadPoolExecutor(1);
    private final ArchitectSwingSessionContext context;
    private final ArchitectSession delegateSession;
    private ArchitectFrame frame;
    private JComponent projectPanel;
    private JScrollPane playPenScrollPane;
    private ArchitectSwingSession.Saver saveBehaviour = new ArchitectSwingSession.Saver(){

        @Override
        public boolean save(ArchitectSwingSession session, boolean showChooser, boolean separateThread) {
            final boolean finalSeparateThread = separateThread;
            final ProgressMonitor pm = new ProgressMonitor(ArchitectSwingSessionImpl.this.frame, Messages.getString("ArchitectSwingSessionImpl.saveProgressDialogTitle"), "", 0, 100);
            class SaverTask
            implements Runnable {
                boolean success;

                SaverTask() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SwingUIProjectLoader project = ArchitectSwingSessionImpl.this.getProjectLoader();
                    try {
                        this.success = false;
                        if (finalSeparateThread) {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    ArchitectSwingSessionImpl.this.getArchitectFrame().setEnableSaveOption(false);
                                }
                            });
                        }
                        project.setSaveInProgress(true);
                        project.save(finalSeparateThread ? pm : null);
                        this.success = true;
                    }
                    catch (Exception ex) {
                        try {
                            this.success = false;
                            ASUtils.showExceptionDialog(ArchitectSwingSessionImpl.this, Messages.getString("ArchitectSwingSessionImpl.cannotSaveProject") + ex.getMessage(), ex);
                        }
                        catch (Throwable throwable) {
                            project.setSaveInProgress(false);
                            if (finalSeparateThread) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ArchitectSwingSessionImpl.this.getArchitectFrame().setEnableSaveOption(true);
                                    }
                                });
                            }
                            throw throwable;
                        }
                        project.setSaveInProgress(false);
                        if (finalSeparateThread) {
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                    project.setSaveInProgress(false);
                    if (finalSeparateThread) {
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }
            }
            SaverTask saveTask = new SaverTask();
            if (separateThread) {
                saveExecutor.execute(saveTask);
                return true;
            }
            saveTask.run();
            return saveTask.success;
        }

        @Override
        public void saveToStream(ArchitectSwingSession session, OutputStream out) throws IOException {
            session.getProjectLoader().save(out, "utf-8");
        }
    };
    private RecentMenu recent;
    private JDialog profileDialog;
    private boolean profileDialogPacked = false;
    private final PlayPen playPen;
    private ProfileManagerView profileManagerView;
    private CompareDMSettings compareDMSettings;
    private ArchitectUndoManager undoManager;
    private boolean isNew;
    private final DBTree dbTree;
    private KettleJob kettleJob;
    private final List<SessionLifecycleListener<ArchitectSession>> lifecycleListeners;
    private Set<SPSwingWorker> swingWorkers;
    private ProjectModificationWatcher projectModificationWatcher;
    private List<OLAPEditSession> olapEditSessions;
    private final OLAPSchemaManager olapSchemaManager;
    private final PrintSettings printSettings;
    private UserPrompterFactory swinguiUserPrompterFactory;
    private static final JColorChooser colourChooser = new JColorChooser();
    private final DatabaseConnectionManager dbConnectionManager;
    private final PreferencesEditor prefsEditor;
    private static final DataSourceDialogFactory dsDialogFactory = new DataSourceDialogFactory(){

        public JDialog showDialog(Window parentWindow, JDBCDataSource dataSource, Runnable onAccept) {
            return ASUtils.showDbcsDialog(parentWindow, dataSource, onAccept);
        }

        public JDialog showDialog(Window parentWindow, Olap4jDataSource dataSource, DataSourceCollection<? super JDBCDataSource> dsCollection, Runnable onAccept) {
            throw new UnsupportedOperationException("There is no editor dialog for Olap4j connections in Architect.");
        }
    };
    private final DataSourceTypeDialogFactory dsTypeDialogFactory = new DataSourceTypeDialogFactory(){

        public Window showDialog(Window owner) {
            return ArchitectSwingSessionImpl.this.prefsEditor.showJDBCDriverPreferences(owner, ArchitectSwingSessionImpl.this);
        }
    };

    ArchitectSwingSessionImpl(ArchitectSwingSessionContext context, String name) throws SQLObjectException {
        this(context, new ArchitectSessionImpl(context, name, new ArchitectSwingProject()));
    }

    ArchitectSwingSessionImpl(ArchitectSwingSessionContext context, ArchitectSession delegateSession) {
        if (!(delegateSession.getWorkspace() instanceof ArchitectSwingProject)) {
            throw new IllegalStateException("The delegate session must have a swing projectas its workspace. If there is no way to pass in a delegate with a swingproject we may need to make the reference non-final.");
        }
        this.swinguiUserPrompterFactory = new DefaultUserPrompterFactory();
        this.isNew = true;
        this.context = context;
        this.delegateSession = delegateSession;
        this.getWorkspace().setSession(this);
        ProfileManagerImpl profileManager = new ProfileManagerImpl();
        ((ArchitectSessionImpl)delegateSession).setProfileManager(profileManager);
        ((ArchitectSessionImpl)delegateSession).setUserPrompterFactory(this);
        this.recent = new RecentMenu(this.getClass()){

            public void loadFile(String fileName) throws IOException {
                File f = new File(fileName);
                try {
                    OpenProjectAction.getFileLoader().open(ArchitectSwingSessionImpl.this.getContext().createSession(), f, (ArchitectSwingSession)ArchitectSwingSessionImpl.this, true);
                }
                catch (SQLObjectException ex) {
                    SPSUtils.showExceptionDialogNoReport((Component)ArchitectSwingSessionImpl.this.getArchitectFrame(), (String)Messages.getString("ArchitectSwingSessionImpl.openProjectFileFailed"), (Throwable)ex);
                }
            }
        };
        this.dbConnectionManager = new DatabaseConnectionManager(delegateSession.getDataSources(), dsDialogFactory, this.dsTypeDialogFactory);
        this.setProjectLoader(new SwingUIProjectLoader(this));
        this.compareDMSettings = new CompareDMSettings();
        this.kettleJob = new KettleJob(this);
        this.olapSchemaManager = new OLAPSchemaManager(this);
        this.dbTree = new DBTree(this);
        if (this.isEnterpriseSession()) {
            ((DBTreeCellRenderer)this.dbTree.getCellRenderer()).addIconFilter(new DomainCategorySnapshotIconFilter());
        }
        this.playPen = RelationalPlayPenFactory.createPlayPen(this, this.dbTree);
        this.getWorkspace().setPlayPenContentPane(this.playPen.getContentPane());
        UserSettings sprefs = this.getUserSettings().getSwingSettings();
        if (sprefs != null && this.playPen.getZoom() == 1.0) {
            this.playPen.setRenderingAntialiased(sprefs.getBoolean("SwingUserSettings.PLAYPEN_RENDER_ANTIALIASED", false));
            Object d = sprefs.getObject("zoom", new Double(1.0));
            if (!(d instanceof Double)) {
                throw new RuntimeException("Your playpen zoom must be a double");
            }
            this.playPen.setZoom((Double)d);
        }
        this.projectModificationWatcher = new ProjectModificationWatcher(this.playPen);
        this.getRootObject().addSPListener((SPListener)new AbstractPoolingSPListener(){

            public void propertyChangeImpl(PropertyChangeEvent e) {
                ArchitectSwingSessionImpl.this.isNew = false;
            }

            public void childRemovedImpl(SPChildEvent e) {
                ArchitectSwingSessionImpl.this.isNew = false;
            }

            public void childAddedImpl(SPChildEvent e) {
                ArchitectSwingSessionImpl.this.isNew = false;
            }
        });
        this.undoManager = new ArchitectUndoManager(this.playPen);
        SPObjectUndoManager.SPObjectUndoableEventAdapter undoListener = this.undoManager.getEventAdapter();
        this.playPen.getContentPane().addComponentPropertyListener(new String[]{"topLeftCorner", "lengths", "pkConnection", "fkConnection", "backgroundColor", "foregroundColor", "dashed", "rounded"}, (SPListener)new AbstractSPListener((PropertyChangeListener)undoListener){
            final /* synthetic */ PropertyChangeListener val$undoListener;
            {
                this.val$undoListener = propertyChangeListener;
            }

            public void propertyChanged(PropertyChangeEvent evt) {
                this.val$undoListener.propertyChange(evt);
            }
        });
        this.getWorkspace().setPlayPenContentPane(this.playPen.getContentPane());
        this.lifecycleListeners = new ArrayList<SessionLifecycleListener<ArchitectSession>>();
        this.swingWorkers = new HashSet<SPSwingWorker>();
        this.olapEditSessions = new ArrayList<OLAPEditSession>();
        this.printSettings = new PrintSettings();
        this.prefsEditor = new PreferencesEditor();
        AbstractSPListener settingsListener = new AbstractSPListener(){

            public void propertyChanged(PropertyChangeEvent evt) {
                ArchitectSwingSessionImpl.this.getPlayPen().updateTablePanes();
                ArchitectSwingSessionImpl.this.getPlayPen().repaint();
            }
        };
        this.getWorkspace().addSPListener((SPListener)new AbstractSPListener((SPListener)settingsListener){
            final /* synthetic */ SPListener val$settingsListener;
            {
                this.val$settingsListener = sPListener;
            }

            public void childAdded(SPChildEvent evt) {
                if (evt.getChildType() == ProjectSettings.class) {
                    evt.getChild().addSPListener(this.val$settingsListener);
                }
            }

            public void childRemoved(SPChildEvent evt) {
                if (evt.getChildType() == ProjectSettings.class) {
                    evt.getChild().removeSPListener(this.val$settingsListener);
                }
            }
        });
        this.getWorkspace().getProjectSettings().addSPListener((SPListener)settingsListener);
        this.getWorkspace().getCriticManager().registerStartingCritics();
    }

    @Override
    public void initGUI(ArchitectFrame parentFrame) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method must be called on the Swing Event Dispatch Thread.");
        }
        this.frame = parentFrame;
        ((ArchitectSessionImpl)this.delegateSession).setStatusInfo(this.getStatusInformation());
        ToolTipManager.sharedInstance().registerComponent(this.playPen);
        ToolTipManager.sharedInstance().registerComponent(this.dbTree);
        this.swinguiUserPrompterFactory = new SwingUIUserPrompterFactory((JFrame)parentFrame);
        if (this.projectPanel == null) {
            this.playPenScrollPane = new JScrollPane(this.playPen);
            this.projectPanel = new JPanel();
            this.projectPanel.setLayout(new BorderLayout());
            this.projectPanel.add((Component)this.playPenScrollPane, "Center");
        }
        this.profileDialog = new JDialog((Frame)this.frame, Messages.getString("ArchitectSwingSessionImpl.profilesDialogTitle"));
        this.profileManagerView = new ProfileManagerView(this.delegateSession.getProfileManager());
        this.delegateSession.getProfileManager().addProfileChangeListener(this.profileManagerView);
        this.profileDialog.add(this.profileManagerView);
        RelationalPlayPenFactory.setupKeyboardActions(this.playPen, this);
        this.dbTree.setupKeyboardActions();
        this.macOSXRegistration(this.frame);
        this.profileDialog.setLocationRelativeTo(this.frame);
    }

    @Override
    public SwingUIProjectLoader getProjectLoader() {
        return (SwingUIProjectLoader)this.delegateSession.getProjectLoader();
    }

    @Override
    public void setProjectLoader(ProjectLoader project) {
        this.delegateSession.setProjectLoader(project);
    }

    @Override
    public CoreUserSettings getUserSettings() {
        return this.context.getUserSettings();
    }

    @Override
    public ArchitectSwingSessionContext getContext() {
        return this.context;
    }

    @Override
    public ArchitectFrame getArchitectFrame() {
        return this.frame;
    }

    private void macOSXRegistration(ArchitectFrame frame) {
        Action exitAction = frame.getExitAction();
        PreferencesAction prefAction = frame.getPrefAction();
        AboutAction aboutAction = frame.getAboutAction();
        OpenProjectAction openProjectAction = frame.getOpenProjectAction();
        if (exitAction == null) {
            throw new IllegalStateException("Exit action has not been initialized");
        }
        if (prefAction == null) {
            throw new IllegalStateException("Prefs action has not been initialized");
        }
        if (aboutAction == null) {
            throw new IllegalStateException("About action has not been initialized");
        }
        if (openProjectAction == null) {
            throw new IllegalStateException("Open Project action has not been initialized");
        }
        if (this.context.isMacOSX()) {
            try {
                Class<?> osxAdapter = ArchitectSwingSessionImpl.class.getClassLoader().loadClass("ca.sqlpower.architect.swingui.OSXAdapter");
                Class[] defArgs = new Class[]{Action.class, Action.class, Action.class, Action.class};
                Method registerMethod = osxAdapter.getDeclaredMethod("registerMacOSXApplication", defArgs);
                Object[] args = new Object[]{exitAction, prefAction, aboutAction, openProjectAction};
                registerMethod.invoke(osxAdapter, args);
                defArgs = new Class[]{Boolean.TYPE};
                Method prefsEnableMethod = osxAdapter.getDeclaredMethod("enablePrefs", defArgs);
                args = new Object[]{Boolean.TRUE};
                prefsEnableMethod.invoke(osxAdapter, args);
            }
            catch (NoClassDefFoundError e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (ClassNotFoundException e) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + e + ")");
            }
            catch (Exception e) {
                System.err.println("Exception while loading the OSXAdapter:");
                e.printStackTrace();
            }
        }
    }

    protected boolean promptForUnsavedModifications() {
        if (this.getProjectLoader().isModified() && this.frame != null) {
            int response = JOptionPane.showOptionDialog(this.frame, Messages.getString("ArchitectSwingSessionImpl.projectHasUnsavedChanges"), Messages.getString("ArchitectSwingSessionImpl.unsavedChangesDialogTitle"), 1, 3, null, new Object[]{Messages.getString("ArchitectSwingSessionImpl.doNotSaveOption"), Messages.getString("ArchitectSwingSessionImpl.cancelOption"), Messages.getString("ArchitectSwingSessionImpl.saveOption")}, Messages.getString("ArchitectSwingSessionImpl.saveOption"));
            if (response == 0) {
                return true;
            }
            if (response == -1 || response == 1) {
                return false;
            }
            return this.saveOrSaveAs(false, false);
        }
        return true;
    }

    @Override
    public boolean saveOrSaveAs(boolean showChooser, boolean separateThread) {
        SwingUIProjectLoader project = this.getProjectLoader();
        if (project.getFile() == null || showChooser) {
            JFileChooser chooser = new JFileChooser(project.getFile());
            chooser.addChoosableFileFilter(SPSUtils.ARCHITECT_FILE_FILTER);
            int response = chooser.showSaveDialog(this.frame);
            if (response != 0) {
                return false;
            }
            File file = chooser.getSelectedFile();
            if (!file.getPath().endsWith(".architect")) {
                file = new File(file.getPath() + ".architect");
            }
            if (file.exists() && (response = JOptionPane.showConfirmDialog(this.frame, Messages.getString("ArchitectSwingSessionImpl.fileAlreadyExists", file.getPath()), Messages.getString("ArchitectSwingSessionImpl.fileAlreadyExistsDialogTitle"), 0)) == 1) {
                return this.saveOrSaveAs(true, separateThread);
            }
            try {
                file.createNewFile();
            }
            catch (Exception e) {
                ASUtils.showExceptionDialog(this, Messages.getString("ArchitectSwingSessionImpl.couldNotCreateFile"), e);
                return false;
            }
            this.getRecentMenu().putRecentFileName(file.getAbsolutePath());
            project.setFile(file);
            project.clearFileVersion();
            String projName = file.getName().substring(0, file.getName().length() - ".architect".length());
            this.setName(projName);
        }
        return this.saveBehaviour.save(this, showChooser, separateThread);
    }

    @Override
    public Executor getSaveExecutor() {
        return saveExecutor;
    }

    @Override
    public boolean close() {
        if (!this.delegateSession.isEnterpriseSession()) {
            if (this.getProjectLoader().isSaveInProgress()) {
                if (this.frame != null) {
                    JOptionPane.showMessageDialog(this.frame, Messages.getString("ArchitectSwingSessionImpl.cannotExitWhileSaving"), Messages.getString("ArchitectSwingSessionImpl.cannotExitWhileSavingDialogTitle"), 2);
                }
                return false;
            }
            if (!this.promptForUnsavedModifications()) {
                return false;
            }
        } else {
            this.getEnterpriseSession().putPref("zoom", this.playPen.getZoom());
        }
        if (!this.delegateSession.close()) {
            return false;
        }
        if (this.swingWorkers.size() > 0) {
            for (SPSwingWorker currentWorker : this.swingWorkers) {
                currentWorker.setCancelled(true);
            }
            Object[] options = new Object[]{Messages.getString("ArchitectSwingSessionImpl.waitOption"), Messages.getString("ArchitectSwingSessionImpl.forceQuiteOption")};
            int n = JOptionPane.showOptionDialog(this.frame, Messages.getString("ArchitectSwingSessionImpl.unfinishedTasksRemaining"), Messages.getString("ArchitectSwingSessionImpl.unfinishedTasksDialogTitle"), 0, 2, null, options, options[0]);
            if (n == 0) {
                return false;
            }
            for (SPSwingWorker currentWorker : this.swingWorkers) {
                currentWorker.kill();
                currentWorker.setCancelled(true);
            }
        }
        if (this.profileDialog != null) {
            this.profileDialog.dispose();
        }
        try {
            if (!this.isEnterpriseSession()) {
                if (this.context.getPlDotIniPath() != null) {
                    this.getDataSources().write(new File(this.context.getPlDotIniPath()));
                } else {
                    this.getDataSources().write();
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"Couldn't save PL.INI file!", (Throwable)e);
        }
        for (SQLDatabase db : this.getRootObject().getChildren(SQLDatabase.class)) {
            logger.debug((Object)("closing connection: " + db.getName()));
            db.disconnect();
        }
        this.delegateSession.getProfileManager().clear();
        this.fireSessionClosing();
        return true;
    }

    @Override
    public DBTree getDBTree() {
        return this.dbTree;
    }

    @Override
    public void setSourceDatabaseList(List<SQLDatabase> databases) throws SQLObjectException {
        this.delegateSession.setSourceDatabaseList(databases);
    }

    @Override
    public SQLDatabase getTargetDatabase() {
        return this.delegateSession.getTargetDatabase();
    }

    public String getServerName() {
        if (this.delegateSession instanceof ArchitectClientSideSession) {
            return ((ArchitectClientSideSession)this.delegateSession).getProjectLocation().getServiceInfo().getName();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.delegateSession.getName();
    }

    @Override
    public void setName(String argName) {
        this.delegateSession.setName(argName);
    }

    @Override
    public PlayPen getPlayPen() {
        return this.playPen;
    }

    @Override
    public RecentMenu getRecentMenu() {
        return this.recent;
    }

    @Override
    public LiquibaseSettings getLiquibaseSettings() {
        return this.delegateSession.getLiquibaseSettings();
    }

    @Override
    public void setLiquibaseSettings(LiquibaseSettings settings) {
        this.delegateSession.setLiquibaseSettings(settings);
    }

    @Override
    public CompareDMSettings getCompareDMSettings() {
        return this.compareDMSettings;
    }

    public void setCompareDMSettings(CompareDMSettings compareDMSettings) {
        this.compareDMSettings = compareDMSettings;
    }

    @Override
    public ArchitectUndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public ProfileManager getProfileManager() {
        return this.delegateSession.getProfileManager();
    }

    @Override
    public JDialog getProfileDialog() {
        if (!this.profileDialogPacked) {
            this.profileDialog.pack();
            this.profileDialogPacked = true;
        }
        return this.profileDialog;
    }

    @Override
    public void setSaveBehaviour(ArchitectSwingSession.Saver saveBehaviour) {
        this.saveBehaviour = saveBehaviour;
    }

    @Override
    public ArchitectSwingSession.Saver getSaveBehaviour() {
        return this.saveBehaviour;
    }

    @Override
    public boolean isSavingEntireSource() {
        return this.getProjectSettings().isSavingEntireSource();
    }

    @Override
    public void setSavingEntireSource(boolean argSavingEntireSource) {
        this.getProjectSettings().setSavingEntireSource(argSavingEntireSource);
    }

    @Override
    public KettleJob getKettleJob() {
        return this.kettleJob;
    }

    @Override
    public void setKettleJob(KettleJob kettleJob) {
        this.kettleJob = kettleJob;
    }

    @Override
    public void addSessionLifecycleListener(SessionLifecycleListener<ArchitectSession> l) {
        this.lifecycleListeners.add(l);
    }

    @Override
    public void removeSessionLifecycleListener(SessionLifecycleListener<ArchitectSession> l) {
        this.lifecycleListeners.remove(l);
    }

    public void fireSessionClosing() {
        SessionLifecycleEvent evt = new SessionLifecycleEvent((Object)this);
        for (SessionLifecycleListener<ArchitectSession> listener : this.lifecycleListeners) {
            listener.sessionClosing(evt);
        }
    }

    public void registerSwingWorker(SPSwingWorker worker) {
        this.swingWorkers.add(worker);
    }

    public void removeSwingWorker(SPSwingWorker worker) {
        this.swingWorkers.remove(worker);
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    ProjectModificationWatcher getProjectModificationWatcher() {
        return this.projectModificationWatcher;
    }

    @Override
    public void setRelationshipLinesDirect(boolean relationshipLinesDirect) {
        this.getProjectSettings().setRelationshipLinesDirect(relationshipLinesDirect);
    }

    @Override
    public boolean getRelationshipLinesDirect() {
        return this.getProjectSettings().isRelationshipLinesDirect();
    }

    @Override
    public boolean isUsingLogicalNames() {
        return this.getProjectSettings().isUsingLogicalNames();
    }

    @Override
    public void setUsingLogicalNames(boolean usingLogicalNames) {
        this.getProjectSettings().setUsingLogicalNames(usingLogicalNames);
    }

    @Override
    public SQLObjectRoot getRootObject() {
        return this.delegateSession.getRootObject();
    }

    @Override
    public DDLGenerator getDDLGenerator() {
        return this.delegateSession.getDDLGenerator();
    }

    @Override
    public void setDDLGenerator(DDLGenerator generator) {
        this.delegateSession.setDDLGenerator(generator);
    }

    @Override
    public OLAPRootObject getOLAPRootObject() {
        return this.getWorkspace().getOlapRootObject();
    }

    public UserPrompter createUserPrompter(String question, UserPrompterFactory.UserPromptType responseType, UserPrompter.UserPromptOptions optionType, UserPrompter.UserPromptResponse defaultResponseType, Object defaultResponse, String ... buttonNames) {
        return this.swinguiUserPrompterFactory.createUserPrompter(question, responseType, optionType, defaultResponseType, defaultResponse, buttonNames);
    }

    @Override
    public ProjectSettings getProjectSettings() {
        return this.getWorkspace().getProjectSettings();
    }

    @Override
    public boolean isShowPkTag() {
        return this.getProjectSettings().isShowPkTag();
    }

    @Override
    public void setShowPkTag(boolean showPkTag) {
        this.getProjectSettings().setShowPkTag(showPkTag);
    }

    @Override
    public boolean isShowFkTag() {
        return this.getProjectSettings().isShowFkTag();
    }

    @Override
    public void setShowFkTag(boolean showFkTag) {
        this.getProjectSettings().setShowFkTag(showFkTag);
    }

    @Override
    public boolean isShowAkTag() {
        return this.getProjectSettings().isShowAkTag();
    }

    @Override
    public void setShowAkTag(boolean showAkTag) {
        this.getProjectSettings().setShowAkTag(showAkTag);
    }

    @Override
    public void setColumnVisibility(ProjectSettings.ColumnVisibility option) {
        this.getProjectSettings().setColumnVisibility(option);
    }

    @Override
    public ProjectSettings.ColumnVisibility getColumnVisibility() {
        return this.getProjectSettings().getColumnVisibility();
    }

    @Override
    public void showOLAPSchemaManager(Window owner) {
        this.olapSchemaManager.showDialog(owner);
    }

    @Override
    public List<OLAPEditSession> getOLAPEditSessions() {
        return this.olapEditSessions;
    }

    @Override
    public OLAPEditSession getOLAPEditSession(OLAPSession olapSession) {
        if (olapSession == null) {
            throw new NullPointerException(Messages.getString("ArchitectSwingSessionImpl.nullOlapSession"));
        }
        for (OLAPEditSession editSession : this.getOLAPEditSessions()) {
            if (editSession.getOlapSession() != olapSession) continue;
            return editSession;
        }
        return new OLAPEditSession(this, olapSession);
    }

    @Override
    public JMenu createDataSourcesMenu() {
        JMenu dbcsMenu = new JMenu(Messages.getString("DBTree.addSourceConnectionMenuName"));
        dbcsMenu.add(new JMenuItem(new NewDataSourceAction(this)));
        dbcsMenu.addSeparator();
        for (SPDataSource dbcs : this.getDataSources().getConnections()) {
            dbcsMenu.add(new JMenuItem(new AddDataSourceAction(this.dbTree, dbcs)));
        }
        SPSUtils.breakLongMenu((Window)this.getArchitectFrame(), (JMenu)dbcsMenu);
        return dbcsMenu;
    }

    @Override
    public PrintSettings getPrintSettings() {
        return this.printSettings;
    }

    public SQLDatabase getDatabase(JDBCDataSource ds) {
        return this.delegateSession.getDatabase(ds);
    }

    @Override
    public boolean isDisplayRelationshipLabel() {
        return this.getProjectSettings().isDisplayRelationshipLabel();
    }

    @Override
    public void setDisplayRelationshipLabel(boolean displayRelationshipLabel) {
        this.getProjectSettings().setDisplayRelationshipLabel(displayRelationshipLabel);
    }

    public static Color getCustomColour(Color initial, JComponent parent) {
        if (initial == null) {
            initial = Color.BLACK;
        }
        colourChooser.setColor(initial);
        ColorTracker ok = new ColorTracker(colourChooser);
        JDialog dialog = JColorChooser.createDialog(parent, "Choose a custom colour", true, colourChooser, ok, null);
        dialog.setVisible(true);
        return ok.getColor();
    }

    public UserPrompter createDatabaseUserPrompter(String question, List<Class<? extends SPDataSource>> dsTypes, UserPrompter.UserPromptOptions optionType, UserPrompter.UserPromptResponse defaultResponseType, Object defaultResponse, DataSourceCollection<SPDataSource> dsCollection, String ... buttonNames) {
        return this.swinguiUserPrompterFactory.createDatabaseUserPrompter(question, dsTypes, optionType, defaultResponseType, defaultResponse, dsCollection, buttonNames);
    }

    @Override
    public ArchitectSwingProject getWorkspace() {
        return (ArchitectSwingProject)this.delegateSession.getWorkspace();
    }

    public boolean isForegroundThread() {
        if (this.frame != null) {
            return SwingUtilities.isEventDispatchThread();
        }
        return true;
    }

    public void runInBackground(Runnable runner) {
        this.runInBackground(runner, "worker");
    }

    @Override
    public void runInBackground(Runnable runner, String name) {
        new Thread(runner, name).start();
    }

    public void runInForeground(Runnable runner) {
        if (this.frame == null || SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    @Override
    public boolean isEnterpriseSession() {
        return this.delegateSession.isEnterpriseSession();
    }

    @Override
    public ArchitectClientSideSession getEnterpriseSession() {
        if (this.isEnterpriseSession()) {
            return (ArchitectClientSideSession)this.delegateSession;
        }
        throw new RuntimeException("This swing session is not an enterprise session");
    }

    @Override
    public DataSourceCollection<JDBCDataSource> getDataSources() {
        return this.delegateSession.getDataSources();
    }

    @Override
    public void showConnectionManager(Window owner) {
        this.dbConnectionManager.showDialog(owner);
    }

    @Override
    public void showPreferenceDialog(Window owner) {
        this.prefsEditor.showPreferencesDialog(owner, this);
    }

    void setUserPrompterFactory(UserPrompterFactory newUPF) {
        this.swinguiUserPrompterFactory = newUPF;
    }

    public void refresh() {
        if (this.isEnterpriseSession()) {
            try {
                ArchitectSwingSession newSession = ((ArchitectSwingSessionContextImpl)this.getContext()).createServerSession(((ArchitectClientSideSession)this.delegateSession).getProjectLocation(), false);
                this.frame.addSession(newSession);
                JLabel messageLabel = new JLabel("Refreshing");
                JProgressBar progressBar = new JProgressBar();
                progressBar.setIndeterminate(true);
                final JDialog dialog = new JDialog((Frame)this.frame, "Refreshing");
                DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow, 5dlu, pref"));
                builder.setDefaultDialogBorder();
                builder.append((Component)messageLabel, 3);
                builder.nextLine();
                builder.append((Component)progressBar, 3);
                dialog.add(builder.getPanel());
                dialog.pack();
                dialog.setLocation(this.frame.getX() + (this.frame.getWidth() - dialog.getWidth()) / 2, this.frame.getY() + (this.frame.getHeight() - dialog.getHeight()) / 2);
                dialog.setAlwaysOnTop(true);
                dialog.setVisible(true);
                this.close();
                ((ArchitectClientSideSession)((ArchitectSwingSessionImpl)newSession).getDelegateSession()).getUpdater().addListener(new AbstractNetworkConflictResolver.UpdateListener(){

                    public boolean updatePerformed(AbstractNetworkConflictResolver updater) {
                        dialog.dispose();
                        return true;
                    }

                    public boolean updateException(AbstractNetworkConflictResolver resolver, Throwable t) {
                        return false;
                    }

                    public void preUpdatePerformed(AbstractNetworkConflictResolver resolver) {
                    }

                    public void workspaceDeleted() {
                    }
                });
                ((ArchitectClientSideSession)((ArchitectSwingSessionImpl)newSession).getDelegateSession()).startUpdaterThread();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to refresh", e);
            }
        }
    }

    public ArchitectSession getDelegateSession() {
        return this.delegateSession;
    }

    @Override
    public List<UserDefinedSQLType> getSQLTypes() {
        return this.delegateSession.getSQLTypes();
    }

    @Override
    public UserDefinedSQLType findSQLTypeByUUID(String uuid) {
        return this.delegateSession.findSQLTypeByUUID(uuid);
    }

    @Override
    public UserDefinedSQLType findSQLTypeByJDBCType(int type) {
        return this.delegateSession.findSQLTypeByJDBCType(type);
    }

    public <T> UserPrompter createListUserPrompter(String question, List<T> responses, T defaultResponse) {
        return this.swinguiUserPrompterFactory.createListUserPrompter(question, responses, defaultResponse);
    }

    @Override
    public List<UserDefinedSQLType> getDomains() {
        return this.delegateSession.getDomains();
    }

    @Override
    public JScrollPane getPlayPenScrollPane() {
        return this.playPenScrollPane;
    }

    @Override
    public void setPlayPenScrollPane(JScrollPane ppScrollPane) {
        this.playPenScrollPane = ppScrollPane;
    }

    @Override
    public JComponent getProjectPanel() {
        return this.projectPanel;
    }

    @Override
    public void setProjectPanel(JComponent panel) {
        this.projectPanel = panel;
    }

    @Override
    public ArchitectStatusBar getStatusInformation() {
        if (this.frame == null || this.frame.getStatusBar() == null) {
            return null;
        }
        return this.frame.getStatusBar();
    }

    @Override
    public Runnable createUpdateSnapshotRunnable(SPObjectSnapshot<?> snapshot) {
        return this.delegateSession.createUpdateSnapshotRunnable(snapshot);
    }

    private static class ColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color;

        public ColorTracker(JColorChooser c) {
            this.chooser = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }

    class ProjectModificationWatcher
    extends AbstractSPListener {
        public ProjectModificationWatcher(PlayPen pp) {
            SQLPowerUtils.listenToHierarchy((SPObject)ArchitectSwingSessionImpl.this.getTargetDatabase(), (SPListener)this);
            PlayPenContentPane ppcp = pp.getContentPane();
            ppcp.addComponentPropertyListener((SPListener)this);
        }

        public void childAdded(SPChildEvent e) {
            ArchitectSwingSessionImpl.this.getProjectLoader().setModified(true);
            SQLPowerUtils.listenToHierarchy((SPObject)e.getChild(), (SPListener)this);
            ArchitectSwingSessionImpl.this.isNew = false;
        }

        public void childRemoved(SPChildEvent e) {
            ArchitectSwingSessionImpl.this.getProjectLoader().setModified(true);
            SQLPowerUtils.unlistenToHierarchy((SPObject)e.getChild(), (SPListener)this);
            ArchitectSwingSessionImpl.this.isNew = false;
        }

        public void propertyChanged(PropertyChangeEvent e) {
            ArchitectSwingSessionImpl.this.getProjectLoader().setModified(true);
            ArchitectSwingSessionImpl.this.isNew = false;
        }
    }
}

