/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenComponentUI;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.TablePaneUI;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class BasicTablePaneUI
extends TablePaneUI
implements Serializable {
    private static Logger logger = Logger.getLogger(BasicTablePaneUI.class);
    private static final GenericDDLGenerator ddlg;
    private TablePane tablePane;
    public static final int BOX_LINE_THICKNESS = 1;
    public static final int GAP = 1;
    public static final int PK_GAP = 10;
    private static final int ARC_LENGTH = 7;
    private static final BasicStroke DASHED_STROKE;
    private static final BasicStroke NORMAL_STROKE;
    protected final Color selectedColor = new Color(204, 204, 255);

    public static PlayPenComponentUI createUI(PlayPenComponent c) {
        return new BasicTablePaneUI();
    }

    @Override
    public void installUI(PlayPenComponent c) {
        this.tablePane = (TablePane)c;
        this.tablePane.addSPListener((SPListener)this);
    }

    @Override
    public void uninstallUI(PlayPenComponent c) {
        this.tablePane = (TablePane)c;
        this.tablePane.removeSPListener((SPListener)this);
    }

    @Override
    public void paint(Graphics2D g) {
        this.paint(g, this.tablePane);
    }

    public void paint(Graphics g, TablePane tp) {
        try {
            Graphics2D g2 = (Graphics2D)g;
            Stroke oldStroke = g2.getStroke();
            if (tp.isDashed()) {
                g2.setStroke(DASHED_STROKE);
            } else {
                g2.setStroke(NORMAL_STROKE);
            }
            if (logger.isDebugEnabled()) {
                Rectangle clip = g2.getClipBounds();
                if (clip != null) {
                    g2.setColor(Color.red);
                    --clip.width;
                    --clip.height;
                    g2.draw(clip);
                    g2.setColor(tp.getForegroundColor());
                    logger.debug((Object)("Clipping region: " + g2.getClip()));
                } else {
                    logger.debug((Object)"Null clipping region");
                }
            }
            Insets insets = tp.getInsets();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, tp.getWidth(), tp.getHeight());
            g.translate(insets.left, insets.top);
            int width = tp.getWidth() - insets.left - insets.right;
            int height = tp.getHeight() - insets.top - insets.bottom;
            Font font = tp.getFont();
            if (font == null) {
                return;
            }
            FontMetrics metrics = tp.getFontMetrics(font);
            int fontHeight = metrics.getHeight();
            int ascent = metrics.getAscent();
            int maxDescent = metrics.getMaxDescent();
            int y = 0;
            g2.setColor(tp.getPlayPen().getBackground());
            g2.fillRect(0, 0, width, height);
            if (tp.selected) {
                g2.setColor(tp.getBackgroundColor().darker());
            } else {
                g2.setColor(tp.getBackgroundColor());
            }
            if (tp.isRounded()) {
                g2.fillRoundRect(0, 0, tp.getWidth(), fontHeight, 7, 7);
            } else {
                g2.fillRect(0, 0, tp.getWidth(), fontHeight);
            }
            if (tp.selected) {
                g2.setColor(tp.getForegroundColor().darker());
            } else {
                g2.setColor(tp.getForegroundColor());
            }
            g2.drawString(this.getTitleString(this.tablePane), 0, y += ascent);
            g2.setColor(Color.BLACK);
            if (fontHeight < 0) {
                throw new IllegalStateException("FontHeight is negative");
            }
            y += 2 + tp.getMargin().top;
            Iterator<SQLColumn> colNameIt = this.tablePane.getItems().iterator();
            int i = 0;
            int hwidth = width - tp.getMargin().right - tp.getMargin().left - 2;
            boolean stillNeedPKLine = true;
            Color currentColor = null;
            while (colNameIt.hasNext()) {
                SQLColumn col = colNameIt.next();
                if (tp.hiddenColumns.contains(col)) {
                    ++i;
                    continue;
                }
                if (!col.isPrimaryKey() && stillNeedPKLine) {
                    stillNeedPKLine = false;
                    currentColor = null;
                    g2.setColor(Color.BLACK);
                    g2.drawLine(0, (y += 10) + maxDescent - 5, width - 1, y + maxDescent - 5);
                }
                if (tp.isItemSelected(i)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Column " + i + " is selected"));
                    }
                    g2.setColor(this.selectedColor);
                    g2.fillRect(1 + tp.getMargin().left, y - ascent + fontHeight, hwidth, fontHeight);
                }
                g2.setColor((currentColor = tp.getColumnHighlight(i)) == null ? Color.BLACK : currentColor);
                g2.drawString(this.columnText(col), 1 + tp.getMargin().left, y += fontHeight);
                ++i;
            }
            g2.setColor(Color.BLACK);
            if (tp.isRounded()) {
                g2.drawRoundRect(0, fontHeight + 1, width - 1, height - (fontHeight + 1 + 1), 7, 7);
            } else {
                g2.drawRect(0, fontHeight + 1, width - 1, height - (fontHeight + 1 + 1));
            }
            if (currentColor != null) {
                g2.setColor(Color.BLACK);
            }
            if (stillNeedPKLine) {
                stillNeedPKLine = false;
                g2.drawLine(0, (y += 10) + maxDescent - 5, width - 1, y + maxDescent - 5);
            }
            int ip = this.tablePane.getInsertionPoint();
            if (logger.isDebugEnabled()) {
                g2.drawString(String.valueOf(ip), width - 20, ascent);
            }
            g2.setStroke(oldStroke);
            int hiddenPkCount = this.tablePane.getHiddenPkCount();
            int pkSize = ((SQLTable)this.tablePane.getModel()).getPkSize() - hiddenPkCount;
            if (ip != -2) {
                y = 2 + tp.getMargin().top + fontHeight;
                if (ip == -3) {
                    y += fontHeight * pkSize;
                } else if (ip == -4) {
                    y += fontHeight * pkSize + 10;
                } else if (ip < pkSize) {
                    if (ip == -1) {
                        ip = 0;
                    }
                    y += ip * fontHeight;
                } else {
                    y += ip * fontHeight + 10;
                }
                this.paintInsertionPoint(g2, y, width);
            }
            g.translate(-insets.left, -insets.top);
        }
        catch (SQLObjectException e) {
            logger.warn((Object)"BasicTablePaneUI.paint failed", (Throwable)e);
        }
    }

    private String columnText(SQLColumn col) {
        StringBuilder displayName = new StringBuilder(50);
        if (this.tablePane.isUsingLogicalNames()) {
            displayName.append(col.getName()).append(": ");
        } else {
            displayName.append(col.getPhysicalName()).append(": ");
        }
        displayName.append(col.getTypeName());
        if (col.getNullable() == 0) {
            displayName.append("   NOT NULL");
        }
        displayName.append(this.getColumnTag(col));
        return displayName.toString();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.tablePane);
    }

    public Dimension getPreferredSize(PlayPenComponent ppc) {
        TablePane c = (TablePane)ppc;
        SQLTable table = (SQLTable)c.getModel();
        if (table == null) {
            return null;
        }
        int height = 0;
        int width = 0;
        try {
            Insets insets = c.getInsets();
            List columnList = table.getColumns();
            int cols = columnList.size() - c.getHiddenColumns().size();
            Font font = c.getFont();
            if (font == null) {
                logger.error((Object)"getPreferredSize(): TablePane is missing font.");
                return null;
            }
            FontRenderContext frc = c.getFontRenderContext();
            FontMetrics metrics = c.getFontMetrics(font);
            int fontHeight = metrics.getHeight();
            height = insets.top + fontHeight + 1 + c.getMargin().top + 10 + cols * fontHeight + 2 + c.getMargin().bottom + insets.bottom;
            width = c.getMinimumSize().width;
            logger.debug((Object)("starting width is: " + width));
            ArrayList<String> itemsToCheck = new ArrayList<String>();
            for (SQLColumn col : table.getColumns()) {
                if (col == null) {
                    logger.error((Object)("Found null column in table '" + table.getName() + "'"));
                    throw new NullPointerException("Found null column in table '" + table.getName() + "'");
                }
                itemsToCheck.add(this.columnText(col));
            }
            itemsToCheck.add(this.getTitleString(c));
            for (String item : itemsToCheck) {
                if (item == null) {
                    item = "(null!?)";
                }
                width = frc == null ? Math.max(width, metrics.stringWidth(item)) : Math.max(width, (int)font.getStringBounds(item, frc).getWidth());
                logger.debug((Object)("new width is: " + width));
            }
            width += insets.left + c.getMargin().left + 2 + c.getMargin().right + insets.right;
        }
        catch (SQLObjectException e) {
            logger.warn((Object)"BasicTablePaneUI.getPreferredSize failed due to", (Throwable)e);
            width = 100;
            height = 100;
        }
        return new Dimension(width, height);
    }

    @Override
    public int pointToItemIndex(Point p) {
        int returnVal;
        Font font = this.tablePane.getFont();
        FontMetrics metrics = this.tablePane.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        int numHiddenCols = this.tablePane.getHiddenColumns().size();
        int numHiddenPkCols = this.tablePane.getHiddenPkCount();
        int numPkCols = ((SQLTable)this.tablePane.getModel()).getPkSize() - numHiddenPkCols;
        int numCols = this.tablePane.getItems().size() - numHiddenCols;
        int firstColStart = fontHeight + 1 + 1 + this.tablePane.getMargin().top;
        int pkLine = firstColStart + fontHeight * numPkCols;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("p.y = " + p.y));
        }
        logger.debug((Object)("pkLine:" + pkLine + ", numPkCols: " + numPkCols));
        logger.debug((Object)("font height: " + fontHeight + ", firstColStart: " + firstColStart));
        if (p.y < 0) {
            logger.debug((Object)"y<0");
            returnVal = -2;
        } else if (p.y <= fontHeight) {
            logger.debug((Object)("y<=fontHeight = " + fontHeight));
            returnVal = -1;
        } else if (numPkCols > 0 && p.y <= pkLine - 1) {
            logger.debug((Object)("y<=firstColStart + fontHeight*numPkCols - 1= " + (firstColStart + fontHeight * numPkCols)));
            returnVal = (p.y - firstColStart) / fontHeight;
            returnVal = this.findIndex(returnVal);
        } else if (p.y <= pkLine + 5) {
            logger.debug((Object)("y<=pkLine + pkGap/2 = " + (pkLine + 5)));
            returnVal = -3;
        } else if (p.y <= pkLine + 10) {
            logger.debug((Object)("y<=firstColStart + fontHeight*numPkCols + pkGap = " + (firstColStart + fontHeight * numPkCols + 10)));
            returnVal = -4;
        } else if (p.y < firstColStart + 10 + fontHeight * numCols) {
            logger.debug((Object)("y<=firstColStart + pkGap + fontHeight*numCols = " + (firstColStart + 10 + fontHeight * numCols)));
            returnVal = (p.y - firstColStart - 10) / fontHeight;
            returnVal = this.findIndex(returnVal);
        } else {
            returnVal = -2;
        }
        logger.debug((Object)("pointToItemIndex return value is " + returnVal));
        return returnVal;
    }

    @Override
    public int columnIndexToCentreY(int colidx) {
        Font font = this.tablePane.getFont();
        FontMetrics metrics = this.tablePane.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        if (colidx == -1) {
            return this.tablePane.getMargin().top + fontHeight / 2;
        }
        if (colidx >= 0 && colidx < this.tablePane.getItems().size()) {
            int firstColY = fontHeight + 1 + 1 + this.tablePane.getMargin().top;
            int y = firstColY + fontHeight * colidx + fontHeight / 2;
            if (colidx >= ((SQLTable)this.tablePane.getModel()).getPkSize()) {
                y += 10;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Column " + colidx + " Y value is " + y));
                logger.debug((Object)("gap=1; boxLineThickness=1; margin.top=" + this.tablePane.getMargin().top));
            }
            return y;
        }
        return -1;
    }

    public void propertyChanged(PropertyChangeEvent e) {
        logger.debug((Object)("BasicTablePaneUI notices change of " + e.getPropertyName() + " from " + e.getOldValue() + " to " + e.getNewValue() + " on " + e.getSource()));
        if (e.getPropertyName().equals("UI")) {
            return;
        }
        if (e.getPropertyName().equals("preferredSize")) {
            return;
        }
        if (e.getPropertyName().equals("insertionPoint")) {
            return;
        }
        if (e.getPropertyName().equals("model.tableName")) {
            return;
        }
        this.tablePane.revalidate();
    }

    @Override
    public boolean contains(Point p) {
        return this.tablePane.getBounds().contains(p);
    }

    @Override
    public void revalidate() {
    }

    private String getTitleString(TablePane tp) {
        if (tp.isFullyQualifiedNameInHeader()) {
            SQLTable t = (SQLTable)tp.getModel();
            String db = t.getParentDatabase() == null ? null : t.getParentDatabase().getName();
            String cat = t.getCatalogName().length() == 0 ? null : t.getCatalogName();
            String sch = t.getSchemaName().length() == 0 ? null : t.getSchemaName();
            StringBuffer fqn = new StringBuffer();
            fqn.append(db);
            if (cat != null) {
                fqn.append('.').append(cat);
            }
            if (sch != null) {
                fqn.append('.').append(sch);
            }
            fqn.append('.').append(tp.isUsingLogicalNames() ? ((SQLTable)tp.getModel()).getName() : ((SQLTable)tp.getModel()).getPhysicalName());
            return fqn.toString();
        }
        return tp.isUsingLogicalNames() ? ((SQLTable)tp.getModel()).getName() : ((SQLTable)tp.getModel()).getPhysicalName();
    }

    private int findIndex(int index) {
        int offset = 0;
        if (index >= this.tablePane.getItems().size() - this.tablePane.getHiddenColumns().size()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < this.tablePane.getItems().size(); ++i) {
            if (this.tablePane.getHiddenColumns().contains(this.tablePane.getItems().get(i)) || ++offset <= index) continue;
            return i;
        }
        return 0;
    }

    private String getColumnTag(SQLColumn col) {
        StringBuffer tag = new StringBuffer();
        StringBuffer fullTag = new StringBuffer();
        boolean isPK = col.isPrimaryKey();
        boolean isFK = col.isForeignKey();
        boolean isAK = col.isUniqueIndexed() && !isPK;
        boolean emptyTag = true;
        if (this.tablePane.isShowPkTag() && isPK) {
            tag.append("P");
            emptyTag = false;
        }
        if (this.tablePane.isShowFkTag() && isFK) {
            tag.append("F");
            emptyTag = false;
        }
        if (this.tablePane.isShowAkTag() && isAK) {
            tag.append("A");
            emptyTag = false;
        }
        if (emptyTag) {
            return "";
        }
        tag.append("K");
        fullTag.append("  [ ");
        fullTag.append(tag);
        fullTag.append(" ]");
        return fullTag.toString();
    }

    @Override
    public Point getPointForModelObject(Object modelObject) {
        Point location = this.tablePane.getLocation();
        if (!this.tablePane.getItems().contains(modelObject) || this.tablePane.getPlayPen() == null || this.tablePane.getFont() == null) {
            return location;
        }
        int y = location.y;
        Font font = this.tablePane.getFont();
        FontMetrics metrics = this.tablePane.getFontMetrics(font);
        int fontHeight = metrics.getHeight();
        y += fontHeight;
        if (!((SQLColumn)modelObject).isPrimaryKey()) {
            y += 10;
        }
        for (SQLColumn col : this.tablePane.getItems()) {
            if (col.equals(modelObject)) {
                return new Point(location.x, y);
            }
            y += fontHeight;
        }
        return this.tablePane.getLocation();
    }

    static {
        try {
            ddlg = new GenericDDLGenerator(false);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        DASHED_STROKE = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{15.0f, 4.0f}, 0.0f);
        NORMAL_STROKE = new BasicStroke(1.0f);
    }
}

