/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.LiquibaseDDLGenerator;
import ca.sqlpower.architect.ddl.PostgresDDLGenerator;
import ca.sqlpower.architect.diff.ArchitectDiffException;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.CompareDMFrame;
import ca.sqlpower.architect.swingui.CompareDMPanel;
import ca.sqlpower.architect.swingui.CompareDMSettings;
import ca.sqlpower.architect.swingui.SQLScriptDialog;
import ca.sqlpower.architect.swingui.SwingUIProjectLoader;
import ca.sqlpower.diff.DiffChunk;
import ca.sqlpower.diff.DiffInfo;
import ca.sqlpower.diff.DiffType;
import ca.sqlpower.diff.PropertyChange;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import java.awt.Color;
import java.awt.Dialog;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class CompareDMFormatter {
    private static final Logger logger = Logger.getLogger(CompareDMFormatter.class);
    private final ArchitectSwingSession session;
    private CompareDMSettings dmSetting;
    private final Dialog dialogOwner;
    public static final Map<DiffType, AttributeSet> DIFF_STYLES = new HashMap<DiffType, AttributeSet>();

    public CompareDMFormatter(ArchitectSwingSession session, Dialog dialogOwner, CompareDMSettings compDMSet) {
        this.session = session;
        this.dialogOwner = dialogOwner;
        this.dmSetting = compDMSet;
    }

    public void formatForEnglishOutput(List<DiffChunk<SQLObject>> diff, List<DiffChunk<SQLObject>> diff1, SQLObject left, SQLObject right) {
        try {
            DefaultStyledDocument sourceDoc = new DefaultStyledDocument();
            DefaultStyledDocument targetDoc = new DefaultStyledDocument();
            sourceDoc = CompareDMFormatter.generateEnglishDescription(DIFF_STYLES, this.convertToDiffInfo(diff));
            targetDoc = CompareDMFormatter.generateEnglishDescription(DIFF_STYLES, this.convertToDiffInfo(diff1));
            String leftTitle = this.toTitleText(true, left);
            String rightTitle = this.toTitleText(false, right);
            CompareDMFrame cf = new CompareDMFrame(this.dialogOwner, sourceDoc, targetDoc, leftTitle, rightTitle);
            cf.pack();
            cf.setVisible(true);
        }
        catch (SQLObjectException exp) {
            ASUtils.showExceptionDialog(this.session, "StartCompareAction failed", exp);
            logger.error((Object)"StartCompareAction failed", (Throwable)exp);
        }
        catch (BadLocationException ex) {
            ASUtils.showExceptionDialog(this.session, "Could not create document for results", ex);
            logger.error((Object)"Could not create document for results", (Throwable)ex);
        }
        catch (Exception ex) {
            ASUtils.showExceptionDialog(this.session, "Unxepected Exception!", ex);
            logger.error((Object)"Unxepected Exception!", (Throwable)ex);
        }
    }

    public DDLGenerator formatForSQLOutput(List<DiffChunk<SQLObject>> diff, List<DiffChunk<SQLObject>> diff1, SQLObject left, SQLObject right) {
        DDLGenerator gen = null;
        try {
            CompareDMPanel.SourceOrTargetStuff source = this.dmSetting.getSourceStuff();
            if (this.dmSetting.getOutputFormat().equals((Object)CompareDMSettings.OutputFormat.SQL)) {
                gen = this.dmSetting.getDdlGenerator().newInstance();
                if (gen instanceof PostgresDDLGenerator) {
                    gen.setComparingDMForPostgres(true);
                }
                SQLCatalog cat = (SQLCatalog)this.dmSetting.getSourceSettings().getCatalogObject();
                SQLSchema sch = (SQLSchema)this.dmSetting.getSourceSettings().getSchemaObject();
                gen.setTargetCatalog(cat == null ? null : gen.getPhysicalName((SQLObject)cat));
                gen.setTargetSchema(sch == null ? null : gen.getPhysicalName((SQLObject)sch));
            } else if (this.dmSetting.getOutputFormat().equals((Object)CompareDMSettings.OutputFormat.LIQUIBASE)) {
                gen = new LiquibaseDDLGenerator();
                LiquibaseDDLGenerator lbgen = (LiquibaseDDLGenerator)gen;
                lbgen.applySettings(this.dmSetting.getLiquibaseSettings());
            } else {
                throw new IllegalStateException("Don't know what kind of SQL script to generate");
            }
            ArrayList<DiffChunk<SQLObject>> addRelationships = new ArrayList<DiffChunk<SQLObject>>();
            ArrayList<DiffChunk<SQLObject>> dropRelationships = new ArrayList<DiffChunk<SQLObject>>();
            ArrayList<DiffChunk<SQLObject>> nonRelationship = new ArrayList<DiffChunk<SQLObject>>();
            for (DiffChunk<SQLObject> d : diff) {
                if (logger.isDebugEnabled()) {
                    logger.debug(d);
                }
                if (d.getData() instanceof SQLRelationship) {
                    if (d.getType() == DiffType.LEFTONLY) {
                        dropRelationships.add(d);
                        continue;
                    }
                    if (d.getType() != DiffType.RIGHTONLY) continue;
                    addRelationships.add(d);
                    continue;
                }
                nonRelationship.add(d);
            }
            this.sqlScriptGenerator(DIFF_STYLES, dropRelationships, gen);
            this.sqlScriptGenerator(DIFF_STYLES, nonRelationship, gen);
            this.sqlScriptGenerator(DIFF_STYLES, addRelationships, gen);
            String titleString = "Generated SQL Script to turn " + this.toTitleText(true, left) + " into " + this.toTitleText(false, right);
            SQLDatabase db = null;
            db = this.dmSetting.getSourceSettings().getDatastoreType().equals((Object)CompareDMSettings.DatastoreType.FILE) ? null : (this.dmSetting.getSourceSettings().getDatastoreType().equals((Object)CompareDMSettings.DatastoreType.PROJECT) ? this.session.getTargetDatabase() : source.getDatabase());
            logger.debug((Object)"We got to place #2");
            SQLScriptDialog ssd = new SQLScriptDialog(this.dialogOwner, "Compare DM", titleString, false, gen, db == null ? null : db.getDataSource(), false, this.session);
            ssd.setVisible(true);
        }
        catch (ArchitectDiffException ex) {
            ASUtils.showExceptionDialog(this.session, "Could not perform the diff", (Throwable)((Object)ex));
            logger.error((Object)"Couldn't do diff", (Throwable)((Object)ex));
        }
        catch (SQLObjectException exp) {
            ASUtils.showExceptionDialog(this.session, "StartCompareAction failed", exp);
            logger.error((Object)"StartCompareAction failed", (Throwable)exp);
        }
        catch (BadLocationException ex) {
            ASUtils.showExceptionDialog(this.session, "Could not create document for results", ex);
            logger.error((Object)"Could not create document for results", (Throwable)ex);
        }
        catch (Exception ex) {
            ASUtils.showExceptionDialog(this.session, "Unxepected Exception!", ex);
            logger.error((Object)"Unxepected Exception!", (Throwable)ex);
        }
        return gen;
    }

    private void sqlScriptGenerator(Map<DiffType, AttributeSet> styles, List<DiffChunk<SQLObject>> diff, DDLGenerator gen) throws ArchitectDiffException, SQLException, SQLObjectException, BadLocationException, InstantiationException, IllegalAccessException {
        block0: for (DiffChunk<SQLObject> chunk : diff) {
            SQLIndex i;
            SQLRelationship r;
            SQLColumn c;
            SQLTable t;
            if (chunk.getType() == DiffType.KEY_CHANGED) {
                if (!(chunk.getData() instanceof SQLTable) || !this.hasKey(t = (SQLTable)chunk.getData())) continue;
                gen.addPrimaryKey(t);
                continue;
            }
            if (chunk.getType() == DiffType.DROP_KEY) {
                if (!(chunk.getData() instanceof SQLTable) || !this.hasKey(t = (SQLTable)chunk.getData())) continue;
                gen.dropPrimaryKey(t);
                continue;
            }
            if (chunk.getType() == DiffType.LEFTONLY) {
                if (chunk.getData() instanceof SQLTable) {
                    t = (SQLTable)chunk.getData();
                    gen.dropTable(t);
                    continue;
                }
                if (chunk.getData() instanceof SQLColumn) {
                    c = (SQLColumn)chunk.getData();
                    gen.dropColumn(c);
                    continue;
                }
                if (chunk.getData() instanceof SQLRelationship) {
                    r = (SQLRelationship)chunk.getData();
                    gen.dropRelationship(r);
                    continue;
                }
                if (chunk.getData() instanceof SQLIndex) {
                    i = (SQLIndex)chunk.getData();
                    gen.dropIndex(i);
                    continue;
                }
                throw new IllegalStateException("DiffChunk is an unexpected type.");
            }
            if (chunk.getType() == DiffType.RIGHTONLY) {
                if (chunk.getData() instanceof SQLTable) {
                    t = (SQLTable)chunk.getData();
                    if (t == null) {
                        throw new NullPointerException();
                    }
                    if (!t.getObjectType().equals("TABLE")) continue;
                    gen.addTable(t);
                    continue;
                }
                if (chunk.getData() instanceof SQLColumn) {
                    c = (SQLColumn)chunk.getData();
                    gen.addColumn(c);
                    continue;
                }
                if (chunk.getData() instanceof SQLRelationship) {
                    r = (SQLRelationship)chunk.getData();
                    gen.addRelationship(r);
                    continue;
                }
                if (chunk.getData() instanceof SQLIndex) {
                    i = (SQLIndex)chunk.getData();
                    gen.addIndex(i);
                    continue;
                }
                throw new IllegalStateException("DiffChunk is an unexpected type.");
            }
            if (chunk.getType() == DiffType.MODIFIED) continue;
            if (chunk.getType() == DiffType.SQL_MODIFIED) {
                if (chunk.getData() instanceof SQLColumn) {
                    c = (SQLColumn)chunk.getData();
                    gen.modifyColumn(c, chunk);
                }
                for (PropertyChange change : chunk.getPropertyChanges()) {
                    if (!change.getPropertyName().equals("remarks")) continue;
                    gen.modifyComment((SQLObject)chunk.getData());
                    continue block0;
                }
                continue;
            }
            if (chunk.getType() == DiffType.SAME) continue;
            if (chunk.getType() == DiffType.NAME_CHANGED) {
                if (chunk.getData() instanceof SQLTable) {
                    SQLTable newTable = (SQLTable)chunk.getData();
                    SQLTable oldTable = (SQLTable)chunk.getOriginalData();
                    gen.renameTable(oldTable, newTable);
                    continue;
                }
                if (chunk.getData() instanceof SQLColumn) {
                    SQLColumn newCol = (SQLColumn)chunk.getData();
                    SQLColumn oldCol = (SQLColumn)chunk.getOriginalData();
                    gen.renameColumn(oldCol, newCol);
                    continue;
                }
                if (chunk.getData() instanceof SQLIndex) {
                    SQLIndex newIndex = (SQLIndex)chunk.getData();
                    SQLIndex oldIndex = (SQLIndex)chunk.getOriginalData();
                    gen.renameIndex(oldIndex, newIndex);
                    continue;
                }
                throw new IllegalStateException("DiffChunk is an unexpected type.");
            }
            throw new IllegalStateException("DiffChunk is an invalid type.");
        }
    }

    public static DefaultStyledDocument generateEnglishDescription(Map<DiffType, AttributeSet> styles, List<DiffChunk<DiffInfo>> diff) throws BadLocationException, SQLObjectException {
        DefaultStyledDocument resultDoc = new DefaultStyledDocument();
        for (DiffChunk<DiffInfo> chunk : diff) {
            String diffTypeEnglish;
            DiffInfo info = (DiffInfo)chunk.getData();
            if (chunk.getType().equals((Object)DiffType.DROP_KEY)) continue;
            AttributeSet attributes = styles.get(chunk.getType());
            SimpleAttributeSet boldAttributes = new SimpleAttributeSet(attributes);
            StyleConstants.setBold(boldAttributes, true);
            switch (chunk.getType()) {
                case LEFTONLY: {
                    diffTypeEnglish = "should be removed";
                    break;
                }
                case MODIFIED: 
                case SQL_MODIFIED: {
                    diffTypeEnglish = "should be modified";
                    break;
                }
                case SAME: {
                    diffTypeEnglish = "needs no changes";
                    break;
                }
                case RIGHTONLY: {
                    diffTypeEnglish = "should be added";
                    break;
                }
                case KEY_CHANGED: {
                    diffTypeEnglish = "needs a different primary key";
                    break;
                }
                case DROP_KEY: {
                    diffTypeEnglish = "needs to drop the source primary key";
                    break;
                }
                case NAME_CHANGED: {
                    diffTypeEnglish = "should be renamed";
                    break;
                }
                default: {
                    diffTypeEnglish = "!UNKNOWN DIFF TYPE!";
                    logger.error((Object)("Woops, unknown diff chunk type: " + chunk.getType()));
                }
            }
            resultDoc.insertString(resultDoc.getLength(), info.toString() + " " + diffTypeEnglish + "\n", attributes);
            for (PropertyChange change : chunk.getPropertyChanges()) {
                logger.debug((Object)"Formatting property change");
                String s = info.getIndent() + "\t" + change.getPropertyName();
                s = s + " has been changed from " + change.getOldValue();
                s = s + " to " + change.getNewValue() + "\n";
                resultDoc.insertString(resultDoc.getLength(), s, attributes);
            }
        }
        return resultDoc;
    }

    private String toTitleText(boolean isSource, SQLObject leftOrRight) {
        StringBuffer fileName = new StringBuffer();
        boolean needBrackets = false;
        CompareDMSettings.SourceOrTargetSettings settings = isSource ? this.dmSetting.getSourceSettings() : this.dmSetting.getTargetSettings();
        if (settings.getDatastoreType().equals((Object)CompareDMSettings.DatastoreType.FILE)) {
            File f = new File(settings.getFilePath());
            String tempName = f.getName();
            int lastIndex = tempName.lastIndexOf(".architect");
            if (lastIndex < 0) {
                fileName.append(tempName);
            } else {
                fileName.append(tempName.substring(0, lastIndex));
            }
            needBrackets = true;
        } else if (settings.getDatastoreType().equals((Object)CompareDMSettings.DatastoreType.PROJECT)) {
            SwingUIProjectLoader swingUIProject = this.session.getProjectLoader();
            String tempName = swingUIProject.getFile() != null ? swingUIProject.getFile().getName() : "New Project";
            int lastIndex = tempName.lastIndexOf(".architect");
            if (lastIndex < 0) {
                fileName.append(tempName);
            } else {
                fileName.append(tempName.substring(0, lastIndex));
            }
            needBrackets = true;
        }
        if (needBrackets) {
            fileName.append(" (");
        }
        fileName.append(SQLObjectUtils.toQualifiedName((SQLObject)leftOrRight));
        if (needBrackets) {
            fileName.append(")");
        }
        return fileName.toString();
    }

    private boolean hasKey(SQLTable t) throws SQLObjectException {
        for (SQLColumn c : t.getColumns()) {
            if (!c.isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    private List<DiffChunk<DiffInfo>> convertToDiffInfo(List<DiffChunk<SQLObject>> diff) {
        ArrayList<DiffChunk<DiffInfo>> newDiff = new ArrayList<DiffChunk<DiffInfo>>();
        ArrayList<Object> ancestors = new ArrayList<Object>();
        ancestors.add(new SQLTable());
        int depth = 0;
        for (DiffChunk<SQLObject> chunk : diff) {
            SQLObject data = (SQLObject)chunk.getData();
            String name = data instanceof SQLTable && data.getPhysicalName() != null ? data.getPhysicalName() : data.getName();
            DiffInfo info = new DiffInfo(data.getClass().getSimpleName().replaceFirst("SQL", ""), name);
            if (chunk.getData() instanceof SQLRelationship) {
                depth = 0;
            } else if (((SQLObject)ancestors.get(depth)).allowsChildType(data.getClass())) {
                ancestors.add(data);
                ++depth;
            }
            while (depth > 0 && !((SQLObject)ancestors.get(depth - 1)).allowsChildType(data.getClass())) {
                ancestors.remove(depth);
                --depth;
            }
            ancestors.add(depth, data);
            info.setDepth(depth);
            DiffChunk newChunk = new DiffChunk((Object)info, chunk.getType());
            for (PropertyChange change : chunk.getPropertyChanges()) {
                newChunk.addPropertyChange(change);
            }
            newDiff.add((DiffChunk<DiffInfo>)newChunk);
        }
        return newDiff;
    }

    static {
        SimpleAttributeSet att = new SimpleAttributeSet();
        StyleConstants.setForeground(att, Color.red);
        DIFF_STYLES.put(DiffType.LEFTONLY, att);
        att = new SimpleAttributeSet();
        StyleConstants.setForeground(att, Color.green.darker().darker());
        DIFF_STYLES.put(DiffType.RIGHTONLY, att);
        att = new SimpleAttributeSet();
        StyleConstants.setForeground(att, Color.black);
        DIFF_STYLES.put(DiffType.SAME, att);
        att = new SimpleAttributeSet();
        StyleConstants.setForeground(att, Color.orange);
        DIFF_STYLES.put(DiffType.MODIFIED, att);
        att = new SimpleAttributeSet();
        StyleConstants.setForeground(att, Color.orange);
        DIFF_STYLES.put(DiffType.SQL_MODIFIED, att);
        att = new SimpleAttributeSet();
        StyleConstants.setForeground(att, Color.blue);
        DIFF_STYLES.put(DiffType.KEY_CHANGED, att);
        DIFF_STYLES.put(DiffType.DROP_KEY, att);
        DIFF_STYLES.put(DiffType.NAME_CHANGED, att);
    }
}

