/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.CompareDMDialog;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.ProfiledTableIconFilter;
import ca.sqlpower.architect.swingui.action.DataSourcePropertiesAction;
import ca.sqlpower.architect.swingui.action.DatabaseConnectionManagerAction;
import ca.sqlpower.architect.swingui.action.NewDataSourceAction;
import ca.sqlpower.architect.swingui.action.RefreshAction;
import ca.sqlpower.architect.swingui.action.RemoveSourceDBAction;
import ca.sqlpower.architect.swingui.action.ShowTableContentsAction;
import ca.sqlpower.architect.swingui.dbtree.DBTreeCellRenderer;
import ca.sqlpower.architect.swingui.dbtree.DBTreeModel;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPObjectSnapshot;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.JDBCDataSourcePanel;
import ca.sqlpower.swingui.JTreeCollapseAllAction;
import ca.sqlpower.swingui.JTreeExpandAllAction;
import ca.sqlpower.swingui.MultiDragTreeUI;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.SPSwingWorker;
import ca.sqlpower.swingui.SwingWorkerRegistry;
import ca.sqlpower.swingui.dbtree.SQLObjectSelection;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DBTree
extends JTree
implements DragSourceListener {
    private static Logger logger = Logger.getLogger(DBTree.class);
    public static final String ACTION_COMMAND_SRC_DBTREE = "DBTree";
    protected JPopupMenu popup;
    protected JMenu dbcsMenu;
    protected JDBCDataSourcePanel spDataSourcePanel;
    protected NewDataSourceAction newDBCSAction;
    private DataSourcePropertiesAction dbcsPropertiesAction;
    private RemoveSourceDBAction removeDBCSAction;
    protected ShowInPlayPenAction showInPlayPenAction;
    protected Action collapseAllAction;
    protected Action expandAllAction;
    protected SetConnAsTargetDB setConnAsTargetDB;
    protected SelectAllChildTablesAction selectAllChildTablesAction;
    private boolean popupMenuEnabled = true;
    private final ArchitectSwingSession session;
    private static final Object KEY_DELETE_SELECTED = "ca.sqlpower.architect.swingui.DBTree.KEY_DELETE_SELECTED";
    private static final String KEY_LEFT = "ca.sqlpower.architect.swingui.DBTree.KEY_LEFT";
    private static final String KEY_RIGHT = "ca.sqlpower.architect.swingui.DBTree.KEY_RIGHT";
    private final DBTreeModel treeModel;
    private final DBTreeCellRenderer treeCellRenderer;

    public DBTree(final ArchitectSwingSession session) {
        this.session = session;
        this.treeModel = session.isEnterpriseSession() ? new DBTreeModel(session.getRootObject(), this, (SPObject)session.getWorkspace().getSnapshotCollection()) : new DBTreeModel(session.getRootObject(), this);
        this.setModel(this.treeModel);
        this.setUI((TreeUI)new MultiDragTreeUI());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        if (!GraphicsEnvironment.isHeadless()) {
            new DragSource().createDefaultDragGestureRecognizer(this, 1, new DBTreeDragGestureListener());
        }
        this.setConnAsTargetDB = new SetConnAsTargetDB(null);
        this.newDBCSAction = new NewDataSourceAction(session);
        this.dbcsPropertiesAction = new DataSourcePropertiesAction(session);
        this.removeDBCSAction = new RemoveSourceDBAction(this);
        this.showInPlayPenAction = new ShowInPlayPenAction();
        this.collapseAllAction = new JTreeCollapseAllAction((JTree)this, Messages.getString("DBTree.collapseAllActionName"));
        this.expandAllAction = new JTreeExpandAllAction((JTree)this, Messages.getString("DBTree.expandAllActionName"));
        this.addMouseListener(new PopupListener());
        this.treeCellRenderer = new DBTreeCellRenderer();
        this.getTreeCellRenderer().addIconFilter(new ProfiledTableIconFilter());
        this.setCellRenderer(this.getTreeCellRenderer());
        this.selectAllChildTablesAction = new SelectAllChildTablesAction();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (DBTree.this.getPathForLocation(e.getX(), e.getY()) != null) {
                    Object node = DBTree.this.getPathForLocation(e.getX(), e.getY()).getLastPathComponent();
                    if (e.getClickCount() == 2 && node instanceof SQLObject && !((SQLObject)node).getChildrenInaccessibleReasons().isEmpty()) {
                        Throwable firstException = (Throwable)((SQLObject)node).getChildrenInaccessibleReasons().entrySet().iterator().next().getValue();
                        SPSUtils.showExceptionDialogNoReport((Component)session.getArchitectFrame(), (String)Messages.getString("DBTree.exceptionNodeReport"), (Throwable)firstException);
                    }
                }
            }
        });
        this.getActionMap().put("copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBTree.this.copySelection();
            }
        });
        this.getActionMap().put("cut", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBTree.this.cutSelection();
            }
        });
    }

    public List<SQLDatabase> getDatabaseList() {
        ArrayList<SQLDatabase> databases = new ArrayList<SQLDatabase>();
        TreeModel m = this.getModel();
        int dbCount = m.getChildCount(m.getRoot());
        for (int i = 0; i < dbCount; ++i) {
            Object child = m.getChild(m.getRoot(), i);
            if (!(child instanceof SQLDatabase)) continue;
            databases.add((SQLDatabase)child);
        }
        return databases;
    }

    public boolean dbcsAlreadyExists(SPDataSource spec) throws SQLObjectException {
        SQLObject so = (SQLObject)this.getModel().getRoot();
        Iterator it = so.getChildren(SQLDatabase.class).iterator();
        boolean found = false;
        while (it.hasNext() && !found) {
            JDBCDataSource dbcs = ((SQLDatabase)it.next()).getDataSource();
            if (dbcs == null || !dbcs.equals((Object)spec)) continue;
            found = true;
        }
        return found;
    }

    public SQLDatabase getDatabase(SPDataSource spec) throws SQLObjectException {
        SQLObject so = (SQLObject)this.getModel().getRoot();
        Iterator it = so.getChildren(SQLDatabase.class).iterator();
        boolean found = false;
        while (it.hasNext() && !found) {
            SQLDatabase database = (SQLDatabase)it.next();
            JDBCDataSource dbcs = database.getDataSource();
            if (!dbcs.equals((Object)spec)) continue;
            return database;
        }
        return null;
    }

    public JDBCDataSource getDuplicateDbcs(SPDataSource spec) {
        JDBCDataSource dup = null;
        boolean found = false;
        Iterator<JDBCDataSource> it = this.session.getContext().getConnections().iterator();
        while (it.hasNext() && !found) {
            JDBCDataSource dbcs = it.next();
            if (!spec.equals((Object)dbcs)) continue;
            dup = dbcs;
            found = true;
        }
        return dup;
    }

    public int getRowForNode(SQLObject node) {
        DBTreeModel m = (DBTreeModel)this.getModel();
        TreePath path = new TreePath(m.getPathToNode((SPObject)node));
        return this.getRowForPath(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expandPath(TreePath tp) {
        try {
            this.session.getArchitectFrame().setCursor(new Cursor(3));
            super.expandPath(tp);
        }
        catch (Exception ex) {
            logger.warn((Object)("Unexpected exception while expanding path " + tp), (Throwable)ex);
        }
        finally {
            this.session.getArchitectFrame().setCursor(null);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        logger.debug((Object)"DBTree: got dragEnter event");
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        logger.debug((Object)"DBTree: got dragOver event");
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
        logger.debug((Object)"DBTree: got dropActionChanged event");
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
        logger.debug((Object)"DBTree: got dragExit event");
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        logger.debug((Object)"DBTree: got dragDropEnd event");
    }

    protected JPopupMenu refreshMenu(TreePath p) {
        logger.debug((Object)"refreshMenu is being called.");
        JPopupMenu newMenu = new JPopupMenu();
        newMenu.add(this.session.createDataSourcesMenu());
        newMenu.add(new DatabaseConnectionManagerAction(this.session));
        newMenu.addSeparator();
        newMenu.add(new JMenuItem(this.expandAllAction));
        newMenu.add(new JMenuItem(this.collapseAllAction));
        this.expandAllAction.setEnabled(p != null);
        this.collapseAllAction.setEnabled(p != null);
        if (!this.isTargetDatabaseNode(p) && this.isTargetDatabaseChild(p)) {
            newMenu.addSeparator();
            ArchitectFrame af = this.session.getArchitectFrame();
            JMenuItem mi = new JMenuItem();
            mi.setAction(af.getInsertIndexAction());
            mi.setActionCommand(ACTION_COMMAND_SRC_DBTREE);
            newMenu.add(mi);
            if (p.getLastPathComponent() instanceof SQLTable) {
                mi.setEnabled(true);
            } else {
                mi.setEnabled(false);
            }
            mi = new JMenuItem();
            mi.setAction(af.getEditIndexAction());
            mi.setActionCommand(ACTION_COMMAND_SRC_DBTREE);
            newMenu.add(mi);
            if (p.getLastPathComponent() instanceof SQLIndex) {
                mi.setEnabled(true);
            } else {
                mi.setEnabled(false);
            }
            newMenu.addSeparator();
            mi = new JMenuItem();
            mi.setAction(af.getInsertColumnAction());
            mi.setActionCommand(ACTION_COMMAND_SRC_DBTREE);
            newMenu.add(mi);
            if (p.getLastPathComponent() instanceof SQLTable || p.getLastPathComponent() instanceof SQLColumn) {
                mi.setEnabled(true);
            } else {
                mi.setEnabled(false);
            }
            mi = new JMenuItem();
            mi.setAction(af.getEditColumnAction());
            mi.setActionCommand(ACTION_COMMAND_SRC_DBTREE);
            newMenu.add(mi);
            if (p.getLastPathComponent() instanceof SQLColumn) {
                mi.setEnabled(true);
            } else {
                mi.setEnabled(false);
            }
            newMenu.addSeparator();
            JMenu setFocus = new JMenu(Messages.getString("Relationship.setFocusMenu"));
            mi = new JMenuItem();
            mi.setAction(af.getFocusToParentAction());
            setFocus.add(mi);
            mi = new JMenuItem();
            mi.setAction(af.getFocusToChildAction());
            setFocus.add(mi);
            newMenu.add(setFocus);
            if (p.getLastPathComponent() instanceof SQLRelationship) {
                setFocus.setEnabled(true);
            } else {
                setFocus.setEnabled(false);
            }
            mi = new JMenuItem(af.getReverseRelationshipAction());
            newMenu.add(mi);
            if (p.getLastPathComponent() instanceof SQLRelationship) {
                mi.setEnabled(true);
            } else {
                mi.setEnabled(false);
            }
            mi = new JMenuItem();
            mi.setAction(af.getEditRelationshipAction());
            mi.setActionCommand(ACTION_COMMAND_SRC_DBTREE);
            newMenu.add(mi);
            if (p.getLastPathComponent() instanceof SQLRelationship) {
                mi.setEnabled(true);
            } else {
                mi.setEnabled(false);
            }
            newMenu.addSeparator();
            JMenu alignTables = new JMenu(Messages.getString("TablePane.alignTablesMenu"));
            mi = new JMenuItem();
            mi.setAction(af.getAlignTableHorizontalAction());
            alignTables.add(mi);
            mi = new JMenuItem();
            mi.setAction(af.getAlignTableVerticalAction());
            alignTables.add(mi);
            newMenu.add(alignTables);
            if (p.getLastPathComponent() instanceof SQLTable) {
                alignTables.setEnabled(true);
            } else {
                alignTables.setEnabled(false);
            }
            mi = new JMenuItem();
            mi.setAction(af.getEditTableAction());
            mi.setActionCommand(ACTION_COMMAND_SRC_DBTREE);
            newMenu.add(mi);
            if (p.getLastPathComponent() instanceof SQLTable) {
                mi.setEnabled(true);
            } else {
                mi.setEnabled(false);
            }
            newMenu.addSeparator();
            mi = new JMenuItem(this.showInPlayPenAction);
            newMenu.add(mi);
            if (p.getLastPathComponent() instanceof SQLTable || p.getLastPathComponent() instanceof SQLColumn || p.getLastPathComponent() instanceof SQLRelationship) {
                mi.setEnabled(true);
            } else {
                mi.setEnabled(false);
            }
            newMenu.addSeparator();
            mi = new JMenuItem();
            mi.setAction(af.getDeleteSelectedAction());
            mi.setActionCommand(ACTION_COMMAND_SRC_DBTREE);
            newMenu.add(mi);
            if (p.getLastPathComponent() instanceof SQLTable || p.getLastPathComponent() instanceof SQLColumn || p.getLastPathComponent() instanceof SQLRelationship || p.getLastPathComponent() instanceof SQLIndex) {
                mi.setEnabled(true);
            } else {
                mi.setEnabled(false);
            }
        } else if (p != null && p.getLastPathComponent() instanceof SPObjectSnapshot) {
            final SPObjectSnapshot snapshot = (SPObjectSnapshot)p.getLastPathComponent();
            newMenu.addSeparator();
            newMenu.add(new AbstractAction("Update to latest changes"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBTree.this.session.createUpdateSnapshotRunnable(snapshot).run();
                }
            });
        } else if (p != null && !this.isTargetDatabaseNode(p) && p.getLastPathComponent() != this.treeModel.getSnapshotContainer()) {
            newMenu.addSeparator();
            newMenu.add(new RefreshAction(this.session, this));
            newMenu.addSeparator();
            if (p.getLastPathComponent() instanceof SQLDatabase) {
                SQLDatabase tempDB = (SQLDatabase)p.getLastPathComponent();
                try {
                    if (!(tempDB.isCatalogContainer() || tempDB.isSchemaContainer() || tempDB.getChildCount() == 1 && !tempDB.getChildrenInaccessibleReasons().isEmpty())) {
                        CompareToCurrentAction compareToCurrentAction = new CompareToCurrentAction();
                        compareToCurrentAction.putValue("DATABASE", tempDB);
                        JMenuItem popupCompareToCurrent = new JMenuItem(compareToCurrentAction);
                        newMenu.add(popupCompareToCurrent);
                    }
                }
                catch (SQLObjectException e) {
                    SPSUtils.showExceptionDialogNoReport((Component)this, (String)Messages.getString("DBTree.errorCommunicatingWithDb"), (Throwable)e);
                }
                JMenuItem profile = new JMenuItem(this.session.getArchitectFrame().getProfileAction());
                newMenu.add(profile);
                JMenuItem setAsDB = new JMenuItem(new SetConnAsTargetDB(tempDB.getDataSource()));
                newMenu.add(setAsDB);
                newMenu.add(new JMenuItem(this.removeDBCSAction));
                newMenu.addSeparator();
            } else if (p.getLastPathComponent() instanceof SQLSchema) {
                CompareToCurrentAction compareToCurrentAction = new CompareToCurrentAction();
                compareToCurrentAction.putValue("SCHEMA", p.getLastPathComponent());
                JMenuItem popupCompareToCurrent = new JMenuItem(compareToCurrentAction);
                newMenu.add(popupCompareToCurrent);
                JMenuItem profile = new JMenuItem(this.session.getArchitectFrame().getProfileAction());
                newMenu.add(profile);
                newMenu.addSeparator();
            } else if (p.getLastPathComponent() instanceof SQLCatalog) {
                SQLCatalog catalog = (SQLCatalog)p.getLastPathComponent();
                try {
                    if (!catalog.isSchemaContainer()) {
                        CompareToCurrentAction compareToCurrentAction = new CompareToCurrentAction();
                        compareToCurrentAction.putValue("CATALOG", catalog);
                        JMenuItem popupCompareToCurrent = new JMenuItem(compareToCurrentAction);
                        newMenu.add(popupCompareToCurrent);
                    }
                }
                catch (SQLObjectException e) {
                    SPSUtils.showExceptionDialogNoReport((Component)this, (String)Messages.getString("DBTree.errorCommunicatingWithDb"), (Throwable)e);
                }
                JMenuItem profile = new JMenuItem(this.session.getArchitectFrame().getProfileAction());
                newMenu.add(profile);
                newMenu.addSeparator();
            } else if (p.getLastPathComponent() instanceof SQLTable) {
                JMenuItem profile = new JMenuItem(this.session.getArchitectFrame().getProfileAction());
                newMenu.add(profile);
                JMenuItem selectAllChildTables = new JMenuItem(this.selectAllChildTablesAction);
                newMenu.add(selectAllChildTables);
                newMenu.add(new JMenuItem(new ShowTableContentsAction(this.session, (SQLTable)p.getLastPathComponent())));
                newMenu.addSeparator();
            }
            JMenuItem popupProperties = new JMenuItem(this.dbcsPropertiesAction);
            newMenu.add(popupProperties);
        }
        if (p != null && p.getLastPathComponent() instanceof SQLObject && !((SQLObject)p.getLastPathComponent()).getChildrenInaccessibleReasons().isEmpty()) {
            newMenu.addSeparator();
            final SQLObject node = (SQLObject)p.getLastPathComponent();
            newMenu.add(new JMenuItem(new AbstractAction(Messages.getString("DBTree.showExceptionDetails")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Throwable firstException = (Throwable)node.getChildrenInaccessibleReasons().entrySet().iterator().next().getValue();
                    SPSUtils.showExceptionDialogNoReport((Component)DBTree.this.session.getArchitectFrame(), (String)Messages.getString("DBTree.exceptionNodeReport"), (Throwable)firstException);
                }
            }));
            if (!node.getChildrenInaccessibleReasons().isEmpty()) {
                newMenu.add(new JMenuItem(new AbstractAction(Messages.getString("DBTree.retryActionName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        node.setPopulated(false);
                        node.getChildren();
                    }
                }));
            }
        }
        if (logger.isDebugEnabled()) {
            newMenu.addSeparator();
            JMenuItem showListeners = new JMenuItem("Show Listeners");
            showListeners.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLObject so = (SQLObject)DBTree.this.getLastSelectedPathComponent();
                    if (so != null) {
                        JOptionPane.showMessageDialog(DBTree.this, new JScrollPane(new JList(new Vector(so.getSPListeners()))));
                    }
                }
            });
            newMenu.add(showListeners);
        }
        return newMenu;
    }

    public boolean isTargetDatabaseNode(TreePath tp) {
        if (tp == null) {
            return false;
        }
        return this.session.getTargetDatabase() == tp.getLastPathComponent();
    }

    public boolean isTargetDatabaseChild(TreePath tp) {
        if (tp == null) {
            return false;
        }
        Object[] oo = tp.getPath();
        for (int i = 0; i < oo.length; ++i) {
            if (this.session.getTargetDatabase() != oo[i]) continue;
            return true;
        }
        return false;
    }

    public void addSourceConnection(SPDataSource dbcs) {
        SQLObject root = (SQLObject)this.getModel().getRoot();
        try {
            if (this.dbcsAlreadyExists(dbcs) && !dbcs.equals((Object)this.session.getTargetDatabase().getDataSource())) {
                logger.warn((Object)"database already exists in this project.");
                JOptionPane.showMessageDialog(this, Messages.getString("DBTree.connectionAlreadyExists", dbcs.getDisplayName()), Messages.getString("DBTree.connectionAlreadyExistsDialogTitle"), 2);
            } else if (dbcs instanceof JDBCDataSource) {
                SQLDatabase newDB = new SQLDatabase((JDBCDataSource)dbcs);
                root.addChild((SPObject)newDB, root.getChildCount());
                this.session.getProjectLoader().setModified(true);
                logger.debug((Object)("start poking database " + newDB.getName()));
                PokeDBWorker poker = new PokeDBWorker((SQLObject)newDB);
                this.session.runInBackground((Runnable)((Object)poker), "PokeDB: " + newDB.getName());
            } else {
                JOptionPane.showMessageDialog(this, Messages.getString("DBTree.cannotAddConnectionType", dbcs.getClass().toString()), Messages.getString("DBTree.cannotAddConnectionTypeTitle"), 1);
            }
        }
        catch (SQLObjectException ex) {
            logger.warn((Object)"Couldn't add new database to tree", (Throwable)ex);
            SPSUtils.showExceptionDialogNoReport((Component)this.session.getArchitectFrame(), (String)Messages.getString("DBTree.couldNotAddNewConnection"), (Throwable)ex);
        }
    }

    public void setupKeyboardActions() {
        final ArchitectFrame frame = this.session.getArchitectFrame();
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), KEY_DELETE_SELECTED);
        this.getActionMap().put(KEY_DELETE_SELECTED, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePath tp = DBTree.this.getSelectionPath();
                if (tp != null) {
                    if (!DBTree.this.isTargetDatabaseNode(tp) && DBTree.this.isTargetDatabaseChild(tp)) {
                        frame.getDeleteSelectedAction().actionPerformed(evt);
                    } else if (!DBTree.this.isTargetDatabaseNode(tp) && tp.getLastPathComponent() instanceof SQLDatabase) {
                        DBTree.this.removeDBCSAction.actionPerformed(evt);
                    }
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(37, 0), KEY_LEFT);
        inputMap.put(KeyStroke.getKeyStroke(39, 0), KEY_RIGHT);
        this.getActionMap().put(KEY_LEFT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath selection = DBTree.this.getSelectionPath();
                if (selection != null) {
                    if (DBTree.this.isExpanded(selection) && DBTree.this.treeModel.getChildCount(selection.getLastPathComponent()) != 0) {
                        DBTree.this.setExpandedState(selection, false);
                    } else if (selection.getPathCount() != 2) {
                        DBTree.this.setSelectionPath(selection.getParentPath());
                    }
                }
            }
        });
        this.getActionMap().put(KEY_RIGHT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath selection = DBTree.this.getSelectionPath();
                if (selection != null && !DBTree.this.treeModel.isLeaf(selection.getLastPathComponent()) && !DBTree.this.isExpanded(selection)) {
                    DBTree.this.setExpandedState(selection, true);
                }
            }
        });
    }

    Set<SQLObject> findSQLObjectsToCopy() {
        TreePath[] p = this.getSelectionPaths();
        HashSet<SQLObject> objectsToTransfer = new HashSet<SQLObject>();
        if (p == null || p.length == 0) {
            return new HashSet<SQLObject>();
        }
        HashMap pathLengthsToSelectedObjectsMap = new HashMap();
        for (int i = 0; i < p.length; ++i) {
            if (!(p[i].getLastPathComponent() instanceof SQLObject)) continue;
            if (pathLengthsToSelectedObjectsMap.get(p[i].getPathCount()) == null) {
                pathLengthsToSelectedObjectsMap.put(p[i].getPathCount(), new ArrayList());
            }
            ((List)pathLengthsToSelectedObjectsMap.get(p[i].getPathCount())).add((SQLObject)p[i].getLastPathComponent());
        }
        ArrayList sortedLengths = new ArrayList(pathLengthsToSelectedObjectsMap.keySet());
        Collections.sort(sortedLengths);
        for (int i = 0; i < sortedLengths.size(); ++i) {
            SQLObject parent;
            SQLObject childObject;
            Iterator i$;
            int j;
            Integer pathCount = (Integer)sortedLengths.get(i);
            if (((List)pathLengthsToSelectedObjectsMap.get(pathCount)).size() > 1) {
                objectsToTransfer.addAll((Collection)pathLengthsToSelectedObjectsMap.get(pathCount));
                for (int j2 = i + 1; j2 < sortedLengths.size(); ++j2) {
                    Iterator i$2 = ((List)pathLengthsToSelectedObjectsMap.get(sortedLengths.get(j2))).iterator();
                    while (i$2.hasNext()) {
                        SQLObject childObject2;
                        SQLObject parent2 = childObject2 = (SQLObject)i$2.next();
                        logger.debug((Object)("Initial Object before recursively go to parent is: " + parent2));
                        for (int k = 0; k < (Integer)sortedLengths.get(j2) - pathCount && parent2.getParent() instanceof SQLObject; ++k) {
                            parent2 = (SQLObject)parent2.getParent();
                        }
                        objectsToTransfer.add(parent2);
                        logger.debug((Object)("Final Object after recursively go to parent is: " + parent2));
                    }
                }
                break;
            }
            SQLObject singleParent = (SQLObject)((List)pathLengthsToSelectedObjectsMap.get(pathCount)).get(0);
            boolean isParentOfAllSelected = true;
            for (j = i + 1; j < sortedLengths.size(); ++j) {
                i$ = ((List)pathLengthsToSelectedObjectsMap.get(sortedLengths.get(j))).iterator();
                while (i$.hasNext()) {
                    parent = childObject = (SQLObject)i$.next();
                    boolean parented = false;
                    for (int k = 0; k < (Integer)sortedLengths.get(j) - pathCount && parent.getParent() instanceof SQLObject; ++k) {
                        if ((parent = (SQLObject)parent.getParent()) != singleParent) continue;
                        parented = true;
                        break;
                    }
                    if (parented) continue;
                    isParentOfAllSelected = false;
                    break;
                }
                if (!isParentOfAllSelected) break;
            }
            if (!isParentOfAllSelected) {
                objectsToTransfer.addAll((Collection)pathLengthsToSelectedObjectsMap.get(pathCount));
                for (j = i + 1; j < sortedLengths.size(); ++j) {
                    i$ = ((List)pathLengthsToSelectedObjectsMap.get(sortedLengths.get(j))).iterator();
                    while (i$.hasNext()) {
                        parent = childObject = (SQLObject)i$.next();
                        for (int k = 0; k < (Integer)sortedLengths.get(j) - pathCount && parent.getParent() instanceof SQLObject; ++k) {
                            parent = (SQLObject)parent.getParent();
                        }
                        objectsToTransfer.add(parent);
                    }
                }
                break;
            }
            if (i + 1 != sortedLengths.size()) continue;
            objectsToTransfer.addAll((Collection)pathLengthsToSelectedObjectsMap.get(pathCount));
        }
        logger.info((Object)"DBTree: exporting list of DnD-type tree paths");
        if (logger.isDebugEnabled()) {
            for (SQLObject object : objectsToTransfer) {
                logger.debug((Object)("The object to transfer copy is: " + object));
            }
        }
        return objectsToTransfer;
    }

    public void copySelection() {
        SQLObjectSelection transferObject = new SQLObjectSelection(this.findSQLObjectsToCopy());
        if (transferObject != null) {
            this.session.getContext().setClipboardContents((Transferable)transferObject);
        }
    }

    public void cutSelection() {
        Set<SQLObject> copyObjects = this.findSQLObjectsToCopy();
        SQLObjectSelection transferObject = new SQLObjectSelection(copyObjects);
        if (transferObject != null) {
            this.session.getContext().setClipboardContents((Transferable)transferObject);
        }
        for (SQLObject o : copyObjects) {
            SQLDatabase target;
            if (o.equals((Object)(target = this.session.getTargetDatabase()))) break;
            if (!SQLObjectUtils.ancestorList((SQLObject)o).contains(target)) continue;
            try {
                o.getParent().removeChild((SPObject)o);
            }
            catch (ObjectDependentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void clearNonPlayPenSelections() {
        if (this.getSelectionPaths() == null) {
            return;
        }
        for (TreePath tp : this.getSelectionPaths()) {
            SPObject obj = (SPObject)tp.getLastPathComponent();
            if (obj instanceof SQLTable || obj instanceof SQLRelationship || obj instanceof SQLColumn || obj instanceof SQLRelationship.SQLImportedKey) continue;
            this.removeSelectionPath(tp);
        }
    }

    public TreePath getTreePathForNode(SQLObject obj) {
        return new TreePath(this.treeModel.getPathToNode((SPObject)obj));
    }

    public void setPopupMenuEnabled(boolean popupMenuEnabled) {
        this.popupMenuEnabled = popupMenuEnabled;
    }

    public boolean isPopupMenuEnabled() {
        return this.popupMenuEnabled;
    }

    public DBTreeCellRenderer getTreeCellRenderer() {
        return this.treeCellRenderer;
    }

    protected class SelectAllChildTablesAction
    extends AbstractAction {
        public SelectAllChildTablesAction() {
            super(Messages.getString("DBTree.selectAllChildTablesActionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath selected = DBTree.this.getSelectionPath();
            try {
                if (selected == null) {
                    return;
                }
                SQLTable centralTable = (SQLTable)selected.getLastPathComponent();
                List exportedKeys = centralTable.getExportedKeys();
                for (int i = 0; i < exportedKeys.size(); ++i) {
                    SQLTable childTable = ((SQLRelationship)exportedKeys.get(i)).getFkTable();
                    DBTree.this.addSelectionPath(DBTree.this.getTreePathForNode((SQLObject)childTable));
                }
            }
            catch (SQLObjectException ex) {
                logger.debug((Object)"Failed to select all child tables", (Throwable)ex);
                throw new SQLObjectRuntimeException(ex);
            }
        }
    }

    protected class ShowInPlayPenAction
    extends AbstractAction {
        public ShowInPlayPenAction() {
            super(Messages.getString("DBTree.showInPlaypenAction"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DBTree.this.session.getPlayPen().showSelected();
        }
    }

    public static class DBTreeDragGestureListener
    implements DragGestureListener {
        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            SQLObjectSelection transferObject;
            logger.info((Object)("Drag gesture event: " + dge));
            InputEvent ie = dge.getTriggerEvent();
            if ((ie.getModifiers() & 0x10) == 0) {
                return;
            }
            DBTree t = (DBTree)dge.getComponent();
            Set<SQLObject> sqlObjectsToCopy = t.findSQLObjectsToCopy();
            if (!sqlObjectsToCopy.isEmpty() && (transferObject = new SQLObjectSelection(sqlObjectsToCopy)) != null) {
                dge.getSourceAsDragGestureRecognizer().setSourceActions(1);
                dge.getDragSource().startDrag(dge, null, (Transferable)transferObject, t);
            }
        }
    }

    protected class CompareToCurrentAction
    extends AbstractAction {
        public static final String SCHEMA = "SCHEMA";
        public static final String CATALOG = "CATALOG";
        public static final String DATABASE = "DATABASE";

        public CompareToCurrentAction() {
            super(Messages.getString("DBTree.compareToCurrentActionName"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SQLSchema schema = null;
            SQLDatabase db = null;
            SQLCatalog catalog = null;
            if (this.getValue(SCHEMA) != null) {
                schema = (SQLSchema)this.getValue(SCHEMA);
                if (schema.getParent().getParent() instanceof SQLDatabase) {
                    db = (SQLDatabase)schema.getParent().getParent();
                    catalog = (SQLCatalog)schema.getParent();
                } else {
                    db = (SQLDatabase)schema.getParent();
                }
            } else if (this.getValue(CATALOG) != null) {
                catalog = (SQLCatalog)this.getValue(CATALOG);
                db = catalog.getParent();
            } else if (this.getValue(DATABASE) != null) {
                db = (SQLDatabase)this.getValue(DATABASE);
            }
            CompareDMDialog compareDialog = new CompareDMDialog(DBTree.this.session);
            compareDialog.setVisible(true);
            compareDialog.compareCurrentWithOrig(schema, catalog, db);
        }
    }

    private class PokeDBWorker
    extends SPSwingWorker {
        final SQLObject root;
        SQLObject mostRecentlyVisited;

        PokeDBWorker(SQLObject so) {
            super((SwingWorkerRegistry)DBTree.this.session);
            this.root = so;
        }

        public void doStuff() throws Exception {
            this.pokeDatabase(this.root);
            logger.debug((Object)("successfully poked database " + this.root.getName()));
        }

        private boolean pokeDatabase(SQLObject source) throws SQLObjectException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HELLO my class is " + source.getClass().getName() + ", my name is + " + source.getName()));
            }
            if (source.allowsChildren()) {
                this.mostRecentlyVisited = source;
                boolean done = false;
                int childCount = source.getChildCount();
                for (int j = 0; !done && j < childCount; ++j) {
                    done = this.pokeDatabase(source.getChild(j));
                }
                return done;
            }
            return true;
        }

        public void cleanup() throws Exception {
            if (this.getDoStuffException() != null) {
                throw new RuntimeException(this.getDoStuffException());
            }
        }
    }

    protected class SetConnAsTargetDB
    extends AbstractAction {
        JDBCDataSource dbcs;

        public SetConnAsTargetDB(JDBCDataSource dbcs) {
            super(Messages.getString("DBTree.setAsTargetDbActionName"));
            this.dbcs = dbcs;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DBTree.this.session.getPlayPen().setDatabaseConnection(this.dbcs);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e, true);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e, false);
        }

        private void maybeShowPopup(MouseEvent e, boolean isPress) {
            TreePath p = DBTree.this.getPathForLocation(e.getX(), e.getY());
            if (e.isPopupTrigger()) {
                logger.debug((Object)("TreePath is: " + p));
                if (p != null) {
                    logger.debug((Object)("selected node object type is: " + p.getLastPathComponent().getClass().getName()));
                }
                if (!DBTree.this.isPathSelected(p)) {
                    DBTree.this.setSelectionPath(p);
                }
                if (DBTree.this.popupMenuEnabled) {
                    DBTree.this.popup = DBTree.this.refreshMenu(p);
                    DBTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            } else if (p == null && !isPress && e.getButton() == 1) {
                DBTree.this.setSelectionPath(null);
            }
        }
    }
}

