/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class ImportSafetyChecker {
    private final ArchitectSwingSession targetSession;
    private boolean isCancelled = false;
    UserPrompter loseLineage;

    ImportSafetyChecker(ArchitectSwingSession session) {
        this.targetSession = session;
        this.loseLineage = this.targetSession.createUserPrompter("One or more columns in {0} have ETL lineage from their source session. \nThis lineage will not be able to be copied along with them. \nCopy {0} anyway, and lose ETL lineage of one or more columns?", UserPrompterFactory.UserPromptType.BOOLEAN, UserPrompter.UserPromptOptions.OK_NOTOK_CANCEL, UserPrompter.UserPromptResponse.NOT_OK, UserPrompter.UserPromptResponse.NOT_OK, new String[]{"Yes", "No", "Cancel"});
    }

    List<SQLObject> filterImportedItems(Collection<SQLObject> items) {
        ArrayList<SQLObject> acceptedItems = new ArrayList<SQLObject>();
        for (SQLObject item : items) {
            if (this.accept(item)) {
                acceptedItems.add(item);
            }
            if (!this.isCancelled) continue;
            return Collections.emptyList();
        }
        return acceptedItems;
    }

    private boolean accept(SQLObject item) {
        SQLObject parent = item;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        if (this.targetSession.getWorkspace() == parent) {
            return true;
        }
        if (!this.visit(item)) {
            UserPrompter.UserPromptResponse response = this.loseLineage.promptUser(new Object[]{item.getPhysicalName()});
            if (response == UserPrompter.UserPromptResponse.CANCEL) {
                this.isCancelled = true;
            }
            return response == UserPrompter.UserPromptResponse.OK;
        }
        return true;
    }

    public boolean visit(SQLObject item) {
        SQLObject child;
        boolean subtreeAccepted = true;
        if (item instanceof SQLColumn) {
            return this.sourceDatabaseAccessible((SQLColumn)item, this.targetSession);
        }
        Iterator i$ = item.getChildren().iterator();
        while (i$.hasNext() && (subtreeAccepted &= this.visit(child = (SQLObject)i$.next()))) {
        }
        return subtreeAccepted;
    }

    private boolean sourceDatabaseAccessible(SQLColumn sourceColumn, ArchitectSwingSession targetSession) {
        SQLDatabase sourceSourceDatabase;
        if (sourceColumn.getSourceColumn() == null) {
            sourceColumn.setSourceColumn(sourceColumn);
        }
        return (sourceSourceDatabase = (SQLDatabase)SQLPowerUtils.getAncestor((SPObject)sourceColumn.getSourceColumn(), SQLDatabase.class)) == null || targetSession.getDBTree().getDuplicateDbcs((SPDataSource)sourceSourceDatabase.getDataSource()) != null;
    }
}

