/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.ArchitectVersion;
import ca.sqlpower.architect.ProjectLoader;
import ca.sqlpower.architect.ProjectSettings;
import ca.sqlpower.architect.UnclosableInputStream;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.LiquibaseSettings;
import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.CriticGrouping;
import ca.sqlpower.architect.ddl.critic.CriticManager;
import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.MondrianXMLReader;
import ca.sqlpower.architect.olap.MondrianXMLWriter;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ColumnValueCount;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.TableProfileResult;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.CompareDMSettings;
import ca.sqlpower.architect.swingui.ContainerPane;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PrintSettings;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.olap.CubePane;
import ca.sqlpower.architect.swingui.olap.DimensionPane;
import ca.sqlpower.architect.swingui.olap.OLAPEditSession;
import ca.sqlpower.architect.swingui.olap.OLAPPane;
import ca.sqlpower.architect.swingui.olap.UsageComponent;
import ca.sqlpower.architect.swingui.olap.VirtualCubePane;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.sqlobject.SQLTypePhysicalProperties;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import ca.sqlpower.util.ExceptionReport;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import ca.sqlpower.xml.XMLHelper;
import java.awt.Color;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SwingUIProjectLoader
extends ProjectLoader {
    private static final String RELATIONSHIP_STYLE_RECTILINEAR = "rectilinear";
    private static final String RELATIONSHIP_STYLE_DIRECT = "direct";
    private static final Logger logger = Logger.getLogger(SwingUIProjectLoader.class);
    protected Map<String, OLAPObject> olapObjectLoadIdMap;
    protected Map<OLAPObject, String> olapObjectSaveIdMap;
    private Map<OLAPPane<?, ?>, String> olapPaneSaveIdMap;
    protected Map<String, OLAPPane<?, ?>> olapPaneLoadIdMap;
    private ProgressMonitor pm;
    XMLHelper ioo = new XMLHelper();

    public SwingUIProjectLoader(ArchitectSwingSession session) {
        super(session);
        if (session == null) {
            throw new NullPointerException("Null session is not allowed!");
        }
        this.session = session;
    }

    @Override
    public boolean isModified() {
        boolean olapModified = false;
        for (OLAPEditSession oSession : this.getSession().getOLAPEditSessions()) {
            olapModified |= oSession.isModified();
        }
        return olapModified || super.isModified();
    }

    @Override
    public void load(InputStream in, DataSourceCollection<? extends SPDataSource> dataSources) throws IOException, SQLObjectException {
        this.load(in, dataSources, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(InputStream in, DataSourceCollection<? extends SPDataSource> dataSources, ArchitectSession messageDelegate) throws IOException, SQLObjectException {
        this.olapPaneLoadIdMap = new HashMap();
        UnclosableInputStream uin = new UnclosableInputStream(in);
        this.olapObjectLoadIdMap = new HashMap<String, OLAPObject>();
        HashMap<OLAPSession, String> sessionDbMap = new HashMap<OLAPSession, String>();
        try {
            this.getSession().getUndoManager().setLoading(true);
            if (!uin.markSupported()) {
                throw new IllegalStateException("Failed to load with an input stream that does not support mark!");
            }
            uin.mark(Integer.MAX_VALUE);
            try {
                MondrianXMLReader.parse(uin, this.getSession().getOLAPRootObject(), sessionDbMap, this.olapObjectLoadIdMap);
            }
            catch (SAXException e) {
                logger.error((Object)"Error parsing project file's olap schemas!", (Throwable)e);
                throw new SQLObjectException("SAX Exception in project file olap schemas parse!", (Throwable)e);
            }
            catch (Exception ex) {
                logger.error((Object)"General Exception in project file olap schemas parse!", (Throwable)ex);
                throw new SQLObjectException("Unexpected Exception", (Throwable)ex);
            }
            in.reset();
            super.load(in, dataSources, messageDelegate);
        }
        finally {
            this.getSession().getUndoManager().setLoading(false);
            uin.forceClose();
        }
        for (Map.Entry entry : sessionDbMap.entrySet()) {
            OLAPSession oSession = (OLAPSession)((Object)entry.getKey());
            SQLDatabase db = (SQLDatabase)this.sqlObjectLoadIdMap.get(entry.getValue());
            oSession.setDatabase(db);
        }
        this.getSession().getPlayPen().setInitialViewPosition();
        for (OLAPEditSession editSession : this.getSession().getOLAPEditSessions()) {
            editSession.getOlapPlayPen().setInitialViewPosition();
        }
        this.getSession().getUndoManager().discardAllEdits();
    }

    @Override
    protected Digester setupDigester() throws ParserConfigurationException, SAXException {
        Digester d = super.setupDigester();
        PrintSettingsFactory printSettingsFactory = new PrintSettingsFactory();
        d.addFactoryCreate("*/print-settings", (ObjectCreationFactory)printSettingsFactory);
        d.addSetProperties("*/print-settings");
        RelationalPlayPenFactory ppFactory = new RelationalPlayPenFactory();
        d.addFactoryCreate("architect-project/play-pen", (ObjectCreationFactory)ppFactory);
        TablePaneFactory tablePaneFactory = new TablePaneFactory();
        d.addFactoryCreate("*/play-pen/table-pane", (ObjectCreationFactory)tablePaneFactory);
        PPRelationshipFactory ppRelationshipFactory = new PPRelationshipFactory();
        d.addFactoryCreate("*/play-pen/table-link", (ObjectCreationFactory)ppRelationshipFactory);
        CompareDMSettingFactory settingFactory = new CompareDMSettingFactory();
        d.addFactoryCreate("architect-project/compare-dm-settings", (ObjectCreationFactory)settingFactory);
        d.addSetProperties("architect-project/compare-dm-settings");
        CompareDMStuffSettingFactory sourceStuffFactory = new CompareDMStuffSettingFactory(true);
        d.addFactoryCreate("architect-project/compare-dm-settings/source-stuff", (ObjectCreationFactory)sourceStuffFactory);
        d.addSetProperties("architect-project/compare-dm-settings/source-stuff");
        CompareDMStuffSettingFactory targetStuffFactory = new CompareDMStuffSettingFactory(false);
        d.addFactoryCreate("architect-project/compare-dm-settings/target-stuff", (ObjectCreationFactory)targetStuffFactory);
        d.addSetProperties("architect-project/compare-dm-settings/target-stuff");
        LiquibaseSettingsFactory lbSettingsFactory = new LiquibaseSettingsFactory();
        d.addFactoryCreate("architect-project/compare-dm-settings/liquibase-settings", (ObjectCreationFactory)lbSettingsFactory);
        d.addSetProperties("architect-project/compare-dm-settings/liquibase-settings");
        CreateKettleJobSettingsFactory ckjsFactory = new CreateKettleJobSettingsFactory();
        d.addFactoryCreate("architect-project/create-kettle-job-settings", (ObjectCreationFactory)ckjsFactory);
        d.addSetProperties("architect-project/create-kettle-job-settings");
        CriticManagerFactory criticManagerFactory = new CriticManagerFactory();
        d.addFactoryCreate("architect-project/critic-manager", (ObjectCreationFactory)criticManagerFactory);
        d.addSetProperties("architect-project/critic-manager");
        CriticGroupingFactory criticGroupingFactory = new CriticGroupingFactory();
        d.addFactoryCreate("architect-project/critic-manager/critic-grouping", (ObjectCreationFactory)criticGroupingFactory);
        d.addSetProperties("architect-project/critic-manager/critic-grouping");
        CriticSettingsFactory criticSettingsFactory = new CriticSettingsFactory();
        d.addFactoryCreate("architect-project/critic-manager/critic-grouping/critic-settings", (ObjectCreationFactory)criticSettingsFactory);
        OLAPEditSessionFactory editSessionFactory = new OLAPEditSessionFactory();
        d.addFactoryCreate("architect-project/olap-gui/olap-edit-session", (ObjectCreationFactory)editSessionFactory);
        OLAPPlayPenFactory olapPPFactory = new OLAPPlayPenFactory();
        d.addFactoryCreate("architect-project/olap-gui/olap-edit-session/play-pen", (ObjectCreationFactory)olapPPFactory);
        CubePaneFactory cubePaneFactory = new CubePaneFactory();
        d.addFactoryCreate("*/play-pen/cube-pane", (ObjectCreationFactory)cubePaneFactory);
        VirtualCubePaneFactory virtualCubePaneFactory = new VirtualCubePaneFactory();
        d.addFactoryCreate("*/play-pen/virtual-cube-pane", (ObjectCreationFactory)virtualCubePaneFactory);
        DimensionPaneFactory dimensionPaneFactory = new DimensionPaneFactory();
        d.addFactoryCreate("*/play-pen/dimension-pane", (ObjectCreationFactory)dimensionPaneFactory);
        UsageComponentFactory usageCompFactory = new UsageComponentFactory();
        d.addFactoryCreate("*/play-pen/usage-comp", (ObjectCreationFactory)usageCompFactory);
        return d;
    }

    private void setupGenericPlayPen(PlayPen pp, Attributes attributes) {
        String zoomLevel = attributes.getValue("zoom");
        if (zoomLevel != null) {
            pp.setZoom(Double.parseDouble(zoomLevel));
        }
        String viewportX = attributes.getValue("viewportX");
        String viewportY = attributes.getValue("viewportY");
        if (viewportX != null && viewportY != null) {
            Point viewPoint = new Point(Integer.parseInt(viewportX), Integer.parseInt(viewportY));
            pp.setViewPosition(viewPoint);
        }
        logger.debug((Object)("Viewport position is " + pp.getViewPosition()));
    }

    public void save(ProgressMonitor pm) throws IOException, SQLObjectException {
        if (this.file.exists() && !this.file.canWrite()) {
            throw new SQLObjectException(Messages.getString("SwingUIProject.errorSavingProject", this.file.getAbsolutePath()));
        }
        if (this.fileVersion != null && !this.fileVersion.equals(ArchitectVersion.APP_FULL_VERSION.toString())) {
            String message;
            try {
                ArchitectVersion oldFileVersion = new ArchitectVersion(this.fileVersion);
                message = oldFileVersion.compareTo(ArchitectVersion.APP_FULL_VERSION) < 0 ? "Overwriting older file. Older versions may have problems loading the newer file format." : "Overwriting newer file. Some data loss from loading may occur.";
            }
            catch (Exception e) {
                message = "Overwriting file with an invalid version.";
            }
            UserPrompter prompter = this.getSession().createUserPrompter(message + "\nDo you wish to continue?", UserPrompterFactory.UserPromptType.BOOLEAN, UserPrompter.UserPromptOptions.OK_CANCEL, UserPrompter.UserPromptResponse.OK, UserPrompter.UserPromptResponse.OK, new String[]{"OK", "Cancel"});
            UserPrompter.UserPromptResponse response = prompter.promptUser(new Object[0]);
            if (response.equals((Object)UserPrompter.UserPromptResponse.CANCEL)) {
                return;
            }
        }
        File backupFile = new File(this.file.getParent(), this.file.getName() + "~");
        File tempFile = null;
        tempFile = new File(this.file.getParent(), "tmp___" + this.file.getName());
        String encoding = "UTF-8";
        try {
            this.out = new PrintWriter(tempFile, encoding);
        }
        catch (IOException e) {
            throw new SQLObjectException(Messages.getString("SwingUIProject.cannotCreateOutputFile") + e, (Throwable)e);
        }
        this.progress = 0;
        this.pm = pm;
        if (pm != null) {
            int pmMax = 0;
            pm.setMinimum(0);
            pmMax = this.getSession().isSavingEntireSource() ? SQLObjectUtils.countTablesSnapshot((SQLObject)((SQLObject)this.getSession().getDBTree().getModel().getRoot())) : SQLObjectUtils.countTables((SQLObject)((SQLObject)this.getSession().getDBTree().getModel().getRoot()));
            logger.debug((Object)("Setting progress monitor maximum to " + pmMax));
            pm.setMaximum(pmMax);
            pm.setProgress(this.progress);
            pm.setMillisToDecideToPopup(0);
        }
        this.save(this.out, encoding);
        this.out = null;
        if (pm != null) {
            pm.close();
        }
        pm = null;
        boolean fstatus = false;
        fstatus = backupFile.delete();
        logger.debug((Object)("deleting backup~ file: " + fstatus));
        if (this.file.exists()) {
            fstatus = this.file.renameTo(backupFile);
            logger.debug((Object)("rename current file to backupFile: " + fstatus));
            if (!fstatus) {
                throw new SQLObjectException(Messages.getString("SwingUIProject.couldNotRenameFile", tempFile.toString(), this.file.toString()));
            }
        }
        if (!(fstatus = tempFile.renameTo(this.file))) {
            throw new SQLObjectException(Messages.getString("SwingUIProject.couldNotRenameTempFile", tempFile.toString(), this.file.toString()));
        }
        logger.debug((Object)("rename tempFile to current file: " + fstatus));
        this.fileVersion = ArchitectVersion.APP_FULL_VERSION.toString();
    }

    public void save(PrintWriter out, String encoding) throws IOException {
        this.sqlObjectSaveIdMap = new IdentityHashMap();
        this.olapObjectSaveIdMap = new IdentityHashMap<OLAPObject, String>();
        this.dbcsSaveIdMap = new HashMap();
        this.olapPaneSaveIdMap = new HashMap();
        this.ioo.indent = 0;
        try {
            this.ioo.println(out, "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
            this.ioo.println(out, "<architect-project version=\"1.0\" appversion=\"" + (Object)((Object)ArchitectVersion.APP_FULL_VERSION) + "\">");
            ++this.ioo.indent;
            this.ioo.println(out, "<project-name>" + SQLPowerUtils.escapeXML((String)this.getSession().getName()) + "</project-name>");
            this.savePrintSettings(out, this.getSession().getPrintSettings());
            this.saveDataSources(out);
            this.saveSourceDatabases(out);
            this.saveTargetDatabase(out);
            this.saveDDLGenerator(out);
            this.saveCompareDMSettings(out);
            this.saveCreateKettleJobSettings(out);
            this.savePlayPen(out, this.getSession().getPlayPen(), true);
            this.saveCriticSettings(out);
            this.saveProfiles(out);
            this.saveOLAP(out);
            this.saveOLAPGUI(out);
            --this.ioo.indent;
            this.ioo.println(out, "</architect-project>");
            this.setModified(false);
            for (OLAPEditSession oSession : this.getSession().getOLAPEditSessions()) {
                oSession.saveNotify();
            }
        }
        catch (IOException e) {
            this.ioo.println(out, new ExceptionReport((Throwable)e, "", ArchitectVersion.APP_FULL_VERSION.toString(), "Architect").toXML());
            throw e;
        }
        catch (RuntimeException e) {
            this.ioo.println(out, new ExceptionReport((Throwable)e, "", ArchitectVersion.APP_FULL_VERSION.toString(), "Architect").toXML());
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public void save(OutputStream out, String encoding) throws IOException {
        this.save(new PrintWriter(new OutputStreamWriter(out, encoding)), encoding);
    }

    private void saveOLAP(PrintWriter out) {
        ++this.ioo.indent;
        this.ioo.println(out, "<olap>");
        ++this.ioo.indent;
        for (OLAPSession osession : this.getSession().getOLAPRootObject().getChildren()) {
            String id;
            if (this.olapObjectSaveIdMap.put(osession, id = Integer.toString(this.olapObjectSaveIdMap.size())) != null) {
                logger.debug((Object)("Duplicate OLAPObject in project file xml: " + (Object)((Object)osession)));
                throw new IllegalStateException("Duplicate OLAPObject found in project file!");
            }
            StringBuilder tagText = new StringBuilder();
            tagText.append("<olap-session id=").append(this.quote(id));
            if (osession.getDatabase() != null) {
                tagText.append(" db-ref=");
                tagText.append(this.quote((String)this.sqlObjectSaveIdMap.get(osession.getDatabase())));
            }
            tagText.append(">");
            this.ioo.println(out, tagText.toString());
            ++this.ioo.indent;
            MondrianXMLWriter.write(out, osession.getSchema(), false, this.ioo.indent, this.olapObjectSaveIdMap);
            --this.ioo.indent;
            this.ioo.println(out, "</olap-session>");
        }
        --this.ioo.indent;
        this.ioo.println(out, "</olap>");
        --this.ioo.indent;
    }

    private void saveOLAPGUI(PrintWriter out) {
        ++this.ioo.indent;
        this.ioo.println(out, "<olap-gui>");
        ++this.ioo.indent;
        for (OLAPEditSession editSession : this.getSession().getOLAPEditSessions()) {
            this.ioo.println(out, "<olap-edit-session osession-ref=" + this.quote(this.olapObjectSaveIdMap.get((Object)editSession.getOlapSession())) + ">");
            ++this.ioo.indent;
            this.savePlayPen(out, editSession.getOlapPlayPen(), false);
            --this.ioo.indent;
            this.ioo.println(out, "</olap-edit-session>");
        }
        --this.ioo.indent;
        this.ioo.println(out, "</olap-gui>");
        --this.ioo.indent;
    }

    private void saveDataSources(PrintWriter out) throws IOException {
        this.ioo.println(out, "<project-data-sources>");
        ++this.ioo.indent;
        int dsNum = 0;
        SQLObject dbTreeRoot = (SQLObject)this.getSession().getDBTree().getModel().getRoot();
        for (SQLObject o : dbTreeRoot.getChildren()) {
            JDBCDataSource ds = ((SQLDatabase)o).getDataSource();
            if (ds != null) {
                String id = (String)this.dbcsSaveIdMap.get(ds);
                if (id == null) {
                    id = "DS" + dsNum;
                    this.dbcsSaveIdMap.put(ds, id);
                }
                this.ioo.println(out, "<data-source id=\"" + SQLPowerUtils.escapeXML((String)id) + "\">");
                ++this.ioo.indent;
                for (Map.Entry ent : ds.getPropertiesMap().entrySet()) {
                    if (ent.getValue() == null) continue;
                    this.ioo.println(out, "<property key=" + this.quote((String)ent.getKey()) + " value=" + this.quote((String)ent.getValue()) + " />");
                }
                --this.ioo.indent;
                this.ioo.println(out, "</data-source>");
                ++dsNum;
            }
            ++dsNum;
        }
        --this.ioo.indent;
        this.ioo.println(out, "</project-data-sources>");
    }

    private void saveDDLGenerator(PrintWriter out) throws IOException {
        this.ioo.print(out, "<ddl-generator type=\"" + this.getSession().getDDLGenerator().getClass().getName() + "\"" + " allow-connection=\"" + this.getSession().getDDLGenerator().getAllowConnection() + "\"");
        if (this.getSession().getDDLGenerator().getTargetCatalog() != null) {
            this.ioo.niprint(out, " target-catalog=\"" + SQLPowerUtils.escapeXML((String)this.getSession().getDDLGenerator().getTargetCatalog()) + "\"");
        }
        if (this.getSession().getDDLGenerator().getTargetSchema() != null) {
            this.ioo.niprint(out, " target-schema=\"" + SQLPowerUtils.escapeXML((String)this.getSession().getDDLGenerator().getTargetSchema()) + "\"");
        }
        this.ioo.niprint(out, ">");
        this.ioo.println(out, "</ddl-generator>");
        this.saveLiquibaseSettings(out, this.session.getLiquibaseSettings());
    }

    private void saveCreateKettleJobSettings(PrintWriter out) throws IOException {
        this.ioo.print(out, "<create-kettle-job-settings");
        this.ioo.niprint(out, " filePath=\"" + SQLPowerUtils.escapeXML((String)this.getSession().getKettleJob().getFilePath()) + "\"");
        this.ioo.niprint(out, " jobName=\"" + SQLPowerUtils.escapeXML((String)this.getSession().getKettleJob().getJobName()) + "\"");
        this.ioo.niprint(out, " schemaName=\"" + SQLPowerUtils.escapeXML((String)this.getSession().getKettleJob().getSchemaName()) + "\"");
        this.ioo.niprint(out, " kettleJoinType=\"" + this.getSession().getKettleJob().getKettleJoinType() + "\"");
        this.ioo.niprint(out, " savingToFile=\"" + this.getSession().getKettleJob().isSavingToFile() + "\"");
        this.ioo.niprintln(out, " />");
    }

    private void saveCompareDMSettings(PrintWriter out) throws IOException {
        if (!this.getSession().getCompareDMSettings().getSaveFlag()) {
            return;
        }
        this.ioo.print(out, "<compare-dm-settings");
        Class<? extends DDLGenerator> ddlgClass = this.getSession().getCompareDMSettings().getDdlGenerator();
        if (ddlgClass != null) {
            this.ioo.print(out, " ddlGenerator=\"" + SQLPowerUtils.escapeXML((String)ddlgClass.getName()) + "\"");
        }
        this.ioo.print(out, " outputFormatAsString=\"" + SQLPowerUtils.escapeXML((String)this.getSession().getCompareDMSettings().getOutputFormatAsString()) + "\"");
        this.ioo.print(out, " saveFlag=\"true\"");
        this.ioo.println(out, ">");
        ++this.ioo.indent;
        this.ioo.print(out, "<source-stuff");
        this.saveSourceOrTargetAttributes(out, this.getSession().getCompareDMSettings().getSourceSettings());
        this.ioo.println(out, "/>");
        this.ioo.print(out, "<target-stuff");
        this.saveSourceOrTargetAttributes(out, this.getSession().getCompareDMSettings().getTargetSettings());
        this.ioo.println(out, "/>");
        this.saveLiquibaseSettings(out, this.getSession().getCompareDMSettings().getLiquibaseSettings());
        --this.ioo.indent;
        this.ioo.println(out, "</compare-dm-settings>");
    }

    private void saveCriticSettings(PrintWriter out) throws IOException {
        CriticManager criticManager = this.getSession().getWorkspace().getCriticManager();
        this.ioo.println(out, "<critic-manager>");
        ++this.ioo.indent;
        for (CriticGrouping group : criticManager.getCriticGroupings()) {
            this.ioo.print(out, "<critic-grouping");
            this.ioo.niprint(out, " platformType=\"" + group.getPlatformType() + "\"");
            this.ioo.niprint(out, " enabled=\"" + Boolean.toString(group.isEnabled()) + "\"");
            this.ioo.niprintln(out, ">");
            ++this.ioo.indent;
            for (CriticAndSettings settings : group.getSettings()) {
                this.ioo.print(out, "<critic-settings");
                this.ioo.niprint(out, " class=\"" + settings.getClass().getName() + "\"");
                this.ioo.niprint(out, " severity=\"" + settings.getSeverity().name() + "\"");
                this.ioo.niprintln(out, "/>");
            }
            --this.ioo.indent;
            this.ioo.println(out, "</critic-grouping>");
        }
        --this.ioo.indent;
        this.ioo.println(out, "</critic-manager>");
    }

    private void saveLiquibaseSettings(PrintWriter out, LiquibaseSettings settings) {
        if (settings == null) {
            return;
        }
        StringBuilder xml = new StringBuilder(150);
        xml.append("<liquibase-settings");
        xml.append(" useSeparateChangeSets=\"" + Boolean.toString(settings.getUseSeparateChangeSets()) + "\"");
        String author = settings.getAuthor();
        if (StringUtils.isNotBlank((String)author)) {
            xml.append(" author=\"" + SQLPowerUtils.escapeXML((String)author) + "\"");
        }
        xml.append(" generateId=\"" + Boolean.toString(settings.getGenerateId()) + "\"");
        xml.append(" idStart=\"" + Integer.toString(settings.getIdStart()) + "\"");
        xml.append("/>");
        this.ioo.println(out, xml.toString());
    }

    private void saveSourceOrTargetAttributes(PrintWriter out, CompareDMSettings.SourceOrTargetSettings sourceSettings) {
        this.ioo.print(out, " datastoreTypeAsString=\"" + SQLPowerUtils.escapeXML((String)sourceSettings.getDatastoreTypeAsString()) + "\"");
        if (sourceSettings.getConnectName() != null) {
            this.ioo.print(out, " connectName=\"" + SQLPowerUtils.escapeXML((String)sourceSettings.getConnectName()) + "\"");
        }
        if (sourceSettings.getCatalog() != null) {
            this.ioo.print(out, " catalog=\"" + SQLPowerUtils.escapeXML((String)sourceSettings.getCatalog()) + "\"");
        }
        if (sourceSettings.getSchema() != null) {
            this.ioo.print(out, " schema=\"" + SQLPowerUtils.escapeXML((String)sourceSettings.getSchema()) + "\"");
        }
        this.ioo.print(out, " filePath=\"" + SQLPowerUtils.escapeXML((String)sourceSettings.getFilePath()) + "\"");
    }

    private void saveSourceDatabases(PrintWriter out) throws IOException {
        this.ioo.println(out, "<source-databases>");
        ++this.ioo.indent;
        SQLObject dbTreeRoot = (SQLObject)this.getSession().getDBTree().getModel().getRoot();
        for (SQLObject o : dbTreeRoot.getChildren()) {
            if (o == this.getSession().getTargetDatabase()) continue;
            this.saveSQLObject(out, o);
        }
        --this.ioo.indent;
        this.ioo.println(out, "</source-databases>");
    }

    private void saveRelationships(PrintWriter out, SQLDatabase db) throws IOException {
        this.ioo.println(out, "<relationships>");
        ++this.ioo.indent;
        Iterator it = db.getChildren().iterator();
        while (it.hasNext()) {
            this.saveRelationshipsRecurse(out, (SQLObject)it.next());
        }
        --this.ioo.indent;
        this.ioo.println(out, "</relationships>");
    }

    private void saveRelationshipsRecurse(PrintWriter out, SQLObject o) throws IOException {
        if (!this.getSession().isSavingEntireSource() && !o.isPopulated()) {
            return;
        }
        if (o instanceof SQLRelationship) {
            this.saveSQLObject(out, o);
        } else if (o.allowsChildren()) {
            Iterator it = o.getChildren().iterator();
            while (it.hasNext()) {
                this.saveRelationshipsRecurse(out, (SQLObject)it.next());
            }
        }
    }

    private void saveTargetDatabase(PrintWriter out) throws IOException {
        SQLDatabase db = this.getSession().getTargetDatabase();
        this.ioo.println(out, "<target-database id=\"ppdb\" dbcs-ref=" + this.quote((String)this.dbcsSaveIdMap.get(db.getDataSource())) + ">");
        this.sqlObjectSaveIdMap.put(db, "ppdb");
        ++this.ioo.indent;
        Iterator it = db.getChildren().iterator();
        while (it.hasNext()) {
            this.saveSQLObject(out, (SQLObject)it.next());
        }
        this.saveRelationships(out, db);
        --this.ioo.indent;
        this.ioo.println(out, "</target-database>");
    }

    private void savePlayPen(PrintWriter out, PlayPen pp, boolean isRelational) {
        StringBuilder tagText = new StringBuilder();
        tagText.append("<play-pen zoom=\"").append(pp.getZoom()).append("\"");
        tagText.append(" viewportX=\"").append(pp.getViewPosition().x).append("\"");
        tagText.append(" viewportY=\"").append(pp.getViewPosition().y).append("\"");
        if (isRelational) {
            String relStyle = this.getSession().getRelationshipLinesDirect() ? RELATIONSHIP_STYLE_DIRECT : RELATIONSHIP_STYLE_RECTILINEAR;
            tagText.append(" relationship-style=").append(this.quote(relStyle));
            tagText.append(" names-displayLogicalNames=\"").append(this.getSession().isUsingLogicalNames()).append("\"");
            tagText.append(" showPrimaryTag=\"").append(this.getSession().isShowPkTag()).append("\"");
            tagText.append(" showForeignTag=\"").append(this.getSession().isShowFkTag()).append("\"");
            tagText.append(" showAlternateTag=\"").append(this.getSession().isShowAkTag()).append("\"");
            tagText.append(" columnVisibility=\"").append((Object)this.getSession().getColumnVisibility()).append("\"");
            tagText.append(" relationshipLabelVisibility=\"").append(this.getSession().isDisplayRelationshipLabel()).append("\"");
        }
        tagText.append(">");
        this.ioo.println(out, tagText.toString());
        ++this.ioo.indent;
        this.savePlayPenComponents(out, pp);
        --this.ioo.indent;
        this.ioo.println(out, "</play-pen>");
    }

    private void savePlayPenComponents(PrintWriter out, PlayPen pp) {
        ArrayList<? extends PlayPenComponent> ppcs = new ArrayList<PlayPenComponent>();
        ppcs.addAll(pp.getContentPane().getChildren());
        Collections.reverse(ppcs);
        for (PlayPenComponent playPenComponent : ppcs) {
            String modelId;
            String paneId;
            Point p;
            if (playPenComponent instanceof TablePane) {
                TablePane tp = (TablePane)playPenComponent;
                p = tp.getLocation();
                if (this.sqlObjectSaveIdMap.get(tp.getModel()) == null) {
                    logger.error((Object)("Play pen tried to save a table pane at " + tp.getX() + ", " + tp.getY() + " with the model " + tp.getModel() + " and reference id " + (String)this.sqlObjectSaveIdMap.get(tp.getModel()) + "." + "\nSaving a table pane with a null reference will cause an NPE on loading."));
                    throw new NullPointerException("Play pen table is saving a null reference.");
                }
                Color bgColor = tp.getBackgroundColor();
                String bgColorString = String.format("0x%02x%02x%02x", bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
                Color fgColor = tp.getForegroundColor();
                String fgColorString = String.format("0x%02x%02x%02x", fgColor.getRed(), fgColor.getGreen(), fgColor.getBlue());
                this.ioo.println(out, "<table-pane table-ref=" + this.quote((String)this.sqlObjectSaveIdMap.get(tp.getModel())) + " x=\"" + p.x + "\" y=\"" + p.y + "\" bgColor=" + this.quote(bgColorString) + " fgColor=" + this.quote(fgColorString) + " rounded=\"" + tp.isRounded() + "\" dashed=\"" + tp.isDashed() + "\"/>");
                if (this.pm == null) continue;
                this.pm.setProgress(++this.progress);
                continue;
            }
            if (playPenComponent instanceof CubePane) {
                CubePane cp = (CubePane)playPenComponent;
                p = cp.getLocation();
                String modelId2 = this.olapObjectSaveIdMap.get(cp.getModel());
                String paneId2 = "CP" + this.olapPaneSaveIdMap.size();
                this.ioo.println(out, "<cube-pane id=" + this.quote(paneId2) + " model-ref=" + this.quote(modelId2) + " x=\"" + p.x + "\" y=\"" + p.y + "\"/>");
                this.olapPaneSaveIdMap.put(cp, paneId2);
                continue;
            }
            if (playPenComponent instanceof DimensionPane) {
                DimensionPane dp = (DimensionPane)playPenComponent;
                p = dp.getLocation();
                paneId = "DP" + this.olapPaneSaveIdMap.size();
                modelId = this.olapObjectSaveIdMap.get(dp.getModel());
                this.ioo.println(out, "<dimension-pane id=" + this.quote(paneId) + " model-ref=" + this.quote(modelId) + " x=\"" + p.x + "\" y=\"" + p.y + "\"/>");
                this.olapPaneSaveIdMap.put(dp, paneId);
                continue;
            }
            if (playPenComponent instanceof VirtualCubePane) {
                VirtualCubePane vcp = (VirtualCubePane)playPenComponent;
                p = vcp.getLocation();
                paneId = "VCP" + this.olapPaneSaveIdMap.size();
                modelId = this.olapObjectSaveIdMap.get(vcp.getModel());
                this.ioo.println(out, "<virtual-cube-pane id=" + this.quote(paneId) + " model-ref=" + this.quote(modelId) + " x=\"" + p.x + "\" y=\"" + p.y + "\"/>");
                this.olapPaneSaveIdMap.put(vcp, paneId);
                continue;
            }
            if (!(playPenComponent instanceof ContainerPane)) continue;
            logger.warn((Object)("Skipping unhandled playpen component: " + playPenComponent));
        }
        for (PlayPenComponent playPenComponent : ppcs) {
            if (playPenComponent instanceof Relationship) {
                Relationship r = (Relationship)playPenComponent;
                Color relationshipLineColor = r.getForegroundColor();
                String rColorString = String.format("0x%02x%02x%02x", relationshipLineColor.getRed(), relationshipLineColor.getGreen(), relationshipLineColor.getBlue());
                this.ioo.println(out, "<table-link relationship-ref=" + this.quote((String)this.sqlObjectSaveIdMap.get(r.getModel())) + " pkConnection=\"" + r.getPkConnection() + "\"" + " fkConnection=\"" + r.getFkConnection() + "\"" + " rLineColor=" + this.quote(rColorString) + " pkLabelText=" + this.quote(r.getTextForParentLabel()) + " fkLabelText=" + this.quote(r.getTextForChildLabel()) + " orientation=\"" + r.getOrientation() + "\"/>");
                continue;
            }
            if (playPenComponent instanceof UsageComponent) {
                UsageComponent usageComp = (UsageComponent)playPenComponent;
                String modelId = this.olapObjectSaveIdMap.get((Object)usageComp.getModel());
                String pane1Id = this.olapPaneSaveIdMap.get(usageComp.getPane1());
                String pane2Id = this.olapPaneSaveIdMap.get(usageComp.getPane2());
                this.ioo.println(out, "<usage-comp model-ref=" + this.quote(modelId) + " pane1-ref=" + this.quote(pane1Id) + " pane2-ref=" + this.quote(pane2Id) + "/>");
                continue;
            }
            if (playPenComponent instanceof ContainerPane) continue;
            logger.warn((Object)("Skipping unhandled playpen component: " + playPenComponent));
        }
    }

    private void saveProfiles(PrintWriter out) {
        ProfileManager profmgr = this.getSession().getProfileManager();
        this.ioo.println(out, "<profiles topNCount=\"" + profmgr.getDefaultProfileSettings().getTopNCount() + "\">");
        ++this.ioo.indent;
        List<TableProfileResult> tableResults = profmgr.getResults();
        for (TableProfileResult tableResult : tableResults) {
            String profiledObjectId = (String)this.sqlObjectSaveIdMap.get(tableResult.getProfiledObject());
            if (profiledObjectId == null) {
                UserPrompter prompter = this.getSession().createUserPrompter("Cannot save profile for table " + ((SQLTable)tableResult.getProfiledObject()).getName() + ", skipping this profile and continuing save.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, null, new String[]{"OK"});
                prompter.promptUser(new Object[0]);
                continue;
            }
            this.ioo.print(out, "<table-profile-result");
            this.printCommonItems(out, tableResult, profiledObjectId);
            this.ioo.niprint(out, " rowCount=\"" + tableResult.getRowCount() + "\"");
            this.ioo.niprint(out, " UUID=\"" + tableResult.getUUID() + "\"");
            this.ioo.niprintln(out, ">");
            ++this.ioo.indent;
            List<ColumnProfileResult> columnProfileResults = tableResult.getColumnProfileResults();
            for (ColumnProfileResult cpr : columnProfileResults) {
                List<ColumnValueCount> valueCount;
                String profiledColumnObjectId = (String)this.sqlObjectSaveIdMap.get(cpr.getProfiledObject());
                if (profiledColumnObjectId == null) {
                    UserPrompter prompter = this.getSession().createUserPrompter("Cannot save profile for column " + ((SQLColumn)cpr.getProfiledObject()).getName() + ", skipping this profile and continuing save.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, null, new String[]{"OK"});
                    prompter.promptUser(new Object[0]);
                    continue;
                }
                this.ioo.print(out, "<column-profile-result");
                this.printCommonItems(out, cpr, profiledColumnObjectId);
                this.ioo.niprint(out, " avgLength=\"" + cpr.getAvgLength() + "\"");
                this.ioo.niprint(out, " minLength=\"" + cpr.getMinLength() + "\"");
                this.ioo.niprint(out, " maxLength=\"" + cpr.getMaxLength() + "\"");
                this.ioo.niprint(out, " nullCount=\"" + cpr.getNullCount() + "\"");
                this.ioo.niprint(out, " distinctValueCount=\"" + cpr.getDistinctValueCount() + "\"");
                this.ioo.niprint(out, " UUID=\"" + cpr.getUUID() + "\"");
                this.ioo.niprintln(out, ">");
                ++this.ioo.indent;
                if (cpr.getAvgValue() != null) {
                    this.ioo.println(out, "<avgValue type=\"" + cpr.getAvgValue().getClass().getName() + "\" value=\"" + SQLPowerUtils.escapeXML((String)String.valueOf(cpr.getAvgValue())) + "\"/>");
                }
                if (cpr.getMaxValue() != null) {
                    this.ioo.println(out, "<maxValue type=\"" + cpr.getMaxValue().getClass().getName() + "\" value=\"" + SQLPowerUtils.escapeXML((String)String.valueOf(cpr.getMaxValue())) + "\"/>");
                }
                if (cpr.getMinValue() != null) {
                    this.ioo.println(out, "<minValue type=\"" + cpr.getMinValue().getClass().getName() + "\" value=\"" + SQLPowerUtils.escapeXML((String)String.valueOf(cpr.getMinValue())) + "\"/>");
                }
                if ((valueCount = cpr.getValueCount()) != null) {
                    for (ColumnValueCount count : valueCount) {
                        this.ioo.println(out, "<topNvalue count=\"" + count.getCount() + "\" type=\"" + (count.getValue() == null ? "" : count.getValue().getClass().getName()) + "\" value=\"" + SQLPowerUtils.escapeXML((String)String.valueOf(count.getValue())) + "\" percent=\"" + count.getPercent() + "\" otherValues=\"" + Boolean.toString(count.isOtherValues()) + "\"/>");
                    }
                }
                --this.ioo.indent;
                this.ioo.println(out, "</column-profile-result>");
            }
            --this.ioo.indent;
            this.ioo.println(out, "</table-profile-result>");
        }
        this.ioo.println(out, "</profiles>");
        --this.ioo.indent;
    }

    private void printCommonItems(PrintWriter out, ProfileResult<?> profileResult, String profiledObjectId) {
        this.ioo.niprint(out, " ref-id=\"" + profiledObjectId + "\"" + " createStartTime=\"" + profileResult.getCreateStartTime() + "\"" + " createEndTime=\"" + profileResult.getCreateEndTime() + "\"" + " exception=\"" + (profileResult.getException() == null ? "false" : "true") + "\"");
        if (profileResult.getException() != null) {
            this.ioo.niprint(out, " exception-type=\"" + SQLPowerUtils.escapeXML((String)profileResult.getException().getClass().getName()) + "\"");
            this.ioo.niprint(out, " exception-message=\"" + SQLPowerUtils.escapeXML((String)profileResult.getException().getMessage()) + "\"");
        }
    }

    private void saveSQLObject(PrintWriter out, SQLObject o) throws IOException {
        String type;
        if (o instanceof SQLRelationship.SQLImportedKey) {
            return;
        }
        String id = (String)this.sqlObjectSaveIdMap.get(o);
        if (id != null) {
            this.ioo.println(out, "<reference ref-id=\"" + SQLPowerUtils.escapeXML((String)id) + "\" />");
            return;
        }
        TreeMap<String, Object> propNames = new TreeMap<String, Object>();
        propNames.put("physicalName", o.getPhysicalName());
        propNames.put("name", o.getName());
        propNames.put("UUID", o.getUUID());
        if (!o.getChildrenInaccessibleReasons().isEmpty()) {
            Throwable topException = o.getChildrenInaccessibleReason(SQLObject.class);
            propNames.put("sql-exception", topException);
        }
        if (o instanceof SQLDatabase) {
            id = "DB" + this.sqlObjectSaveIdMap.size();
            type = "database";
            propNames.put("dbcs-ref", this.dbcsSaveIdMap.get(((SQLDatabase)o).getDataSource()));
        } else if (o instanceof SQLCatalog) {
            id = "CAT" + this.sqlObjectSaveIdMap.size();
            type = "catalog";
            propNames.put("nativeTerm", ((SQLCatalog)o).getNativeTerm());
        } else if (o instanceof SQLSchema) {
            id = "SCH" + this.sqlObjectSaveIdMap.size();
            type = "schema";
            propNames.put("nativeTerm", ((SQLSchema)o).getNativeTerm());
        } else if (o instanceof SQLTable) {
            id = "TAB" + this.sqlObjectSaveIdMap.size();
            type = "table";
            propNames.put("objectType", ((SQLTable)o).getObjectType());
            if (this.pm != null) {
                this.pm.setProgress(++this.progress);
            }
        } else if (o instanceof SQLColumn) {
            UserDefinedSQLType userDefinedSQLType;
            id = "COL" + this.sqlObjectSaveIdMap.size();
            type = "column";
            SQLColumn sourceCol = ((SQLColumn)o).getSourceColumn();
            if (sourceCol != null) {
                propNames.put("source-column-ref", this.sqlObjectSaveIdMap.get(sourceCol));
            }
            if ((userDefinedSQLType = ((SQLColumn)o).getUserDefinedSQLType()).getUpstreamType() != null) {
                propNames.put("userDefinedTypeUUID", userDefinedSQLType.getUpstreamType().getUUID());
            }
            propNames.put("type", new Integer(((SQLColumn)o).getType()));
            propNames.put("sourceDataTypeName", ((SQLColumn)o).getSourceDataTypeName());
            propNames.put("scale", new Integer(((SQLColumn)o).getScale()));
            propNames.put("precision", new Integer(((SQLColumn)o).getPrecision()));
            propNames.put("nullable", new Integer(((SQLColumn)o).getNullable()));
            propNames.put("defaultValue", ((SQLColumn)o).getDefaultValue());
            propNames.put("primaryKeySeq", ((SQLColumn)o).isPrimaryKey() ? Integer.valueOf(((SQLColumn)o).getParent().getChildrenWithoutPopulating(SQLColumn.class).indexOf(o)) : null);
            propNames.put("autoIncrement", ((SQLColumn)o).isAutoIncrement());
            propNames.put("referenceCount", new Integer(((SQLColumn)o).getReferenceCount()));
            if (((SQLColumn)o).isAutoIncrementSequenceNameSet()) {
                propNames.put("autoIncrementSequenceName", ((SQLColumn)o).getAutoIncrementSequenceName());
            }
        } else if (o instanceof SQLRelationship) {
            id = "REL" + this.sqlObjectSaveIdMap.size();
            type = "relationship";
            propNames.put("pk-table-ref", this.sqlObjectSaveIdMap.get(((SQLRelationship)o).getPkTable()));
            propNames.put("fk-table-ref", this.sqlObjectSaveIdMap.get(((SQLRelationship)o).getFkTable()));
            propNames.put("updateRule", new Integer(((SQLRelationship)o).getUpdateRule().getCode()));
            propNames.put("deleteRule", new Integer(((SQLRelationship)o).getDeleteRule().getCode()));
            propNames.put("deferrability", new Integer(((SQLRelationship)o).getDeferrability().getCode()));
            propNames.put("pkCardinality", new Integer(((SQLRelationship)o).getPkCardinality()));
            propNames.put("fkCardinality", new Integer(((SQLRelationship)o).getFkCardinality()));
            propNames.put("identifying", ((SQLRelationship)o).isIdentifying());
        } else if (o instanceof SQLRelationship.ColumnMapping) {
            id = "CMP" + this.sqlObjectSaveIdMap.size();
            type = "column-mapping";
            propNames.put("pk-column-ref", this.sqlObjectSaveIdMap.get(((SQLRelationship.ColumnMapping)o).getPkColumn()));
            propNames.put("fk-column-ref", this.sqlObjectSaveIdMap.get(((SQLRelationship.ColumnMapping)o).getFkColumn()));
            propNames.put("fk-col-name", ((SQLRelationship.ColumnMapping)o).getFkColName());
            propNames.put("fk-table", this.sqlObjectSaveIdMap.get(((SQLRelationship.ColumnMapping)o).getFkTable()));
        } else if (o instanceof SQLIndex) {
            id = "IDX" + this.sqlObjectSaveIdMap.size();
            type = "index";
            SQLIndex index = (SQLIndex)o;
            propNames.put("unique", index.isUnique());
            propNames.put("qualifier", index.getQualifier());
            propNames.put("clustered", index.isClustered());
            propNames.put("index-type", index.getType());
            propNames.put("primaryKeyIndex", index.isPrimaryKeyIndex());
            propNames.put("filterCondition", index.getFilterCondition());
        } else if (o instanceof SQLIndex.Column) {
            id = "IDC" + this.sqlObjectSaveIdMap.size();
            type = "index-column";
            SQLIndex.Column col = (SQLIndex.Column)o;
            if (col.getColumn() != null) {
                propNames.put("column-ref", this.sqlObjectSaveIdMap.get(col.getColumn()));
            }
            propNames.put("ascendingOrDescending", col.getAscendingOrDescending().name());
        } else {
            throw new UnsupportedOperationException("Whoops, the SQLObject type " + o.getClass().getName() + " is not supported!");
        }
        this.sqlObjectSaveIdMap.put(o, id);
        if (logger.isDebugEnabled()) {
            this.ioo.print(out, "<" + type + " hashCode=\"" + o.hashCode() + "\" id=\"" + this.quote(id) + "\" ");
        } else {
            this.ioo.print(out, "<" + type + " id=" + this.quote(id) + " ");
        }
        if (!this.getSession().isSavingEntireSource() && !o.isPopulated()) {
            this.ioo.niprint(out, "populated=\"false\" ");
        } else {
            this.ioo.niprint(out, "populated=\"true\" ");
        }
        for (Object key : propNames.keySet()) {
            Object value = propNames.get(key);
            if (value == null) continue;
            this.ioo.niprint(out, key + "=" + this.quote(value.toString()) + " ");
        }
        if (o.allowsChildren()) {
            this.ioo.niprintln(out, ">");
            Iterator children = this.getSession().isSavingEntireSource() ? o.getChildren().iterator() : o.getChildrenWithoutPopulating().iterator();
            ++this.ioo.indent;
            SQLObject lastChild = null;
            String exportedKeysFolder = null;
            String importedKeysFolder = null;
            String indicesFolder = null;
            if (o instanceof SQLTable) {
                SQLTable table = (SQLTable)o;
                this.ioo.println(out, "<remarks>" + SQLPowerUtils.escapeXML((String)table.getRemarks()) + "</remarks>");
                String exception = table.getChildrenInaccessibleReason(SQLColumn.class) != null ? "sql-exception=\"" + table.getChildrenInaccessibleReason(SQLColumn.class) + "\" " : "";
                this.ioo.println(out, "<folder id=\"FOL" + id + "1\" populated=\"" + table.isColumnsPopulated() + "\" name=\"Columns\" " + "physicalName=\"Columns\" " + exception + "type=\"1\">");
                ++this.ioo.indent;
                exception = table.getChildrenInaccessibleReason(SQLRelationship.SQLImportedKey.class) != null ? "sql-exception=\"" + table.getChildrenInaccessibleReason(SQLRelationship.SQLImportedKey.class) + "\" " : "";
                importedKeysFolder = "<folder id=\"FOL" + id + "2\" populated=\"" + table.isImportedKeysPopulated() + "\" name=\"Imported Keys\" " + "physicalName=\"Imported Keys\" " + exception + "type=\"2\">";
                exception = table.getChildrenInaccessibleReason(SQLRelationship.class) != null ? "sql-exception=\"" + table.getChildrenInaccessibleReason(SQLRelationship.class) + "\" " : "";
                exportedKeysFolder = "<folder id=\"FOL" + id + "3\" populated=\"" + table.isExportedKeysPopulated() + "\" name=\"Exported Keys\" " + "physicalName=\"Exported Keys\" " + exception + "type=\"3\">";
                exception = table.getChildrenInaccessibleReason(SQLIndex.class) != null ? "sql-exception=\"" + table.getChildrenInaccessibleReason(SQLIndex.class) + "\" " : "";
                indicesFolder = "<folder id=\"FOL" + id + "4\" populated=\"" + table.isIndicesPopulated() + "\" name=\"Indices\" " + "physicalName=\"Indices\" " + exception + "type=\"4\">";
            } else if (o instanceof SQLColumn) {
                this.ioo.println(out, "<remarks>" + SQLPowerUtils.escapeXML((String)((SQLColumn)o).getRemarks()) + "</remarks>");
            }
            while (children.hasNext()) {
                SQLObject child = (SQLObject)children.next();
                if (o instanceof SQLTable && lastChild instanceof SQLColumn && !(child instanceof SQLColumn)) {
                    this.ioo.println(out, "</folder>");
                    this.ioo.println(out, exportedKeysFolder);
                    this.ioo.println(out, "</folder>");
                    this.ioo.println(out, importedKeysFolder);
                    this.ioo.println(out, "</folder>");
                    this.ioo.println(out, indicesFolder);
                }
                if (!(child instanceof SQLRelationship || child instanceof UserDefinedSQLType || child instanceof SQLTypePhysicalProperties)) {
                    this.saveSQLObject(out, child);
                }
                lastChild = child;
            }
            if (o instanceof SQLTable) {
                --this.ioo.indent;
                if (lastChild == null || lastChild instanceof SQLColumn) {
                    this.ioo.println(out, "</folder>");
                    this.ioo.println(out, exportedKeysFolder);
                    this.ioo.println(out, "</folder>");
                    this.ioo.println(out, importedKeysFolder);
                    this.ioo.println(out, "</folder>");
                    this.ioo.println(out, indicesFolder);
                }
                this.ioo.println(out, "</folder>");
            }
            if (o instanceof SQLDatabase) {
                this.saveRelationships(out, (SQLDatabase)o);
            }
            --this.ioo.indent;
            this.ioo.println(out, "</" + type + ">");
        } else {
            this.ioo.niprintln(out, "/>");
        }
    }

    private void savePrintSettings(PrintWriter out, PrintSettings settings) {
        StringBuilder tagText = new StringBuilder();
        tagText.append("<print-settings ");
        if (settings.getPrinterName() != null) {
            tagText.append("printerName=\"" + settings.getPrinterName() + "\" ");
        }
        tagText.append("numCopies=\"" + settings.getNumCopies() + "\" ");
        tagText.append("zoom=\"" + settings.getZoom() + "\" ");
        tagText.append("pageNumbersPrinted=\"" + Boolean.toString(settings.isPageNumbersPrinted()) + "\" ");
        tagText.append("orientation=\"" + settings.getOrientation() + "\" ");
        tagText.append("paperWidth=\"" + settings.getPaperWidth() + "\" ");
        tagText.append("paperHeight=\"" + settings.getPaperHeight() + "\" ");
        tagText.append("leftBorder=\"" + settings.getLeftBorder() + "\" ");
        tagText.append("rightBorder=\"" + settings.getRightBorder() + "\" ");
        tagText.append("topBorder=\"" + settings.getTopBorder() + "\" ");
        tagText.append("bottomBorder=\"" + settings.getBottomBorder() + "\" ");
        tagText.append("/>");
        this.ioo.println(out, tagText.toString());
    }

    private String quote(String str) {
        return "\"" + SQLPowerUtils.escapeXML((String)str) + "\"";
    }

    @Override
    protected ArchitectSwingSession getSession() {
        return (ArchitectSwingSession)this.session;
    }

    private class CriticSettingsFactory
    extends AbstractObjectCreationFactory {
        private CriticSettingsFactory() {
        }

        public Object createObject(Attributes attr) throws Exception {
            Object topItem = this.getDigester().peek();
            if (!(topItem instanceof CriticGrouping)) {
                logger.error((Object)("Expected parent CriticGrouping object on top of stack but found: " + topItem));
                throw new IllegalStateException("Ancestor CriticGrouping object not found!");
            }
            CriticGrouping group = (CriticGrouping)((Object)topItem);
            String criticClassName = attr.getValue("class");
            Class<?> criticClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(criticClassName);
            CriticAndSettings criticSettings = (CriticAndSettings)criticClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            String severity = attr.getValue("severity");
            criticSettings.setSeverity(CriticAndSettings.Severity.valueOf(severity));
            group.getParent().registerCritic(criticSettings);
            return criticSettings;
        }
    }

    private class CriticManagerFactory
    extends AbstractObjectCreationFactory {
        private CriticManagerFactory() {
        }

        public Object createObject(Attributes attr) throws Exception {
            Object topItem = this.getDigester().peek();
            if (!(topItem instanceof ArchitectSwingSession)) {
                logger.error((Object)("Expected parent ArchitectSwingSession object on top of stack but found: " + topItem));
                throw new IllegalStateException("Ancestor ArchitectSwingSession object not found!");
            }
            ArchitectSwingSession session = (ArchitectSwingSession)topItem;
            session.getWorkspace().getCriticManager().clear();
            return session.getWorkspace().getCriticManager();
        }
    }

    private class CriticGroupingFactory
    extends AbstractObjectCreationFactory {
        private CriticGroupingFactory() {
        }

        public Object createObject(Attributes attr) throws Exception {
            Object topItem = this.getDigester().peek();
            if (!(topItem instanceof CriticManager)) {
                logger.error((Object)("Expected parent CriticManager object on top of stack but found: " + topItem));
                throw new IllegalStateException("Ancestor CriticManager object not found!");
            }
            CriticManager criticManager = (CriticManager)((Object)topItem);
            String platformType = attr.getValue("platformType");
            CriticGrouping group = new CriticGrouping(platformType);
            criticManager.addChild((SPObject)group, criticManager.getChildren(CriticGrouping.class).size());
            return group;
        }
    }

    private class PrintSettingsFactory
    extends AbstractObjectCreationFactory {
        private PrintSettingsFactory() {
        }

        public Object createObject(Attributes arg0) throws Exception {
            return SwingUIProjectLoader.this.getSession().getPrintSettings();
        }
    }

    private class CompareDMStuffSettingFactory
    extends AbstractObjectCreationFactory {
        private boolean source;

        public CompareDMStuffSettingFactory(boolean source) {
            this.source = source;
        }

        public Object createObject(Attributes attributes) {
            if (this.source) {
                return SwingUIProjectLoader.this.getSession().getCompareDMSettings().getSourceSettings();
            }
            return SwingUIProjectLoader.this.getSession().getCompareDMSettings().getTargetSettings();
        }
    }

    private class CompareDMSettingFactory
    extends AbstractObjectCreationFactory {
        private CompareDMSettingFactory() {
        }

        public Object createObject(Attributes attributes) {
            return SwingUIProjectLoader.this.getSession().getCompareDMSettings();
        }
    }

    private class LiquibaseSettingsFactory
    extends AbstractObjectCreationFactory {
        private LiquibaseSettingsFactory() {
        }

        public Object createObject(Attributes attributes) {
            LiquibaseSettings settings = SwingUIProjectLoader.this.getSession().getCompareDMSettings().getLiquibaseSettings();
            if (settings == null) {
                settings = new LiquibaseSettings();
                SwingUIProjectLoader.this.getSession().getCompareDMSettings().setLiquibaseSettings(settings);
            }
            return settings;
        }
    }

    private class CreateKettleJobSettingsFactory
    extends AbstractObjectCreationFactory {
        private CreateKettleJobSettingsFactory() {
        }

        public Object createObject(Attributes attributes) throws SQLException {
            return SwingUIProjectLoader.this.getSession().getKettleJob();
        }
    }

    private class OLAPEditSessionFactory
    extends AbstractObjectCreationFactory {
        private OLAPEditSessionFactory() {
        }

        public Object createObject(Attributes attributes) {
            OLAPSession oSession = (OLAPSession)SwingUIProjectLoader.this.olapObjectLoadIdMap.get(attributes.getValue("osession-ref"));
            return SwingUIProjectLoader.this.getSession().getOLAPEditSession(oSession);
        }
    }

    private class UsageComponentFactory
    extends AbstractObjectCreationFactory {
        private UsageComponentFactory() {
        }

        public Object createObject(Attributes attributes) {
            Object topItem = this.getDigester().peek();
            if (!(topItem instanceof PlayPen)) {
                logger.error((Object)("Expected parent PlayPen object on top of stack but found: " + topItem));
                throw new IllegalStateException("Parent PlayPen object not found!");
            }
            PlayPen pp = (PlayPen)topItem;
            OLAPObject model = SwingUIProjectLoader.this.olapObjectLoadIdMap.get(attributes.getValue("model-ref"));
            OLAPPane<?, ?> pane1 = SwingUIProjectLoader.this.olapPaneLoadIdMap.get(attributes.getValue("pane1-ref"));
            OLAPPane<?, ?> pane2 = SwingUIProjectLoader.this.olapPaneLoadIdMap.get(attributes.getValue("pane2-ref"));
            UsageComponent usageComp = new UsageComponent(pp.getContentPane(), model, pane1, pane2);
            pp.getContentPane().addChild((SPObject)usageComp, pp.getContentPane().getChildren().size());
            return usageComp;
        }
    }

    private class PPRelationshipFactory
    extends AbstractObjectCreationFactory {
        private PPRelationshipFactory() {
        }

        public Object createObject(Attributes attributes) {
            Object topItem = this.getDigester().peek();
            if (!(topItem instanceof PlayPen)) {
                logger.error((Object)("Expected parent PlayPen object on top of stack but found: " + topItem));
                throw new IllegalStateException("Parent PlayPen object not found!");
            }
            PlayPen pp = (PlayPen)topItem;
            Relationship r = null;
            try {
                String fkLabelText;
                String pkLabelText;
                String rLineColor;
                try {
                    SQLRelationship rel = (SQLRelationship)SwingUIProjectLoader.this.sqlObjectLoadIdMap.get(attributes.getValue("relationship-ref"));
                    r = new Relationship(rel, pp.getContentPane());
                    pp.addRelationship(r);
                    r.updateUI();
                    String pkxStr = attributes.getValue("pk-x");
                    if (pkxStr != null) {
                        int pkx = Integer.parseInt(pkxStr);
                        int pky = Integer.parseInt(attributes.getValue("pk-y"));
                        int fkx = Integer.parseInt(attributes.getValue("fk-x"));
                        int fky = Integer.parseInt(attributes.getValue("fk-y"));
                        r.setPkConnectionPoint(new Point(pkx, pky));
                        r.setFkConnectionPoint(new Point(fkx, fky));
                    } else {
                        double pk = Double.parseDouble(attributes.getValue("pkConnection"));
                        double fk = Double.parseDouble(attributes.getValue("fkConnection"));
                        r.setPkConnection(pk);
                        r.setFkConnection(fk);
                    }
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(null, "Warning: your relationship point connection data was not loaded properly, but\nit was not a critical failure. This file could be too old or corrupted.", "Warning", 2);
                    logger.warn((Object)"Didn't set connection points because of integer parse error");
                }
                catch (NullPointerException e) {
                    JOptionPane.showMessageDialog(null, "Warning: your relationship point connection data was not loaded properly, but\nit was not a critical failure. This file could be too old or corrupted.", "Warning", 2);
                    logger.debug((Object)"No pk/fk connection points specified in save file; not setting custom connection points");
                }
                String rOrientation = attributes.getValue("orientation");
                if (rOrientation != null) {
                    int orientation = Integer.parseInt(rOrientation);
                    r.setOrientation(orientation);
                }
                if ((rLineColor = attributes.getValue("rLineColor")) != null) {
                    Color relationshipLineColor = Color.decode(rLineColor);
                    r.setForegroundColor(relationshipLineColor);
                }
                if ((pkLabelText = attributes.getValue("pkLabelText")) != null) {
                    r.setTextForParentLabel(pkLabelText);
                }
                if ((fkLabelText = attributes.getValue("fkLabelText")) != null) {
                    r.setTextForChildLabel(fkLabelText);
                }
            }
            catch (SQLObjectException e) {
                logger.error((Object)"Couldn't create relationship component", (Throwable)e);
            }
            catch (NullPointerException e) {
                logger.error((Object)"Error loading a relationship.", (Throwable)e);
            }
            return r;
        }
    }

    private class DimensionPaneFactory
    extends AbstractObjectCreationFactory {
        private DimensionPaneFactory() {
        }

        public Object createObject(Attributes attributes) {
            Object topItem = this.getDigester().peek();
            if (!(topItem instanceof PlayPen)) {
                logger.error((Object)("Expected parent PlayPen object on top of stack but found: " + topItem));
                throw new IllegalStateException("Parent PlayPen object not found!");
            }
            PlayPen pp = (PlayPen)topItem;
            int x = Integer.parseInt(attributes.getValue("x"));
            int y = Integer.parseInt(attributes.getValue("y"));
            MondrianModel.Dimension dim = (MondrianModel.Dimension)SwingUIProjectLoader.this.olapObjectLoadIdMap.get(attributes.getValue("model-ref"));
            DimensionPane dp = new DimensionPane(dim, pp.getContentPane());
            pp.addPlayPenComponent(dp, new Point(x, y));
            String id = attributes.getValue("id");
            if (id != null) {
                SwingUIProjectLoader.this.olapPaneLoadIdMap.put(id, dp);
            } else {
                logger.warn((Object)"No ID element found in dimension pane element while loading project!");
            }
            return dp;
        }
    }

    private class VirtualCubePaneFactory
    extends AbstractObjectCreationFactory {
        private VirtualCubePaneFactory() {
        }

        public Object createObject(Attributes attributes) {
            Object topItem = this.getDigester().peek();
            if (!(topItem instanceof PlayPen)) {
                logger.error((Object)("Expected parent PlayPen object on top of stack but found: " + topItem));
                throw new IllegalStateException("Parent PlayPen object not found!");
            }
            PlayPen pp = (PlayPen)topItem;
            int x = Integer.parseInt(attributes.getValue("x"));
            int y = Integer.parseInt(attributes.getValue("y"));
            MondrianModel.VirtualCube virtualCube = (MondrianModel.VirtualCube)SwingUIProjectLoader.this.olapObjectLoadIdMap.get(attributes.getValue("model-ref"));
            VirtualCubePane vcp = new VirtualCubePane(virtualCube, pp.getContentPane());
            pp.addPlayPenComponent(vcp, new Point(x, y));
            String id = attributes.getValue("id");
            if (id != null) {
                SwingUIProjectLoader.this.olapPaneLoadIdMap.put(id, vcp);
            } else {
                logger.warn((Object)"No ID element found in virtual cube pane element while loading project!");
            }
            return vcp;
        }
    }

    private class CubePaneFactory
    extends AbstractObjectCreationFactory {
        private CubePaneFactory() {
        }

        public Object createObject(Attributes attributes) {
            Object topItem = this.getDigester().peek();
            if (!(topItem instanceof PlayPen)) {
                logger.error((Object)("Expected parent PlayPen object on top of stack but found: " + topItem));
                throw new IllegalStateException("Parent PlayPen object not found!");
            }
            PlayPen pp = (PlayPen)topItem;
            int x = Integer.parseInt(attributes.getValue("x"));
            int y = Integer.parseInt(attributes.getValue("y"));
            MondrianModel.Cube cube = (MondrianModel.Cube)SwingUIProjectLoader.this.olapObjectLoadIdMap.get(attributes.getValue("model-ref"));
            CubePane cp = new CubePane(cube, pp.getContentPane());
            pp.addPlayPenComponent(cp, new Point(x, y));
            String id = attributes.getValue("id");
            if (id != null) {
                SwingUIProjectLoader.this.olapPaneLoadIdMap.put(id, cp);
            } else {
                logger.warn((Object)"No ID element found in cube pane element while loading project!");
            }
            return cp;
        }
    }

    private class TablePaneFactory
    extends AbstractObjectCreationFactory {
        private TablePaneFactory() {
        }

        public Object createObject(Attributes attributes) {
            String fgColorString;
            Object topItem = this.getDigester().peek();
            if (!(topItem instanceof PlayPen)) {
                logger.error((Object)("Expected parent PlayPen object on top of stack but found: " + topItem));
                throw new IllegalStateException("Parent PlayPen object not found!");
            }
            PlayPen pp = (PlayPen)topItem;
            int x = Integer.parseInt(attributes.getValue("x"));
            int y = Integer.parseInt(attributes.getValue("y"));
            SQLTable tab = (SQLTable)SwingUIProjectLoader.this.sqlObjectLoadIdMap.get(attributes.getValue("table-ref"));
            TablePane tp = new TablePane(tab, pp.getContentPane());
            String bgColorString = attributes.getValue("bgColor");
            if (bgColorString != null) {
                Color bgColor = Color.decode(bgColorString);
                tp.setBackgroundColor(bgColor);
            }
            if ((fgColorString = attributes.getValue("fgColor")) != null) {
                Color fgColor = Color.decode(fgColorString);
                tp.setForegroundColor(fgColor);
            }
            boolean rounded = "true".equals(attributes.getValue("rounded"));
            tp.setRounded(rounded);
            boolean dashed = "true".equals(attributes.getValue("dashed"));
            tp.setDashed(dashed);
            pp.addTablePane(tp, new Point(x, y));
            return tp;
        }
    }

    private class RelationalPlayPenFactory
    extends AbstractObjectCreationFactory {
        private RelationalPlayPenFactory() {
        }

        public Object createObject(Attributes attributes) {
            boolean direct;
            String showPrimaryTag;
            PlayPen pp = SwingUIProjectLoader.this.getSession().getPlayPen();
            SwingUIProjectLoader.this.setupGenericPlayPen(pp, attributes);
            String columnVisibility = attributes.getValue("columnVisibility");
            if (columnVisibility != null) {
                SwingUIProjectLoader.this.getSession().setColumnVisibility(ProjectSettings.ColumnVisibility.valueOf(columnVisibility));
            }
            if ((showPrimaryTag = attributes.getValue("showPrimaryTag")) == null) {
                SwingUIProjectLoader.this.getSession().setShowPkTag(true);
            } else if (!Boolean.valueOf(showPrimaryTag).booleanValue()) {
                SwingUIProjectLoader.this.getSession().setShowPkTag(false);
            } else {
                SwingUIProjectLoader.this.getSession().setShowPkTag(true);
            }
            String showForeignTag = attributes.getValue("showForeignTag");
            if (showForeignTag == null) {
                SwingUIProjectLoader.this.getSession().setShowFkTag(true);
            } else if (!Boolean.valueOf(showForeignTag).booleanValue()) {
                SwingUIProjectLoader.this.getSession().setShowFkTag(false);
            } else {
                SwingUIProjectLoader.this.getSession().setShowFkTag(true);
            }
            String showAlternateTag = attributes.getValue("showAlternateTag");
            if (showAlternateTag == null) {
                SwingUIProjectLoader.this.getSession().setShowAkTag(true);
            } else if (!Boolean.valueOf(showAlternateTag).booleanValue()) {
                SwingUIProjectLoader.this.getSession().setShowAkTag(false);
            } else {
                SwingUIProjectLoader.this.getSession().setShowAkTag(true);
            }
            String usingLogicalNames = attributes.getValue("names-displayLogicalNames");
            if (usingLogicalNames == null) {
                SwingUIProjectLoader.this.getSession().setUsingLogicalNames(true);
            } else if (!Boolean.valueOf(usingLogicalNames).booleanValue()) {
                SwingUIProjectLoader.this.getSession().setUsingLogicalNames(false);
            } else {
                SwingUIProjectLoader.this.getSession().setUsingLogicalNames(true);
            }
            String relationshipLabelVisibility = attributes.getValue("relationshipLabelVisibility");
            if (relationshipLabelVisibility == null) {
                SwingUIProjectLoader.this.getSession().setDisplayRelationshipLabel(true);
            } else if (!Boolean.valueOf(relationshipLabelVisibility).booleanValue()) {
                SwingUIProjectLoader.this.getSession().setDisplayRelationshipLabel(false);
            } else {
                SwingUIProjectLoader.this.getSession().setDisplayRelationshipLabel(true);
            }
            String relStyle = attributes.getValue("relationship-style");
            if (relStyle == null) {
                direct = false;
            } else if (relStyle.equals(SwingUIProjectLoader.RELATIONSHIP_STYLE_DIRECT)) {
                direct = true;
            } else if (relStyle.equals(SwingUIProjectLoader.RELATIONSHIP_STYLE_RECTILINEAR)) {
                direct = false;
            } else {
                logger.warn((Object)"Unknown relationship style \"\"; defaulting to rectilinear");
                direct = false;
            }
            SwingUIProjectLoader.this.getSession().setRelationshipLinesDirect(direct);
            return pp;
        }
    }

    private class OLAPPlayPenFactory
    extends AbstractObjectCreationFactory {
        private OLAPPlayPenFactory() {
        }

        public Object createObject(Attributes attributes) {
            Object topItem = this.getDigester().peek();
            if (!(topItem instanceof OLAPEditSession)) {
                logger.error((Object)("Expected parent OLAPEditSession object on top of stack but found: " + topItem));
                throw new IllegalStateException("Parent OLAPEditSession not found!");
            }
            OLAPEditSession editSession = (OLAPEditSession)((Object)topItem);
            PlayPen pp = editSession.getOlapPlayPen();
            SwingUIProjectLoader.this.setupGenericPlayPen(pp, attributes);
            return pp;
        }
    }
}

