/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.InsertionPointWatcher;
import ca.sqlpower.architect.ProjectSettings;
import ca.sqlpower.architect.layout.LayoutEdge;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingProject;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.BasicTablePaneUI;
import ca.sqlpower.architect.swingui.ContainerPane;
import ca.sqlpower.architect.swingui.DuplicateProperties;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenComponentUI;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.TablePaneUI;
import ca.sqlpower.architect.swingui.action.EditSpecificIndexAction;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sqlobject.LockedColumnException;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.ColorIcon;
import ca.sqlpower.swingui.ColourScheme;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.dbtree.SQLObjectSelection;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import ca.sqlpower.util.UserPrompterFactory;
import ca.sqlpower.util.WebColour;
import com.google.common.collect.ArrayListMultimap;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class TablePane
extends ContainerPane<SQLTable, SQLColumn> {
    private static final Logger logger = Logger.getLogger(TablePane.class);
    public static final List<Class<? extends SPObject>> allowedChildTypes = PlayPenComponent.allowedChildTypes;
    public static final int COLUMN_INDEX_END_OF_PK = -3;
    public static final int COLUMN_INDEX_START_OF_NON_PK = -4;
    private final AbstractSPListener containerPaneListener = new AbstractSPListener(){

        public void childRemoved(SPChildEvent e) {
            if (e.getChild() == TablePane.this) {
                TablePane.this.destroy();
            }
        }
    };
    protected int insertionPoint;
    protected Set<SQLColumn> hiddenColumns;
    boolean usingLogicalNames;
    protected Map<SQLColumn, List<Color>> columnHighlight;
    protected SQLColumn draggingColumn;
    private boolean fullyQualifiedNameInHeader = false;
    private boolean isDragging = false;
    SPListener columnListener = new ColumnListener();

    public TablePane(TablePane tp, PlayPenContentPane parent) {
        super(tp.getName(), parent);
        this.model = tp.getModel();
        this.margin = (Insets)tp.margin.clone();
        this.columnHighlight = new HashMap<SQLColumn, List<Color>>(tp.columnHighlight);
        this.setMinimumSize(tp.getMinimumSize());
        for (SQLColumn c : tp.getSelectedItems()) {
            this.selectItem(c);
        }
        this.insertionPoint = tp.insertionPoint;
        this.draggingColumn = tp.draggingColumn;
        this.topLeftCorner = new Point(tp.topLeftCorner);
        this.selected = false;
        this.hiddenColumns = new HashSet<SQLColumn>(tp.getHiddenColumns());
        this.foregroundColor = tp.getForegroundColor();
        this.backgroundColor = tp.getBackgroundColor();
        this.setDashed(tp.isDashed());
        this.setRounded(tp.isRounded());
        try {
            PlayPenComponentUI newUi = (PlayPenComponentUI)tp.getUI().getClass().newInstance();
            newUi.installUI(this);
            this.setUI(newUi);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Woops, couldn't invoke no-args constructor of " + tp.getUI().getClass().getName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Woops, couldn't access no-args constructor of " + tp.getUI().getClass().getName());
        }
    }

    @Constructor
    public TablePane(@ConstructorParameter(propertyName="model") SQLTable m, @ConstructorParameter(propertyName="parent") PlayPenContentPane parent) {
        super(m.getName());
        this.setParent((SPObject)parent);
        this.setModel(m);
        this.hiddenColumns = new HashSet<SQLColumn>();
        this.setInsertionPoint(-2);
        this.updateUI();
    }

    @Override
    protected List<SQLColumn> getItems() {
        try {
            return ((SQLTable)this.model).getColumns();
        }
        catch (SQLObjectException e) {
            throw new SQLObjectRuntimeException(e);
        }
    }

    public String toString() {
        return "TablePane: " + this.model;
    }

    public void updateUI() {
        TablePaneUI ui = (TablePaneUI)BasicTablePaneUI.createUI(this);
        ui.installUI(this);
        this.setUI(ui);
        this.updateLengths(false);
    }

    @Override
    public void connect() {
        this.destroy();
        SQLPowerUtils.listenToHierarchy((SPObject)((SPObject)this.model), (SPListener)this.columnListener);
        this.getParent().addSPListener((SPListener)this.containerPaneListener);
    }

    private void destroy() {
        SQLPowerUtils.unlistenToHierarchy((SPObject)((SPObject)this.model), (SPListener)this.columnListener);
        this.getParent().removeSPListener((SPListener)this.containerPaneListener);
    }

    private void setModel(SQLTable m) {
        if (this.model != null) {
            throw new IllegalStateException("model already set to " + this.model);
        }
        this.model = m;
        try {
            this.columnHighlight = new HashMap<SQLColumn, List<Color>>();
            for (SQLColumn column : ((SQLTable)this.model).getColumns()) {
                this.columnHighlight.put(column, new ArrayList());
            }
        }
        catch (SQLObjectException e) {
            logger.error((Object)"Error getting children on new model", (Throwable)e);
        }
        this.connect();
    }

    @Override
    public String getModelName() {
        if (this.model == null) {
            return null;
        }
        return ((SQLTable)this.model).getName();
    }

    @Transient
    @Accessor
    public int getInsertionPoint() {
        return this.insertionPoint;
    }

    @Transient
    @Mutator
    public void setInsertionPoint(int ip) {
        int old = this.insertionPoint;
        this.insertionPoint = ip;
        if (ip != old) {
            if (!this.isDragging()) {
                this.firePropertyChange("insertionPoint", new Integer(old), new Integer(this.insertionPoint));
            }
            this.repaint();
        }
    }

    public void updateHiddenColumns() {
        this.hiddenColumns.clear();
        ArchitectSwingSession session = this.getPlayPen().getSession();
        ProjectSettings.ColumnVisibility choice = session.getColumnVisibility();
        if (!choice.equals((Object)ProjectSettings.ColumnVisibility.ALL)) {
            this.hiddenColumns.addAll(this.getItems());
            for (SQLColumn col : this.getItems()) {
                if (col.isPrimaryKey()) {
                    this.hiddenColumns.remove(col);
                }
                if (!choice.equals((Object)ProjectSettings.ColumnVisibility.PK) && col.isForeignKey()) {
                    this.hiddenColumns.remove(col);
                }
                if (!choice.equals((Object)ProjectSettings.ColumnVisibility.PK) && !choice.equals((Object)ProjectSettings.ColumnVisibility.PK_FK) && col.isUniqueIndexed()) {
                    this.hiddenColumns.remove(col);
                }
                if (choice.equals((Object)ProjectSettings.ColumnVisibility.PK) || choice.equals((Object)ProjectSettings.ColumnVisibility.PK_FK) || choice.equals((Object)ProjectSettings.ColumnVisibility.PK_FK_UNIQUE) || !col.isIndexed()) continue;
                this.hiddenColumns.remove(col);
            }
        }
    }

    @Transient
    @Accessor
    public boolean isUsingLogicalNames() {
        ArchitectSwingSession session;
        PlayPen pp = this.getPlayPen();
        if (pp != null && (session = pp.getSession()) != null) {
            return session.isUsingLogicalNames();
        }
        return true;
    }

    public void updateNameDisplay() {
        ArchitectSwingSession session = this.getPlayPen().getSession();
        this.usingLogicalNames = session.isUsingLogicalNames();
    }

    @Override
    @Deprecated
    public int pointToItemIndex(Point p) {
        return ((TablePaneUI)this.getUI()).pointToItemIndex(p);
    }

    public int columnIndexToCentreY(int colidx) {
        return ((TablePaneUI)this.getUI()).columnIndexToCentreY(colidx);
    }

    public boolean insertObjects(List<? extends SQLObject> items, int insertionPoint, boolean deleteSource) throws SQLObjectException {
        boolean newColumnsInPk = false;
        if (insertionPoint == -3) {
            insertionPoint = ((SQLTable)this.getModel()).getPkSize();
            newColumnsInPk = true;
        } else if (insertionPoint == -4) {
            insertionPoint = ((SQLTable)this.getModel()).getPkSize();
            newColumnsInPk = false;
        } else if (insertionPoint == -1) {
            insertionPoint = 0;
            newColumnsInPk = true;
        } else if (insertionPoint < 0) {
            insertionPoint = ((SQLTable)this.getModel()).getColumns().size();
            newColumnsInPk = false;
        } else if (insertionPoint < ((SQLTable)this.getModel()).getPkSize()) {
            newColumnsInPk = true;
        }
        ArrayListMultimap newColumns = ArrayListMultimap.create();
        for (int i = items.size() - 1; i >= 0; --i) {
            SQLObject someData = items.get(i);
            DuplicateProperties duplicateProperties = ASUtils.createDuplicateProperties(this.getParent().getPlayPen().getSession(), someData);
            logger.debug((Object)("insertObjects: got item of type " + someData.getClass().getName()));
            if (someData instanceof SQLTable) {
                SQLTable table = (SQLTable)someData;
                newColumns.putAll((Object)table.getParentDatabase().getDataSource().getParentType().getName(), (Iterable)((SQLTable)this.getModel()).inherit(insertionPoint, table, duplicateProperties.getDefaultTransferStyle(), duplicateProperties.isPreserveColumnSource()));
                for (SQLColumn column : table.getColumns()) {
                    SQLColumn targetCol = ((SQLTable)this.getModel()).getColumnByName(column.getName());
                    ASUtils.correctSourceColumn(column, duplicateProperties, targetCol, this.getPlayPen().getSession().getDBTree());
                }
                continue;
            }
            if (someData instanceof SQLColumn) {
                SQLColumn col = (SQLColumn)someData;
                if (deleteSource) {
                    if (col.getParent() == this.getModel()) {
                        int oldIndex = col.getParent().getColumns().indexOf(col);
                        if (insertionPoint > oldIndex) {
                            --insertionPoint;
                        }
                        ((SQLTable)this.getModel()).changeColumnIndex(oldIndex, insertionPoint, newColumnsInPk);
                        continue;
                    }
                    if (col.getParent().getParentDatabase() == ((SQLTable)this.getModel()).getParentDatabase()) {
                        try {
                            ((SQLTable)this.getModel()).begin("Moving column " + col.getName() + " to table " + this.getName());
                            InsertionPointWatcher<SQLObject> ipWatcher = new InsertionPointWatcher<SQLObject>((SQLObject)this.getModel(), insertionPoint, SQLColumn.class);
                            col.getParent().removeColumn(col);
                            ipWatcher.dispose();
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Moving column '" + col.getName() + "' to table '" + ((SQLTable)this.getModel()).getName() + "' at position " + ipWatcher.getInsertionPoint()));
                            }
                            ((SQLTable)this.getModel()).addColumn(col, newColumnsInPk, ipWatcher.getInsertionPoint());
                            ((SQLTable)this.getModel()).commit();
                        }
                        catch (RuntimeException e) {
                            ((SQLTable)this.getModel()).rollback(e.getMessage());
                            throw e;
                        }
                        logger.debug((Object)("Column listeners are " + col.getSPListeners()));
                        continue;
                    }
                    newColumns.put((Object)col.getParent().getParentDatabase().getDataSource().getParentType().getName(), (Object)((SQLTable)this.getModel()).inherit(insertionPoint, col, newColumnsInPk, duplicateProperties.getDefaultTransferStyle(), duplicateProperties.isPreserveColumnSource()));
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Inherited " + col.getName() + " to table with precision " + col.getPrecision()));
                    continue;
                }
                if (col.getParent() == null) {
                    newColumns.put(null, (Object)((SQLTable)this.getModel()).inherit(insertionPoint, col, newColumnsInPk, duplicateProperties.getDefaultTransferStyle(), duplicateProperties.isPreserveColumnSource()));
                } else {
                    newColumns.put((Object)col.getParent().getParentDatabase().getDataSource().getParentType().getName(), (Object)((SQLTable)this.getModel()).inherit(insertionPoint, col, newColumnsInPk, duplicateProperties.getDefaultTransferStyle(), duplicateProperties.isPreserveColumnSource()));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Inherited " + col.getName() + " to table with precision " + col.getPrecision()));
                }
                ASUtils.correctSourceColumn(col, duplicateProperties, ((SQLTable)this.getModel()).getColumnByName(col.getName()), this.getPlayPen().getSession().getDBTree());
                continue;
            }
            return false;
        }
        DataSourceCollection dsCollection = ((SQLTable)this.getModel()).getParentDatabase().getDataSource().getParentCollection();
        for (String platform : newColumns.keySet()) {
            SQLColumn.assignTypes((List)newColumns.get((Object)platform), (DataSourceCollection)dsCollection, (String)(platform == null ? "" : platform), (UserPrompterFactory)this.getPlayPen().getSession());
        }
        return true;
    }

    public void addColumnHighlight(SQLColumn column, Color colour) {
        if (this.columnHighlight.get(column) == null) {
            this.columnHighlight.put(column, new ArrayList());
        }
        this.columnHighlight.get(column).add(colour);
        this.repaint();
    }

    public void removeColumnHighlight(SQLColumn column, Color colour) {
        this.columnHighlight.get(column).remove(colour);
        this.repaint();
    }

    @NonBound
    public Color getColumnHighlight(int i) throws SQLObjectException {
        return this.getColumnHighlight(((SQLTable)this.model).getColumn(i));
    }

    @NonBound
    public Color getColumnHighlight(SQLColumn column) {
        logger.debug((Object)("Checking column " + column));
        if (this.columnHighlight.get(column) == null || this.columnHighlight.get(column).isEmpty()) {
            return this.getForegroundColor();
        }
        float[] rgbsum = new float[3];
        for (Color c : this.columnHighlight.get(column)) {
            float[] comps = c.getRGBColorComponents(new float[3]);
            rgbsum[0] = rgbsum[0] + comps[0];
            rgbsum[1] = rgbsum[1] + comps[1];
            rgbsum[2] = rgbsum[2] + comps[2];
        }
        float sz = this.columnHighlight.get(column).size();
        return new Color(rgbsum[0] / sz, rgbsum[1] / sz, rgbsum[2] / sz);
    }

    @Transient
    @Mutator
    public void setFullyQualifiedNameInHeader(boolean fullyQualifiedNameInHeader) {
        this.fullyQualifiedNameInHeader = fullyQualifiedNameInHeader;
    }

    @Transient
    @Accessor
    public boolean isFullyQualifiedNameInHeader() {
        return this.fullyQualifiedNameInHeader;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DragEnter event on " + this.getName()));
        }
        this.setDragging(true);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DragExit event on " + this.getName()));
        }
        this.setDragging(false);
        this.setInsertionPoint(-2);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.setDragging(true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DragOver event on " + this.getName() + ": " + dtde));
            logger.debug((Object)("Drop Action = " + dtde.getDropAction()));
            logger.debug((Object)("Source Actions = " + dtde.getSourceActions()));
        }
        dtde.acceptDrag(3 & dtde.getDropAction());
        Point loc = this.getPlayPen().unzoomPoint(new Point(dtde.getLocation()));
        loc.x -= this.getX();
        loc.y -= this.getY();
        int idx = this.pointToItemIndex(loc);
        this.setInsertionPoint(idx);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (dsde.getDropSuccess()) {
            logger.debug((Object)"Succesful drop");
        } else {
            logger.debug((Object)"Unsuccesful drop");
        }
        this.setDragging(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent dtde) {
        PlayPen pp = this.getPlayPen();
        Point loc = pp.unzoomPoint(new Point(dtde.getLocation()));
        loc.x -= this.getX();
        loc.y -= this.getY();
        logger.debug((Object)("Drop target drop event on " + this.getName() + ": " + dtde));
        Transferable t = dtde.getTransferable();
        DataFlavor importFlavor = this.bestImportFlavor(pp, t.getTransferDataFlavors());
        if (importFlavor == null) {
            dtde.rejectDrop();
            this.setInsertionPoint(-2);
        } else {
            try {
                pp.startCompoundEdit("Drag and drop");
                if ((dtde.getSourceActions() & dtde.getDropAction()) == 0) {
                    dtde.rejectDrop();
                    return;
                }
                boolean success = false;
                success = this.addTransferable(loc, t, importFlavor, dtde.getDropAction() == 2);
                if (success) {
                    dtde.acceptDrop(1);
                } else {
                    dtde.rejectDrop();
                }
                dtde.dropComplete(success);
            }
            catch (Exception ex) {
                logger.error((Object)"Error processing drop operation", (Throwable)ex);
                dtde.rejectDrop();
                dtde.dropComplete(false);
                ASUtils.showExceptionDialogNoReport(this.getParent().getPlayPen(), "Error processing drop operation", ex);
            }
            finally {
                this.setInsertionPoint(-2);
                pp.endCompoundEdit("Ending drag and drop");
                this.setDragging(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addTransferable(Point loc, Transferable t, DataFlavor importFlavor, boolean deleteSource) throws UnsupportedFlavorException, IOException, SQLObjectException {
        boolean success;
        PlayPen pp = this.getPlayPen();
        try {
            List<SQLObject> droppedItems;
            int insertionPoint = this.pointToItemIndex(loc);
            if (importFlavor == SQLObjectSelection.LOCAL_SQLOBJECT_ARRAY_FLAVOUR) {
                droppedItems = Arrays.asList((SQLObject[])t.getTransferData(importFlavor));
            } else if (importFlavor == DataFlavor.stringFlavor) {
                String[] stringPieces = ((String)t.getTransferData(DataFlavor.stringFlavor)).split("[\n\r\t]+");
                droppedItems = new ArrayList<SQLObject>();
                for (String s : stringPieces) {
                    if (s.length() <= 0) continue;
                    SQLColumn newCol = new SQLColumn();
                    newCol.setName(s);
                    newCol.setParent((SQLTable)this.getModel());
                    droppedItems.add((SQLObject)newCol);
                }
            } else {
                boolean stringPieces = false;
                return stringPieces;
            }
            logger.debug((Object)("Importing items: " + droppedItems));
            List importedKeys = SQLRelationship.getExportedKeys((List)((SQLTable)this.getModel()).getImportedKeys());
            boolean newColumnsInPk = false;
            if (insertionPoint == -3) {
                newColumnsInPk = true;
            } else if (insertionPoint == -4) {
                newColumnsInPk = false;
            } else if (insertionPoint == -1) {
                newColumnsInPk = true;
            } else if (insertionPoint < 0) {
                newColumnsInPk = false;
            } else if (insertionPoint < ((SQLTable)this.getModel()).getPkSize()) {
                newColumnsInPk = true;
            }
            try {
                ArrayList<SQLColumn> droppedColumns = new ArrayList<SQLColumn>();
                for (SQLObject o : droppedItems) {
                    if (o instanceof SQLColumn) {
                        droppedColumns.add((SQLColumn)o);
                        continue;
                    }
                    if (!(o instanceof SQLTable)) continue;
                    droppedColumns.addAll(((SQLTable)o).getChildren(SQLColumn.class));
                }
                block13: for (int i = 0; i < importedKeys.size(); ++i) {
                    if (((SQLRelationship)importedKeys.get(i)).getPkTable().equals((Object)((SQLRelationship)importedKeys.get(i)).getFkTable())) continue;
                    for (SQLColumn droppedColumn : droppedColumns) {
                        if (!((SQLRelationship)importedKeys.get(i)).containsFkColumn(droppedColumn)) continue;
                        ((SQLRelationship)importedKeys.get(i)).setIdentifying(newColumnsInPk);
                        continue block13;
                    }
                }
                ArchitectSwingProject project = this.getParent().getParent();
                success = false;
                try {
                    project.begin("Inserting column(s) into table");
                    success = this.insertObjects(droppedItems, insertionPoint, deleteSource);
                    if (success) {
                        project.commit();
                    }
                }
                catch (Throwable e) {
                    if (e instanceof SQLObjectException) {
                        throw new SQLObjectException(e);
                    }
                    throw new RuntimeException(e);
                }
                finally {
                    if (!success) {
                        project.rollback("Was unsuccessful inserting objects into table");
                    }
                }
            }
            catch (LockedColumnException ex) {
                if (logger.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                JOptionPane.showConfirmDialog(pp, "Could not delete the column " + ex.getCol().getName() + " because it is part of\n" + "the relationship \"" + ex.getLockingRelationship() + "\".\n\n", "Column is Locked", -1);
                success = false;
            }
        }
        finally {
            this.setInsertionPoint(-2);
        }
        return success;
    }

    @Override
    public void pasteData(Transferable t) {
        Point loc = this.getPlayPen().unzoomPoint(this.getPlayPen().getMousePosition());
        if (loc == null) {
            loc = new Point(0, this.getHeight());
        } else {
            loc.x -= this.getX();
            loc.y -= this.getY();
        }
        DataFlavor bestImportFlavor = null;
        try {
            this.getPlayPen().startCompoundEdit("Transfering data");
            bestImportFlavor = this.bestImportFlavor(this.getPlayPen(), t.getTransferDataFlavors());
            this.addTransferable(loc, t, bestImportFlavor, false);
        }
        catch (UnsupportedFlavorException e) {
            throw new RuntimeException("Cannot add items to a table of type " + bestImportFlavor, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Transfer type changed while adding it to the table", e);
        }
        catch (SQLObjectException e) {
            throw new RuntimeException("Unknown object type to add to a table", e);
        }
        finally {
            this.getPlayPen().endCompoundEdit("End transfering data");
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        logger.debug((Object)"");
    }

    @Override
    public DataFlavor bestImportFlavor(JComponent c, DataFlavor[] flavors) {
        int i;
        logger.debug((Object)("can I import " + Arrays.asList(flavors)));
        for (i = 0; i < flavors.length; ++i) {
            String cls = flavors[i].getDefaultRepresentationClassAsString();
            logger.debug((Object)("representation class = " + cls));
            logger.debug((Object)("mime type = " + flavors[i].getMimeType()));
            logger.debug((Object)("type = " + flavors[i].getPrimaryType()));
            logger.debug((Object)("subtype = " + flavors[i].getSubType()));
            logger.debug((Object)("class = " + flavors[i].getParameter("class")));
            logger.debug((Object)("isSerializedObject = " + flavors[i].isFlavorSerializedObjectType()));
            logger.debug((Object)("isInputStream = " + flavors[i].isRepresentationClassInputStream()));
            logger.debug((Object)("isRemoteObject = " + flavors[i].isFlavorRemoteObjectType()));
            logger.debug((Object)("isLocalObject = " + flavors[i].getMimeType().equals("application/x-java-jvm-local-objectref")));
            if (!flavors[i].equals(SQLObjectSelection.LOCAL_SQLOBJECT_ARRAY_FLAVOUR)) continue;
            logger.debug((Object)"YES");
            return flavors[i];
        }
        for (i = 0; i < flavors.length; ++i) {
            if (!flavors[i].equals(DataFlavor.stringFlavor)) continue;
            return flavors[i];
        }
        logger.debug((Object)"NO!");
        return null;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.bestImportFlavor(c, flavors) != null;
    }

    @Override
    @Transient
    @Accessor
    public List<LayoutEdge> getInboundEdges() {
        try {
            List relationships = SQLRelationship.getExportedKeys((List)((SQLTable)this.getModel()).getImportedKeys());
            ArrayList<LayoutEdge> edges = new ArrayList<LayoutEdge>();
            for (SQLRelationship r : relationships) {
                edges.add(this.getPlayPen().findRelationship(r));
            }
            return edges;
        }
        catch (SQLObjectException ex) {
            throw new SQLObjectRuntimeException(ex);
        }
    }

    @Override
    @Transient
    @Accessor
    public List<LayoutEdge> getOutboundEdges() {
        try {
            List relationships = ((SQLTable)this.getModel()).getExportedKeys();
            ArrayList<LayoutEdge> edges = new ArrayList<LayoutEdge>();
            for (SQLRelationship r : relationships) {
                edges.add(this.getPlayPen().findRelationship(r));
            }
            return edges;
        }
        catch (SQLObjectException ex) {
            throw new SQLObjectRuntimeException(ex);
        }
    }

    @Transient
    @Accessor
    public int getHiddenPkCount() {
        int count = 0;
        for (SQLColumn c : this.hiddenColumns) {
            if (!c.isPrimaryKey()) continue;
            ++count;
        }
        return count;
    }

    @Transient
    @Accessor
    public boolean isShowPkTag() {
        ArchitectSwingSession session;
        PlayPen pp = this.getPlayPen();
        if (pp != null && (session = pp.getSession()) != null) {
            return session.isShowPkTag();
        }
        return true;
    }

    @Transient
    @Accessor
    public boolean isShowFkTag() {
        ArchitectSwingSession session;
        PlayPen pp = this.getPlayPen();
        if (pp != null && (session = pp.getSession()) != null) {
            return session.isShowFkTag();
        }
        return true;
    }

    @Transient
    @Accessor
    public boolean isShowAkTag() {
        ArchitectSwingSession session;
        PlayPen pp = this.getPlayPen();
        if (pp != null && (session = pp.getSession()) != null) {
            return session.isShowAkTag();
        }
        return true;
    }

    @Transient
    @Accessor
    public Set<SQLColumn> getHiddenColumns() {
        return this.hiddenColumns;
    }

    private List<TablePane> getSelectedTablePanes() {
        ArrayList<TablePane> selectedTables = new ArrayList<TablePane>();
        for (ContainerPane<?, ?> cp : this.getPlayPen().getSelectedContainers()) {
            if (!(cp instanceof TablePane)) continue;
            selectedTables.add((TablePane)cp);
        }
        return Collections.unmodifiableList(selectedTables);
    }

    @Override
    @NonBound
    public JPopupMenu getPopup(Point p) {
        ColorIcon icon;
        ArchitectFrame af = this.getPlayPen().getSession().getArchitectFrame();
        JPopupMenu tablePanePopup = new JPopupMenu();
        JMenuItem mi = new JMenuItem();
        mi.setAction(af.getInsertIndexAction());
        mi.setActionCommand("PlayPen");
        tablePanePopup.add(mi);
        try {
            if (this.model != null && ((SQLTable)this.model).getIndices().size() > 0) {
                JMenu menu = new JMenu(Messages.getString("TablePane.indexPropertiesMenu"));
                menu.setIcon(SPSUtils.createIcon((String)"edit_index", (String)Messages.getString("TablePane.editIndexTooltip"), (int)16));
                for (SQLIndex index : ((SQLTable)this.model).getIndices()) {
                    JMenuItem menuItem = new JMenuItem(new EditSpecificIndexAction(this.getPlayPen().getSession(), index));
                    menuItem.setActionCommand("PlayPen");
                    menu.add(menuItem);
                }
                tablePanePopup.add(menu);
            }
        }
        catch (SQLObjectException e) {
            throw new SQLObjectRuntimeException(e);
        }
        tablePanePopup.addSeparator();
        mi = new JMenuItem();
        mi.setAction(af.getInsertColumnAction());
        mi.setActionCommand("PlayPen");
        tablePanePopup.add(mi);
        mi = new JMenuItem();
        mi.setAction(af.getEditColumnAction());
        mi.setActionCommand("PlayPen");
        tablePanePopup.add(mi);
        tablePanePopup.addSeparator();
        JMenu align = new JMenu(Messages.getString("TablePane.alignTablesMenu"));
        mi = new JMenuItem();
        mi.setAction(af.getAlignTableHorizontalAction());
        mi.setActionCommand("PlayPen");
        align.add(mi);
        mi = new JMenuItem();
        mi.setAction(af.getAlignTableVerticalAction());
        mi.setActionCommand("PlayPen");
        align.add(mi);
        tablePanePopup.add(align);
        JMenu tableAppearance = new JMenu(Messages.getString("TablePane.tableAppearances"));
        JMenu backgroundColours = new JMenu(Messages.getString("TableEditPanel.tableColourLabel"));
        JMenu foregroundColours = new JMenu(Messages.getString("TableEditPanel.textColourLabel"));
        for (WebColour colour : ColourScheme.BACKGROUND_COLOURS) {
            icon = new ColorIcon(60, 25, (Color)colour);
            mi = new JMenuItem((Icon)icon);
            mi.addActionListener(new ActionListener((Color)colour){
                final /* synthetic */ Color val$colour;
                {
                    this.val$colour = color;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    TablePane.this.getPlayPen().startCompoundEdit("Started setting table colour");
                    for (TablePane tp : TablePane.this.getSelectedTablePanes()) {
                        tp.setBackgroundColor(this.val$colour);
                    }
                    TablePane.this.getPlayPen().endCompoundEdit("Finished setting table colour");
                }
            });
            backgroundColours.add(mi);
        }
        for (WebColour colour : ColourScheme.FOREGROUND_COLOURS) {
            icon = new ColorIcon(60, 25, (Color)colour);
            mi = new JMenuItem((Icon)icon);
            mi.addActionListener(new ActionListener((Color)colour){
                final /* synthetic */ Color val$colour;
                {
                    this.val$colour = color;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    TablePane.this.getPlayPen().startCompoundEdit("Started setting text colour");
                    for (TablePane tp : TablePane.this.getSelectedTablePanes()) {
                        tp.setForegroundColor(this.val$colour);
                    }
                    TablePane.this.getPlayPen().endCompoundEdit("Finished setting text colour");
                }
            });
            foregroundColours.add(mi);
        }
        tableAppearance.add(backgroundColours);
        tableAppearance.add(foregroundColours);
        JCheckBoxMenuItem cmi = new JCheckBoxMenuItem(Messages.getString("TableEditPanel.dashedLinesLabel"), this.isDashed());
        cmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePane.this.getPlayPen().startCompoundEdit("Started setting dashed lines.");
                for (TablePane tp : TablePane.this.getSelectedTablePanes()) {
                    tp.setDashed(((JCheckBoxMenuItem)e.getSource()).isSelected());
                }
                TablePane.this.getPlayPen().endCompoundEdit("Finished setting dashed lines.");
            }
        });
        tableAppearance.add(cmi);
        cmi = new JCheckBoxMenuItem(Messages.getString("TableEditPanel.roundedCornersLabel"), this.isRounded());
        cmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePane.this.getPlayPen().startCompoundEdit("Started setting rounded edges.");
                for (TablePane tp : TablePane.this.getSelectedTablePanes()) {
                    tp.setRounded(((JCheckBoxMenuItem)e.getSource()).isSelected());
                }
                TablePane.this.getPlayPen().endCompoundEdit("Finished setting rounded edges.");
            }
        });
        tableAppearance.add(cmi);
        tablePanePopup.add(tableAppearance);
        mi = new JMenuItem();
        mi.setAction(af.getEditTableAction());
        mi.setActionCommand("PlayPen");
        tablePanePopup.add(mi);
        if (!this.getPlayPen().getSession().isEnterpriseSession()) {
            tablePanePopup.addSeparator();
            mi = new JMenuItem();
            mi.setAction(this.getPlayPen().bringToFrontAction);
            mi.setActionCommand("PlayPen");
            tablePanePopup.add(mi);
            mi = new JMenuItem();
            mi.setAction(this.getPlayPen().sendToBackAction);
            mi.setActionCommand("PlayPen");
            tablePanePopup.add(mi);
        }
        if (logger.isDebugEnabled()) {
            tablePanePopup.addSeparator();
            mi = new JMenuItem("Show listeners");
            mi.setActionCommand("PlayPen");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    List<PlayPenComponent> selection = TablePane.this.getPlayPen().getSelectedItems();
                    if (selection.size() == 1) {
                        TablePane tp = (TablePane)selection.get(0);
                        JOptionPane.showMessageDialog(TablePane.this.getPlayPen(), new JScrollPane(new JList<Object>(((SQLTable)tp.getModel()).getSPListeners().toArray())));
                    } else {
                        JOptionPane.showMessageDialog(TablePane.this.getPlayPen(), "You can only show listeners on one item at a time");
                    }
                }
            });
            tablePanePopup.add(mi);
            mi = new JMenuItem("Show Selection List");
            mi.setActionCommand("PlayPen");
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    List<PlayPenComponent> selection = TablePane.this.getPlayPen().getSelectedItems();
                    if (selection.size() == 1) {
                        TablePane tp = (TablePane)selection.get(0);
                        JOptionPane.showMessageDialog(TablePane.this.getPlayPen(), new JScrollPane(new JList<Object>(tp.getSelectedItems().toArray())));
                    } else {
                        JOptionPane.showMessageDialog(TablePane.this.getPlayPen(), "You can only show selected columns on one item at a time");
                    }
                }
            });
            tablePanePopup.add(mi);
        }
        tablePanePopup.addSeparator();
        mi = new JMenuItem();
        mi.setAction(af.getDeleteSelectedAction());
        mi.setActionCommand("PlayPen");
        tablePanePopup.add(mi);
        return tablePanePopup;
    }

    @Override
    public void handleMouseEvent(MouseEvent evt) {
        super.handleMouseEvent(evt);
        PlayPen pp = this.getPlayPen();
        Point p = evt.getPoint();
        pp.unzoomPoint(p);
        p.translate(-this.getX(), -this.getY());
        if (evt.getID() == 500 && (evt.getModifiers() & 0x10) != 0) {
            int selectedColIndex = this.pointToItemIndex(p);
            if (evt.getClickCount() == 2 && this.isSelected()) {
                ArchitectFrame af = pp.getSession().getArchitectFrame();
                if (selectedColIndex == -1) {
                    af.getEditTableAction().actionPerformed(new ActionEvent(this, 1001, "PlayPen"));
                } else if (selectedColIndex >= 0) {
                    af.getEditColumnAction().actionPerformed(new ActionEvent(this, 1001, "PlayPen"));
                }
            }
        }
    }

    @Override
    public Transferable createTransferableForSelection() {
        if (this.getSelectedItems().isEmpty()) {
            return null;
        }
        return new SQLObjectSelection(new ArrayList(this.getSelectedItems()));
    }

    @NonBound
    public boolean isDragging() {
        return this.isDragging;
    }

    @NonBound
    public void setDragging(boolean isDragging) {
        this.isDragging = isDragging;
    }

    private class ColumnListener
    implements SPListener {
        private SQLColumn mostRecentSelectedRemoval;
        private SQLColumn mostRecentSelectedReplacement;

        private ColumnListener() {
        }

        public void childAdded(SPChildEvent e) {
            if (e.getSource() == TablePane.this.getModel() && e.getChildType() == SQLColumn.class) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Column inserted. Syncing select/highlight lists. New index=" + e.getIndex()));
                }
                boolean wasSelectedPreviously = e.getChild() == this.mostRecentSelectedRemoval;
                SQLColumn column = (SQLColumn)e.getChild();
                if (wasSelectedPreviously) {
                    TablePane.this.deselectItem(this.mostRecentSelectedReplacement);
                    TablePane.this.selectItem(e.getIndex());
                    logger.debug((Object)"Restored most recent selection");
                } else {
                    logger.debug((Object)"Was not the most recent selection; not restoring");
                }
                if (TablePane.this.columnHighlight.get(column) == null) {
                    TablePane.this.columnHighlight.put(column, new ArrayList());
                }
            }
            SQLPowerUtils.listenToHierarchy((SPObject)e.getChild(), (SPListener)this);
            TablePane.this.updateHiddenColumns();
            TablePane.this.firePropertyChange("model.children", null, e.getChild());
            TablePane.this.setLengths(TablePane.this.getUI().getPreferredSize());
            TablePane.this.repaint();
        }

        public void childRemoved(SPChildEvent e) {
            if (e.getSource() == TablePane.this.model && e.getChild() instanceof SQLColumn) {
                SQLColumn removedCol;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Column removed. Syncing select/highlight lists. Removed index=" + e.getIndex()));
                }
                if (TablePane.this.isItemSelected(removedCol = (SQLColumn)e.getChild())) {
                    int removedIdx = e.getIndex();
                    TablePane.this.deselectItem(removedCol);
                    this.mostRecentSelectedRemoval = removedCol;
                    this.mostRecentSelectedReplacement = TablePane.this.getItems().isEmpty() ? null : TablePane.this.getItems().get(Math.min(removedIdx, TablePane.this.getItems().size() - 1));
                    TablePane.this.selectItem(this.mostRecentSelectedReplacement);
                    logger.debug((Object)("Remembering as most recent selection: " + this.mostRecentSelectedRemoval));
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Not remembering as recent selection. Selected items: " + TablePane.this.getSelectedItems()));
                }
            }
            SQLPowerUtils.unlistenToHierarchy((SPObject)e.getChild(), (SPListener)this);
            TablePane.this.updateHiddenColumns();
            TablePane.this.firePropertyChange("model.children", e.getChild(), null);
            TablePane.this.setLengths(TablePane.this.getUI().getPreferredSize());
            TablePane.this.repaint();
        }

        public void propertyChanged(PropertyChangeEvent e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TablePane got object changed event.  Source=" + e.getSource() + " Property=" + e.getPropertyName() + " oldVal=" + e.getOldValue() + " newVal=" + e.getNewValue() + " selectedItems=" + TablePane.this.getSelectedItems()));
            }
            TablePane.this.updateHiddenColumns();
            TablePane.this.firePropertyChange("model." + e.getPropertyName(), e.getOldValue(), e.getNewValue());
            TablePane.this.setLengths(TablePane.this.getUI().getPreferredSize());
            TablePane.this.repaint();
        }

        public void transactionEnded(TransactionEvent e) {
        }

        public void transactionRollback(TransactionEvent e) {
        }

        public void transactionStarted(TransactionEvent e) {
        }
    }
}

