/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ContainerPane;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenLabel;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.architect.swingui.event.ItemSelectionEvent;
import ca.sqlpower.architect.swingui.event.ItemSelectionListener;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.LockedColumnException;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class DeleteSelectedAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(DeleteSelectedAction.class);
    private SelectionHandler selectionHandler = new SelectionHandler();

    public DeleteSelectedAction(ArchitectSwingSession session) throws SQLObjectException {
        super(session, Messages.getString("DeleteSelectedAction.name"), Messages.getString("DeleteSelectedAction.description"), "delete");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        this.putValue("ActionCommandKey", "PlayPen");
        this.getPlaypen().addSelectionListener(this.selectionHandler);
        this.setupAction();
    }

    public DeleteSelectedAction(ArchitectFrame frame) {
        super(frame, Messages.getString("DeleteSelectedAction.name"), Messages.getString("DeleteSelectedAction.description"), "delete");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        this.putValue("ActionCommandKey", "PlayPen");
        frame.addSelectionListener(this.selectionHandler);
        this.setupAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        int decision;
        logger.debug((Object)"delete action detected!");
        logger.debug((Object)("ACTION COMMAND: " + evt.getActionCommand()));
        if (this.getPlaypen().getSelectedItems().size() < 1) {
            JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("DeleteSelectedAction.noItemsToDelete"));
            return;
        }
        List<SPObject> deleteItems = this.retrieveDeletableItems();
        int tCount = 0;
        int rCount = 0;
        int cCount = 0;
        int iCount = 0;
        int lCount = 0;
        for (SPObject item : deleteItems) {
            if (item instanceof SQLColumn) {
                ++cCount;
                continue;
            }
            if (item instanceof SQLTable) {
                ++tCount;
                for (SPObject child : ((SQLTable)item).getChildren()) {
                    if (deleteItems.contains(child)) continue;
                    if (child instanceof SQLColumn) {
                        ++cCount;
                        continue;
                    }
                    if (child instanceof SQLRelationship) {
                        ++rCount;
                        continue;
                    }
                    if (!(child instanceof SQLIndex)) continue;
                    ++iCount;
                }
                continue;
            }
            if (item instanceof SQLRelationship) {
                ++rCount;
                continue;
            }
            if (item instanceof SQLIndex) {
                ++iCount;
                continue;
            }
            if (item instanceof PlayPenLabel) {
                ++lCount;
                continue;
            }
            logger.warn((Object)("Unexpected type for deletable item: " + item.getClass()));
        }
        if (deleteItems.size() > 1 && (decision = JOptionPane.showConfirmDialog(this.frame, Messages.getString("DeleteSelectedAction.multipleDeleteConfirmation", String.valueOf(tCount), String.valueOf(cCount), String.valueOf(rCount), String.valueOf(iCount), String.valueOf(lCount)), Messages.getString("DeleteSelectedAction.multipleDeleteDialogTitle"), 0)) != 0) {
            return;
        }
        this.getPlaypen().getContentPane().begin("Delete");
        try {
            this.getPlaypen().startCompoundEdit("Delete");
            this.getPlaypen().setIgnoreTreeSelection(true);
            for (SPObject o : deleteItems) {
                try {
                    if (o instanceof SQLIndex) {
                        SQLIndex index = (SQLIndex)o;
                        o.getParent().removeChild(o);
                        continue;
                    }
                    if (o instanceof PlayPenLabel) {
                        this.getPlaypen().getContentPane().removeChild(o);
                        continue;
                    }
                    if (o.getParent() == null || !(o.getParent() instanceof SQLObject) || !((SQLObject)o.getParent()).getChildrenWithoutPopulating().contains(o)) continue;
                    o.getParent().removeChild(o);
                }
                catch (LockedColumnException ex) {
                    int decision2 = JOptionPane.showConfirmDialog(this.getPlaypen(), Messages.getString("DeleteSelectedAction.couldNotDeleteColumnContinueConfirmation", ex.getCol().getName(), ex.getLockingRelationship().toString()), Messages.getString("DeleteSelectedAction.couldNotDeleteColumnDialogTitle"), 0);
                    if (decision2 != 1) continue;
                    this.getPlaypen().getContentPane().commit();
                    this.getPlaypen().endCompoundEdit("Ending multi-select");
                    this.getPlaypen().setIgnoreTreeSelection(false);
                    return;
                }
                catch (IllegalArgumentException e) {
                    this.getPlaypen().getContentPane().rollback(e.toString());
                    throw new RuntimeException(e);
                }
                catch (ObjectDependentException e) {
                    this.getPlaypen().getContentPane().rollback(e.toString());
                    throw new RuntimeException(e);
                }
                catch (Throwable e) {
                    this.getPlaypen().getContentPane().rollback(e.toString());
                    throw new RuntimeException(e);
                }
            }
            this.getPlaypen().getContentPane().commit();
        }
        finally {
            this.getPlaypen().endCompoundEdit("Ending multi-select");
            this.getPlaypen().setIgnoreTreeSelection(false);
        }
    }

    List<SPObject> retrieveDeletableItems() {
        List<PlayPenComponent> selection = this.getPlaypen().getSelectedItems();
        ArrayList<SPObject> deleteItems = new ArrayList<SPObject>(selection.size());
        for (PlayPenComponent ppc : selection) {
            Object model;
            if (ppc instanceof TablePane) {
                TablePane tp = (TablePane)ppc;
                deleteItems.addAll(tp.getSelectedItems());
            } else if (ppc instanceof PlayPenLabel) {
                deleteItems.add((SPObject)ppc);
            }
            if (!((model = ppc.getModel()) instanceof SQLObject)) continue;
            deleteItems.add((SPObject)((SQLObject)model));
        }
        HashSet<SQLTable> tablesWithSelectedColumns = new HashSet<SQLTable>();
        ListIterator it = deleteItems.listIterator();
        while (it.hasNext()) {
            SPObject item = (SPObject)it.next();
            if (item instanceof SQLColumn) {
                tablesWithSelectedColumns.add(((SQLColumn)item).getParent());
                continue;
            }
            if (item instanceof SQLTable || item instanceof SQLRelationship || item instanceof SQLIndex || item instanceof PlayPenLabel) continue;
            logger.debug((Object)("Not deleting selected tree item " + item));
            it.remove();
        }
        deleteItems.removeAll(tablesWithSelectedColumns);
        return deleteItems;
    }

    private void setupAction() {
        String description;
        List<SPObject> deletableItems = this.retrieveDeletableItems();
        if (deletableItems.size() == 0) {
            this.setEnabled(false);
            description = Messages.getString("DeleteSelectedAction.deleteSelected");
        } else if (deletableItems.size() == 1) {
            this.setEnabled(true);
            SPObject item = deletableItems.get(0);
            String name = item.getName();
            description = Messages.getString("DeleteSelectedAction.deleteItem", name);
        } else {
            this.setEnabled(true);
            int numSelectedItems = deletableItems.size();
            description = Messages.getString("DeleteSelectedAction.deleteNumberOfItems", String.valueOf(numSelectedItems));
        }
        this.putValue("ShortDescription", description + Messages.getString("DeleteSelectedAction.shortcut"));
    }

    private class SelectionHandler
    implements SelectionListener,
    ItemSelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void itemSelected(SelectionEvent e) {
            DeleteSelectedAction.this.setupAction();
            if (e.getSource() instanceof ContainerPane) {
                ((ContainerPane)e.getSource()).addItemSelectionListener(this);
            }
        }

        @Override
        public void itemDeselected(SelectionEvent e) {
            DeleteSelectedAction.this.setupAction();
            if (e.getSource() instanceof ContainerPane) {
                ((ContainerPane)e.getSource()).removeItemSelectionListener(this);
            }
        }

        public void itemsDeselected(ItemSelectionEvent e) {
            DeleteSelectedAction.this.setupAction();
        }

        public void itemsSelected(ItemSelectionEvent e) {
            DeleteSelectedAction.this.setupAction();
        }
    }
}

