/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ddl.ConflictResolver;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.ddl.critic.CriticFix;
import ca.sqlpower.architect.ddl.critic.Criticism;
import ca.sqlpower.architect.ddl.critic.CriticismBucket;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.DDLExportPanel;
import ca.sqlpower.architect.swingui.SQLScriptDialog;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.architect.swingui.critic.CriticSwingUtil;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.SPSwingWorker;
import ca.sqlpower.swingui.SwingWorkerRegistry;
import ca.sqlpower.swingui.table.FancyExportableJTable;
import ca.sqlpower.swingui.table.TableUtils;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ExportDDLAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(ExportDDLAction.class);
    private static final String GENDDL_WARNINGS_EXPLANATION = Messages.getString("ExportDDLAction.errorsInstructions");
    private JDialog d;

    public ExportDDLAction(ArchitectFrame frame) {
        super(frame, Messages.getString("ExportDDLAction.name"), Messages.getString("ExportDDLAction.description"), "fwdSQL");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final DDLExportPanel ddlPanel = new DDLExportPanel(this.getSession());
        Callable<Boolean> okCall = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                if (ddlPanel.applyChanges()) {
                    DDLGenerator ddlg = ddlPanel.getGenerator();
                    ddlg.setTargetSchema(ddlPanel.getSchemaField().getText());
                    this.checkErrorsAndGenerateDDL(ddlg);
                }
                return Boolean.FALSE;
            }

            private void checkErrorsAndGenerateDDL(final DDLGenerator ddlg) {
                List<Criticism> criticisms = ExportDDLAction.this.getSession().getWorkspace().getCriticManager().criticize(ddlg.getClass());
                if (criticisms.isEmpty()) {
                    try {
                        this.generateAndDisplayDDL(ddlPanel, ddlg);
                    }
                    catch (Exception ex) {
                        ASUtils.showExceptionDialog(ExportDDLAction.this.getSession(), Messages.getString("ExportDDLAction.errorGeneratingDDLScript"), ex);
                    }
                } else {
                    final JDialog warningDialog = new JDialog(ExportDDLAction.this.frame);
                    JPanel mainPanel = new JPanel();
                    DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow"), mainPanel);
                    builder.setDefaultDialogBorder();
                    JTextArea explanation = new JTextArea(GENDDL_WARNINGS_EXPLANATION, 8, 60);
                    explanation.setLineWrap(true);
                    explanation.setWrapStyleWord(true);
                    explanation.setEditable(false);
                    explanation.setBackground(mainPanel.getBackground());
                    explanation.setPreferredSize(new Dimension(0, 0));
                    builder.append((Component)explanation);
                    builder.appendRow("10dlu");
                    builder.nextLine();
                    builder.appendRow("fill:pref:grow");
                    builder.nextLine();
                    final CriticismBucket bucket = new CriticismBucket();
                    bucket.updateCriticismsToMatch(criticisms);
                    FancyExportableJTable errorTable = CriticSwingUtil.createCriticTable(ExportDDLAction.this.getSession(), bucket);
                    builder.append((Component)new JScrollPane((Component)errorTable));
                    builder.nextLine();
                    JButton quickFixButton = new JButton(new AbstractAction(Messages.getString("ExportDDLAction.quickFixAllOption")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            warningDialog.dispose();
                            block0: for (Criticism criticism : bucket.getCriticisms()) {
                                if (criticism.getFixes().isEmpty()) continue;
                                for (CriticFix fix : criticism.getFixes()) {
                                    if (!fix.getFixType().equals((Object)CriticFix.FixType.QUICK_FIX)) continue;
                                    fix.apply();
                                    continue block0;
                                }
                            }
                            this.checkErrorsAndGenerateDDL(ddlg);
                        }
                    });
                    JButton ignoreButton = new JButton(new AbstractAction(Messages.getString("ExportDDLAction.ignoreWarningsOption")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            warningDialog.dispose();
                            try {
                                this.generateAndDisplayDDL(ddlPanel, ddlg);
                            }
                            catch (Exception ex) {
                                ASUtils.showExceptionDialog(ExportDDLAction.this.getSession(), Messages.getString("ExportDDLAction.errorGeneratingDDLScript"), ex);
                            }
                        }
                    });
                    JButton cancelButton = new JButton(new AbstractAction(Messages.getString("ExportDDLAction.cancelOption")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            warningDialog.dispose();
                        }
                    });
                    JButton recheckButton = new JButton(new AbstractAction(Messages.getString("ExportDDLAction.recheckOption")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            warningDialog.dispose();
                            this.checkErrorsAndGenerateDDL(ddlg);
                        }
                    });
                    ButtonBarBuilder buttonBar = new ButtonBarBuilder();
                    buttonBar.addGlue();
                    buttonBar.addGriddedButtons(new JButton[]{quickFixButton, ignoreButton, cancelButton, recheckButton});
                    builder.append((Component)buttonBar.getPanel());
                    warningDialog.add(mainPanel);
                    warningDialog.pack();
                    TableUtils.fitColumnWidths((JTable)errorTable, (int)10);
                    errorTable.setAutoResizeMode(2);
                    warningDialog.setLocationRelativeTo(ExportDDLAction.this.frame);
                    warningDialog.setVisible(true);
                }
            }

            private void generateAndDisplayDDL(DDLExportPanel ddlPanel2, DDLGenerator ddlg) throws SQLException, SQLObjectException {
                ddlg.generateDDLScript(ExportDDLAction.this.getSession(), ExportDDLAction.this.getSession().getTargetDatabase().getTables());
                SQLDatabase ppdb = new SQLDatabase(ddlPanel2.getTargetDB());
                SQLScriptDialog ssd = new SQLScriptDialog(ExportDDLAction.this.d, Messages.getString("ExportDDLAction.previewSQLScriptDialogTitle"), "", false, ddlg, ppdb.getDataSource(), true, ExportDDLAction.this.getSession());
                SPSwingWorker scriptWorker = ssd.getExecuteTask();
                ConflictFinderProcess cfp = new ConflictFinderProcess(ssd, ppdb, ddlg, ddlg.getDdlStatements(), ExportDDLAction.this.getSession());
                ConflictResolverProcess crp = new ConflictResolverProcess(ssd, cfp, ExportDDLAction.this.getSession());
                cfp.setNextProcess(crp);
                crp.setNextProcess(scriptWorker);
                ssd.setExecuteTask(cfp);
                ssd.setVisible(true);
            }
        };
        Callable<Boolean> cancelCall = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                ddlPanel.discardChanges();
                return Boolean.TRUE;
            }
        };
        this.d = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)ddlPanel, (Component)this.frame, (String)Messages.getString("ExportDDLAction.forwardEngineerSQLDialogTitle"), (String)Messages.getString("ExportDDLAction.okOption"), (Callable)okCall, (Callable)cancelCall);
        this.d.pack();
        this.d.setLocationRelativeTo(this.frame);
        this.d.setVisible(true);
    }

    public class ConflictResolverProcess
    extends SPSwingWorker {
        private JDialog parentDialog;
        private ConflictFinderProcess conflictFinder;
        private ConflictResolver cr;
        private String errorMessage;
        private Exception error;

        public ConflictResolverProcess(JDialog d, ConflictFinderProcess cfp, ArchitectSwingSession session) {
            super((SwingWorkerRegistry)session);
            this.parentDialog = d;
            this.conflictFinder = cfp;
        }

        public void doStuff() {
            if (this.isCancelled()) {
                return;
            }
            if (this.conflictFinder.doesUserWantToDropConflicts()) {
                this.cr = this.conflictFinder.getConflictResolver();
                this.cr.aboutToCallDropConflicting();
                try {
                    this.cr.dropConflicting();
                }
                catch (Exception ex) {
                    logger.error((Object)"Error while dropping conflicting objects", (Throwable)ex);
                    this.errorMessage = Messages.getString("ExportDDLAction.errorDroppingConflictingObjects") + ex.getMessage();
                }
            }
        }

        public void cleanup() {
            if (this.errorMessage != null) {
                ASUtils.showExceptionDialogNoReport(this.parentDialog, Messages.getString("ExportDDLAction.errorDroppingConflictingObjects") + this.errorMessage, this.error);
                this.setCancelled(true);
            }
        }

        protected Integer getJobSizeImpl() {
            return this.cr.getJobSize();
        }

        protected String getMessageImpl() {
            return this.cr.getMessage();
        }

        protected int getProgressImpl() {
            return this.cr.getProgress();
        }

        protected boolean hasStartedImpl() {
            return this.cr.hasStarted();
        }

        protected boolean isFinishedImpl() {
            return this.cr.isFinished();
        }
    }

    public class ConflictFinderProcess
    extends SPSwingWorker {
        JDialog parentDialog;
        SQLDatabase target;
        DDLGenerator ddlg;
        List<DDLStatement> statements;
        ConflictResolver cr;
        String errorMessage;
        Throwable error;
        private boolean shouldDropConflicts;

        public ConflictFinderProcess(JDialog parentDialog, SQLDatabase target, DDLGenerator ddlg, List<DDLStatement> statements, ArchitectSwingSession session) throws SQLObjectException {
            super((SwingWorkerRegistry)session);
            this.parentDialog = parentDialog;
            this.target = target;
            this.ddlg = ddlg;
            this.statements = statements;
            this.cr = new ConflictResolver(target, ddlg, statements);
        }

        public boolean doesUserWantToDropConflicts() {
            return this.shouldDropConflicts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doStuff() {
            if (this.isCancelled()) {
                return;
            }
            Connection con = null;
            try {
                con = this.target.getConnection();
            }
            catch (Exception ex) {
                this.error = ex;
                this.errorMessage = Messages.getString("ExportDDLAction.failedToConnectToDb");
                return;
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"Failed to close connection. This exception is getting squashed:", (Throwable)ex);
                    }
                }
            }
            try {
                this.cr.findConflicting();
            }
            catch (Exception ex) {
                this.error = ex;
                this.errorMessage = Messages.getString("ExportDDLAction.unexpectedException");
                logger.error((Object)"Unexpected exception setting up DDL generation", (Throwable)ex);
            }
        }

        public void cleanup() {
            if (!SwingUtilities.isEventDispatchThread()) {
                logger.error((Object)"runFinished is running on the wrong thread!");
            }
            if (this.errorMessage != null) {
                if (this.error != null) {
                    ASUtils.showExceptionDialogNoReport(this.parentDialog, this.errorMessage, this.error);
                } else {
                    JOptionPane.showMessageDialog(this.parentDialog, this.errorMessage, Messages.getString("ExportDDLAction.errorMessageDialogTitle"), 0);
                }
            } else if (!this.cr.isEmpty()) {
                Object[] messages = new Object[3];
                messages[0] = Messages.getString("ExportDDLAction.conflictingObjectsInDatabase");
                JTextArea conflictsPane = new JTextArea(this.cr.toConflictTree());
                conflictsPane.setRows(15);
                conflictsPane.setEditable(false);
                messages[1] = new JScrollPane(conflictsPane);
                messages[2] = Messages.getString("ExportDDLAction.dropConflictingObjectsConfirmation");
                int choice = JOptionPane.showConfirmDialog(this.parentDialog, messages, Messages.getString("ExportDDLAction.conflictingObjectsInDatabaseDialogTitle"), 1);
                if (choice == 0) {
                    this.shouldDropConflicts = true;
                } else if (choice == 1) {
                    this.shouldDropConflicts = false;
                } else if (choice == 2) {
                    this.shouldDropConflicts = false;
                    this.setCancelled(true);
                }
            }
        }

        public ConflictResolver getConflictResolver() {
            return this.cr;
        }

        protected Integer getJobSizeImpl() {
            return this.cr.getJobSize();
        }

        protected String getMessageImpl() {
            return this.cr.getMessage();
        }

        protected int getProgressImpl() {
            return this.cr.getProgress();
        }

        protected boolean hasStartedImpl() {
            return this.cr.hasStarted();
        }

        protected boolean isFinishedImpl() {
            return this.cr.isFinished();
        }
    }
}

