/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.dbtree.SQLObjectSelection;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class PasteSelectedAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(PasteSelectedAction.class);

    public PasteSelectedAction(ArchitectFrame frame) {
        super(frame, Messages.getString("PasteSelectedAction.name"), Messages.getString("PasteSelectedAction.description"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PlayPen playPen = this.getSession().getPlayPen();
        Component focusOwner = this.getSession().getArchitectFrame().getFocusOwner();
        DBTree tree = this.getSession().getDBTree();
        TreePath tp = tree.getSelectionModel().getSelectionPath();
        if (playPen.isAncestorOf(focusOwner) || playPen == focusOwner || tree.isTargetDatabaseNode(tp)) {
            Transferable clipboardContents = this.getSession().getContext().getClipboardContents();
            logger.debug((Object)("Pasting " + clipboardContents + " into the playpen."));
            if (clipboardContents != null) {
                for (PlayPenComponent comp : playPen.getSelectedItems()) {
                    if (!(comp instanceof TablePane) || !(clipboardContents instanceof SQLObjectSelection) || !(((SQLObjectSelection)clipboardContents).getSqlObjects()[0] instanceof SQLTable)) continue;
                    JOptionPane.showMessageDialog(this.getSession().getArchitectFrame(), "cannot paste Table inside another Table", "Cannot Paste", 1);
                    return;
                }
                playPen.pasteData(clipboardContents);
            } else {
                JOptionPane.showMessageDialog(this.getSession().getArchitectFrame(), "There is no contents in the clipboard to paste.", "Clipboard empty", 1);
            }
        }
    }
}

