/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.architect.swingui.action.UndoAction;
import ca.sqlpower.object.undo.NotifyingUndoManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class RedoAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(UndoAction.class);
    private NotifyingUndoManager manager;
    private ChangeListener managerListener = new ManagerListener();

    public RedoAction(ArchitectSwingSession session, NotifyingUndoManager manager) {
        super(session, Messages.getString("RedoAction.name"), Messages.getString("RedoAction.description"), "redo_arrow");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.manager = manager;
        this.manager.addChangeListener(this.managerListener);
        this.updateSettingsFromManager();
    }

    public RedoAction(ArchitectSwingSession session, ArchitectFrame frame, NotifyingUndoManager manager) {
        super(session, frame, Messages.getString("RedoAction.name"), Messages.getString("RedoAction.description"), "redo_arrow");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.manager = manager;
        this.manager.addChangeListener(this.managerListener);
        this.updateSettingsFromManager();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.manager);
            int choice = JOptionPane.showConfirmDialog(null, "Undo manager state dumped to logger.\n\nProceed with redo?");
            if (choice == 0) {
                this.manager.redo();
            }
        } else {
            this.manager.redo();
        }
    }

    private void updateSettingsFromManager() {
        this.putValue("ShortDescription", this.manager.getRedoPresentationName());
        this.setEnabled(this.manager.canRedo());
    }

    public void setUndoManager(NotifyingUndoManager manager) {
        this.manager.removeChangeListener(this.managerListener);
        this.manager = manager;
        manager.addChangeListener(this.managerListener);
        this.updateSettingsFromManager();
    }

    private class ManagerListener
    implements ChangeListener {
        private ManagerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            RedoAction.this.updateSettingsFromManager();
        }
    }
}

