/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.object.undo.NotifyingUndoManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class UndoAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(UndoAction.class);
    private NotifyingUndoManager manager;
    private ChangeListener managerListener = new ManagerListener();

    public UndoAction(ArchitectSwingSession session, NotifyingUndoManager manager) {
        super(session, Messages.getString("UndoAction.name"), Messages.getString("UndoAction.description"), "undo_arrow");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.manager = manager;
        this.manager.addChangeListener(this.managerListener);
        this.updateSettingsFromManager();
    }

    public UndoAction(ArchitectSwingSession session, ArchitectFrame frame, NotifyingUndoManager manager) {
        super(session, frame, Messages.getString("UndoAction.name"), Messages.getString("UndoAction.description"), "undo_arrow");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.manager = manager;
        this.manager.addChangeListener(this.managerListener);
        this.updateSettingsFromManager();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.manager);
            int choice = JOptionPane.showConfirmDialog(null, "Undo manager state dumped to logger.\n\nProceed with undo?");
            if (choice == 0) {
                this.manager.undo();
            }
        } else {
            this.manager.undo();
        }
    }

    public void updateSettingsFromManager() {
        this.putValue("ShortDescription", this.manager.getUndoPresentationName());
        this.setEnabled(this.manager.canUndo());
    }

    public void setUndoManager(NotifyingUndoManager manager) {
        this.manager.removeChangeListener(this.managerListener);
        this.manager = manager;
        manager.addChangeListener(this.managerListener);
        this.updateSettingsFromManager();
    }

    private class ManagerListener
    implements ChangeListener {
        private ManagerListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            UndoAction.this.updateSettingsFromManager();
        }
    }
}

