/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.olap.undo.OLAPUndoManager;
import ca.sqlpower.architect.swingui.ArchitectSwingProject;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenComponentLocationEdit;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.event.ItemSelectionEvent;
import ca.sqlpower.architect.swingui.event.ItemSelectionListener;
import ca.sqlpower.architect.swingui.event.PlayPenLifecycleEvent;
import ca.sqlpower.architect.swingui.event.PlayPenLifecycleListener;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.architect.swingui.olap.CubePane;
import ca.sqlpower.architect.swingui.olap.DimensionPane;
import ca.sqlpower.architect.swingui.olap.OLAPContextMenuFactory;
import ca.sqlpower.architect.swingui.olap.OLAPEditSession;
import ca.sqlpower.architect.swingui.olap.OLAPTree;
import ca.sqlpower.architect.swingui.olap.PaneSection;
import ca.sqlpower.architect.swingui.olap.UsageComponent;
import ca.sqlpower.architect.swingui.olap.VirtualCubePane;
import ca.sqlpower.object.AbstractSPListener;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.undo.CompoundEventListener;
import ca.sqlpower.object.undo.PropertyChangeEdit;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.WeakHashMap;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoableEdit;
import org.apache.log4j.Logger;

public class OLAPPlayPenFactory {
    private static final Logger logger = Logger.getLogger(OLAPPlayPenFactory.class);

    public static PlayPen createPlayPen(ArchitectSwingSession session, OLAPEditSession oSession, OLAPUndoManager undoManager) {
        PlayPen pp;
        OLAPSession olapSession;
        if (session == null) {
            throw new NullPointerException("Null session");
        }
        if (oSession == null) {
            throw new NullPointerException("Null oSession");
        }
        ArchitectSwingProject project = session.getWorkspace();
        PlayPenContentPane contentPane = project.getOlapContentPane(olapSession = oSession.getOlapSession());
        if (contentPane != null) {
            pp = new PlayPen(session, contentPane);
        } else {
            pp = new PlayPen(session, (SPObject)olapSession);
            project.addOLAPContentPane(pp.getContentPane());
        }
        OLAPModelListener ppcl = new OLAPModelListener(pp, oSession);
        pp.addPlayPenLifecycleListener(ppcl);
        pp.setPopupFactory(new OLAPContextMenuFactory(session, oSession));
        SQLPowerUtils.listenToHierarchy((SPObject)oSession.getOlapSession().getSchema(), (SPListener)ppcl);
        SelectionSynchronizer synchronizer = new SelectionSynchronizer(oSession.getOlapTree(), pp);
        pp.addSelectionListener(synchronizer);
        oSession.getOlapTree().addTreeSelectionListener(synchronizer);
        pp.getContentPane().addSPListener((SPListener)synchronizer);
        PlayPenUndoAdapter undoAdapter = new PlayPenUndoAdapter(undoManager);
        pp.getContentPane().addComponentPropertyListener((SPListener)undoAdapter);
        pp.addUndoEventListener((CompoundEventListener)undoAdapter);
        return pp;
    }

    static void setupOLAPKeyboardActions(PlayPen pp, OLAPEditSession oSession) {
        pp.setupKeyboardActions();
        InputMap im = pp.getInputMap(2);
        ActionMap am = pp.getActionMap();
        if (im == null) {
            throw new NullPointerException("Null input map");
        }
        if (am == null) {
            throw new NullPointerException("Null action map");
        }
        String KEY_DELETE_SELECTED = "ca.sqlpower.architect.swingui.PlayPen.KEY_DELETE_SELECTED";
        InputMap inputMap = pp.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(127, 0), KEY_DELETE_SELECTED);
        inputMap.put(KeyStroke.getKeyStroke(8, 0), KEY_DELETE_SELECTED);
        pp.getActionMap().put(KEY_DELETE_SELECTED, oSession.getOLAPDeleteSelectedAction());
        pp.getInputMap(2).put((KeyStroke)oSession.getZoomToFitAction().getValue("AcceleratorKey"), "ZOOM TO FIT");
        pp.getActionMap().put("ZOOM TO FIT", oSession.getZoomToFitAction());
        pp.getInputMap(2).put((KeyStroke)oSession.getZoomInAction().getValue("AcceleratorKey"), "ZOOM IN");
        pp.getActionMap().put("ZOOM IN", oSession.getZoomInAction());
        pp.getInputMap(2).put((KeyStroke)oSession.getZoomOutAction().getValue("AcceleratorKey"), "ZOOM OUT");
        pp.getActionMap().put("ZOOM OUT", oSession.getZoomOutAction());
        pp.getInputMap(2).put((KeyStroke)oSession.getZoomNormalAction().getValue("AcceleratorKey"), "ZOOM RESET");
        pp.getActionMap().put("ZOOM RESET", oSession.getZoomNormalAction());
        im.put((KeyStroke)oSession.getCreateCubeAction().getValue("AcceleratorKey"), "NEW CUBE");
        am.put("NEW CUBE", oSession.getCreateCubeAction());
        im.put((KeyStroke)oSession.getCreateVirtualCubeAction().getValue("AcceleratorKey"), "NEW VIRTUAL CUBE");
        am.put("NEW VIRTUAL CUBE", oSession.getCreateVirtualCubeAction());
        im.put((KeyStroke)oSession.getCreateMeasureAction().getValue("AcceleratorKey"), "NEW MEASURE");
        am.put("NEW MEASURE", oSession.getCreateMeasureAction());
        im.put((KeyStroke)oSession.getCreateDimensionAction().getValue("AcceleratorKey"), "NEW DIMENSION");
        am.put("NEW DIMENSION", oSession.getCreateDimensionAction());
        im.put((KeyStroke)oSession.getCreateDimensionUsageAction().getValue("AcceleratorKey"), "NEW DIMENSION USAGE");
        am.put("NEW DIMENSION USAGE", oSession.getCreateDimensionUsageAction());
        im.put((KeyStroke)oSession.getCreateCubeUsageAction().getValue("AcceleratorKey"), "NEW CUBE USAGE");
        am.put("NEW CUBE USAGE", oSession.getCreateCubeUsageAction());
        im.put((KeyStroke)oSession.getCreateHierarchyAction().getValue("AcceleratorKey"), "NEW HIERARCHY");
        am.put("NEW HIERARCHY", oSession.getCreateHierarchyAction());
        im.put((KeyStroke)oSession.getCreateLevelAction().getValue("AcceleratorKey"), "NEW LEVEL");
        am.put("NEW LEVEL", oSession.getCreateLevelAction());
    }

    static class SelectionSynchronizer
    extends AbstractSPListener
    implements SelectionListener,
    ItemSelectionListener<MondrianModel.Cube, OLAPObject>,
    TreeSelectionListener {
        private int eventDepth = 0;
        private final OLAPTree tree;
        private final PlayPen pp;

        public SelectionSynchronizer(OLAPTree tree, PlayPen pp) {
            this.tree = tree;
            this.pp = pp;
        }

        public void updateOLAPTree() {
            if (this.eventDepth != 1) {
                return;
            }
            this.tree.clearSelection();
            ArrayList<TreePath> selectionPaths = new ArrayList<TreePath>();
            boolean addedPaths = false;
            TreePath lastPath = null;
            for (PlayPenComponent comp : this.pp.getSelectedItems()) {
                TreePath tp = this.tree.getTreePathForNode((SPObject)((OLAPObject)((Object)comp.getModel())));
                if (!selectionPaths.contains(tp)) {
                    selectionPaths.add(tp);
                    addedPaths = true;
                    lastPath = tp;
                }
                if (comp instanceof VirtualCubePane) {
                    for (OLAPObject oLAPObject : ((VirtualCubePane)comp).getSelectedItems()) {
                        tp = this.tree.getTreePathForNode((SPObject)oLAPObject);
                        if (selectionPaths.contains(tp)) continue;
                        selectionPaths.add(tp);
                        addedPaths = true;
                        lastPath = tp;
                    }
                    continue;
                }
                if (comp instanceof CubePane) {
                    for (OLAPObject oLAPObject : ((CubePane)comp).getSelectedItems()) {
                        tp = this.tree.getTreePathForNode((SPObject)oLAPObject);
                        if (selectionPaths.contains(tp)) continue;
                        selectionPaths.add(tp);
                        addedPaths = true;
                        lastPath = tp;
                    }
                    continue;
                }
                if (comp instanceof DimensionPane) {
                    for (OLAPObject oLAPObject : ((DimensionPane)comp).getSelectedItems()) {
                        tp = this.tree.getTreePathForNode((SPObject)oLAPObject);
                        if (selectionPaths.contains(tp)) continue;
                        selectionPaths.add(tp);
                        addedPaths = true;
                        lastPath = tp;
                    }
                    for (PaneSection paneSection : ((DimensionPane)comp).getSelectedSections()) {
                        if (!(paneSection instanceof DimensionPane.HierarchySection)) {
                            throw new IllegalArgumentException("Unknown section type " + paneSection.getClass() + " in a DimensionPane!");
                        }
                        MondrianModel.Hierarchy hierarchy = ((DimensionPane.HierarchySection)paneSection).getHierarchy();
                        tp = this.tree.getTreePathForNode((SPObject)hierarchy);
                        if (selectionPaths.contains(tp)) continue;
                        selectionPaths.add(tp);
                        addedPaths = true;
                        lastPath = tp;
                    }
                    continue;
                }
                if (!(comp instanceof UsageComponent) || selectionPaths.contains(tp = this.tree.getTreePathForNode((SPObject)((UsageComponent)comp).getModel()))) continue;
                selectionPaths.add(tp);
                addedPaths = true;
                lastPath = tp;
            }
            if (lastPath != null) {
                this.tree.scrollPathToVisible(lastPath);
            }
            this.tree.setSelectionPaths(selectionPaths.toArray(new TreePath[selectionPaths.size()]));
            if (addedPaths) {
                this.tree.clearNonPlayPenSelections();
            }
        }

        private void selectInPlayPen(TreePath[] treePaths) {
            if (this.eventDepth != 1) {
                return;
            }
            if (treePaths == null) {
                this.pp.selectNone();
            } else {
                ArrayList<OLAPObject> objects = new ArrayList<OLAPObject>();
                for (TreePath tp : treePaths) {
                    OLAPObject obj = (OLAPObject)((Object)tp.getLastPathComponent());
                    objects.add(obj);
                }
                try {
                    this.pp.selectObjects(objects, this.tree);
                }
                catch (SQLObjectException e) {
                    throw new SQLObjectRuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemDeselected(SelectionEvent e) {
            try {
                ++this.eventDepth;
                this.updateOLAPTree();
            }
            finally {
                --this.eventDepth;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemSelected(SelectionEvent e) {
            try {
                ++this.eventDepth;
                this.updateOLAPTree();
            }
            finally {
                --this.eventDepth;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            try {
                ++this.eventDepth;
                this.selectInPlayPen(((JTree)e.getSource()).getSelectionPaths());
            }
            finally {
                --this.eventDepth;
            }
        }

        public void childAdded(SPChildEvent evt) {
            if (evt.getChild() instanceof CubePane) {
                ((CubePane)evt.getChild()).addItemSelectionListener(this);
            }
        }

        public void childRemoved(SPChildEvent evt) {
            if (evt.getChild() instanceof CubePane) {
                ((CubePane)evt.getChild()).removeItemSelectionListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemsDeselected(ItemSelectionEvent<MondrianModel.Cube, OLAPObject> e) {
            try {
                ++this.eventDepth;
                this.updateOLAPTree();
            }
            finally {
                --this.eventDepth;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemsSelected(ItemSelectionEvent<MondrianModel.Cube, OLAPObject> e) {
            try {
                ++this.eventDepth;
                this.updateOLAPTree();
            }
            finally {
                --this.eventDepth;
            }
        }
    }

    static class PlayPenUndoAdapter
    extends AbstractSPListener {
        private final OLAPUndoManager undoManager;

        PlayPenUndoAdapter(OLAPUndoManager undoManager) {
            this.undoManager = undoManager;
        }

        public void propertyChanged(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("topLeftCorner")) {
                PropertyChangeEdit edit = new PropertyChangeEdit(e);
                this.undoManager.addEdit((UndoableEdit)edit);
            }
        }

        public void transactionStarted(TransactionEvent e) {
            this.undoManager.addEdit(new PlayPenComponentLocationEdit());
        }

        public void transactionEnded(TransactionEvent e) {
        }
    }

    private static class OLAPModelListener
    implements SPListener,
    PlayPenLifecycleListener {
        private final PlayPen pp;
        private final OLAPEditSession session;
        private final WeakHashMap<OLAPObject, RemovedComponentInfo> removedPPCs = new WeakHashMap();

        public OLAPModelListener(PlayPen pp, OLAPEditSession oSession) {
            this.pp = pp;
            this.session = oSession;
        }

        public void childAdded(SPChildEvent e) {
            SQLPowerUtils.listenToHierarchy((SPObject)e.getChild(), (SPListener)this);
            RemovedComponentInfo compInfo = this.removedPPCs.get(e.getChild());
            logger.debug((Object)("OLAP Child was added. Previously removed component: " + compInfo));
            if (compInfo != null && this.pp.getContentPane().isMagicEnabled() && e.getSource().isMagicEnabled()) {
                PlayPenComponent ppc = compInfo.getComponent();
                int oldIndex = compInfo.getIndex();
                this.pp.getContentPane().addChild((SPObject)ppc, oldIndex);
            }
        }

        public void childRemoved(SPChildEvent e) {
            SQLPowerUtils.unlistenToHierarchy((SPObject)e.getChild(), (SPListener)this);
            if (this.pp.getContentPane().isMagicEnabled() && e.getSource().isMagicEnabled()) {
                for (int j = this.pp.getContentPane().getChildren().size() - 1; j >= 0; --j) {
                    PlayPenComponent ppc = this.pp.getContentPane().getChildren().get(j);
                    if (ppc.getModel() != e.getChild()) continue;
                    ppc.setSelected(false, 4);
                    try {
                        this.pp.getContentPane().removeChild((SPObject)ppc);
                    }
                    catch (ObjectDependentException ex) {
                        throw new RuntimeException(ex);
                    }
                    this.removedPPCs.put((OLAPObject)e.getChild(), new RemovedComponentInfo(ppc, j));
                    logger.debug((Object)("Put dead component in map: " + e.getChild().getName() + " -> " + ppc + " @ " + j));
                }
            }
        }

        @Override
        public void PlayPenLifeEnding(PlayPenLifecycleEvent e) {
            OLAPUtil.unlistenToHierarchy(this.session.getOlapSession().getSchema(), this, null);
        }

        public void propertyChanged(PropertyChangeEvent evt) {
        }

        public void transactionEnded(TransactionEvent e) {
        }

        public void transactionRollback(TransactionEvent e) {
        }

        public void transactionStarted(TransactionEvent e) {
        }

        private static class RemovedComponentInfo {
            WeakReference<PlayPenComponent> weakComponentRef;
            int index;

            RemovedComponentInfo(PlayPenComponent removed, int position) {
                this.weakComponentRef = new WeakReference<PlayPenComponent>(removed);
                this.index = position;
            }

            public PlayPenComponent getComponent() {
                return (PlayPenComponent)this.weakComponentRef.get();
            }

            public int getIndex() {
                return this.index;
            }
        }
    }
}

