/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.gwt.GwtModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.services.IModelerService;
import org.pentaho.agilebi.modeler.util.ModelerWorkspaceHelper;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.util.MondrianModelExporter;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclDto;
import org.pentaho.platform.dataaccess.datasource.api.DatasourceService;
import org.pentaho.platform.dataaccess.datasource.api.MetadataService;
import org.pentaho.platform.dataaccess.datasource.api.resources.MetadataTempFilesListBundleDto;
import org.pentaho.platform.dataaccess.datasource.api.resources.MetadataTempFilesListDto;
import org.pentaho.platform.dataaccess.datasource.beans.LogicalModelSummary;
import org.pentaho.platform.dataaccess.datasource.utils.DataAccessPermissionUtil;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.DatasourceServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.IDSWDatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.DSWDatasourceServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ModelerService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.UtilHtmlSanitizer;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.metadata.MetadataPublisher;
import org.pentaho.platform.plugin.action.mondrian.MondrianCachePublisher;
import org.pentaho.platform.plugin.action.mondrian.catalog.IAclAwareMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogServiceException;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importexport.legacy.MondrianCatalogRepositoryHelper;
import org.pentaho.platform.plugin.services.metadata.IAclAwarePentahoMetadataDomainRepositoryImporter;
import org.pentaho.platform.plugin.services.metadata.IPentahoMetadataDomainRepositoryExporter;

public class DataSourceWizardService
extends DatasourceService {
    protected IDSWDatasourceService dswService = this.getDswDatasourceService();
    protected IModelerService modelerService = new ModelerService();
    protected IDatasourceMgmtService datasourceMgmtSvc;
    protected IAclAwarePentahoMetadataDomainRepositoryImporter aclAwarePentahoMetadataDomainRepositoryImporter;
    protected IAclAwareMondrianCatalogService aclAwareMondrianCatalogService;
    protected UtilHtmlSanitizer sanitizer = UtilHtmlSanitizer.getInstance();
    private static final Log logger = LogFactory.getLog(DataSourceWizardService.class);
    private static final String MONDRIAN_CATALOG_REF = "MondrianCatalogRef";
    private static final String METADATA_PUBLISHER = MetadataPublisher.class.getName();
    private static final String MONDRIAN_PUBLISHER = MondrianCachePublisher.class.getName();
    private static final String ENCODING = "UTF-8";
    private static final String MONDRIAN_CONNECTION_PARAM = "parameters";
    private static final String MONDRIAN_SCHEMA_NAME = "schema.xml";
    private static final String MONDRIAN_MIME = "application/vnd.pentaho.mondrian+xml";
    private static final String METADATA_MIME = "text/xmi+xml";
    public static final String METADATA_EXT = ".xmi";
    private static final String IMPORT_DOMAIN_ID = "domain-id";

    public DataSourceWizardService() {
        this.datasourceMgmtSvc = (IDatasourceMgmtService)PentahoSystem.get(IDatasourceMgmtService.class, (IPentahoSession)PentahoSessionHolder.getSession());
        if (this.metadataDomainRepository instanceof IAclAwarePentahoMetadataDomainRepositoryImporter) {
            this.aclAwarePentahoMetadataDomainRepositoryImporter = (IAclAwarePentahoMetadataDomainRepositoryImporter)this.metadataDomainRepository;
        }
        if (this.mondrianCatalogService instanceof IAclAwareMondrianCatalogService) {
            this.aclAwareMondrianCatalogService = (IAclAwareMondrianCatalogService)this.mondrianCatalogService;
        }
    }

    protected IDSWDatasourceService getDswDatasourceService() {
        return new DSWDatasourceServiceImpl();
    }

    public Map<String, InputStream> doGetDSWFilesAsDownload(String dswId) throws PentahoAccessControlException {
        if (!this.canManageACL()) {
            throw new PentahoAccessControlException();
        }
        Map<String, InputStream> fileData = this.getMetadataFiles(dswId);
        Domain domain = this.metadataDomainRepository.getDomain(dswId);
        ModelerWorkspace model = this.createModelerWorkspace();
        model.setDomain(domain);
        LogicalModel logicalModel = model.getLogicalModel(ModelerPerspective.ANALYSIS);
        if (logicalModel == null) {
            logicalModel = model.getLogicalModel(ModelerPerspective.REPORTING);
        }
        if (logicalModel.getProperty(MONDRIAN_CATALOG_REF) != null) {
            MondrianCatalogRepositoryHelper helper = this.createMondrianCatalogRepositoryHelper();
            String catalogRef = (String)logicalModel.getProperty(MONDRIAN_CATALOG_REF);
            fileData.putAll(helper.getModrianSchemaFiles(catalogRef));
            this.parseMondrianSchemaNameWrapper(dswId, fileData);
        }
        return fileData;
    }

    public void removeDSW(String dswId) throws PentahoAccessControlException {
        try {
            this.ensureDataAccessPermissionCheck();
        }
        catch (ConnectionServiceException e) {
            throw new PentahoAccessControlException();
        }
        Domain domain = this.metadataDomainRepository.getDomain(dswId);
        ModelerWorkspace model = this.createModelerWorkspace();
        model.setDomain(domain);
        LogicalModel logicalModel = model.getLogicalModel(ModelerPerspective.ANALYSIS);
        if (logicalModel == null) {
            logicalModel = model.getLogicalModel(ModelerPerspective.REPORTING);
        }
        if (logicalModel.getProperty(MONDRIAN_CATALOG_REF) != null) {
            String catalogRef = (String)logicalModel.getProperty(MONDRIAN_CATALOG_REF);
            try {
                this.mondrianCatalogService.removeCatalog(catalogRef, this.getSession());
            }
            catch (MondrianCatalogServiceException e) {
                logger.warn((Object)"Failed to remove mondrian catalog", (Throwable)e);
            }
        }
        try {
            this.dswService.deleteLogicalModel(domain.getId(), logicalModel.getId());
        }
        catch (DatasourceServiceException ex) {
            logger.warn((Object)"Failed to remove logical model", (Throwable)ex);
        }
        this.metadataDomainRepository.removeDomain(dswId);
    }

    public List<String> getDSWDatasourceIds() {
        ArrayList<String> datasourceList = new ArrayList<String>();
        try {
            block2: for (LogicalModelSummary summary : this.dswService.getLogicalModels(null)) {
                Domain domain = this.modelerService.loadDomain(summary.getDomainId());
                List logicalModelList = domain.getLogicalModels();
                if (logicalModelList == null || logicalModelList.size() < 1) continue;
                for (LogicalModel logicalModel : logicalModelList) {
                    Object property = logicalModel.getProperty("AGILE_BI_GENERATED_SCHEMA");
                    if (property == null) continue;
                    datasourceList.add(summary.getDomainId());
                    continue block2;
                }
            }
        }
        catch (Throwable e) {
            return null;
        }
        return datasourceList;
    }

    public String publishDsw(String domainId, InputStream metadataFile, boolean overwrite, boolean checkConnection, RepositoryFileAclDto acl) throws PentahoAccessControlException, IllegalArgumentException, DswPublishValidationException, Exception {
        return this.publishDsw(domainId, metadataFile, null, null, overwrite, checkConnection, acl);
    }

    public String publishDsw(String domainId, InputStream metadataFile, List<InputStream> localizeFiles, List<String> localizeFileNames, boolean overwrite, boolean checkConnection, RepositoryFileAclDto acl) throws PentahoAccessControlException, IllegalArgumentException, DswPublishValidationException, Exception {
        String connectionId;
        List<String> overwritten;
        if (!this.hasManageAccessCheck()) {
            throw new PentahoAccessControlException();
        }
        if (!this.endsWith(domainId, METADATA_EXT)) {
            String errorMsg = "domainId must end in .xmi";
            throw new IllegalArgumentException("domainId must end in .xmi");
        }
        if (localizeFiles == null ? localizeFileNames != null : localizeFiles.size() != localizeFileNames.size()) {
            throw new IllegalArgumentException("localizeFiles and localizeFileNames must have equal size");
        }
        if (metadataFile == null) {
            throw new IllegalArgumentException("metadataFile is null");
        }
        if (!overwrite && !(overwritten = this.getOverwrittenDomains(domainId)).isEmpty()) {
            String domainIds = StringUtils.join(overwritten, (String)",");
            throw new DswPublishValidationException(DswPublishValidationException.Type.OVERWRITE_CONFLICT, domainIds);
        }
        XmiParser xmiParser = this.createXmiParser();
        Domain domain = null;
        try {
            domain = xmiParser.parseXmi(metadataFile);
        }
        catch (Exception e) {
            throw new DswPublishValidationException(DswPublishValidationException.Type.INVALID_XMI, e.getMessage());
        }
        domain.setId(domainId);
        if (checkConnection && this.datasourceMgmtSvc.getDatasourceByName(this.sanitizer.escape(connectionId = this.getMondrianDatasourceWrapper(domain))) == null && this.datasourceMgmtSvc.getDatasourceByName(connectionId) == null) {
            String msg = "connection not found: '" + connectionId + "'";
            throw new DswPublishValidationException(DswPublishValidationException.Type.MISSING_CONNECTION, msg);
        }
        IPlatformImportBundle mondrianBundle = this.createMondrianDswBundle(domain, acl);
        InputStream metadataIn = this.toInputStreamWrapper(domain, xmiParser);
        IPlatformImportBundle metadataBundle = this.createMetadataDswBundle(domain, metadataIn, overwrite, acl);
        if (localizeFiles != null) {
            for (int i = 0; i < localizeFiles.size(); ++i) {
                RepositoryFileImportBundle localizationBundle = MetadataService.createNewRepositoryFileImportBundle(localizeFiles.get(i), localizeFileNames.get(i), domainId);
                metadataBundle.getChildBundles().add(localizationBundle);
                logger.info((Object)"created language file");
            }
        }
        IPlatformImporter importer = this.getIPlatformImporter();
        importer.importFile(metadataBundle);
        logger.debug((Object)"imported metadata xmi");
        importer.importFile(mondrianBundle);
        logger.debug((Object)"imported mondrian schema");
        IPentahoSession session = this.getSession();
        PentahoSystem.publish((IPentahoSession)session, (String)METADATA_PUBLISHER);
        PentahoSystem.publish((IPentahoSession)session, (String)MONDRIAN_PUBLISHER);
        logger.info((Object)("publishDsw: Published DSW with domainId='" + domainId + "'."));
        return domainId;
    }

    public String publishDswFromTemp(String domainId, MetadataTempFilesListDto fileList, boolean overwrite, boolean checkConnection, RepositoryFileAclDto acl) throws PentahoAccessControlException, IllegalArgumentException, DswPublishValidationException, Exception {
        String metadataTempFileName = fileList.getXmiFileName();
        InputStream metaDataFileInputStream = this.createInputStreamFromFile(MetadataService.getUploadDir() + File.separatorChar + metadataTempFileName);
        List<MetadataTempFilesListBundleDto> locBundles = fileList.getBundles();
        ArrayList<String> localeFileNames = new ArrayList<String>();
        ArrayList<InputStream> localeFileStreams = new ArrayList<InputStream>();
        if (locBundles != null) {
            for (MetadataTempFilesListBundleDto bundle : locBundles) {
                localeFileNames.add(bundle.getOriginalFileName());
                localeFileStreams.add(new FileInputStream(MetadataService.getUploadDir() + File.separatorChar + bundle.getTempFileName()));
            }
        }
        return this.publishDsw(domainId + METADATA_EXT, metaDataFileInputStream, localeFileStreams, localeFileNames, overwrite, checkConnection, acl);
    }

    public RepositoryFileAclDto getDSWAcl(String dswId) throws PentahoAccessControlException, FileNotFoundException {
        this.checkDSWExists(dswId);
        if (this.aclAwarePentahoMetadataDomainRepositoryImporter != null) {
            RepositoryFileAcl acl = this.aclAwarePentahoMetadataDomainRepositoryImporter.getAclFor(dswId);
            return acl == null ? null : this.repositoryFileAclAdapter.marshal(acl);
        }
        return null;
    }

    public void setDSWAcl(String dswId, RepositoryFileAclDto aclDto) throws PentahoAccessControlException, FileNotFoundException {
        RepositoryFileAcl acl;
        this.checkDSWExists(dswId);
        if (!this.endsWith(dswId, METADATA_EXT)) {
            String errorMsg = "domainId must end in .xmi";
            throw new IllegalArgumentException("domainId must end in .xmi");
        }
        RepositoryFileAcl repositoryFileAcl = acl = aclDto == null ? null : this.repositoryFileAclAdapter.unmarshal(aclDto);
        if (this.aclAwareMondrianCatalogService != null) {
            this.aclAwareMondrianCatalogService.setAclFor(dswId.substring(0, dswId.lastIndexOf(METADATA_EXT)), acl);
        }
        if (this.aclAwarePentahoMetadataDomainRepositoryImporter != null) {
            this.aclAwarePentahoMetadataDomainRepositoryImporter.setAclFor(dswId, acl);
        }
        this.flushDataSources();
    }

    private void checkDSWExists(String dswId) throws PentahoAccessControlException, FileNotFoundException {
        try {
            this.doGetDSWFilesAsDownload(dswId);
        }
        catch (NullPointerException e) {
            throw new FileNotFoundException(dswId + " doesn't exist");
        }
    }

    protected List<String> getOverwrittenDomains(String dswId) {
        String catalogName;
        ArrayList<String> domainIds = new ArrayList<String>(2);
        if (this.metadataDomainRepository.getDomainIds().contains(dswId)) {
            domainIds.add("dsw/" + dswId);
        }
        if (this.mondrianCatalogService.getCatalog(catalogName = this.toAnalysisDomainId(dswId), PentahoSessionHolder.getSession()) != null) {
            domainIds.add("mondrian/" + catalogName);
        }
        return domainIds;
    }

    private String toAnalysisDomainId(String dswId) {
        return dswId.substring(0, dswId.lastIndexOf(46));
    }

    protected IPlatformImportBundle createMetadataDswBundle(Domain domain, InputStream metadataIn, boolean overwrite, RepositoryFileAclDto acl) {
        RepositoryFileImportBundle.Builder builder = new RepositoryFileImportBundle.Builder().input(metadataIn).charSet(ENCODING).hidden(Boolean.valueOf(false)).overwriteFile(overwrite).mime(METADATA_MIME).withParam(IMPORT_DOMAIN_ID, domain.getId()).preserveDsw(true);
        if (acl != null) {
            builder.acl(this.repositoryFileAclAdapter.unmarshal(acl)).applyAclSettings(true);
        }
        return builder.build();
    }

    protected IPlatformImportBundle createMondrianDswBundle(Domain domain, RepositoryFileAclDto acl) throws DatasourceServiceException, DswPublishValidationException, IOException {
        String analysisDomainId = this.toAnalysisDomainId(domain.getId());
        String dataSource = ModelerService.getMondrianDatasource(domain);
        String locale = Locale.getDefault().toString();
        ModelerWorkspace workspace = new ModelerWorkspace((IModelerWorkspaceHelper)new ModelerWorkspaceHelper(locale), this.dswService.getGeoContext());
        workspace.setModelName(analysisDomainId);
        workspace.setDomain(domain);
        LogicalModel olapModel = workspace.getLogicalModel(ModelerPerspective.ANALYSIS);
        if (olapModel == null) {
            throw new IllegalArgumentException("No analysis model in xmi.");
        }
        olapModel.setProperty(MONDRIAN_CATALOG_REF, (Object)analysisDomainId);
        MondrianModelExporter exporter = new MondrianModelExporter(olapModel, locale);
        exporter.updateModelToNewDomainName(analysisDomainId);
        String mondrianSchema = null;
        try {
            mondrianSchema = exporter.createMondrianModelXML();
        }
        catch (Exception e) {
            throw new DswPublishValidationException(DswPublishValidationException.Type.INVALID_XMI, e.getMessage());
        }
        RepositoryFileImportBundle.Builder builder = new RepositoryFileImportBundle.Builder().input(IOUtils.toInputStream((String)mondrianSchema, (String)ENCODING)).name(MONDRIAN_SCHEMA_NAME).charSet(ENCODING).overwriteFile(true).mime(MONDRIAN_MIME).withParam(IMPORT_DOMAIN_ID, analysisDomainId).withParam(MONDRIAN_CONNECTION_PARAM, "DataSource=" + dataSource);
        if (acl != null) {
            builder.acl(this.repositoryFileAclAdapter.unmarshal(acl)).applyAclSettings(true);
        }
        return builder.build();
    }

    protected boolean canAdministerCheck() {
        return DatasourceService.canAdminister();
    }

    protected void ensureDataAccessPermissionCheck() throws ConnectionServiceException {
        super.ensureDataAccessPermission();
    }

    protected boolean hasManageAccessCheck() {
        return DataAccessPermissionUtil.hasManageAccess();
    }

    protected boolean endsWith(String str, String suffix) {
        return StringUtils.endsWith((String)str, (String)suffix);
    }

    protected XmiParser createXmiParser() {
        return new XmiParser();
    }

    protected void parseMondrianSchemaNameWrapper(String dswId, Map<String, InputStream> fileData) {
        DatasourceService.parseMondrianSchemaName(dswId, fileData);
    }

    protected String getMondrianDatasourceWrapper(Domain domain) {
        return ModelerService.getMondrianDatasource(domain);
    }

    protected InputStream toInputStreamWrapper(Domain domain, XmiParser xmiParser) throws IOException {
        return IOUtils.toInputStream((String)xmiParser.generateXmi(domain), (String)ENCODING);
    }

    protected String parseMondrianSchemaNameWrapper(String dswId) {
        return super.fixEncodedSlashParam(dswId);
    }

    protected Map<String, InputStream> getMetadataFiles(String dswId) {
        return ((IPentahoMetadataDomainRepositoryExporter)this.metadataDomainRepository).getDomainFilesData(dswId);
    }

    protected ModelerWorkspace createModelerWorkspace() {
        return new ModelerWorkspace((IModelerWorkspaceHelper)new GwtModelerWorkspaceHelper());
    }

    protected MondrianCatalogRepositoryHelper createMondrianCatalogRepositoryHelper() {
        return new MondrianCatalogRepositoryHelper((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
    }

    protected IPentahoSession getSession() {
        return PentahoSessionHolder.getSession();
    }

    protected IPlatformImporter getIPlatformImporter() {
        return (IPlatformImporter)PentahoSystem.get(IPlatformImporter.class);
    }

    protected InputStream createInputStreamFromFile(String fileName) throws FileNotFoundException {
        return new FileInputStream(fileName);
    }

    public static class DswPublishValidationException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Type type;

        public DswPublishValidationException(Type type, String msg) {
            super(msg);
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public static enum Type {
            OVERWRITE_CONFLICT,
            MISSING_CONNECTION,
            INVALID_XMI;

        }
    }
}

