/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.api;

import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataBodyPart;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclDto;
import org.pentaho.platform.dataaccess.datasource.api.DatasourceService;
import org.pentaho.platform.dataaccess.datasource.api.resources.MetadataTempFilesListBundleDto;
import org.pentaho.platform.dataaccess.datasource.api.resources.MetadataTempFilesListDto;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.metadata.MetadataPublisher;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.metadata.IAclAwarePentahoMetadataDomainRepositoryImporter;
import org.pentaho.platform.plugin.services.metadata.IPentahoMetadataDomainRepositoryExporter;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.platform.web.http.api.resources.FileResource;
import org.pentaho.platform.web.servlet.UploadFileUtils;

public class MetadataService
extends DatasourceService {
    private static final String XMI_EXTENSION = ".xmi";
    protected IAclAwarePentahoMetadataDomainRepositoryImporter aclAwarePentahoMetadataDomainRepositoryImporter;
    private static final Log logger = LogFactory.getLog(MetadataService.class);
    private static String upload_dir;

    public static String getUploadDir() {
        if (upload_dir == null) {
            IApplicationContext context = PentahoSystem.getApplicationContext();
            if (context != null) {
                upload_dir = PentahoSystem.getApplicationContext().getSolutionPath("system/tmp");
            } else {
                return "";
            }
        }
        return upload_dir;
    }

    protected String internalGetUploadDir() {
        return MetadataService.getUploadDir();
    }

    public MetadataService() {
        if (this.metadataDomainRepository instanceof IAclAwarePentahoMetadataDomainRepositoryImporter) {
            this.aclAwarePentahoMetadataDomainRepositoryImporter = (IAclAwarePentahoMetadataDomainRepositoryImporter)this.metadataDomainRepository;
        }
    }

    public void removeMetadata(String metadataId) throws PentahoAccessControlException {
        try {
            this.ensureDataAccessPermissionCheck();
        }
        catch (ConnectionServiceException e) {
            throw new PentahoAccessControlException();
        }
        this.metadataDomainRepository.removeDomain(metadataId);
    }

    public List<String> getMetadataDatasourceIds() {
        ArrayList<String> metadataIds = new ArrayList<String>();
        try {
            this.sleep(100);
            for (String id : this.metadataDomainRepository.getDomainIds()) {
                if (!this.isMetadataDatasource(id)) continue;
                metadataIds.add(id);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return metadataIds;
    }

    public MetadataTempFilesListDto uploadMetadataFilesToTempDir(InputStream metadataFile, List<InputStream> localeFileStreams, List<String> localeFileNames) throws Exception {
        String fileName = this.uploadFile(metadataFile);
        MetadataTempFilesListDto dto = new MetadataTempFilesListDto();
        dto.setXmiFileName(fileName);
        logger.info((Object)("metadata file uploaded: " + fileName));
        if (localeFileStreams != null && localeFileStreams.size() != 0) {
            ArrayList<MetadataTempFilesListBundleDto> bundles = new ArrayList<MetadataTempFilesListBundleDto>();
            int cntr = 0;
            for (InputStream inputStream : localeFileStreams) {
                fileName = this.uploadFile(inputStream);
                MetadataTempFilesListBundleDto bundle = new MetadataTempFilesListBundleDto(localeFileNames.get(cntr), fileName);
                bundles.add(bundle);
                logger.info((Object)("locale file uploaded: " + fileName));
                ++cntr;
            }
            dto.setBundles(bundles);
        }
        return dto;
    }

    protected String uploadFile(InputStream is) throws Exception {
        StringWriter fileNameWriter = new StringWriter();
        UploadFileUtils utils = new UploadFileUtils(PentahoSessionHolder.getSession());
        utils.setShouldUnzip(false);
        utils.setTemporary(true);
        utils.setFileName(UUIDUtil.getUUID().toString());
        utils.setWriter((Writer)fileNameWriter);
        utils.process(is);
        return fileNameWriter.toString();
    }

    public MetadataTempFilesListDto uploadMetadataFilesToTempDir(InputStream metadataFile, List<FormDataBodyPart> localeFiles) throws Exception {
        ArrayList<ByteArrayInputStream> bundles = null;
        ArrayList<String> fileNames = null;
        if (localeFiles != null && localeFiles.size() != 0) {
            bundles = new ArrayList<ByteArrayInputStream>();
            fileNames = new ArrayList<String>();
            for (FormDataBodyPart localeFile : localeFiles) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])localeFile.getValueAs(byte[].class));
                bundles.add(inputStream);
                fileNames.add(localeFile.getFormDataContentDisposition().getFileName());
            }
        }
        return this.uploadMetadataFilesToTempDir(metadataFile, bundles, fileNames);
    }

    public void importMetadataDatasource(String domainId, InputStream metadataFile, FormDataContentDisposition metadataFileInfo, boolean overwrite, List<FormDataBodyPart> localeFiles, List<FormDataContentDisposition> localeFilesInfo, RepositoryFileAclDto acl) throws PentahoAccessControlException, PlatformImportException, Exception {
        if (StringUtils.isEmpty((String)domainId)) {
            throw new PlatformImportException(Messages.getString("MetadataDatasourceService.ERROR_005_DOMAIN_NAME_EMPTY"));
        }
        ArrayList<InputStream> localeFileStreams = null;
        ArrayList<String> localeFileNames = null;
        if (localeFiles != null) {
            localeFileStreams = new ArrayList<InputStream>();
            localeFileNames = new ArrayList<String>();
            for (int i = 0; i < localeFiles.size(); ++i) {
                logger.info((Object)"create language file");
                ByteArrayInputStream inputStream = this.createNewByteArrayInputStream((byte[])localeFiles.get(i).getValueAs(byte[].class));
                localeFileStreams.add(inputStream);
                localeFileNames.add(localeFilesInfo.get(i).getFileName());
            }
        }
        this.importMetadataDatasource(domainId, metadataFile, overwrite, localeFileStreams, localeFileNames, acl);
    }

    public void importMetadataDatasource(String domainId, InputStream metadataFile, boolean overwrite, List<InputStream> localeFileStreams, List<String> localeFileNames, RepositoryFileAclDto acl) throws PentahoAccessControlException, PlatformImportException, Exception {
        if (StringUtils.isEmpty((String)domainId)) {
            throw new PlatformImportException(Messages.getString("MetadataDatasourceService.ERROR_005_DOMAIN_NAME_EMPTY"));
        }
        this.accessValidation();
        FileResource fr = this.createNewFileResource();
        Object reservedCharsObject = fr.doGetReservedChars().getEntity();
        String reservedChars = this.objectToString(reservedCharsObject);
        if (reservedChars != null && domainId.matches(".*[" + reservedChars.replaceAll("/", "") + "]+.*")) {
            String msg = this.prohibitedSymbolMessage(domainId, fr);
            throw new PlatformImportException(msg, 10);
        }
        metadataFile = this.validateFileSize(metadataFile, domainId);
        domainId = MetadataService.forceXmiSuffix(domainId);
        RepositoryFileImportBundle.Builder bundleBuilder = this.createNewRepositoryFileImportBundleBuilder(metadataFile, overwrite, domainId, acl);
        if (localeFileStreams != null) {
            for (int i = 0; i < localeFileStreams.size(); ++i) {
                RepositoryFileImportBundle localizationBundle = MetadataService.createNewRepositoryFileImportBundle(localeFileStreams.get(i), localeFileNames.get(i), domainId);
                bundleBuilder.addChildBundle((IPlatformImportBundle)localizationBundle);
            }
        }
        RepositoryFileImportBundle bundle = bundleBuilder.build();
        IPlatformImporter importer = this.getImporter();
        importer.importFile((IPlatformImportBundle)bundle);
        IPentahoSession pentahoSession = this.getSession();
        this.publish(pentahoSession);
    }

    public boolean isContainsModel(String tempFileName) throws Exception {
        XmiParser xmiParser = new XmiParser();
        byte[] is = IOUtils.toByteArray((InputStream)this.createInputStreamFromFile(this.internalGetUploadDir() + File.separatorChar + tempFileName));
        Domain domain = xmiParser.parseXmi((InputStream)new ByteArrayInputStream(is));
        return this.isContainsModel(domain);
    }

    protected boolean isContainsModel(Domain domain) throws Exception {
        return !DatasourceService.isMetadataDatasource(domain) && domain.getLogicalModels().size() > 1;
    }

    public void importMetadataFromTemp(String domainId, MetadataTempFilesListDto fileList, boolean overwrite, RepositoryFileAclDto acl) throws PentahoAccessControlException, PlatformImportException, Exception {
        String metadataTempFileName = fileList.getXmiFileName();
        InputStream metaDataFileInputStream = this.createInputStreamFromFile(this.internalGetUploadDir() + File.separatorChar + metadataTempFileName);
        List<MetadataTempFilesListBundleDto> locBundles = fileList.getBundles();
        ArrayList<String> localeFileNames = new ArrayList<String>();
        ArrayList<InputStream> localeFileStreams = new ArrayList<InputStream>();
        if (locBundles != null) {
            for (MetadataTempFilesListBundleDto bundle : locBundles) {
                localeFileNames.add(bundle.getOriginalFileName());
                localeFileStreams.add(this.createInputStreamFromFile(this.internalGetUploadDir() + File.separatorChar + bundle.getTempFileName()));
            }
        }
        this.importMetadataDatasource(domainId, metaDataFileInputStream, overwrite, localeFileStreams, localeFileNames, acl);
    }

    @VisibleForTesting
    InputStream validateFileSize(InputStream metadataFile, String domainId) throws IOException, PlatformImportException {
        String maxFileLimit = PentahoSystem.getSystemSetting((String)"file-upload-defaults/max-file-limit", (String)String.valueOf(10000000));
        byte[] bytes = IOUtils.toByteArray((InputStream)metadataFile);
        if (Long.parseLong(maxFileLimit) < (long)bytes.length) {
            String msg = Messages.getString("MetadataDatasourceService.ERROR_004_MAX_FILE_SIZE_EXCEEDED_ERROR", domainId);
            throw new PlatformImportException(msg, 6);
        }
        return new ByteArrayInputStream(bytes);
    }

    public RepositoryFileAclDto getMetadataAcl(String domainId) throws PentahoAccessControlException, FileNotFoundException {
        this.checkMetadataExists(domainId);
        if (this.aclAwarePentahoMetadataDomainRepositoryImporter != null) {
            RepositoryFileAcl acl = this.aclAwarePentahoMetadataDomainRepositoryImporter.getAclFor(domainId);
            return acl == null ? null : this.repositoryFileAclAdapter.marshal(acl);
        }
        return null;
    }

    public void setMetadataAcl(String domainId, RepositoryFileAclDto aclDto) throws PentahoAccessControlException, FileNotFoundException {
        this.checkMetadataExists(domainId);
        if (this.aclAwarePentahoMetadataDomainRepositoryImporter != null) {
            RepositoryFileAcl acl = aclDto == null ? null : this.repositoryFileAclAdapter.unmarshal(aclDto);
            this.aclAwarePentahoMetadataDomainRepositoryImporter.setAclFor(domainId, acl);
            this.flushDataSources();
        }
    }

    private void checkMetadataExists(String domainId) throws PentahoAccessControlException, FileNotFoundException {
        Map domainFilesData;
        if (!this.canManageACL()) {
            throw new PentahoAccessControlException();
        }
        if (this.metadataDomainRepository instanceof IPentahoMetadataDomainRepositoryExporter && ((domainFilesData = ((IPentahoMetadataDomainRepositoryExporter)this.metadataDomainRepository).getDomainFilesData(domainId)) == null || domainFilesData.isEmpty())) {
            throw new FileNotFoundException();
        }
    }

    protected void sleep(int i) throws InterruptedException {
        Thread.sleep(i);
    }

    protected String prohibitedSymbolMessage(String domainId, FileResource fr) throws InterruptedException {
        String illegalCharacterList = (String)fr.doGetReservedCharactersDisplay().getEntity();
        illegalCharacterList = illegalCharacterList.replaceAll("\\,", "");
        return Messages.getString("MetadataDatasourceService.ERROR_003_PROHIBITED_SYMBOLS_ERROR", domainId, illegalCharacterList);
    }

    protected String objectToString(Object o) throws InterruptedException {
        return (String)o;
    }

    protected void publish(IPentahoSession pentahoSession) throws InterruptedException {
        PentahoSystem.publish((IPentahoSession)pentahoSession, (String)MetadataPublisher.class.getName());
    }

    protected IPentahoSession getSession() throws InterruptedException {
        return PentahoSessionHolder.getSession();
    }

    protected IPlatformImporter getImporter() throws InterruptedException {
        return (IPlatformImporter)PentahoSystem.get(IPlatformImporter.class);
    }

    protected void accessValidation() throws PentahoAccessControlException {
        DatasourceService.validateAccess();
    }

    protected boolean canAdministerCheck() {
        return DatasourceService.canAdminister();
    }

    protected void ensureDataAccessPermissionCheck() throws ConnectionServiceException {
        super.ensureDataAccessPermission();
    }

    protected FileResource createNewFileResource() {
        return new FileResource();
    }

    protected RepositoryFileImportBundle.Builder createNewRepositoryFileImportBundleBuilder(InputStream metadataFile, boolean overWriteInRepository, String domainId, RepositoryFileAclDto acl) {
        RepositoryFileImportBundle.Builder builder = new RepositoryFileImportBundle.Builder().input(metadataFile).charSet("UTF-8").hidden(Boolean.valueOf(false)).overwriteFile(overWriteInRepository).mime("text/xmi+xml").withParam("domain-id", domainId);
        if (acl != null) {
            builder.acl(this.repositoryFileAclAdapter.unmarshal(acl)).applyAclSettings(true);
        }
        return builder;
    }

    protected InputStream createInputStreamFromFile(String fileName) throws FileNotFoundException {
        return new FileInputStream(fileName);
    }

    public static RepositoryFileImportBundle createNewRepositoryFileImportBundle(InputStream bais, String fileName, String domainId) {
        return new RepositoryFileImportBundle.Builder().input(bais).charSet("UTF-8").hidden(Boolean.valueOf(false)).name(fileName).withParam("domain-id", domainId).build();
    }

    protected ByteArrayInputStream createNewByteArrayInputStream(byte[] buf) {
        if (buf != null) {
            return new ByteArrayInputStream(buf);
        }
        return null;
    }

    private static String forceXmiSuffix(String domainId) {
        if (domainId.endsWith(XMI_EXTENSION)) {
            return domainId;
        }
        return domainId + XMI_EXTENSION;
    }
}

