/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.api.resources;

import com.sun.jersey.multipart.FormDataParam;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclDto;
import org.pentaho.platform.dataaccess.datasource.api.DataSourceWizardService;
import org.pentaho.platform.dataaccess.datasource.api.resources.MetadataTempFilesListDto;
import org.pentaho.platform.dataaccess.datasource.api.resources.ResourceUtil;
import org.pentaho.platform.web.http.api.resources.JaxbList;

@Path(value="/data-access/api/datasource/dsw")
public class DataSourceWizardResource {
    private static final String DATASOURCE_ACL = "acl";
    protected DataSourceWizardService service = this.createDataSourceWizardService();
    protected ResourceUtil resourceUtil = new ResourceUtil();

    protected DataSourceWizardService createDataSourceWizardService() {
        return new DataSourceWizardService();
    }

    @GET
    @Path(value="/domain/{dswId : .+}")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="DSW datasource export succeeded."), @ResponseCode(code=401, condition="User is not authorized to export DSW datasource."), @ResponseCode(code=500, condition="Failure to export DSW datasource.")})
    public Response downloadDsw(@PathParam(value="dswId") String dswId) {
        try {
            Map<String, InputStream> fileData = this.service.doGetDSWFilesAsDownload(dswId);
            return this.createAttachment(fileData, dswId);
        }
        catch (PentahoAccessControlException e) {
            return this.buildUnauthorizedResponse();
        }
    }

    @DELETE
    @Path(value="/domain/{dswId : .+}")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="DSW datasource removed successfully."), @ResponseCode(code=401, condition="User is not authorized to remove DSW datasource.")})
    public Response remove(@PathParam(value="dswId") String dswId) {
        try {
            this.service.removeDSW(dswId);
            return this.buildOkResponse();
        }
        catch (PentahoAccessControlException e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    @GET
    @Path(value="/domain")
    @Produces(value={"application/xml", "application/json"})
    public JaxbList<String> getDSWDIds() {
        return this.createNewJaxbList(this.service.getDSWDatasourceIds());
    }

    protected Response buildOkResponse() {
        return Response.ok().build();
    }

    protected Response buildOkResponse(String dswId) {
        return Response.ok((Object)dswId).build();
    }

    protected Response buildServerErrorResponse() {
        return Response.serverError().build();
    }

    protected Response buildUnauthorizedResponse() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    protected Response buildBadRequestResponse(String message) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
    }

    protected Response buildConfilictResponse(String message) {
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)message).build();
    }

    protected Response createAttachment(Map<String, InputStream> fileData, String dswId) {
        return this.resourceUtil.createAttachment(fileData, dswId);
    }

    protected JaxbList<String> createNewJaxbList(List<String> DSWDatasources) {
        return new JaxbList(DSWDatasources);
    }

    @PUT
    @Path(value="/import")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @Facet(name="Unsupported")
    public Response publishDsw(@FormDataParam(value="domainId") String domainId, @FormDataParam(value="metadataFile") InputStream metadataFile, @FormDataParam(value="overwrite") @DefaultValue(value="false") boolean overwrite, @FormDataParam(value="checkConnection") @DefaultValue(value="false") boolean checkConnection, @FormDataParam(value="acl") RepositoryFileAclDto acl) {
        try {
            String dswId = this.service.publishDsw(domainId, metadataFile, overwrite, checkConnection, acl);
            return this.buildOkResponse(dswId);
        }
        catch (PentahoAccessControlException e) {
            return this.buildUnauthorizedResponse();
        }
        catch (IllegalArgumentException e) {
            return this.buildBadRequestResponse(e.getMessage());
        }
        catch (DataSourceWizardService.DswPublishValidationException e) {
            return this.buildConfilictResponse(e.getMessage());
        }
        catch (Exception e) {
            return this.buildServerErrorResponse();
        }
    }

    @POST
    @Path(value="/import/uploaded")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="File successfully imported."), @ResponseCode(code=401, condition="User is not authorized")})
    public Response publishDswFromTemp(@FormParam(value="domainId") String domainId, @FormParam(value="jsonFileList") String fileList, @FormParam(value="overwrite") @DefaultValue(value="false") boolean overwrite, @FormParam(value="checkConnection") @DefaultValue(value="false") boolean checkConnection, @FormParam(value="acl") RepositoryFileAclDto acl) {
        try {
            String dswId = this.service.publishDswFromTemp(domainId, new MetadataTempFilesListDto(fileList), overwrite, checkConnection, acl);
            return this.buildOkResponse(dswId);
        }
        catch (PentahoAccessControlException e) {
            return this.buildUnauthorizedResponse();
        }
        catch (IllegalArgumentException e) {
            return this.buildBadRequestResponse(e.getMessage());
        }
        catch (DataSourceWizardService.DswPublishValidationException e) {
            switch (e.getType()) {
                case OVERWRITE_CONFLICT: {
                    return this.buildConfilictResponse(e.getMessage());
                }
            }
            return this.buildBadRequestResponse(e.getMessage());
        }
        catch (Exception e) {
            return this.buildServerErrorResponse();
        }
    }

    @GET
    @Path(value="/ids")
    @Produces(value={"application/xml", "application/json"})
    @Facet(name="Unsupported")
    public JaxbList<String> getDSWDatasourceIds() {
        return this.getDSWDIds();
    }

    @GET
    @Path(value="/{dswId : .+}/download")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="DSW datasource export succeeded."), @ResponseCode(code=401, condition="User is not authorized to export DSW datasource."), @ResponseCode(code=500, condition="Failure to export DSW datasource.")})
    public Response doGetDSWFilesAsDownload(@PathParam(value="dswId") String dswId) {
        return this.downloadDsw(dswId);
    }

    @POST
    @Path(value="/{dswId : .+}/remove")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="DSW datasource removed successfully."), @ResponseCode(code=401, condition="User is not authorized to remove DSW datasource.")})
    @Facet(name="Unsupported")
    public Response doRemoveMetadata(@PathParam(value="dswId") String metadataId) {
        return this.remove(metadataId);
    }

    @GET
    @Path(value="/{dswId : .+}/acl")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully got the ACL"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=404, condition="ACL doesn't exist"), @ResponseCode(code=409, condition="DSW doesn't exist"), @ResponseCode(code=500, condition="ACL failed to be retrieved. This could be caused by an invalid path, or the file does not exist.")})
    public RepositoryFileAclDto doGetDSWAcl(@PathParam(value="dswId") String dswId) {
        try {
            RepositoryFileAclDto acl = this.service.getDSWAcl(dswId);
            if (acl == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            return acl;
        }
        catch (FileNotFoundException e) {
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        catch (PentahoAccessControlException e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    @PUT
    @Path(value="/{dswId : .+}/acl")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully updated the ACL"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=409, condition="DSW doesn't exist"), @ResponseCode(code=500, condition="Failed to save acls due to another error.")})
    public Response doSetDSWAcl(@PathParam(value="dswId") String dswId, RepositoryFileAclDto acl) throws PentahoAccessControlException {
        try {
            this.service.setDSWAcl(dswId, acl);
            return this.buildOkResponse();
        }
        catch (PentahoAccessControlException e) {
            return this.buildUnauthorizedResponse();
        }
        catch (FileNotFoundException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (Exception e) {
            return this.buildServerErrorResponse();
        }
    }
}

