/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.api.resources;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataParam;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclDto;
import org.pentaho.platform.dataaccess.datasource.api.DatasourceService;
import org.pentaho.platform.dataaccess.datasource.api.MetadataService;
import org.pentaho.platform.dataaccess.datasource.api.resources.MetadataTempFilesListDto;
import org.pentaho.platform.dataaccess.datasource.api.resources.ResourceUtil;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.metadata.IPentahoMetadataDomainRepositoryExporter;
import org.pentaho.platform.web.http.api.resources.FileResource;
import org.pentaho.platform.web.http.api.resources.JaxbList;

@Path(value="/data-access/api/datasource/metadata")
public class MetadataResource {
    private static final Log logger = LogFactory.getLog(MetadataResource.class);
    protected static final String OVERWRITE_IN_REPOS = "overwrite";
    private static final String SUCCESS = "3";
    private static final String DATASOURCE_ACL = "acl";
    protected MetadataService service = this.createMetadataService();
    protected IMetadataDomainRepository metadataDomainRepository;
    protected ResourceUtil resourceUtil = new ResourceUtil();

    public MetadataResource() {
        this.metadataDomainRepository = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, (IPentahoSession)PentahoSessionHolder.getSession());
    }

    protected MetadataService createMetadataService() {
        return new MetadataService();
    }

    @GET
    @Path(value="/domain/{domainId : .+}")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Metadata datasource export succeeded."), @ResponseCode(code=401, condition="User is not authorized to export Metadata datasource."), @ResponseCode(code=500, condition="Failure to export Metadata datasource.")})
    public Response downloadMetadata(@PathParam(value="domainId") String domainId) {
        if (!this.canAdminister()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (!this.isInstanceOfIPentahoMetadataDomainRepositoryExporter(this.metadataDomainRepository)) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        Map<String, InputStream> fileData = this.getDomainFilesData(domainId);
        return this.createAttachment(fileData, domainId);
    }

    @DELETE
    @Path(value="/domain/{domainId : .+}")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Metadata datasource removed."), @ResponseCode(code=401, condition="User is not authorized to delete the Metadata datasource.")})
    public Response deleteMetadata(@PathParam(value="domainId") String domainId) {
        try {
            this.service.removeMetadata(domainId);
            return this.buildOkResponse();
        }
        catch (PentahoAccessControlException e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    @GET
    @Path(value="/domain")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of existing metadata IDs")})
    public JaxbList<String> listDomains() {
        return this.createNewJaxbList(this.service.getMetadataDatasourceIds());
    }

    public Response importMetadataDatasourceLegacy(@PathParam(value="domainId") String domainId, @FormDataParam(value="metadataFile") InputStream metadataFile, @FormDataParam(value="metadataFile") FormDataContentDisposition metadataFileInfo, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="localeFiles") List<FormDataBodyPart> localeFiles, @FormDataParam(value="localeFiles") List<FormDataContentDisposition> localeFilesInfo, @FormDataParam(value="acl") RepositoryFileAclDto acl) {
        return this.importMetadataDatasource(domainId, metadataFile, metadataFileInfo, overwrite, localeFiles, localeFilesInfo, acl);
    }

    private Response catchPlatformImportException(String domainId, PlatformImportException e) {
        if (e.getErrorStatus() == 10) {
            FileResource fr = this.createFileResource();
            return this.buildServerError003Response(domainId, fr);
        }
        String msg = e.getMessage();
        logger.error((Object)("Error import metadata: " + msg + " status = " + e.getErrorStatus()));
        Throwable throwable = e.getCause();
        if (throwable != null) {
            msg = throwable.getMessage();
            logger.error((Object)("Root cause: " + msg));
        }
        return this.buildOkResponse(String.valueOf(e.getErrorStatus()));
    }

    @PUT
    @Path(value="/domain/{domainId : .+}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=409, condition="Content already exists (use overwrite flag to force)"), @ResponseCode(code=401, condition="Import failed because publish is prohibited"), @ResponseCode(code=500, condition="Unspecified general error has occurred"), @ResponseCode(code=412, condition="Metadata datasource import failed.  Error code or message included in response entity"), @ResponseCode(code=403, condition="Access Control Forbidden"), @ResponseCode(code=201, condition="Indicates successful import")})
    public Response importMetadata(@PathParam(value="domainId") String domainId, @FormDataParam(value="metadataFile") InputStream metadataFile, @FormDataParam(value="metadataFile") FormDataContentDisposition metadataFileInfo, @FormDataParam(value="overwrite") Boolean overwrite, @FormDataParam(value="localeFiles") List<FormDataBodyPart> localeFiles, @FormDataParam(value="localeFiles") List<FormDataContentDisposition> localeFilesInfo, @FormDataParam(value="acl") RepositoryFileAclDto acl) {
        try {
            this.service.importMetadataDatasource(domainId, metadataFile, metadataFileInfo, overwrite, localeFiles, localeFilesInfo, acl);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (PentahoAccessControlException e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        catch (PlatformImportException e) {
            if (e.getErrorStatus() == 10) {
                throw new ResourceUtil.PublishProhibitedException(e.getMessage());
            }
            throw this.catchNotImportException(e);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new ResourceUtil.UnspecifiedErrorException(e.getMessage());
        }
    }

    protected Response importMetadataDatasource(@FormDataParam(value="domainId") String domainId, @FormDataParam(value="metadataFile") InputStream metadataFile, @FormDataParam(value="metadataFile") FormDataContentDisposition metadataFileInfo, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="localeFiles") List<FormDataBodyPart> localeFiles, @FormDataParam(value="localeFiles") List<FormDataContentDisposition> localeFilesInfo, @FormDataParam(value="acl") RepositoryFileAclDto acl) {
        try {
            boolean overWriteInRepository = "True".equalsIgnoreCase(overwrite);
            this.service.importMetadataDatasource(domainId, metadataFile, metadataFileInfo, overWriteInRepository, localeFiles, localeFilesInfo, acl);
            return Response.ok().status(new Integer(SUCCESS).intValue()).type("text/plain").build();
        }
        catch (PentahoAccessControlException e) {
            return this.buildServerErrorResponse(e);
        }
        catch (PlatformImportException e) {
            return this.catchPlatformImportException(domainId, e);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return this.buildServerError001Response();
        }
    }

    protected Response buildOkResponse(String statusCode) {
        return Response.ok().status(new Integer(statusCode).intValue()).type("text/plain").build();
    }

    protected Response buildOkResponse() {
        return Response.ok().build();
    }

    protected Response buildUnauthorizedResponse() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    protected Response buildServerErrorResponse(PentahoAccessControlException e) {
        return Response.serverError().entity((Object)e.toString()).build();
    }

    protected Response buildServerErrorResponse() {
        return Response.serverError().build();
    }

    protected Response buildServerError001Response() {
        return Response.serverError().entity((Object)Messages.getString("MetadataDatasourceService.ERROR_001_METADATA_DATASOURCE_ERROR")).build();
    }

    protected Response buildServerError003Response(String domainId, FileResource fr) {
        return Response.status((int)10).entity((Object)Messages.getString("MetadataDatasourceService.ERROR_003_PROHIBITED_SYMBOLS_ERROR", domainId, (String)fr.doGetReservedCharactersDisplay().getEntity())).build();
    }

    protected boolean canAdminister() {
        return DatasourceService.canAdminister();
    }

    protected Response createAttachment(Map<String, InputStream> fileData, String dswId) {
        return this.resourceUtil.createAttachment(fileData, dswId);
    }

    protected JaxbList<String> createNewJaxbList(List<String> DSWDatasources) {
        return new JaxbList(DSWDatasources);
    }

    protected Map<String, InputStream> getDomainFilesData(String domainId) {
        return ((IPentahoMetadataDomainRepositoryExporter)this.metadataDomainRepository).getDomainFilesData(domainId);
    }

    protected boolean isInstanceOfIPentahoMetadataDomainRepositoryExporter(IMetadataDomainRepository obj) {
        return obj instanceof IPentahoMetadataDomainRepositoryExporter;
    }

    protected FileResource createFileResource() {
        return new FileResource();
    }

    @GET
    @Path(value="/ids")
    @Produces(value={"application/xml", "application/json"})
    @Facet(name="Unsupported")
    public JaxbList<String> getMetadataDatasourceIds() {
        return this.listDomains();
    }

    @GET
    @Path(value="/{domainId : .+}/download")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Metadata datasource export succeeded."), @ResponseCode(code=401, condition="User is not authorized to export Metadata datasource."), @ResponseCode(code=500, condition="Failure to export Metadata datasource.")})
    public Response doGetMetadataFilesAsDownload(@PathParam(value="domainId") String domainId) {
        return this.downloadMetadata(domainId);
    }

    @POST
    @Path(value="/{domainId : .+}/remove")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Metadata datasource removed."), @ResponseCode(code=401, condition="User is not authorized to delete the Metadata datasource.")})
    public Response doRemoveMetadata(@PathParam(value="domainId") String domainId) {
        return this.deleteMetadata(domainId);
    }

    @POST
    @Path(value="/uploadxmi")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @StatusCodes(value={@ResponseCode(code=403, condition="Access Control Forbidden"), @ResponseCode(code=200, condition="Indicates successful upload")})
    public String uploadMetadataFilesToTempDir(@FormDataParam(value="metadataFile") InputStream metadataFile, @FormDataParam(value="localeFiles") List<FormDataBodyPart> localeFiles) throws Exception {
        return this.service.uploadMetadataFilesToTempDir(metadataFile, localeFiles).toJSONString();
    }

    @GET
    @Path(value="/iscontainsmodel")
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="File successfully checked."), @ResponseCode(code=401, condition="User is not authorized")})
    public Response isContainsModel(@QueryParam(value="tempFileName") String tempFileName) {
        boolean res;
        try {
            res = this.service.isContainsModel(tempFileName);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return this.buildServerErrorResponse();
        }
        return Response.ok((Object)Boolean.toString(res)).build();
    }

    @POST
    @Path(value="/import/uploaded")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=409, condition="Content already exists (use overwrite flag to force)"), @ResponseCode(code=401, condition="Import failed because publish is prohibited"), @ResponseCode(code=500, condition="Unspecified general error has occurred"), @ResponseCode(code=412, condition="Metadata datasource import failed.  Error code or message included in response entity"), @ResponseCode(code=403, condition="Access Control Forbidden"), @ResponseCode(code=201, condition="Indicates successful import")})
    public Response importMetadataFromTemp(@FormParam(value="domainId") String domainId, @FormParam(value="jsonFileList") String fileList, @FormParam(value="overwrite") boolean overwrite, @FormParam(value="acl") RepositoryFileAclDto acl) {
        try {
            this.service.importMetadataFromTemp(domainId, new MetadataTempFilesListDto(fileList), overwrite, acl);
            return Response.ok((Object)"UPLOADED").build();
        }
        catch (PentahoAccessControlException e) {
            return this.buildServerErrorResponse(e);
        }
        catch (PlatformImportException e) {
            if (e.getErrorStatus() == 10) {
                FileResource fr = this.createFileResource();
                return this.buildServerError003Response(domainId, fr);
            }
            throw this.catchNotImportException(e);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return this.buildServerError001Response();
        }
    }

    private WebApplicationException catchNotImportException(PlatformImportException e) {
        int status;
        String msg = e.getMessage();
        logger.error((Object)("Error import metadata: " + msg + " status = " + e.getErrorStatus()));
        Throwable throwable = e.getCause();
        if (throwable != null) {
            msg = throwable.getMessage();
            logger.error((Object)("Root cause: " + msg));
        }
        if ((status = e.getErrorStatus()) == 8) {
            return new ResourceUtil.ContentAlreadyExistsException(msg);
        }
        return new ResourceUtil.ImportFailedException(msg);
    }

    @PUT
    @Path(value="/import")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Metadata datasource import succeeded. A response of:\n   *  2: Unspecified general error has occurred\n   *  3: Indicates successful import\n   *  9: Content already exists (use overwrite flag to force)\n   * 10: Import failed because publish is prohibited"), @ResponseCode(code=500, condition="Metadata datasource import failed.  Error code or message included in response entity")})
    public Response doImportMetadataDatasource(@FormDataParam(value="domainId") String domainId, @FormDataParam(value="metadataFile") InputStream metadataFile, @FormDataParam(value="metadataFile") FormDataContentDisposition metadataFileInfo, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="localeFiles") List<FormDataBodyPart> localeFiles, @FormDataParam(value="localeFiles") List<FormDataContentDisposition> localeFilesInfo, @FormDataParam(value="acl") RepositoryFileAclDto acl) {
        return this.importMetadataDatasource(domainId, metadataFile, metadataFileInfo, overwrite, localeFiles, localeFilesInfo, acl);
    }

    @GET
    @Path(value="/{domainId : .+}/acl")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully got the ACL"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=404, condition="ACL doesn't exist"), @ResponseCode(code=409, condition="Metadata DS doesn't exist"), @ResponseCode(code=500, condition="ACL failed to be retrieved. This could be caused by an invalid path, or the file does not exist.")})
    public RepositoryFileAclDto doGetMetadataAcl(@PathParam(value="domainId") String domainId) {
        try {
            RepositoryFileAclDto acl = this.service.getMetadataAcl(domainId);
            if (acl == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            return acl;
        }
        catch (PentahoAccessControlException e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        catch (FileNotFoundException e) {
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
    }

    @PUT
    @Path(value="/{domainId : .+}/acl")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully updated the ACL"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=409, condition="Metadata DS doesn't exist"), @ResponseCode(code=500, condition="Failed to save acls due to another error.")})
    public Response doSetMetadataAcl(@PathParam(value="domainId") String domainId, RepositoryFileAclDto acl) {
        try {
            this.service.setMetadataAcl(domainId, acl);
            return this.buildOkResponse();
        }
        catch (PentahoAccessControlException e) {
            return this.buildUnauthorizedResponse();
        }
        catch (FileNotFoundException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (Exception e) {
            return this.buildServerErrorResponse();
        }
    }
}

