/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.ui.importing;

import com.google.gwt.user.client.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.gwt.widgets.client.utils.string.StringUtils;
import org.pentaho.platform.dataaccess.datasource.ui.importing.IImportPerspective;
import org.pentaho.ui.xul.components.XulFileUpload;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class ImportDialogController
extends AbstractXulEventHandler {
    private XulFileUpload genericFileUpload;
    private XulDeck importDeck;
    private Map<Integer, IImportPerspective> importPerspectives = new HashMap<Integer, IImportPerspective>();
    private IImportPerspective activeImportPerspective;

    public void init() {
        this.importDeck = (XulDeck)this.document.getElementById("importDeck");
        try {
            this.genericFileUpload = (XulFileUpload)this.document.getElementById("genericFileUpload");
            this.genericFileUpload.addPropertyChangeListener((PropertyChangeListener)new FileUploadPropertyChangeListener());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addImportPerspective(int index, IImportPerspective importPerspective) {
        this.importPerspectives.put(index, importPerspective);
    }

    public String getName() {
        return "importDialogController";
    }

    public void show(int index) {
        this.reset();
        this.importDeck.setSelectedIndex(index);
        this.activeImportPerspective = this.importPerspectives.get(index);
        this.activeImportPerspective.showDialog();
    }

    private void reset() {
        if (this.genericFileUpload != null) {
            this.genericFileUpload.setSelectedFile("");
        }
    }

    @Bindable
    public void genericUploadSuccess(String uploadedFile) {
        try {
            this.activeImportPerspective.genericUploadCallback(uploadedFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Bindable
    public void concreteUploadSuccess(String uploadedFile) {
    }

    @Bindable
    public void uploadFailure(Throwable error) {
        error.printStackTrace();
        Window.alert((String)error.getMessage());
    }

    @Bindable
    public void closeDialog() {
        this.activeImportPerspective.onDialogCancel();
    }

    @Bindable
    public void acceptDialog() {
        if (this.activeImportPerspective.isValid()) {
            this.activeImportPerspective.onDialogAccept();
            this.closeDialog();
        }
    }

    class FileUploadPropertyChangeListener
    implements PropertyChangeListener {
        FileUploadPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            XulFileUpload uploadControl = (XulFileUpload)propertyChangeEvent.getSource();
            String value = uploadControl.getSeletedFile();
            if (!StringUtils.isEmpty((String)value)) {
                uploadControl.addParameter("file_name", uploadControl.getSeletedFile());
                uploadControl.addParameter("mark_temporary", "true");
                uploadControl.addParameter("unzip", "true");
                uploadControl.submit();
            }
        }
    }
}

