/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.ui.importing;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.gwt.widgets.client.utils.NameUtils;
import org.pentaho.gwt.widgets.client.utils.i18n.ResourceBundle;
import org.pentaho.platform.dataaccess.datasource.ui.importing.IImportPerspective;
import org.pentaho.platform.dataaccess.datasource.ui.importing.IOverwritableController;
import org.pentaho.platform.dataaccess.datasource.ui.importing.MetadataImportDialogModel;
import org.pentaho.platform.dataaccess.datasource.wizard.DatasourceMessages;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.gwt.tags.GwtConfirmBox;
import org.pentaho.ui.xul.gwt.tags.GwtMessageBox;
import org.pentaho.ui.xul.gwt.tags.GwtPromptBox;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractXulDialogController;
import org.pentaho.ui.xul.util.DialogController;
import org.pentaho.ui.xul.util.XulDialogCallback;

public class MetadataImportDialogController
extends AbstractXulDialogController<MetadataImportDialogModel>
implements IImportPerspective,
IOverwritableController {
    private static final String UPLOAD_URL = "plugin/data-access/api/datasource/metadata/uploadxmi";
    private static final String METADATA_IMPORT_XMI_URL = "plugin/data-access/api/datasource/metadata/import/uploaded";
    private static final String METADATA_IMPORT_DSW_URL = "plugin/data-access/api/datasource/dsw/import/uploaded";
    private static final String METADATA_CHECK_URL = "plugin/data-access/api/datasource/metadata/iscontainsmodel";
    private static Integer FILE_UPLOAD_SUFFIX = 0;
    private BindingFactory bf;
    private XulButton acceptButton;
    private XulTree localizedBundlesTree;
    private XulTextbox domainIdText;
    private XulLabel metaFileLocation;
    private XulDialog importDialog;
    private ResourceBundle resBundle;
    private MetadataImportDialogModel importDialogModel;
    private XulLabel fileLabel;
    private FlowPanel mainFormPanel;
    private FlowPanel propertiesFileImportPanel;
    private XulVbox hiddenArea;
    private DatasourceMessages messages = null;
    private boolean overwrite;
    private boolean allowToHide = true;
    private static FormPanel.SubmitCompleteHandler submitHandler = null;
    private ImportCompleteCallback importCompleteCallback;
    private FormPanel formPanel;
    private FileUpload metadataFileUpload;
    private TextBox formDomainIdText;
    protected static final int OVERWRITE_EXISTING_SCHEMA = 8;
    private List<DialogController.DialogListener> dialogCopyListeners = new ArrayList<DialogController.DialogListener>();

    public void init() {
        try {
            this.resBundle = (ResourceBundle)super.getXulDomContainer().getResourceBundles().get(0);
            this.importDialogModel = new MetadataImportDialogModel();
            this.localizedBundlesTree = (XulTree)this.document.getElementById("localizedBundlesTree");
            this.domainIdText = (XulTextbox)this.document.getElementById("domainIdText");
            this.domainIdText.addPropertyChangeListener((PropertyChangeListener)new DomainIdChangeListener());
            this.importDialog = (XulDialog)this.document.getElementById("importDialog");
            this.fileLabel = (XulLabel)this.document.getElementById("fileLabel");
            this.metaFileLocation = (XulLabel)this.document.getElementById("uploadFileLabel");
            this.acceptButton = (XulButton)this.document.getElementById("importDialog_accept");
            this.hiddenArea = (XulVbox)this.document.getElementById("metadataImportCard");
            this.acceptButton.setDisabled(true);
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            Binding localizedBundlesBinding = this.bf.createBinding((Object)this.importDialogModel, "localizedBundles", (Object)this.localizedBundlesTree, "elements", new BindingConvertor[0]);
            localizedBundlesBinding.fireSourceChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createWorkingForm() {
        if (this.formPanel == null) {
            this.formPanel = new FormPanel();
            this.formPanel.setMethod("post");
            this.formPanel.setEncoding("multipart/form-data");
            this.formPanel.setAction(UPLOAD_URL);
            this.formPanel.getElement().getStyle().setProperty("position", "absolute");
            this.formPanel.getElement().getStyle().setProperty("visibility", "hidden");
            this.formPanel.getElement().getStyle().setProperty("overflow", "hidden");
            this.formPanel.getElement().getStyle().setProperty("clip", "rect(0px,0px,0px,0px)");
            this.mainFormPanel = new FlowPanel();
            this.formPanel.add((Widget)this.mainFormPanel);
            this.propertiesFileImportPanel = new FlowPanel();
            this.mainFormPanel.add((Widget)this.propertiesFileImportPanel);
            this.formDomainIdText = new TextBox();
            this.formDomainIdText.setName("domainId");
            this.mainFormPanel.add((Widget)this.formDomainIdText);
            this.metadataFileUpload = new FileUpload();
            this.metadataFileUpload.setName("metadataFile");
            this.metadataFileUpload.getElement().setId("metaFileUpload");
            this.metadataFileUpload.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    String filename = ((FileUpload)event.getSource()).getFilename();
                    if (filename != null && filename.trim().length() > 0) {
                        MetadataImportDialogController.this.metaFileLocation.setValue(filename);
                        MetadataImportDialogController.this.importDialogModel.setUploadedFile(filename);
                        MetadataImportDialogController.this.acceptButton.setDisabled(!MetadataImportDialogController.this.isValid());
                    } else {
                        MetadataImportDialogController.this.metaFileLocation.setValue(MetadataImportDialogController.this.resBundle.getString("importDialog.SELECT_METAFILE_LABEL", "browse for metadata file"));
                        MetadataImportDialogController.this.importDialogModel.setUploadedFile(null);
                        MetadataImportDialogController.this.acceptButton.setDisabled(!MetadataImportDialogController.this.isValid());
                    }
                }
            });
            this.mainFormPanel.add((Widget)this.metadataFileUpload);
            this.formPanel.addSubmitCompleteHandler(this.createSubmitCompleteHandler());
            VerticalPanel vp = (VerticalPanel)this.hiddenArea.getManagedObject();
            vp.add((Widget)this.formPanel);
        }
    }

    private FormPanel.SubmitCompleteHandler createSubmitCompleteHandler() {
        return new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                String jsonResponseText = new HTML(event.getResults()).getText();
                JSONValue jsonVal = JSONParser.parseStrict((String)jsonResponseText);
                final JSONObject jsonResponse = jsonVal != null ? jsonVal.isObject() : null;
                if (jsonResponse == null) {
                    MetadataImportDialogController.this.onImportError("wrong data from xmi file checker");
                    return;
                }
                String tempFileName = jsonResponse.get("xmiFileName").isString().stringValue();
                RequestBuilder checkFileRequest = new RequestBuilder(RequestBuilder.GET, "plugin/data-access/api/datasource/metadata/iscontainsmodel?tempFileName=" + URL.encode((String)tempFileName));
                checkFileRequest.setCallback(new RequestCallback(){

                    public void onResponseReceived(Request request, Response response) {
                        if (response.getStatusCode() == 200) {
                            if (Boolean.TRUE.toString().equalsIgnoreCase(response.getText())) {
                                MetadataImportDialogController.this.promptImportMetadata(MetadataImportDialogController.this.resBundle.getString("importDialog.IMPORT_METADATA"), MetadataImportDialogController.this.resBundle.getString("importDialog.CONFIRMATION_LOAD_DSW"), MetadataImportDialogController.this.resBundle.getString("importDialog.DIALOG_DSW_RADIO", "Data Source Wizard (Includes Analysis model)"), MetadataImportDialogController.this.resBundle.getString("importDialog.DIALOG_METADATA_RADIO", "Metadata model"), (AsyncCallback<Boolean>)((AsyncCallback)new AsyncCallback<Boolean>(){

                                    public void onSuccess(Boolean result) {
                                        new XmiImporterRequest(result != false ? MetadataImportDialogController.METADATA_IMPORT_DSW_URL : MetadataImportDialogController.METADATA_IMPORT_XMI_URL, jsonResponse).doImport(false);
                                    }

                                    public void onFailure(Throwable caught) {
                                        MetadataImportDialogController.this.onImportError(caught.getMessage());
                                    }
                                }));
                            } else if (Boolean.FALSE.toString().equals(response.getText())) {
                                new XmiImporterRequest(MetadataImportDialogController.METADATA_IMPORT_XMI_URL, jsonResponse).doImport(false);
                            } else {
                                MetadataImportDialogController.this.onImportError("wrong data from xmi file checker");
                            }
                        } else {
                            MetadataImportDialogController.this.onImportError("[server data error] , wrong code: " + response.getStatusCode());
                        }
                    }

                    public void onError(Request request, Throwable exception) {
                        MetadataImportDialogController.this.onImportError("[request error] " + exception.getMessage());
                    }
                });
                try {
                    checkFileRequest.send();
                }
                catch (RequestException e) {
                    MetadataImportDialogController.this.onImportError(e.getMessage());
                }
            }
        };
    }

    public void setImportCompleteCallback(ImportCompleteCallback callback) {
        this.importCompleteCallback = callback;
    }

    public XulDialog getDialog() {
        return this.importDialog;
    }

    public MetadataImportDialogModel getDialogResult() {
        return this.importDialogModel;
    }

    @Override
    public boolean isValid() {
        return this.importDialogModel.isValid();
    }

    @Bindable
    public void setMetadataFile() {
        this.jsClickUpload(this.metadataFileUpload.getElement().getId());
    }

    @Bindable
    public void removeLocalizedBundle() {
        int[] selectedRows = this.localizedBundlesTree.getSelectedRows();
        if (selectedRows.length == 1) {
            this.propertiesFileImportPanel.remove(selectedRows[0]);
            this.importDialogModel.removeLocalizedBundle(selectedRows[0]);
        }
    }

    @Bindable
    public void addLocalizedBundle() {
        final FileUpload localizedBundleUpload = new FileUpload();
        localizedBundleUpload.setName("localeFiles");
        Integer n = FILE_UPLOAD_SUFFIX;
        Integer n2 = FILE_UPLOAD_SUFFIX = Integer.valueOf(FILE_UPLOAD_SUFFIX + 1);
        localizedBundleUpload.getElement().setId("propertyFileUpload" + n);
        localizedBundleUpload.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String fileName = ((FileUpload)event.getSource()).getFilename();
                if (fileName == null || fileName.length() < 1) {
                    MetadataImportDialogController.this.propertiesFileImportPanel.remove((Widget)localizedBundleUpload);
                } else {
                    MetadataImportDialogController.this.importDialogModel.addLocalizedBundle(fileName, fileName);
                }
            }
        });
        this.propertiesFileImportPanel.add((Widget)localizedBundleUpload);
        this.jsClickUpload(localizedBundleUpload.getElement().getId());
    }

    native void jsClickUpload(String var1);

    private void reset() {
        this.metaFileLocation.setValue(this.resBundle.getString("importDialog.SELECT_METAFILE_LABEL", "browse for metadata file"));
        this.importDialogModel.removeAllLocalizedBundles();
        this.importDialogModel.setUploadedFile(null);
        if (this.formPanel != null && RootPanel.get().getWidgetIndex((Widget)this.formPanel) != -1) {
            RootPanel.get().remove((Widget)this.formPanel);
        }
        this.acceptButton.setDisabled(true);
        this.domainIdText.setValue("");
        this.overwrite = false;
        this.formPanel = null;
        this.importCompleteCallback = null;
        this.removeHiddenPanels();
    }

    @Override
    public void concreteUploadCallback(String fileName, String uploadedFile) {
        this.importDialogModel.addLocalizedBundle(fileName, uploadedFile);
    }

    @Override
    public void genericUploadCallback(String uploadedFile) {
        this.importDialogModel.setUploadedFile(uploadedFile);
        this.acceptButton.setDisabled(!this.isValid());
    }

    private void onImportCancel() {
        if (this.importCompleteCallback != null) {
            this.importCompleteCallback.onImportCancel();
        }
    }

    private void onImportSuccess() {
        this.showMessagebox(this.resBundle.getString("importDialog.IMPORT_METADATA"), this.resBundle.getString("importDialog.SUCCESS_METADATA_IMPORT"));
        super.hideDialog();
    }

    private void onImportError(String message) {
        this.showMessagebox(this.resBundle.getString("importDialog.IMPORT_METADATA"), this.resBundle.getString("importDialog.ERROR_IMPORTING_METADATA") + ": " + message);
        super.hideDialog();
    }

    @Override
    public void showDialog() {
        this.reset();
        this.importDialog.setTitle(this.resBundle.getString("importDialog.IMPORT_METADATA", "Import Metadata"));
        this.fileLabel.setValue(this.resBundle.getString("importDialog.XMI_FILE", "XMI File") + ":");
        super.showDialog();
        this.createWorkingForm();
        this.getDialog().center();
    }

    public void reShowDialog() {
        this.importDialog.setDisabled(false);
        this.allowToHide = true;
        for (DialogController.DialogListener l : this.dialogCopyListeners) {
            super.addDialogListener(l);
        }
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    public String getName() {
        return "metadataImportDialogController";
    }

    public FormPanel getFormPanel() {
        return this.formPanel;
    }

    @Override
    public void buildAndSetParameters() {
        Hidden overwriteParam = new Hidden("overwrite", String.valueOf(this.overwrite));
        this.mainFormPanel.add((Widget)overwriteParam);
    }

    @Override
    public void removeHiddenPanels() {
        for (int i = 0; this.mainFormPanel != null && i < this.mainFormPanel.getWidgetCount(); ++i) {
            if (!this.mainFormPanel.getWidget(i).getClass().equals(Hidden.class)) continue;
            this.mainFormPanel.remove(this.mainFormPanel.getWidget(i));
        }
    }

    public String convertToNLSMessage(String results, String fileName) {
        String messageId;
        String msg = results;
        int code = new Integer(results);
        String[] parameters = new String[]{};
        switch (code) {
            case 1: {
                messageId = "Metadata.PUBLISH_TO_SERVER_FAILED";
                break;
            }
            case 2: {
                messageId = "Metadata.PUBLISH_GENERAL_ERROR";
                break;
            }
            case 3: {
                messageId = "Metadata.PUBLISH_DATASOURCE_ERROR";
                break;
            }
            case 4: {
                messageId = "Metadata.PUBLISH_USERNAME_PASSWORD_FAIL";
                break;
            }
            case 7: {
                messageId = "Metadata.PUBLISH_XMLA_CATALOG_EXISTS";
                break;
            }
            case 8: {
                messageId = "Metadata.OVERWRITE_EXISTING_SCHEMA";
                break;
            }
            case 10: {
                messageId = "Metadata.PUBLISH_PROHIBITED_SYMBOLS_ERROR";
                parameters = new String[]{NameUtils.reservedCharListForDisplay((String)", ")};
                break;
            }
            default: {
                messageId = "Metadata.ERROR";
            }
        }
        msg = this.messages.getString(messageId, parameters);
        return msg + " Metadata File: " + fileName;
    }

    private void showMessagebox(String title, String message) {
        GwtMessageBox messagebox = new GwtMessageBox(){

            public void hide() {
                super.hide();
                if (MetadataImportDialogController.this.importCompleteCallback != null) {
                    MetadataImportDialogController.this.importCompleteCallback.onImportSuccess();
                }
            }
        };
        messagebox.setTitle(title);
        messagebox.setMessage(message);
        messagebox.open();
    }

    private void confirm(String title, String message, String okButtonLabel, String cancelButtonLabel, final AsyncCallback<Boolean> onResulthandler) {
        GwtConfirmBox confirm = new GwtConfirmBox(){

            public Panel getDialogContents() {
                VerticalPanel vp = new VerticalPanel();
                Label lbl = new Label(this.getMessage());
                vp.add((Widget)lbl);
                vp.setCellHorizontalAlignment((Widget)lbl, VerticalPanel.ALIGN_LEFT);
                vp.setCellVerticalAlignment((Widget)lbl, VerticalPanel.ALIGN_MIDDLE);
                return vp;
            }
        };
        confirm.setTitle(title);
        confirm.setMessage(message);
        confirm.setAcceptLabel(okButtonLabel);
        confirm.setCancelLabel(cancelButtonLabel);
        confirm.addDialogCallback((XulDialogCallback)new XulDialogCallback<String>(){

            public void onClose(XulComponent component, XulDialogCallback.Status status, String value) {
                if (onResulthandler != null) {
                    onResulthandler.onSuccess((Object)(status == XulDialogCallback.Status.ACCEPT ? 1 : 0));
                }
            }

            public void onError(XulComponent component, Throwable err) {
                onResulthandler.onFailure(err);
            }
        });
        confirm.open();
    }

    private void promptImportMetadata(String title, String message, String radioDSWLabel, String radioMetaLabel, final AsyncCallback<Boolean> onResulthandler) {
        final VerticalPanel panel = new VerticalPanel();
        panel.add((Widget)new Label(message));
        VerticalPanel vp = new VerticalPanel();
        HorizontalPanel hp = new HorizontalPanel();
        hp.getElement().getStyle().setMarginBottom(10.0, Style.Unit.PX);
        hp.getElement().getStyle().setMarginTop(10.0, Style.Unit.PX);
        final RadioButton dswRadio = new RadioButton("importMetadata");
        RadioButton metadataRadio = new RadioButton("importMetadata");
        dswRadio.setEnabled(true);
        dswRadio.setValue(Boolean.valueOf(true));
        hp.add((Widget)dswRadio);
        hp.add((Widget)new Label(radioDSWLabel));
        vp.add((Widget)hp);
        HorizontalPanel hp2 = new HorizontalPanel();
        hp2.add((Widget)metadataRadio);
        hp2.add((Widget)new Label(radioMetaLabel));
        vp.add((Widget)hp2);
        panel.add((Widget)vp);
        GwtPromptBox promptBox = new GwtPromptBox(){

            public Panel getDialogContents() {
                return panel;
            }

            public int open() {
                super.show();
                dswRadio.setFocus(true);
                return 0;
            }

            public Panel getButtonPanel() {
                Panel button = super.getButtonPanel();
                return button;
            }
        };
        promptBox.setTitle(title);
        promptBox.setAcceptLabel(this.resBundle.getString("importDialog.DIALOG_OK", "OK"));
        promptBox.setCancelLabel(this.resBundle.getString("importDialog.DIALOG_Cancel", "Cancel"));
        promptBox.addDialogCallback((XulDialogCallback)new XulDialogCallback<String>(){

            public void onClose(XulComponent component, XulDialogCallback.Status status, String value) {
                if (status == XulDialogCallback.Status.CANCEL) {
                    MetadataImportDialogController.this.onImportCancel();
                    MetadataImportDialogController.this.reShowDialog();
                    return;
                }
                if (onResulthandler != null) {
                    onResulthandler.onSuccess((Object)dswRadio.getValue());
                }
            }

            public void onError(XulComponent xulComponent, Throwable throwable) {
                onResulthandler.onFailure(throwable);
            }
        });
        promptBox.setWidth(460);
        promptBox.setHeight(140);
        promptBox.open();
    }

    public void setDatasourceMessages(DatasourceMessages datasourceMessages) {
        this.messages = datasourceMessages;
    }

    public String getFileName() {
        return this.importDialogModel.getUploadedFile();
    }

    @Override
    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void addDialogListener(DialogController.DialogListener<MetadataImportDialogModel> listener) {
        super.addDialogListener(listener);
        this.dialogCopyListeners.add(listener);
    }

    @Override
    public void onDialogAccept() {
        this.importDialog.setDisabled(true);
        this.allowToHide = false;
        super.onDialogAccept();
    }

    public void hideDialog() {
        if (this.allowToHide) {
            super.hideDialog();
        }
    }

    class DomainIdChangeListener
    implements PropertyChangeListener {
        DomainIdChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            MetadataImportDialogController.this.formDomainIdText.setText(evt.getNewValue().toString());
            MetadataImportDialogController.this.importDialogModel.setDomainId(evt.getNewValue().toString());
            MetadataImportDialogController.this.acceptButton.setDisabled(!MetadataImportDialogController.this.isValid());
        }
    }

    private class XmiImporterRequest
    implements RequestCallback {
        private JSONObject jsonFileList = null;
        private String url = null;

        public XmiImporterRequest(String url, JSONObject jsonFileList) {
            this.jsonFileList = jsonFileList;
            this.url = url;
        }

        public void doImport(boolean overwrite) {
            RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, this.url);
            requestBuilder.setRequestData("domainId=" + URL.encode((String)MetadataImportDialogController.this.importDialogModel.getDomainId()) + "&jsonFileList=" + URL.encode((String)this.jsonFileList.toString()) + "&overwrite=" + Boolean.toString(overwrite));
            requestBuilder.setHeader("Content-Type", "application/x-www-form-urlencoded");
            requestBuilder.setCallback((RequestCallback)this);
            try {
                requestBuilder.send();
            }
            catch (RequestException e) {
                MetadataImportDialogController.this.onImportError(e.getMessage());
            }
        }

        public void onResponseReceived(Request request, Response response) {
            if (response.getStatusCode() == 200) {
                MetadataImportDialogController.this.onImportSuccess();
            } else if (response.getStatusCode() == 409) {
                MetadataImportDialogController.this.confirm(MetadataImportDialogController.this.resBundle.getString("Metadata.OVERWRITE_TITLE"), MetadataImportDialogController.this.messages.getString("Metadata.OVERWRITE_EXISTING_SCHEMA"), MetadataImportDialogController.this.resBundle.getString("importDialog.DIALOG_OK", "Ok"), MetadataImportDialogController.this.resBundle.getString("importDialog.DIALOG_CANCEL", "Cancel"), (AsyncCallback<Boolean>)((AsyncCallback)new AsyncCallback<Boolean>(){

                    public void onSuccess(Boolean result) {
                        if (result.booleanValue()) {
                            XmiImporterRequest.this.doImport(true);
                        } else {
                            MetadataImportDialogController.this.allowToHide = true;
                            MetadataImportDialogController.this.hideDialog();
                        }
                    }

                    public void onFailure(Throwable caught) {
                        MetadataImportDialogController.this.onImportError(caught.getMessage());
                    }
                }));
            } else {
                MetadataImportDialogController.this.onImportError("[server data error] , wrong code: " + response.getStatusCode());
            }
        }

        public void onError(Request request, Throwable exception) {
            MetadataImportDialogController.this.onImportError("[request error] " + exception.getMessage());
        }
    }

    public static interface ImportCompleteCallback {
        public void onImportSuccess();

        public void onImportCancel();
    }
}

