/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.ui.selectdialog;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.RootPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.platform.dataaccess.datasource.IDatasourceInfo;
import org.pentaho.platform.dataaccess.datasource.beans.LogicalModelSummary;
import org.pentaho.platform.dataaccess.datasource.modeler.ModelerDialog;
import org.pentaho.platform.dataaccess.datasource.ui.selectdialog.DatasourceSelectionDialogModel;
import org.pentaho.platform.dataaccess.datasource.ui.service.UIDatasourceServiceManager;
import org.pentaho.platform.dataaccess.datasource.wizard.EmbeddedWizard;
import org.pentaho.platform.dataaccess.datasource.wizard.GwtDatasourceMessages;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDSWDatasourceService;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.gwt.util.AsyncConstructorListener;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractXulDialogController;
import org.pentaho.ui.xul.util.DialogController;

public class DatasourceSelectionDialogController
extends AbstractXulDialogController<LogicalModelSummary> {
    private static final String REMOVE_DS_MSG_ID = "removeDatasourceConfirmationDialog.message";
    private BindingFactory bf;
    private IXulAsyncDSWDatasourceService datasourceService;
    private DatasourceSelectionDialogModel datasourceSelectionDialogModel = new DatasourceSelectionDialogModel();
    private XulDialog datasourceSelectionDialog;
    private XulDialog removeDatasourceConfirmationDialog;
    private boolean administrator;
    private EmbeddedWizard datasourceEditor;
    private XulButton addDatasourceButton;
    private XulButton editDatasourceButton;
    private XulButton removeDatasourceButton;
    private XulListbox datasourceListbox;
    private Binding editDatasourceButtonBinding;
    private Binding removeDatasourceButtonBinding;
    private String context;
    UIDatasourceServiceManager manager;
    private List<IDatasourceInfo> datasourceInfos = new ArrayList<IDatasourceInfo>();
    private GwtDatasourceMessages messageBundle;

    public DatasourceSelectionDialogController(String context) {
        this.context = context;
    }

    @Bindable
    public void init() {
        this.internalInit();
        String url = GWT.getHostPageBaseURL() + "plugin/data-access/api/permissions/hasDataAccess";
        RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, url);
        builder.setHeader("accept", "application/json");
        builder.setHeader("If-Modified-Since", "01 Jan 1970 00:00:00 GMT");
        try {
            builder.sendRequest(null, new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    DatasourceSelectionDialogController.this.showMessagebox("Error", exception.getLocalizedMessage());
                }

                public void onResponseReceived(Request request, Response response) {
                    boolean hasDataAccess = new Boolean(response.getText());
                    DatasourceSelectionDialogController.this.administrator = hasDataAccess;
                    DatasourceSelectionDialogController.this.addDatasourceButton.setVisible(hasDataAccess);
                    DatasourceSelectionDialogController.this.editDatasourceButton.setVisible(hasDataAccess);
                    DatasourceSelectionDialogController.this.removeDatasourceButton.setVisible(hasDataAccess);
                    try {
                        DatasourceSelectionDialogController.this.removeDatasourceButtonBinding.fireSourceChanged();
                        DatasourceSelectionDialogController.this.editDatasourceButtonBinding.fireSourceChanged();
                    }
                    catch (Exception e) {
                        DatasourceSelectionDialogController.this.showMessagebox("Error", e.getLocalizedMessage());
                    }
                }
            });
        }
        catch (RequestException requestException) {
            // empty catch block
        }
    }

    public void reset() {
        if (this.datasourceListbox != null && this.datasourceListbox.getChildNodes().size() > 0) {
            this.datasourceListbox.setSelectedIndex(0);
        }
    }

    private void internalInit() {
        try {
            this.datasourceListbox = (XulListbox)this.safeGetElementById(this.document, "datasourceListbox");
            this.datasourceSelectionDialog = (XulDialog)this.safeGetElementById(this.document, "datasourceSelectionDialog");
            this.removeDatasourceConfirmationDialog = (XulDialog)this.safeGetElementById(this.document, "removeDatasourceConfirmationDialog");
            XulButton acceptButton = null;
            try {
                acceptButton = (XulButton)this.safeGetElementById(this.document, "datasourceSelectionDialog_accept");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.addDatasourceButton = (XulButton)this.safeGetElementById(this.document, "addDatasource");
            this.editDatasourceButton = (XulButton)this.safeGetElementById(this.document, "editDatasource");
            this.removeDatasourceButton = (XulButton)this.safeGetElementById(this.document, "removeDatasource");
            this.manager = UIDatasourceServiceManager.getInstance();
            this.manager.getIds(new XulServiceCallback<List<IDatasourceInfo>>(){

                public void success(List<IDatasourceInfo> infoList) {
                    DatasourceSelectionDialogController.this.datasourceInfos = infoList;
                }

                public void error(String message, Throwable error) {
                }
            });
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            this.bf.createBinding((Object)this.datasourceSelectionDialogModel, "logicalModelSummaries", (Object)this.datasourceListbox, "elements", new BindingConvertor[0]);
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            this.bf.createBinding((Object)this.datasourceListbox, "selectedIndex", (Object)this.datasourceSelectionDialogModel, "selectedIndex", new BindingConvertor[0]);
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            if (acceptButton != null) {
                BindingConvertor<Integer, Boolean> acceptButtonConvertor = new BindingConvertor<Integer, Boolean>(){

                    public Boolean sourceToTarget(Integer value) {
                        return value > -1;
                    }

                    public Integer targetToSource(Boolean value) {
                        throw new UnsupportedOperationException();
                    }
                };
                this.bf.createBinding((Object)this.datasourceSelectionDialogModel, "selectedIndex", (Object)acceptButton, "!disabled", new BindingConvertor[]{acceptButtonConvertor});
            }
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            BindingConvertor<Integer, Boolean> removeDatasourceButtonConvertor = new BindingConvertor<Integer, Boolean>(){

                public Boolean sourceToTarget(Integer value) {
                    boolean active = false;
                    if (value > -1) {
                        LogicalModelSummary summary = (LogicalModelSummary)DatasourceSelectionDialogController.this.datasourceListbox.getSelectedItem();
                        if (DatasourceSelectionDialogController.this.datasourceInfos.size() > 0) {
                            for (int i = 0; i < DatasourceSelectionDialogController.this.datasourceInfos.size(); ++i) {
                                IDatasourceInfo datasourceInfo = (IDatasourceInfo)DatasourceSelectionDialogController.this.datasourceInfos.get(i);
                                if (!datasourceInfo.getId().equals(summary.getDomainId())) continue;
                                active = datasourceInfo.isEditable();
                                break;
                            }
                        }
                    }
                    return active && DatasourceSelectionDialogController.this.administrator;
                }

                public Integer targetToSource(Boolean value) {
                    throw new UnsupportedOperationException();
                }
            };
            this.removeDatasourceButtonBinding = this.bf.createBinding((Object)this.datasourceSelectionDialogModel, "selectedIndex", (Object)this.removeDatasourceButton, "!disabled", new BindingConvertor[]{removeDatasourceButtonConvertor});
            BindingConvertor<Integer, Boolean> editDatasourceButtonConvertor = new BindingConvertor<Integer, Boolean>(){

                public Boolean sourceToTarget(Integer value) {
                    boolean active = false;
                    if (value > -1) {
                        LogicalModelSummary summary = (LogicalModelSummary)DatasourceSelectionDialogController.this.datasourceListbox.getSelectedItem();
                        if (DatasourceSelectionDialogController.this.datasourceInfos.size() > 0) {
                            for (int i = 0; i < DatasourceSelectionDialogController.this.datasourceInfos.size(); ++i) {
                                IDatasourceInfo datasourceInfo = (IDatasourceInfo)DatasourceSelectionDialogController.this.datasourceInfos.get(i);
                                if (!datasourceInfo.getId().equals(summary.getDomainId())) continue;
                                active = datasourceInfo.isEditable();
                                break;
                            }
                        }
                    }
                    return active && DatasourceSelectionDialogController.this.administrator;
                }

                public Integer targetToSource(Boolean value) {
                    throw new UnsupportedOperationException();
                }
            };
            this.editDatasourceButtonBinding = this.bf.createBinding((Object)this.datasourceSelectionDialogModel, "selectedIndex", (Object)this.editDatasourceButton, "!disabled", new BindingConvertor[]{editDatasourceButtonConvertor});
            this.datasourceListbox.setSelectedIndex(-1);
            this.datasourceSelectionDialogModel.setSelectedIndex(-1);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showMessagebox("Error", e.getLocalizedMessage());
        }
    }

    private void showMessagebox(String title, String message) {
        XulMessageBox messagebox = null;
        try {
            messagebox = (XulMessageBox)this.document.createElement("messagebox");
        }
        catch (XulException e) {
            e.printStackTrace();
            return;
        }
        messagebox.setTitle(title);
        messagebox.setMessage(message);
        messagebox.open();
    }

    private XulComponent safeGetElementById(Document doc, String id) {
        XulComponent elem = doc.getElementById(id);
        if (elem != null) {
            return elem;
        }
        throw new NullPointerException("element with id \"" + id + "\" is null");
    }

    private void refreshDatasources(final String domainId, final String modelId) {
        this.datasourceService.getLogicalModels(this.context, new XulServiceCallback<List<LogicalModelSummary>>(){

            public void error(String message, Throwable error) {
                System.out.println(message);
            }

            public void success(List<LogicalModelSummary> logicalModelSummaries) {
                Collections.sort(logicalModelSummaries);
                DatasourceSelectionDialogController.this.datasourceSelectionDialogModel.setSelectedIndex(-1);
                DatasourceSelectionDialogController.this.datasourceSelectionDialogModel.setLogicalModelSummaries(logicalModelSummaries);
                if (domainId != null && modelId != null) {
                    DatasourceSelectionDialogController.this.datasourceSelectionDialogModel.setSelectedLogicalModel(domainId, modelId);
                    DatasourceSelectionDialogController.this.datasourceListbox.setSelectedIndex(DatasourceSelectionDialogController.this.datasourceSelectionDialogModel.getSelectedIndex());
                } else {
                    DatasourceSelectionDialogController.this.datasourceSelectionDialogModel.setSelectedIndex(0);
                }
                DatasourceSelectionDialogController.this.manager = UIDatasourceServiceManager.getInstance();
                DatasourceSelectionDialogController.this.manager.getIds(new XulServiceCallback<List<IDatasourceInfo>>(){

                    public void success(List<IDatasourceInfo> infoList) {
                        DatasourceSelectionDialogController.this.datasourceInfos = infoList;
                    }

                    public void error(String message, Throwable error) {
                    }
                });
            }
        });
    }

    public String getName() {
        return "datasourceSelectionDialogController";
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    public void setDatasourceService(IXulAsyncDSWDatasourceService datasourceService) {
        this.datasourceService = datasourceService;
    }

    protected LogicalModelSummary getDialogResult() {
        int selectedIndex = this.datasourceSelectionDialogModel.getSelectedIndex();
        if (selectedIndex > -1) {
            return this.datasourceSelectionDialogModel.getLogicalModelSummaries().get(selectedIndex);
        }
        return null;
    }

    protected XulDialog getDialog() {
        return this.datasourceSelectionDialog;
    }

    public void setDatasourceDialogController(EmbeddedWizard gwtDatasourceEditor) {
        this.datasourceEditor = gwtDatasourceEditor;
    }

    private void enableWaitCursor(boolean enable) {
        if (enable) {
            DOM.setStyleAttribute((Element)RootPanel.get().getElement(), (String)"cursor", (String)"wait");
        } else {
            DOM.setStyleAttribute((Element)RootPanel.get().getElement(), (String)"cursor", (String)"default");
        }
    }

    @Bindable
    public void addDatasource() {
        this.enableWaitCursor(true);
        DialogController.DialogListener<Domain> dialogListener = new DialogController.DialogListener<Domain>(){

            public void onDialogAccept(Domain domain) {
                DatasourceSelectionDialogController.this.refreshDatasources(domain.getId(), ((LogicalModel)domain.getLogicalModels().get(0)).getId());
            }

            public void onDialogCancel() {
            }

            public void onDialogReady() {
                DatasourceSelectionDialogController.this.enableWaitCursor(false);
            }

            public void onDialogError(String value) {
            }
        };
        if (this.datasourceEditor.isInitialized()) {
            this.datasourceEditor.addDialogListener(dialogListener);
            this.datasourceEditor.showDialog();
        } else {
            this.datasourceEditor.init(new AsyncConstructorListener<EmbeddedWizard>((DialogController.DialogListener)dialogListener){
                final /* synthetic */ DialogController.DialogListener val$dialogListener;
                {
                    this.val$dialogListener = dialogListener;
                }

                public void asyncConstructorDone(EmbeddedWizard dialog) {
                    DatasourceSelectionDialogController.this.datasourceEditor.addDialogListener((DialogController.DialogListener<Domain>)this.val$dialogListener);
                    DatasourceSelectionDialogController.this.datasourceEditor.showDialog();
                }
            });
        }
    }

    @Bindable
    public void editDatasource() {
        if (this.datasourceEditor.isInitialized()) {
            this.showModeler();
        } else {
            this.datasourceEditor.init(new AsyncConstructorListener<EmbeddedWizard>(){

                public void asyncConstructorDone(EmbeddedWizard dialog) {
                    DatasourceSelectionDialogController.this.showModeler();
                }
            });
        }
    }

    private void showModeler() {
        ModelerDialog.getInstance(this.datasourceEditor, new AsyncConstructorListener<ModelerDialog>(){

            public void asyncConstructorDone(ModelerDialog dialog) {
                DialogController.DialogListener<Domain> listener = new DialogController.DialogListener<Domain>(){

                    public void onDialogCancel() {
                    }

                    public void onDialogAccept(Domain domain) {
                        DatasourceSelectionDialogController.this.refreshDatasources(domain.getId(), ((LogicalModel)domain.getLogicalModels().get(0)).getId());
                    }

                    public void onDialogReady() {
                        DatasourceSelectionDialogController.this.enableWaitCursor(false);
                    }

                    public void onDialogError(String value) {
                    }
                };
                LogicalModelSummary logicalModelSummary = DatasourceSelectionDialogController.this.getDialogResult();
                dialog.addDialogListener(listener);
                dialog.showDialog(logicalModelSummary.getDomainId(), logicalModelSummary.getModelId());
            }
        });
    }

    @Bindable
    public void removeDatasourceConfirm() {
        if (this.messageBundle != null) {
            XulLabel removeDatasourceConfirmationDialogLabel = (XulLabel)this.removeDatasourceConfirmationDialog.getElementById("removeDatasourceConfirmationDialogLabel");
            LogicalModelSummary logicalModelSummary = this.getDialogResult();
            if (removeDatasourceConfirmationDialogLabel != null && logicalModelSummary != null) {
                removeDatasourceConfirmationDialogLabel.setValue(this.messageBundle.getString(REMOVE_DS_MSG_ID, logicalModelSummary.getModelName()));
            }
        }
        this.removeDatasourceConfirmationDialog.show();
    }

    @Bindable
    public void removeDatasourceCancel() {
        this.removeDatasourceConfirmationDialog.hide();
    }

    @Bindable
    public void removeDatasourceAccept() {
        if (this.removeDatasourceButton.isDisabled()) {
            return;
        }
        this.removeDatasourceButton.setDisabled(true);
        LogicalModelSummary logicalModelSummary = this.getDialogResult();
        this.datasourceService.deleteLogicalModel(logicalModelSummary.getDomainId(), logicalModelSummary.getModelId(), new XulServiceCallback<Boolean>(){

            public void error(String message, Throwable error) {
                DatasourceSelectionDialogController.this.showMessagebox("Error", error.getLocalizedMessage());
                DatasourceSelectionDialogController.this.removeDatasourceButton.setDisabled(false);
            }

            public void success(Boolean retVal) {
                DatasourceSelectionDialogController.this.refreshDatasources(null, null);
                DatasourceSelectionDialogController.this.removeDatasourceConfirmationDialog.hide();
                DatasourceSelectionDialogController.this.removeDatasourceButton.setDisabled(false);
            }
        });
    }

    public void showDialog() {
        super.showDialog();
        this.refreshDatasources(null, null);
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setMessageBundle(GwtDatasourceMessages messageBundle) {
        this.messageBundle = messageBundle;
    }
}

