/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.ui.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.gwt.widgets.client.ui.ICallback;
import org.pentaho.platform.dataaccess.datasource.IDatasourceInfo;
import org.pentaho.platform.dataaccess.datasource.ui.service.IUIDatasourceAdminService;
import org.pentaho.ui.xul.XulServiceCallback;

public class UIDatasourceServiceManager {
    Map<String, IUIDatasourceAdminService> serviceMap = new HashMap<String, IUIDatasourceAdminService>();
    private static UIDatasourceServiceManager instance;

    private UIDatasourceServiceManager() {
    }

    public static UIDatasourceServiceManager getInstance() {
        if (instance == null) {
            instance = new UIDatasourceServiceManager();
        }
        return instance;
    }

    public UIDatasourceServiceManager(List<IUIDatasourceAdminService> services) {
        for (IUIDatasourceAdminService service : services) {
            this.registerService(service);
        }
    }

    public void registerService(IUIDatasourceAdminService service) {
        this.serviceMap.put(service.getType(), service);
    }

    public IUIDatasourceAdminService getService(String serviceType) {
        return this.serviceMap.get(serviceType);
    }

    public void getIds(final XulServiceCallback<List<IDatasourceInfo>> mainCallback) {
        final ArrayList datasourceList = new ArrayList();
        final int asyncCallCount = this.serviceMap.size();
        ICallback<Void> counterCallback = new ICallback<Void>(){
            int counter = 0;

            public void onHandle(Void o) {
                ++this.counter;
                if (this.counter >= asyncCallCount && mainCallback != null) {
                    mainCallback.success((Object)datasourceList);
                }
            }
        };
        for (IUIDatasourceAdminService service : this.serviceMap.values()) {
            service.getIds(new XulServiceCallback<List<IDatasourceInfo>>((ICallback)counterCallback, mainCallback){
                final /* synthetic */ ICallback val$counterCallback;
                final /* synthetic */ XulServiceCallback val$mainCallback;
                {
                    this.val$counterCallback = iCallback;
                    this.val$mainCallback = xulServiceCallback;
                }

                public void success(List<IDatasourceInfo> list) {
                    datasourceList.addAll(list);
                    this.val$counterCallback.onHandle(null);
                }

                public void error(String message, Throwable error) {
                    if (this.val$mainCallback != null) {
                        this.val$mainCallback.error(message, error);
                    }
                }
            });
        }
    }

    public void exportDatasource(IDatasourceInfo dsInfo) {
        for (IUIDatasourceAdminService service : this.serviceMap.values()) {
            if (!service.getType().equals(dsInfo.getType()) || !dsInfo.isExportable()) continue;
            service.export(dsInfo);
            break;
        }
    }

    public void remove(IDatasourceInfo dsInfo, XulServiceCallback<Boolean> callback) {
        for (IUIDatasourceAdminService service : this.serviceMap.values()) {
            if (!service.getType().equals(dsInfo.getType()) || !dsInfo.isRemovable()) continue;
            service.remove(dsInfo, callback);
            break;
        }
    }

    public List<String> getTypes() {
        return new ArrayList<String>(this.serviceMap.keySet());
    }
}

