/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.csv;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StringEvaluationResult;
import org.pentaho.di.core.util.StringEvaluator;
import org.pentaho.di.trans.steps.textfileinput.TextFileInput;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.util.Util;
import org.pentaho.platform.dataaccess.datasource.wizard.csv.CsvInspector;
import org.pentaho.platform.dataaccess.datasource.wizard.csv.UnicodeBOMInputStream;
import org.pentaho.platform.dataaccess.datasource.wizard.models.ColumnInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.CsvFileInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DataRow;
import org.pentaho.platform.dataaccess.datasource.wizard.models.ModelInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.service.agile.AgileHelper;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;

public class CsvUtils
extends PentahoBase {
    public static final List<String> NUMBER_FORMATS = Arrays.asList("#", "#,##0.###");
    private static final long serialVersionUID = 2498165533158485182L;
    private Log log = LogFactory.getLog(CsvUtils.class);
    public static final String DEFAULT_RELATIVE_UPLOAD_FILE_PATH = File.separatorChar + "system" + File.separatorChar + "metadata" + File.separatorChar + "csvfiles" + File.separatorChar;
    public static final String TMP_FILE_PATH = File.separatorChar + "system" + File.separatorChar + File.separatorChar + "tmp" + File.separatorChar;

    public ModelInfo getFileContents(String project, String name, String delimiter, String enclosure, int rows, boolean isFirstRowHeader, String encoding) throws Exception {
        String path;
        if (name.endsWith(".tmp")) {
            path = PentahoSystem.getApplicationContext().getSolutionPath(TMP_FILE_PATH);
        } else {
            String relativePath = PentahoSystem.getSystemSetting((String)"file-upload-defaults/relative-path", (String)String.valueOf(DEFAULT_RELATIVE_UPLOAD_FILE_PATH));
            path = PentahoSystem.getApplicationContext().getSolutionPath(relativePath);
        }
        String fileLocation = path + name;
        ModelInfo result = new ModelInfo();
        CsvFileInfo fileInfo = new CsvFileInfo();
        fileInfo.setTmpFilename(name);
        result.setFileInfo(fileInfo);
        fileInfo.setContents(this.getLinesList(fileLocation, rows, encoding));
        fileInfo.setDelimiter(delimiter);
        fileInfo.setEnclosure(enclosure);
        fileInfo.setHeaderRows(0);
        return result;
    }

    public ModelInfo generateFields(String project, String filename, int rowLimit, String delimiter, String enclosure, int headerRows, boolean doData, boolean doColumns, String encoding) throws Exception {
        String path;
        if (filename.endsWith(".tmp")) {
            path = PentahoSystem.getApplicationContext().getSolutionPath(TMP_FILE_PATH);
        } else {
            String relativePath = PentahoSystem.getSystemSetting((String)"file-upload-defaults/relative-path", (String)String.valueOf(DEFAULT_RELATIVE_UPLOAD_FILE_PATH));
            path = PentahoSystem.getApplicationContext().getSolutionPath(relativePath);
        }
        String fileLocation = path + filename;
        return this.generateFields(project, fileLocation, filename, rowLimit, delimiter, enclosure, headerRows, doData, doColumns, encoding);
    }

    ModelInfo generateFields(String project, String fileLocation, String filename, int rowLimit, String delimiter, String enclosure, int headerRows, boolean doData, boolean doColumns, String encoding) throws Exception {
        ModelInfo result = new ModelInfo();
        CsvFileInfo fileInfo = new CsvFileInfo();
        result.setFileInfo(fileInfo);
        CsvInspector inspector = new CsvInspector();
        String sampleLine = this.getLines(fileLocation, 1, encoding);
        int fileType = inspector.determineFileFormat(sampleLine);
        String contents = this.getLines(fileLocation, rowLimit, encoding);
        fileInfo.setContents(this.getLinesList(fileLocation, rowLimit, encoding));
        if (delimiter.equals("")) {
            delimiter = inspector.guessDelimiter(contents);
            enclosure = "\"";
            headerRows = 0;
        }
        fileInfo.setDelimiter(delimiter);
        fileInfo.setEnclosure(enclosure);
        fileInfo.setHeaderRows(headerRows);
        fileInfo.setEncoding(encoding);
        fileInfo.setProject(project);
        fileInfo.setTmpFilename(filename);
        DataProfile data = this.getDataProfile(fileInfo, rowLimit, fileLocation, fileType, encoding);
        if (doData) {
            result.setData(data.getRows());
        }
        if (doColumns) {
            result.setColumns(data.getColumns());
        }
        return result;
    }

    private List<String> getColumnData(int columnNumber, String[][] data) {
        ArrayList<String> dataSample = new ArrayList<String>(data.length);
        for (String[] row : data) {
            dataSample.add(row[columnNumber]);
        }
        return dataSample;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getLinesList(String fileLocation, int rows, String encoding) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader reader = null;
        try {
            String line;
            File file = new File(fileLocation);
            fis = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)fis, encoding);
            reader = new LineNumberReader(isr);
            for (int lineNumber = 0; (line = ((LineNumberReader)reader).readLine()) != null && lineNumber < rows; ++lineNumber) {
                lines.add(line);
            }
        }
        catch (Exception e) {
            this.log.equals(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    this.log.warn((Object)"Close LineNumberReader exception", (Throwable)e);
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception e) {
                    this.log.warn((Object)"Close InputStreamReader exception", (Throwable)e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    this.log.warn((Object)"Close FileInputStream exception", (Throwable)e);
                }
            }
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLines(String fileLocation, int rows, String encoding) {
        File file = new File(fileLocation);
        InputStreamReader inr = null;
        StringBuilder line = new StringBuilder();
        int count = 0;
        try {
            FileInputStream in = new FileInputStream(file);
            inr = new InputStreamReader((InputStream)in, encoding);
            int c = inr.read();
            boolean looking = true;
            while (looking && c > 0) {
                line.append((char)c);
                if (c == 13 || c == 10) {
                    c = inr.read();
                    if (c == 13 || c == 10) {
                        line.append((char)c);
                        c = inr.read();
                    }
                    if (++count != rows) continue;
                    looking = false;
                    continue;
                }
                c = inr.read();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (inr != null) {
                try {
                    inr.close();
                }
                catch (IOException iOException) {}
            }
        }
        return line.toString();
    }

    /*
     * WARNING - void declaration
     */
    private DataProfile getDataProfile(CsvFileInfo fileInfo, int rowLimit, String fileLocation, int fileType, String encoding) throws Exception {
        int row;
        DataProfile result = new DataProfile();
        String line = null;
        ArrayList headerSample = new ArrayList();
        ArrayList dataSample = new ArrayList(rowLimit);
        int maxColumns = 0;
        try (InputStreamReader reader = null;){
            FileInputStream inputStream = new FileInputStream(fileLocation);
            UnicodeBOMInputStream bomIs = new UnicodeBOMInputStream(inputStream);
            reader = new InputStreamReader((InputStream)bomIs, encoding);
            bomIs.skipBOM();
            StringBuilder stringBuilder = new StringBuilder(1000);
            line = TextFileInput.getLine(null, (InputStreamReader)reader, (int)fileType, (StringBuilder)stringBuilder);
            for (row = 0; line != null && row < rowLimit; ++row) {
                CSVTokenizer cSVTokenizer = new CSVTokenizer(line, fileInfo.getDelimiter(), fileInfo.getEnclosure());
                ArrayList<void> rowData = new ArrayList<void>();
                int count = 0;
                while (cSVTokenizer.hasMoreTokens()) {
                    void var19_31;
                    String string = cSVTokenizer.nextToken();
                    if (string != null) {
                        String string2 = string.trim();
                    }
                    rowData.add(var19_31);
                    ++count;
                }
                if (maxColumns < count) {
                    maxColumns = count;
                }
                if (row < fileInfo.getHeaderRows()) {
                    headerSample.add(rowData);
                } else {
                    dataSample.add(rowData);
                }
                line = TextFileInput.getLine(null, (InputStreamReader)reader, (int)fileType, (StringBuilder)stringBuilder);
            }
        }
        String[][] headerValues = new String[headerSample.size()][maxColumns];
        int rowNo = 0;
        for (List list : headerSample) {
            int colNo = 0;
            Iterator count = list.iterator();
            while (count.hasNext()) {
                String string;
                headerValues[rowNo][colNo] = string = (String)count.next();
                ++colNo;
            }
            ++rowNo;
        }
        int[] fieldLengths = new int[maxColumns];
        String[][] stringArray = new String[dataSample.size()][maxColumns];
        DataRow[] data = new DataRow[dataSample.size()];
        rowNo = 0;
        for (List list : dataSample) {
            int colNo = 0;
            Iterator e = list.iterator();
            while (e.hasNext()) {
                String value;
                stringArray[rowNo][colNo] = value = (String)e.next();
                int currentMaxLength = fieldLengths[colNo];
                if (value.length() > currentMaxLength) {
                    fieldLengths[colNo] = value.length();
                }
                ++colNo;
            }
            data[rowNo] = new DataRow();
            data[rowNo].setCells(stringArray[rowNo]);
            ++rowNo;
        }
        result.setRows(data);
        DecimalFormat df = new DecimalFormat("000");
        ColumnInfo[] columnInfoArray = new ColumnInfo[maxColumns];
        for (int idx = 0; idx < maxColumns; ++idx) {
            ColumnInfo profile;
            columnInfoArray[idx] = profile = new ColumnInfo();
            String title = "Field_" + df.format(idx + 1);
            String colId = "PC_" + idx;
            if (headerValues.length > 0 && headerValues[headerValues.length - 1][idx] != null) {
                colId = title = headerValues[headerValues.length - 1][idx];
                if (!Util.validateId((CharSequence)title)) {
                    colId = Util.toId((String)colId);
                }
            }
            profile.setTitle(title);
            profile.setId(colId);
            List<String> samples = this.getColumnData(idx, stringArray);
            this.assumeColumnDetails(profile, samples);
        }
        result.setColumns(columnInfoArray);
        return result;
    }

    protected void assumeColumnDetails(ColumnInfo profile, List<String> samples) {
        StringEvaluator eval = new StringEvaluator(false, NUMBER_FORMATS, ColumnInfo.DATE_FORMATS);
        for (String sample : samples) {
            eval.evaluateString(sample);
        }
        StringEvaluationResult result = eval.getAdvicedResult();
        ValueMetaInterface meta = result.getConversionMeta();
        int type = meta.getType();
        String mask = meta.getConversionMask();
        int precision = meta.getPrecision();
        profile.setFormat(mask);
        profile.setPrecision(precision > 0 ? precision : 0);
        profile.setDataType(this.convertDataType(type));
        int size = meta.isString() ? meta.getLength() + meta.getLength() / 2 : (meta.isInteger() ? meta.getLength() : (precision > 0 ? meta.getLength() : 0));
        profile.setLength(size);
    }

    public Log getLogger() {
        return this.log;
    }

    public String getEncoding(String fileName) throws Exception {
        String encoding;
        String path;
        if (fileName.endsWith(".tmp")) {
            path = PentahoSystem.getApplicationContext().getSolutionPath(TMP_FILE_PATH);
        } else {
            String relativePath = PentahoSystem.getSystemSetting((String)"file-upload-defaults/relative-path", (String)String.valueOf(DEFAULT_RELATIVE_UPLOAD_FILE_PATH));
            path = PentahoSystem.getApplicationContext().getSolutionPath(relativePath);
        }
        String fileLocation = path + fileName;
        try {
            byte[] bytes = new byte[1024];
            FileInputStream inputStream = new FileInputStream(new File(fileLocation));
            ((InputStream)inputStream).read(bytes);
            CharsetDetector charsetDetector = new CharsetDetector();
            charsetDetector.setText(bytes);
            CharsetMatch charsetMatch = charsetDetector.detect();
            encoding = charsetMatch.getName();
            ((InputStream)inputStream).close();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw e;
        }
        return encoding;
    }

    public ModelInfo getModelInfo(String project, String filename) throws FileNotFoundException {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        xstream.alias("modelInfo", ModelInfo.class);
        xstream.alias("columnInfo", ColumnInfo.class);
        String filepath = AgileHelper.getFolderPath(project) + "/" + filename + ".xml";
        System.out.println(filepath);
        File f = new File(filepath);
        FileInputStream fis = new FileInputStream(f);
        return (ModelInfo)xstream.fromXML((InputStream)fis);
    }

    private DataType convertDataType(int type) {
        switch (type) {
            case 1: 
            case 5: 
            case 6: {
                return DataType.NUMERIC;
            }
            case 3: {
                return DataType.DATE;
            }
            case 4: {
                return DataType.BOOLEAN;
            }
        }
        return DataType.STRING;
    }

    private static class DataProfile {
        DataRow[] rows = null;
        ColumnInfo[] columns = null;

        private DataProfile() {
        }

        public DataRow[] getRows() {
            return this.rows;
        }

        public void setRows(DataRow[] rows) {
            this.rows = rows;
        }

        public ColumnInfo[] getColumns() {
            return this.columns;
        }

        public void setColumns(ColumnInfo[] columns) {
            this.columns = columns;
        }
    }
}

