/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.agile;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.calculator.CalculatorMeta;
import org.pentaho.di.trans.steps.calculator.CalculatorMetaFunction;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.dataaccess.datasource.wizard.models.ColumnInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.CsvTransformGeneratorException;
import org.pentaho.platform.dataaccess.datasource.wizard.models.ModelInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.service.agile.AgileHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.agile.PdiRowListener;
import org.pentaho.platform.dataaccess.datasource.wizard.service.agile.PdiTransListener;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.csv.FileTransformStats;
import org.pentaho.platform.engine.core.system.PentahoBase;

public abstract class StagingTransformGenerator
extends PentahoBase {
    private static final long serialVersionUID = -185098401772609035L;
    private static final String DUMMY = "dummy";
    private static final String TABLE_OUTPUT = "output";
    private static final String TRANS_SESSION_ATTR = "PDI_Trans";
    private static final Log log = LogFactory.getLog(StagingTransformGenerator.class);
    private DatabaseMeta targetDatabaseMeta;
    private String tableName = null;
    private FileTransformStats transformStats;
    protected long errorRowCount;
    protected long maxErrorRows = 100L;
    protected long csvErrorRowCount;
    private ModelInfo modelInfo;

    protected abstract StepMeta[] getSteps(TransMeta var1);

    protected abstract String[] getIndexedColumnNames();

    public StagingTransformGenerator() {
        this.targetDatabaseMeta = AgileHelper.getDatabaseMeta();
    }

    public StagingTransformGenerator(DatabaseMeta databaseMeta) {
        this.targetDatabaseMeta = databaseMeta;
    }

    private static String getStackTraceAsString(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public void preview(IPentahoSession session) throws CsvTransformGeneratorException {
        Trans trans = this.createTransform(false);
        try {
            this.prepareTransform(trans, session);
        }
        catch (Exception e) {
            this.error("Preview Failed: transformation preparation", e);
            throw new CsvTransformGeneratorException("Preview Failed: transformation preparation: preview", e, StagingTransformGenerator.getStackTraceAsString(e));
        }
        String[] stepNames = trans.getTransMeta().getStepNames();
        this.executeTransformSync(trans, stepNames[stepNames.length - 1], session);
    }

    public void dropTable(String tableName) throws CsvTransformGeneratorException {
        if (tableName == null) {
            throw new IllegalArgumentException("Table Name cannot be null");
        }
        String schemaTableName = this.targetDatabaseMeta.getQuotedSchemaTableCombination(AgileHelper.getSchemaName(), tableName);
        if (this.checkTableExists(schemaTableName)) {
            String ddl = "DROP TABLE " + schemaTableName;
            this.execSqlStatement(ddl, this.targetDatabaseMeta, null);
        }
    }

    public void createOrModifyTable(IPentahoSession session) throws CsvTransformGeneratorException, IllegalArgumentException {
        block4: {
            if (session == null) {
                throw new IllegalArgumentException("IPentahoSession cannot be null");
            }
            if (this.tableName == null) {
                throw new IllegalArgumentException("Table name cannot be null");
            }
            TransMeta transMeta = this.createTransMeta(true);
            StepMeta[] steps = transMeta.getStepsArray();
            StepMeta tableStepMeta = steps[steps.length - 1];
            TableOutputMeta meta = (TableOutputMeta)tableStepMeta.getStepMetaInterface();
            meta.setDatabaseMeta(this.targetDatabaseMeta);
            try {
                this.executeSql(meta, tableStepMeta, transMeta);
            }
            catch (CsvTransformGeneratorException e) {
                if (e.getMessage().equalsIgnoreCase("No SQL generated")) break block4;
                this.error(e.getMessage());
                throw new CsvTransformGeneratorException("Could not create or modify table", e, StagingTransformGenerator.getStackTraceAsString(e), null, Messages.getString("StagingTransformGenerator.ERROR_0001_UNABLE_TO_CREATE_OR_MODIFY_TABLE"));
            }
        }
    }

    public void loadTable(boolean truncate, IPentahoSession session, boolean async) throws CsvTransformGeneratorException {
        if (session == null) {
            throw new IllegalArgumentException("IPentahoSession cannot be null");
        }
        if (this.tableName == null) {
            throw new IllegalArgumentException("Table name cannot be null");
        }
        if (this.transformStats != null) {
            this.transformStats.setRowsFinished(false);
            this.transformStats.setRowsStarted(true);
            this.transformStats.setTotalRecords(0L);
            this.transformStats.setRowsRejected(0L);
        }
        Trans trans = this.createTransform(true);
        StepMeta[] steps = trans.getTransMeta().getStepsArray();
        StepMeta tableStepMeta = steps[steps.length - 1];
        TableOutputMeta meta = (TableOutputMeta)tableStepMeta.getStepMetaInterface();
        meta.setDatabaseMeta(this.targetDatabaseMeta);
        meta.setTruncateTable(truncate);
        try {
            this.prepareTransform(trans, session);
        }
        catch (Exception e) {
            this.error("Preview Failed: transformation preparation", e);
            Throwable e2 = e.getCause();
            e2 = e2 == null ? e : e2;
            throw new CsvTransformGeneratorException("Preview Failed: transformation preparation: loadTable", e2, StagingTransformGenerator.getStackTraceAsString(e2));
        }
        StepInterface step = trans.findRunThread(TABLE_OUTPUT);
        PdiTransListener listener = new PdiTransListener(trans, step, this.transformStats);
        Thread listenerThread = new Thread(listener);
        listenerThread.start();
        session.setAttribute(TRANS_SESSION_ATTR, (Object)trans);
        if (async) {
            this.executeTransformAsync(trans);
        } else {
            this.executeTransformSync(trans, null, session);
        }
    }

    public int createIndices(IPentahoSession session) {
        if (this.transformStats != null) {
            this.transformStats.setIndexFinished(false);
            this.transformStats.setIndexStarted(true);
        }
        String tableName = this.getTableName();
        Database db = new Database(this.targetDatabaseMeta);
        String[] indexed = this.getIndexedColumnNames();
        ArrayList<String> commands = new ArrayList<String>();
        for (String columnName : indexed) {
            String indexSql = db.getCreateIndexStatement(tableName, columnName + "_idx", new String[]{columnName}, false, false, false, true);
            commands.add(indexSql);
        }
        if (this.transformStats != null) {
            this.transformStats.setIndexCount(commands.size());
        }
        int indexDone = 0;
        int indexSuccess = 0;
        for (String command : commands) {
            try {
                this.execSqlStatement(command, this.targetDatabaseMeta, null);
                ++indexSuccess;
            }
            catch (CsvTransformGeneratorException csvTransformGeneratorException) {
                // empty catch block
            }
            ++indexDone;
            if (this.transformStats == null) continue;
            this.transformStats.setIndexDone(indexDone);
        }
        if (this.transformStats != null) {
            this.transformStats.setIndexFinished(true);
            this.transformStats.setIndexStarted(false);
        }
        return indexSuccess;
    }

    public void cancelLoad(IPentahoSession session) {
        Trans trans = (Trans)session.getAttribute(TRANS_SESSION_ATTR);
        trans.stopAll();
    }

    protected StepMeta addDummyStep(TransMeta transMeta, String stepName) {
        DummyTransMeta meta = new DummyTransMeta();
        StepMeta stepMeta = new StepMeta(stepName, stepName, (StepMetaInterface)meta);
        transMeta.addStep(stepMeta);
        return stepMeta;
    }

    protected StepMeta addTableOutputStep(TransMeta transMeta, String tableOutputStepName, String modelName) {
        TableOutputMeta tableOutputMeta = new TableOutputMeta();
        tableOutputMeta.setCommitSize(1000);
        tableOutputMeta.setIgnoreErrors(true);
        tableOutputMeta.setPartitioningEnabled(false);
        tableOutputMeta.setSchemaName(AgileHelper.getSchemaName());
        tableOutputMeta.setTableName(this.getTableName());
        tableOutputMeta.setUseBatchUpdate(false);
        StepMeta tableOutputStepMeta = new StepMeta(tableOutputStepName, tableOutputStepName, (StepMetaInterface)tableOutputMeta);
        transMeta.addStep(tableOutputStepMeta);
        return tableOutputStepMeta;
    }

    protected void createHop(StepMeta fromStep, StepMeta toStep, TransMeta transMeta) {
        TransHopMeta hopMeta = new TransHopMeta();
        hopMeta.setFromStep(fromStep);
        hopMeta.setToStep(toStep);
        hopMeta.setEnabled(true);
        transMeta.addTransHop(hopMeta);
    }

    protected void prepareTransform(Trans trans, IPentahoSession session) throws KettleException {
        trans.prepareExecution(trans.getArguments());
        StepInterface tableOutputStep = trans.findRunThread(TABLE_OUTPUT);
        if (tableOutputStep != null) {
            StepErrorMeta tableOutputErrorMeta = new StepErrorMeta((VariableSpace)trans.getTransMeta(), tableOutputStep.getStepMeta()){

                public void addErrorRowData(Object[] row, int startIndex, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) {
                    if (StagingTransformGenerator.this.errorRowCount < StagingTransformGenerator.this.maxErrorRows) {
                        StringBuffer sb = new StringBuffer();
                        sb.append("Rejected Row: ");
                        for (Object rowData : row) {
                            sb.append(rowData);
                            sb.append(", ");
                        }
                        sb.append("\r\n");
                        if (StagingTransformGenerator.this.transformStats != null) {
                            ((ArrayList)StagingTransformGenerator.this.transformStats.getErrors()).add(sb.toString() + errorDescriptions);
                        }
                    }
                    ++StagingTransformGenerator.this.errorRowCount;
                    StagingTransformGenerator.this.transformStats.setErrorCount(StagingTransformGenerator.this.errorRowCount);
                    super.addErrorRowData(row, startIndex, nrErrors, errorDescriptions, fieldNames, errorCodes);
                }
            };
            StepMeta outputDummyStepMeta = this.addDummyStep(trans.getTransMeta(), "TableOutputErrorDummy");
            tableOutputErrorMeta.setTargetStep(outputDummyStepMeta);
            tableOutputErrorMeta.setEnabled(true);
            tableOutputStep.getStepMeta().setStepErrorMeta(tableOutputErrorMeta);
        }
    }

    protected void executeTransformSync(Trans trans, String listenerStepName, IPentahoSession session) throws CsvTransformGeneratorException {
        PdiRowListener rowListener = new PdiRowListener();
        if (listenerStepName != null) {
            trans.getStepInterface(listenerStepName, 0).addRowListener((RowListener)rowListener);
        }
        try {
            trans.startThreads();
        }
        catch (Exception e) {
            this.error("Preview Failed: starting threads", e);
            throw new CsvTransformGeneratorException("Preview Failed: starting threads", e, StagingTransformGenerator.getStackTraceAsString(e));
        }
        try {
            trans.waitUntilFinished();
        }
        catch (Exception e) {
            this.error("Preview Failed: running", e);
            throw new CsvTransformGeneratorException("Preview Failed: running", e, StagingTransformGenerator.getStackTraceAsString(e));
        }
        try {
            trans.cleanup();
        }
        catch (Exception e) {
            this.error("Preview Failed: ending", e);
            throw new CsvTransformGeneratorException("Preview Failed: ending", e, StagingTransformGenerator.getStackTraceAsString(e));
        }
        if (this.transformStats != null) {
            this.transformStats.setDataRows(rowListener.getWrittenRows());
        }
    }

    protected void executeTransformAsync(Trans trans) throws CsvTransformGeneratorException {
        try {
            trans.startThreads();
        }
        catch (Exception e) {
            this.error("Preview Failed: starting threads", e);
            throw new CsvTransformGeneratorException("Preview Failed: starting threads", e, StagingTransformGenerator.getStackTraceAsString(e));
        }
    }

    protected Trans createTransform(boolean doOutput) {
        TransMeta transMeta = this.createTransMeta(doOutput);
        return new Trans(transMeta);
    }

    private TransMeta createTransMeta(boolean doOutput) {
        TransMeta transMeta = new TransMeta();
        StepMeta[] steps = this.getSteps(transMeta);
        StepMeta lastStep = steps[steps.length - 1];
        StepMeta tableStepMeta = null;
        if (doOutput) {
            tableStepMeta = this.addTableOutputStep(transMeta, TABLE_OUTPUT, this.tableName);
            this.createHop(lastStep, tableStepMeta, transMeta);
            lastStep = tableStepMeta;
        }
        StepMeta dummyStepMeta = null;
        if (lastStep != tableStepMeta) {
            dummyStepMeta = this.addDummyStep(transMeta, DUMMY);
            this.createHop(lastStep, dummyStepMeta, transMeta);
        }
        return transMeta;
    }

    protected void executeSql(TableOutputMeta meta, StepMeta stepMeta, TransMeta transMeta) throws CsvTransformGeneratorException {
        try {
            RowMetaInterface prev = transMeta.getPrevStepFields(TABLE_OUTPUT);
            SQLStatement sqlStatement = meta.getSQLStatements(transMeta, stepMeta, prev, null, false, null);
            if (!sqlStatement.hasError()) {
                if (!sqlStatement.hasSQL()) {
                    this.error("No SQL generated");
                    throw new CsvTransformGeneratorException("No SQL generated");
                }
            } else {
                this.error(sqlStatement.getError());
                throw new CsvTransformGeneratorException(sqlStatement.getError());
            }
            String sqlScript = sqlStatement.getSQL();
            this.execSqlStatement(sqlScript, meta.getDatabaseMeta(), null);
        }
        catch (KettleException ke) {
            this.error("Exception encountered", ke);
            throw new CsvTransformGeneratorException("Exception encountered", ke, StagingTransformGenerator.getStackTraceAsString(ke));
        }
    }

    public void execSqlStatement(String sqlScript, DatabaseMeta ci, StringBuilder message) throws IllegalArgumentException, CsvTransformGeneratorException {
        if (ci == null) {
            throw new IllegalArgumentException("DatabaesMeta cannot be null");
        }
        Database db = this.getDatabase(ci);
        try {
            db.connect(null);
            String all = sqlScript + Const.CR;
            int from = 0;
            int to = 0;
            int length = all.length();
            while (to < length) {
                int c = all.charAt(to);
                if (c == 34) {
                    ++to;
                    c = 32;
                    while (to < length && c != 34) {
                        c = all.charAt(to);
                        ++to;
                    }
                } else if (c == 39) {
                    ++to;
                    c = 32;
                    while (to < length && c != 39) {
                        c = all.charAt(to);
                        ++to;
                    }
                }
                if ((c = (int)all.charAt(to)) == 59 || to >= length - 1) {
                    if (to >= length - 1) {
                        ++to;
                    }
                    String stat = all.substring(from, to);
                    String sql = Const.trim((String)stat);
                    try {
                        if (!sql.equals("")) {
                            db.execStatement(sql);
                        }
                    }
                    catch (Exception dbe) {
                        this.error("Error executing DDL", dbe);
                        throw new CsvTransformGeneratorException(dbe.getMessage(), dbe, StagingTransformGenerator.getStackTraceAsString(dbe));
                    }
                    from = ++to;
                    continue;
                }
                ++to;
            }
        }
        catch (KettleDatabaseException dbe) {
            this.error("Connection error", dbe);
            throw new CsvTransformGeneratorException("Connection error", dbe, StagingTransformGenerator.getStackTraceAsString(dbe));
        }
        finally {
            db.disconnect();
        }
    }

    Database getDatabase(DatabaseMeta databaseMeta) {
        return new Database(databaseMeta);
    }

    protected int convertDataType(ColumnInfo ci) {
        if (ci != null && ci.getDataType() != null) {
            switch (ci.getDataType()) {
                case NUMERIC: {
                    if (ci.getPrecision() <= 0) {
                        return 5;
                    }
                    return 1;
                }
            }
            return ValueMetaBase.getType((String)ci.getDataType().getName());
        }
        return 2;
    }

    public Log getLogger() {
        return log;
    }

    public FileTransformStats getTransformStats() {
        return this.transformStats;
    }

    public void setTransformStats(FileTransformStats transformStats) {
        this.transformStats = transformStats;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    protected StepMeta createCalcStep(TransMeta transMeta, String stepName, ColumnInfo[] columns) {
        CalculatorMeta meta = new CalculatorMeta();
        ArrayList<CalculatorMetaFunction> funcs = new ArrayList<CalculatorMetaFunction>();
        for (ColumnInfo column : columns) {
            CalculatorMetaFunction func;
            if (column == null || column.isIgnore() || column.getDataType() != DataType.DATE) continue;
            int dateBreakOut = column.getDateFieldBreakout();
            if ((dateBreakOut & 1) > 0) {
                func = this.createDateCalc(22, column.getTitle() + " (year)", column.getId(), 4);
                funcs.add(func);
            }
            if ((dateBreakOut & 4) > 0) {
                func = this.createDateCalc(59, column.getTitle() + " (qtr)", column.getId(), 4);
                funcs.add(func);
            }
            if ((dateBreakOut & 2) > 0) {
                func = this.createDateCalc(23, column.getTitle() + " (month)", column.getId(), 4);
                funcs.add(func);
            }
            if ((dateBreakOut & 8) > 0) {
                func = this.createDateCalc(27, column.getTitle() + " (week)", column.getId(), 4);
                funcs.add(func);
            }
            if ((dateBreakOut & 0x10) > 0) {
                func = this.createDateCalc(25, column.getTitle() + " (day)", column.getId(), 4);
                funcs.add(func);
            }
            if ((dateBreakOut & 0x20) <= 0) continue;
            func = this.createDateCalc(26, column.getTitle() + " (day of week)", column.getId(), 4);
            funcs.add(func);
        }
        if (funcs.size() == 0) {
            return null;
        }
        meta.setCalculation(funcs.toArray(new CalculatorMetaFunction[funcs.size()]));
        StepMeta stepMeta = new StepMeta(stepName, stepName, (StepMetaInterface)meta);
        transMeta.addStep(stepMeta);
        return stepMeta;
    }

    protected CalculatorMetaFunction createDateCalc(int calcType, String fieldName, String fieldId, int valueLength) {
        String fieldB = null;
        System.out.println(99);
        String fieldC = null;
        int valueType = 5;
        int valuePrecision = 0;
        boolean removedFromResult = false;
        String conversionMask = "";
        String decimalSymbol = "";
        String groupingSymbol = "";
        String currencySymbol = "";
        CalculatorMetaFunction func = new CalculatorMetaFunction(fieldName, calcType, fieldId, fieldB, fieldC, valueType, valueLength, valuePrecision, removedFromResult, conversionMask, decimalSymbol, groupingSymbol, currencySymbol);
        ColumnInfo column = new ColumnInfo();
        column.setAggregateType(AggregationType.NONE.toString());
        column.setDataType(DataType.NUMERIC);
        column.setFieldType("dimension");
        column.setIgnore(false);
        column.setId(fieldId);
        column.setIndex(true);
        column.setTitle(fieldName);
        return func;
    }

    public ModelInfo getModelInfo() {
        return this.modelInfo;
    }

    public void setModelInfo(ModelInfo modelInfo) {
        this.modelInfo = modelInfo;
    }

    private boolean checkTableExists(String tableName) throws CsvTransformGeneratorException {
        Database db = this.getDatabase(this.targetDatabaseMeta);
        try {
            db.connect(null);
            try {
                boolean bl = db.checkTableExists(tableName);
                return bl;
            }
            catch (KettleDatabaseException dbe) {
                try {
                    this.error("Error executing DDL", dbe);
                    throw new CsvTransformGeneratorException(dbe.getMessage(), dbe, StagingTransformGenerator.getStackTraceAsString(dbe));
                }
                catch (KettleDatabaseException dbe2) {
                    this.error("Connection error", dbe2);
                    throw new CsvTransformGeneratorException("Connection error", dbe2, StagingTransformGenerator.getStackTraceAsString(dbe2));
                }
            }
        }
        finally {
            db.disconnect();
        }
    }
}

