/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.AgileMartDatasourceHelper;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.pentaho.platform.repository2.unified.lifecycle.AbstractBackingRepositoryLifecycleManager;
import org.springframework.extensions.jcr.JcrTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public class AgileMartDatasourceLifecycleManager
extends AbstractBackingRepositoryLifecycleManager {
    private IDatasourceMgmtService datasourceMgmtService;
    public static final String PLUGIN_NAME = "data-access";
    private static final String AGILE_MART_STAGING_DATASOURCE_NAME = "agile-mart-staging-datasource";
    private static final String SETTINGS_FILE = "data-access/settings.xml";
    private AgileMartDatasourceHelper agileMartDatasourceHelper;
    private static final Log log = LogFactory.getLog(AgileMartDatasourceLifecycleManager.class);
    private static AgileMartDatasourceLifecycleManager instance;

    public AgileMartDatasourceLifecycleManager(TransactionTemplate txnTemplate, JcrTemplate adminJcrTemplate, IPathConversionHelper pathConversionHelper, IDatasourceMgmtService datasourceMgmtService, IPluginResourceLoader resLoader) {
        super(txnTemplate, adminJcrTemplate, pathConversionHelper);
        this.datasourceMgmtService = datasourceMgmtService;
        this.agileMartDatasourceHelper = new AgileMartDatasourceHelper(resLoader);
    }

    public static AgileMartDatasourceLifecycleManager getInstance() {
        if (instance == null) {
            TransactionTemplate txnTemplate = (TransactionTemplate)PentahoSystem.get(TransactionTemplate.class, (String)"jcrTransactionTemplate", (IPentahoSession)PentahoSessionHolder.getSession());
            JcrTemplate adminJcrTemplate = (JcrTemplate)PentahoSystem.get(JcrTemplate.class, (String)"adminJcrTemplate", (IPentahoSession)PentahoSessionHolder.getSession());
            IPathConversionHelper pathConversionHelper = (IPathConversionHelper)PentahoSystem.get(IPathConversionHelper.class, (String)"pathConversionHelper", (IPentahoSession)PentahoSessionHolder.getSession());
            IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, (IPentahoSession)PentahoSessionHolder.getSession());
            IDatasourceMgmtService datasourceMgmtService = (IDatasourceMgmtService)PentahoSystem.get(IDatasourceMgmtService.class, (IPentahoSession)PentahoSessionHolder.getSession());
            instance = new AgileMartDatasourceLifecycleManager(txnTemplate, adminJcrTemplate, pathConversionHelper, datasourceMgmtService, resLoader);
        }
        return instance;
    }

    public void startup() {
        try {
            String agileMartDatasourceName = PentahoSystem.getSystemSetting((String)SETTINGS_FILE, (String)AGILE_MART_STAGING_DATASOURCE_NAME, null);
            IDatabaseConnection agileMartDatasource = this.datasourceMgmtService.getDatasourceByName(agileMartDatasourceName);
            IDatabaseConnection newAgileMartDatasource = this.agileMartDatasourceHelper.getAgileMartDatasource();
            if (agileMartDatasource != null) {
                newAgileMartDatasource.setId(agileMartDatasource.getId());
                this.datasourceMgmtService.updateDatasourceByName(agileMartDatasource.getName(), newAgileMartDatasource);
            } else {
                this.datasourceMgmtService.createDatasource(newAgileMartDatasource);
            }
        }
        catch (Throwable th) {
            log.warn((Object)"Error during the create/update of AgileMart Datasource", th);
        }
    }

    public void shutdown() {
    }

    public void newTenant() {
    }

    public void newUser() {
    }

    public void newTenant(ITenant tenant) {
    }

    public void newUser(ITenant tenant, String username) {
    }
}

