/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ConnectionServiceImpl;

public class ConnectionServiceConcrete {
    private ConnectionServiceImpl service = new ConnectionServiceImpl();
    private static final Log logger = LogFactory.getLog(ConnectionServiceConcrete.class);

    public List<DatabaseConnection> getConnections() throws ConnectionServiceException {
        List<IDatabaseConnection> iConnections = this.service.getConnections();
        ArrayList<DatabaseConnection> connections = new ArrayList<DatabaseConnection>();
        for (IDatabaseConnection iConnection : iConnections) {
            this.hidePassword(iConnection);
            connections.add((DatabaseConnection)iConnection);
        }
        return connections;
    }

    public DatabaseConnection getConnectionByName(String name) throws ConnectionServiceException {
        DatabaseConnection connection = (DatabaseConnection)this.service.getConnectionByName(name);
        this.hidePassword((IDatabaseConnection)connection);
        return connection;
    }

    public boolean addConnection(DatabaseConnection connection) throws ConnectionServiceException {
        return this.service.addConnection((IDatabaseConnection)connection);
    }

    public boolean updateConnection(DatabaseConnection connection) throws ConnectionServiceException {
        this.applySavedPassword((IDatabaseConnection)connection);
        return this.service.updateConnection((IDatabaseConnection)connection);
    }

    public boolean deleteConnection(DatabaseConnection connection) throws ConnectionServiceException {
        return this.service.deleteConnection((IDatabaseConnection)connection);
    }

    public boolean deleteConnectionByName(String name) throws ConnectionServiceException {
        return this.service.deleteConnection(name);
    }

    public boolean testConnection(DatabaseConnection connection) throws ConnectionServiceException {
        return this.service.testConnection((IDatabaseConnection)connection);
    }

    public boolean isConnectionExist(String connectionName) throws ConnectionServiceException {
        return this.service.isConnectionExist(connectionName);
    }

    private void hidePassword(IDatabaseConnection connection) {
        connection.setPassword("");
    }

    private void applySavedPassword(IDatabaseConnection conn) throws ConnectionServiceException {
        if (StringUtils.isBlank((String)conn.getPassword())) {
            IDatabaseConnection savedConn;
            if (conn.getId() != null) {
                savedConn = this.service.getConnectionById(conn.getId());
            } else {
                try {
                    savedConn = this.service.getConnectionByName(conn.getName());
                }
                catch (ConnectionServiceException e) {
                    logger.warn((Object)e.getMessage());
                    savedConn = null;
                }
            }
            if (savedConn != null) {
                conn.setPassword(savedConn.getPassword());
            }
        }
    }
}

