/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.dataaccess.datasource.api.resources.AnalysisResource;
import org.pentaho.platform.dataaccess.datasource.api.resources.DataSourceWizardResource;
import org.pentaho.platform.dataaccess.datasource.api.resources.MetadataResource;
import org.pentaho.platform.dataaccess.datasource.utils.DataSourceInfoUtil;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.web.http.api.resources.JaxbList;

@Path(value="/data-access/api/datasource")
public class DatasourceResource {
    private static final Log logger = LogFactory.getLog(DatasourceResource.class);

    @GET
    @Path(value="/{catalogId : .+}/getAnalysisDatasourceInfo")
    @Produces(value={"*/*"})
    @Facet(name="Unsupported")
    public Response getAnalysisDatasourceInfo(@PathParam(value="catalogId") String catalogId) {
        IMondrianCatalogService mondrianCatalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (IPentahoSession)PentahoSessionHolder.getSession());
        MondrianCatalog catalog = mondrianCatalogService.getCatalog(catalogId, PentahoSessionHolder.getSession());
        if (catalog == null) {
            logger.warn((Object)("Catalog " + catalogId + " doesn't exist"));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String parameters = DatasourceResource.prepareDataSourceInfo(catalog.getDataSourceInfo());
        return Response.ok().entity((Object)parameters).build();
    }

    static String prepareDataSourceInfo(String dataSourceInfo) {
        StringBuilder sb = new StringBuilder();
        Map<String, String> parameters = DataSourceInfoUtil.parseDataSourceInfo(dataSourceInfo);
        parameters.forEach((key, value) -> {
            String unescapedValue = StringEscapeUtils.unescapeXml((String)value);
            String valueWithEscapedQuotes = DataSourceInfoUtil.escapeQuotes(unescapedValue);
            sb.append((String)key);
            sb.append("=\"");
            sb.append(valueWithEscapedQuotes);
            sb.append("\"");
            sb.append(";");
        });
        return sb.toString();
    }

    public JaxbList<String> getAnalysisDatasourceIds() {
        return new AnalysisResource().getSchemaIds();
    }

    public JaxbList<String> getMetadataDatasourceIds() {
        return new MetadataResource().listDomains();
    }

    @Facet(name="Unsupported")
    public Response doGetMetadataFilesAsDownload(@PathParam(value="metadataId") String metadataId) {
        return new MetadataResource().downloadMetadata(metadataId);
    }

    @Facet(name="Unsupported")
    public Response doGetAnalysisFilesAsDownload(@PathParam(value="analysisId") String analysisId) {
        return new AnalysisResource().downloadSchema(analysisId);
    }

    @Facet(name="Unsupported")
    public Response doRemoveAnalysis(@PathParam(value="analysisId") String analysisId) {
        return new AnalysisResource().downloadSchema(analysisId);
    }

    @Facet(name="Unsupported")
    public Response doRemoveDSW(@PathParam(value="dswId") String dswId) {
        return new DataSourceWizardResource().remove(dswId);
    }
}

