/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataBodyPart;
import com.sun.jersey.multipart.FormDataParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.Facet;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclDto;
import org.pentaho.platform.dataaccess.datasource.api.DatasourceService;
import org.pentaho.platform.dataaccess.datasource.api.resources.MetadataResource;
import org.pentaho.platform.dataaccess.datasource.wizard.csv.CsvUtils;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.metadata.PentahoMetadataDomainRepository;

@Path(value="/data-access/api/metadata")
public class MetadataDatasourceService {
    private static final String OVERWRITE_IN_REPOS = "overwrite";
    private static final String DATASOURCE_ACL = "acl";
    private static final String LANG = "[a-z]{2}";
    private static final String LANG_CC = "[a-z]{2}_[A-Z]{2}";
    private static final String LANG_CC_EXT = "[a-z]{2}_[A-Z]{2}_[^/]+";
    private static final List<String> ENCODINGS = Arrays.asList("", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-32BE", "UTF-32LE", "Shift_JIS", "ISO-2022-JP", "ISO-2022-CN", "ISO-2022-KR", "GB18030", "Big5", "EUC-JP", "EUC-KR", "ISO-8859-1", "ISO-8859-2", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "windows-1251", "windows-1256", "KOI8-R", "ISO-8859-9");
    private static final Pattern[] patterns = new Pattern[]{Pattern.compile("([a-z]{2}).properties$"), Pattern.compile("([a-z]{2}_[A-Z]{2}).properties$"), Pattern.compile("([a-z]{2}_[A-Z]{2}_[^/]+).properties$"), Pattern.compile("([^/]+)_([a-z]{2})\\.properties$"), Pattern.compile("([^/]+)_([a-z]{2}_[A-Z]{2})\\.properties$"), Pattern.compile("([^/]+)_([a-z]{2}_[A-Z]{2}_[^/]+)\\.properties$")};

    @PUT
    @Path(value="/addLocalizationFile")
    @Consumes(value={"application/octet-stream", "text/plain"})
    @Produces(value={"text/plain"})
    @Facet(name="Unsupported")
    public Response addLocalizationFile(@QueryParam(value="domainId") String domainId, @QueryParam(value="locale") String locale, InputStream propertiesFile) throws PentahoAccessControlException {
        try {
            DatasourceService.validateAccess();
            PentahoMetadataDomainRepository metadataImporter = new PentahoMetadataDomainRepository((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
            metadataImporter.addLocalizationFile(domainId, locale, propertiesFile, true);
            return Response.ok((Object)"SUCCESS").type("text/plain").build();
        }
        catch (PentahoAccessControlException e) {
            return Response.serverError().entity((Object)e.toString()).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)Messages.getString("MetadataDatasourceService.ERROR_001_METADATA_DATASOURCE_ERROR")).build();
        }
    }

    @PUT
    @Path(value="/storeDomain")
    @Consumes(value={"application/octet-stream", "text/plain"})
    @Produces(value={"text/plain"})
    @Facet(name="Unsupported")
    public Response storeDomain(InputStream metadataFile, @QueryParam(value="domainId") String domainId) throws PentahoAccessControlException {
        try {
            DatasourceService.validateAccess();
            PentahoMetadataDomainRepository metadataImporter = new PentahoMetadataDomainRepository((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
            metadataImporter.storeDomain(metadataFile, domainId, true);
            return Response.ok((Object)"SUCCESS").type("text/plain").build();
        }
        catch (PentahoAccessControlException e) {
            return Response.serverError().entity((Object)e.toString()).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)Messages.getString("MetadataDatasourceService.ERROR_001_METADATA_DATASOURCE_ERROR")).build();
        }
    }

    @PUT
    @Path(value="/uploadServletImport")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Deprecated
    @Facet(name="Unsupported")
    public Response uploadServletImportMetadataDatasource(String localizeBundleEntries, @QueryParam(value="domainId") String domainId, @QueryParam(value="metadataFile") String metadataFile) throws PentahoAccessControlException {
        try {
            DatasourceService.validateAccess();
        }
        catch (PentahoAccessControlException e) {
            return Response.serverError().entity((Object)e.toString()).build();
        }
        IMetadataDomainRepository metadataDomainRepository = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, (IPentahoSession)PentahoSessionHolder.getSession());
        PentahoMetadataDomainRepository metadataImporter = new PentahoMetadataDomainRepository((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
        CsvUtils csvUtils = new CsvUtils();
        boolean validPropertyFiles = true;
        StringBuffer invalidFiles = new StringBuffer();
        try {
            String TMP_FILE_PATH = File.separatorChar + "system" + File.separatorChar + "tmp" + File.separatorChar;
            String sysTmpDir = PentahoSystem.getApplicationContext().getSolutionPath(TMP_FILE_PATH);
            FileInputStream metadataInputStream = new FileInputStream(sysTmpDir + File.separatorChar + metadataFile);
            metadataImporter.storeDomain((InputStream)metadataInputStream, domainId, true);
            metadataDomainRepository.getDomain(domainId);
            StringTokenizer bundleEntriesParam = new StringTokenizer(localizeBundleEntries, ";");
            block4: while (bundleEntriesParam.hasMoreTokens()) {
                String localizationBundleElement = bundleEntriesParam.nextToken();
                StringTokenizer localizationBundle = new StringTokenizer(localizationBundleElement, "=");
                String localizationFileName = localizationBundle.nextToken();
                String localizationFile = localizationBundle.nextToken();
                if (localizationFileName.endsWith(".properties")) {
                    String encoding = csvUtils.getEncoding(localizationFile);
                    if (ENCODINGS.contains(encoding)) {
                        for (Pattern propertyBundlePattern : patterns) {
                            Matcher propertyBundleMatcher = propertyBundlePattern.matcher(localizationFileName);
                            if (!propertyBundleMatcher.matches()) continue;
                            FileInputStream bundleFileInputStream = new FileInputStream(sysTmpDir + File.separatorChar + localizationFile);
                            metadataImporter.addLocalizationFile(domainId, propertyBundleMatcher.group(2), (InputStream)bundleFileInputStream, true);
                            continue block4;
                        }
                        continue;
                    }
                    validPropertyFiles = false;
                    invalidFiles.append(localizationFileName);
                    continue;
                }
                validPropertyFiles = false;
                invalidFiles.append(localizationFileName);
            }
            if (!validPropertyFiles) {
                return Response.serverError().entity((Object)(Messages.getString("MetadataDatasourceService.ERROR_002_PROPERTY_FILES_ERROR") + invalidFiles.toString())).build();
            }
            return Response.ok((Object)"SUCCESS").type("text/plain").build();
        }
        catch (Exception e) {
            metadataImporter.removeDomain(domainId);
            return Response.serverError().entity((Object)Messages.getString("MetadataDatasourceService.ERROR_001_METADATA_DATASOURCE_ERROR")).build();
        }
    }

    @POST
    @Path(value="/postimport")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @Facet(name="Unsupported")
    public Response importMetadataDatasourceWithPost(@FormDataParam(value="domainId") String domainId, @FormDataParam(value="metadataFile") InputStream metadataFile, @FormDataParam(value="metadataFile") FormDataContentDisposition metadataFileInfo, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="localeFiles") List<FormDataBodyPart> localeFiles, @FormDataParam(value="localeFiles") List<FormDataContentDisposition> localeFilesInfo, @FormDataParam(value="acl") RepositoryFileAclDto acl) throws PentahoAccessControlException {
        Response response = this.importMetadataDatasource(domainId, metadataFile, metadataFileInfo, overwrite, localeFiles, localeFilesInfo, acl);
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder.entity((Object)String.valueOf(response.getStatus()));
        responseBuilder.status(200);
        return responseBuilder.build();
    }

    @PUT
    @Path(value="/import")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @Deprecated
    @Facet(name="Unsupported")
    public Response importMetadataDatasource(@FormDataParam(value="domainId") String domainId, @FormDataParam(value="metadataFile") InputStream metadataFile, @FormDataParam(value="metadataFile") FormDataContentDisposition metadataFileInfo, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="localeFiles") List<FormDataBodyPart> localeFiles, @FormDataParam(value="localeFiles") List<FormDataContentDisposition> localeFilesInfo, @FormDataParam(value="acl") RepositoryFileAclDto acl) {
        return new MetadataResource().importMetadataDatasourceLegacy(domainId, metadataFile, metadataFileInfo, overwrite, localeFiles, localeFilesInfo, acl);
    }
}

