/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.agilebi.modeler.models.SchemaModel;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.service.DatabaseDialectService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.MultiTableDatasourceDTO;

public class LegacyDatasourceConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        MultiTableDatasourceDTO resultDTO = new MultiTableDatasourceDTO();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if (nodeName.equalsIgnoreCase("datasourceName")) {
                String value = reader.getValue();
                resultDTO.setDatasourceName(value);
            } else if (nodeName.equalsIgnoreCase("selectedConnection")) {
                String connectionClass = reader.getAttribute("class");
                if (connectionClass != null) {
                    DatabaseConnection databaseConnection = new DatabaseConnection();
                    if (connectionClass.equals("org.pentaho.platform.dataaccess.datasource.beans.Connection")) {
                        while (reader.hasMoreChildren()) {
                            reader.moveDown();
                            nodeName = reader.getNodeName();
                            if (reader.getNodeName().equalsIgnoreCase("name")) {
                                String databaseName = reader.getValue();
                                databaseConnection.setName(databaseName);
                                databaseConnection.setId(databaseName);
                            } else if (reader.getNodeName().equalsIgnoreCase("username")) {
                                databaseConnection.setUsername(reader.getValue());
                            } else if (reader.getNodeName().equalsIgnoreCase("password")) {
                                databaseConnection.setPassword(reader.getValue());
                            } else if (reader.getNodeName().equalsIgnoreCase("url")) {
                                ParsedJdbcUrl parsedJdbcUrl = new ParsedJdbcUrl(reader.getValue());
                                databaseConnection.setHostname(parsedJdbcUrl.getHostname());
                                databaseConnection.setDatabasePort(parsedJdbcUrl.getPort());
                                databaseConnection.setDatabaseName(parsedJdbcUrl.getDatabaseName());
                                databaseConnection.setDatabaseType(this.resolveDatabaseType(parsedJdbcUrl.getJdbcPrefix()));
                            }
                            reader.moveUp();
                        }
                        resultDTO.setSelectedConnection((IDatabaseConnection)databaseConnection);
                    } else {
                        try {
                            Class<?> databaseConnectionClass = Class.forName(connectionClass);
                            IDatabaseConnection databaseConnectionInstance = (IDatabaseConnection)context.convertAnother((Object)resultDTO, databaseConnectionClass);
                            resultDTO.setSelectedConnection(databaseConnectionInstance);
                        }
                        catch (ClassNotFoundException e) {
                            resultDTO.setSelectedConnection((IDatabaseConnection)new DatabaseConnection());
                        }
                    }
                }
            } else if (nodeName.equalsIgnoreCase("schemaModel")) {
                SchemaModel schemaModel = (SchemaModel)context.convertAnother((Object)resultDTO, SchemaModel.class);
                if (schemaModel != null) {
                    resultDTO.setSchemaModel(schemaModel);
                }
            } else if (nodeName.equalsIgnoreCase("selectedTables")) {
                List selectedTables = (List)context.convertAnother((Object)resultDTO, ArrayList.class);
                if (selectedTables != null) {
                    resultDTO.setSelectedTables(selectedTables);
                }
            } else if (nodeName.equalsIgnoreCase("doOlap")) {
                resultDTO.setDoOlap(Boolean.valueOf(reader.getValue()));
            }
            reader.moveUp();
        }
        return resultDTO;
    }

    public boolean canConvert(Class type) {
        return type.isAssignableFrom(MultiTableDatasourceDTO.class);
    }

    private IDatabaseType resolveDatabaseType(String urlPrefix) {
        DatabaseDialectService databaseDialectService = new DatabaseDialectService(false);
        List databaseDialects = databaseDialectService.getDatabaseDialects();
        String nativePre = null;
        for (IDatabaseDialect databaseDialect : databaseDialects) {
            nativePre = databaseDialect.getNativeJdbcPre();
            if (nativePre == null || !nativePre.startsWith(urlPrefix)) continue;
            return databaseDialect.getDatabaseType();
        }
        return null;
    }

    private class ParsedJdbcUrl {
        private String hostname;
        private String port;
        private String databaseName;
        private String jdbcPrefix;

        ParsedJdbcUrl(String jdbcUrl) {
            this.parseUrl(jdbcUrl);
        }

        void parseUrl(String jdbcUrl) {
            String[] urlParts = jdbcUrl.split(":");
            String port = "";
            String hostname = "";
            String databaseName = urlParts[urlParts.length - 1];
            databaseName = databaseName.replaceAll(".*[/|:]", "");
            databaseName = databaseName.replaceAll("[^a-zA-Z0-9\\-_]+.*", "");
            for (int x = 0; x <= urlParts.length - 1; ++x) {
                String part = urlParts[x];
                if (!part.matches("^[\\d]+.*")) continue;
                port = part.replaceAll("[/|:].*", "");
                port = port.replaceAll("[^\\d]+", "");
                hostname = urlParts[x - 1];
                hostname = hostname.contains("@") ? hostname.replaceAll(".*@\\W*", "") : hostname.replaceAll("[^a-zA-Z0-9\\-.]", "");
            }
            if (hostname.isEmpty()) {
                if (jdbcUrl.contains("//")) {
                    urlParts = jdbcUrl.split("//");
                    hostname = urlParts[urlParts.length - 1];
                    hostname = hostname.replaceAll("[\\W].*", "");
                } else if (jdbcUrl.contains("@")) {
                    urlParts = jdbcUrl.split("@");
                    hostname = urlParts[urlParts.length - 1];
                }
            }
            this.hostname = hostname;
            this.port = port;
            this.databaseName = databaseName;
            this.jdbcPrefix = urlParts[0] + ":" + urlParts[1];
        }

        private String getHostname() {
            return this.hostname;
        }

        private String getPort() {
            return this.port;
        }

        private String getDatabaseName() {
            return this.databaseName;
        }

        private String getJdbcPrefix() {
            return this.jdbcPrefix;
        }
    }
}

