/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils;

import org.apache.commons.lang.StringEscapeUtils;
import org.pentaho.database.model.IDatabaseConnection;

public class UtilHtmlSanitizer {
    private static UtilHtmlSanitizer sanitizerInstance;

    private UtilHtmlSanitizer() {
    }

    public static synchronized UtilHtmlSanitizer getInstance() {
        if (sanitizerInstance == null) {
            sanitizerInstance = new UtilHtmlSanitizer();
        }
        return sanitizerInstance;
    }

    public void sanitizeConnectionParameters(IDatabaseConnection connection) {
        String safeName = this.safeEscapeHtml(connection.getName());
        connection.setName(safeName);
        String safeDbName = this.safeEscapeHtml(connection.getDatabaseName());
        connection.setDatabaseName(safeDbName);
        String safeDbPort = this.safeEscapeHtml(connection.getDatabasePort());
        connection.setDatabasePort(safeDbPort);
        String safeHostname = this.safeEscapeHtml(connection.getHostname());
        connection.setHostname(safeHostname);
        String safePassword = this.safeEscapeHtml(connection.getPassword());
        connection.setPassword(safePassword);
        String safeUsername = this.safeEscapeHtml(connection.getUsername());
        connection.setUsername(safeUsername);
    }

    public void unsanitizeConnectionParameters(IDatabaseConnection connection) {
        String safeName = StringEscapeUtils.unescapeHtml((String)connection.getName());
        connection.setName(safeName);
        String safeDbName = StringEscapeUtils.unescapeHtml((String)connection.getDatabaseName());
        connection.setDatabaseName(safeDbName);
        String safeDbPort = StringEscapeUtils.unescapeHtml((String)connection.getDatabasePort());
        connection.setDatabasePort(safeDbPort);
        String safeHostname = StringEscapeUtils.unescapeHtml((String)connection.getHostname());
        connection.setHostname(safeHostname);
        String safePassword = StringEscapeUtils.unescapeHtml((String)connection.getPassword());
        connection.setPassword(safePassword);
        String safeUsername = StringEscapeUtils.unescapeHtml((String)connection.getUsername());
        connection.setUsername(safeUsername);
    }

    public String safeEscapeHtml(String html) {
        return StringEscapeUtils.escapeHtml((String)StringEscapeUtils.unescapeHtml((String)html));
    }

    public String escape(String stringToEscape) {
        return StringEscapeUtils.escapeHtml((String)stringToEscape);
    }
}

