/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable;

import java.util.ArrayList;
import org.pentaho.agilebi.modeler.models.JoinRelationshipModel;
import org.pentaho.agilebi.modeler.models.JoinTableModel;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IWizardModel;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable.JoinError;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable.MultitableGuiModel;

public class JoinValidator {
    private MultitableGuiModel joinGuiModel;
    private JoinError error;

    public JoinValidator(MultitableGuiModel joinGuiModel, IWizardModel wizardModel) {
        this.joinGuiModel = joinGuiModel;
    }

    public boolean isValid(JoinRelationshipModel join) {
        return this.notDuplicate(join) && this.notSelfJoin(join) && this.notCircularJoins(join);
    }

    private boolean notDuplicate(JoinRelationshipModel newJoin) {
        boolean notDuplicate = true;
        for (JoinRelationshipModel join : this.joinGuiModel.getJoins()) {
            if (!newJoin.equals(join)) continue;
            notDuplicate = false;
            this.error = new JoinError(MessageHandler.getString("multitable.DUPLICATE_JOIN_TITLE"), MessageHandler.getString("multitable.DUPLICATE_JOIN_ERROR"));
            break;
        }
        return notDuplicate;
    }

    private boolean notSelfJoin(JoinRelationshipModel newJoin) {
        boolean notSelfJoin;
        boolean bl = notSelfJoin = !newJoin.getLeftKeyFieldModel().getParentTable().equals((Object)newJoin.getRightKeyFieldModel().getParentTable());
        if (!notSelfJoin) {
            this.error = new JoinError(MessageHandler.getString("multitable.SELF_JOIN_TITLE"), MessageHandler.getString("multitable.SELF_JOIN_ERROR"));
        }
        return notSelfJoin;
    }

    private boolean notCircularJoins(JoinRelationshipModel newJoin) {
        boolean notCircularJoin = true;
        return notCircularJoin;
    }

    public boolean hasTablesSelected() {
        return !this.joinGuiModel.getSelectedTables().isEmpty();
    }

    private boolean isSingleTable() {
        return this.joinGuiModel.getSelectedTables().size() == 1;
    }

    public boolean allTablesJoined() {
        if (this.isSingleTable()) {
            return true;
        }
        ArrayList<String> orphanedTables = new ArrayList<String>();
        block0: for (JoinTableModel table : this.joinGuiModel.getSelectedTables()) {
            for (JoinRelationshipModel join : this.joinGuiModel.getJoins()) {
                JoinTableModel table1 = join.getLeftKeyFieldModel().getParentTable();
                JoinTableModel table2 = join.getRightKeyFieldModel().getParentTable();
                if (!table.equals((Object)table1) && !table.equals((Object)table2)) continue;
                continue block0;
            }
            orphanedTables.add(table.getName());
        }
        if (!orphanedTables.isEmpty()) {
            StringBuffer tables = new StringBuffer();
            for (String table : orphanedTables) {
                tables.append(" " + table + ", ");
            }
            this.error = new JoinError(MessageHandler.getString("multitable.ORPHANED_TABLES_TITLE"), MessageHandler.getString("multitable.ORPHANED_TABLES") + tables.substring(0, tables.lastIndexOf(",")));
        }
        return orphanedTables.isEmpty();
    }

    public JoinError getError() {
        return this.error;
    }
}

