/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pentaho.agilebi.modeler.models.JoinFieldModel;
import org.pentaho.agilebi.modeler.models.JoinRelationshipModel;
import org.pentaho.agilebi.modeler.models.JoinTableModel;
import org.pentaho.agilebi.modeler.models.SchemaModel;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.MultiTableDatasourceDTO;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractModelList;

public class MultitableGuiModel
extends XulEventSourceAdapter {
    private List<String> schemas;
    private AbstractModelList<JoinRelationshipModel> joins;
    private AbstractModelList<JoinTableModel> selectedTables;
    private AbstractModelList<JoinTableModel> availableTables = new AbstractModelList();
    private AbstractModelList<JoinTableModel> leftTables;
    private AbstractModelList<JoinTableModel> rightTables;
    private JoinTableModel leftJoinTable;
    private JoinTableModel rightJoinTable;
    private JoinFieldModel leftKeyField;
    private JoinFieldModel rightKeyField;
    private JoinRelationshipModel selectedJoin;
    private JoinTableModel factTable;
    private boolean doOlap;

    public MultitableGuiModel() {
        this.selectedTables = new AbstractModelList();
        this.leftTables = new AbstractModelList();
        this.rightTables = new AbstractModelList();
        this.joins = new AbstractModelList();
        this.leftJoinTable = new JoinTableModel();
        this.rightJoinTable = new JoinTableModel();
        this.selectedJoin = new JoinRelationshipModel();
        this.schemas = new AbstractModelList();
    }

    @Bindable
    public AbstractModelList<JoinTableModel> getAvailableTables() {
        return this.availableTables;
    }

    @Bindable
    public void setAvailableTables(AbstractModelList<JoinTableModel> availableTables) {
        this.availableTables.setChildren(availableTables);
    }

    @Bindable
    public void setSchemas(List<String> schemas) {
        List<String> previousValue = this.schemas;
        this.schemas = schemas;
        this.firePropertyChange("schemas", previousValue, schemas);
    }

    @Bindable
    public List<String> getSchemas() {
        return this.schemas;
    }

    @Bindable
    public AbstractModelList<JoinTableModel> getSelectedTables() {
        return this.selectedTables;
    }

    @Bindable
    public void setSelectedTables(AbstractModelList<JoinTableModel> selectedTables) {
        this.selectedTables = selectedTables;
    }

    @Bindable
    public JoinTableModel getLeftJoinTable() {
        return this.leftJoinTable;
    }

    @Bindable
    public void setLeftJoinTable(JoinTableModel leftJoinTable) {
        this.leftJoinTable = leftJoinTable;
    }

    @Bindable
    public JoinTableModel getRightJoinTable() {
        return this.rightJoinTable;
    }

    @Bindable
    public void setRightJoinTable(JoinTableModel rightJoinTable) {
        this.rightJoinTable = rightJoinTable;
    }

    @Bindable
    public JoinFieldModel getLeftKeyField() {
        return this.leftKeyField;
    }

    @Bindable
    public void setLeftKeyField(JoinFieldModel leftKeyField) {
        this.leftKeyField = leftKeyField;
    }

    @Bindable
    public JoinFieldModel getRightKeyField() {
        return this.rightKeyField;
    }

    @Bindable
    public void setRightKeyField(JoinFieldModel rightKeyField) {
        this.rightKeyField = rightKeyField;
    }

    @Bindable
    public AbstractModelList<JoinRelationshipModel> getJoins() {
        return this.joins;
    }

    @Bindable
    public void setJoins(AbstractModelList<JoinRelationshipModel> joins) {
        this.joins = joins;
    }

    @Bindable
    public JoinRelationshipModel getSelectedJoin() {
        return this.selectedJoin;
    }

    @Bindable
    public void setSelectedJoin(JoinRelationshipModel selectedJoin) {
        this.selectedJoin = selectedJoin;
    }

    @Bindable
    public JoinTableModel getFactTable() {
        return this.factTable;
    }

    @Bindable
    public void setFactTable(JoinTableModel factTable) {
        this.factTable = factTable;
    }

    public void addJoin(JoinRelationshipModel join) {
        this.joins.add((Object)join);
        this.selectedJoin = join;
    }

    public void removeSelectedJoin() {
        this.joins.remove((Object)this.selectedJoin);
        this.selectedJoin = this.joins == null || this.joins.asList().isEmpty() ? null : (JoinRelationshipModel)this.joins.asList().get(0);
    }

    public void addSelectedTable(JoinTableModel table) {
        this.availableTables.remove((Object)table);
        this.selectedTables.add((Object)table);
    }

    public void addSelectedTables(List<JoinTableModel> selected) {
        this.availableTables.removeAll(selected);
        this.selectedTables.addAll(selected);
    }

    public void removeSelectedTables(List<JoinTableModel> selected) {
        this.selectedTables.removeAll(selected);
        this.availableTables.addAll(selected);
    }

    public void removeSelectedTable(JoinTableModel table) {
        this.selectedTables.remove((Object)table);
        this.availableTables.add((Object)table);
    }

    @Bindable
    public AbstractModelList<JoinTableModel> getLeftTables() {
        return this.leftTables;
    }

    @Bindable
    public AbstractModelList<JoinTableModel> getRightTables() {
        return this.rightTables;
    }

    @Bindable
    public boolean isDoOlap() {
        return this.doOlap;
    }

    @Bindable
    public void setDoOlap(boolean isStar) {
        boolean origStar = this.doOlap;
        this.doOlap = isStar;
        this.firePropertyChange("doOlap", origStar, isStar);
    }

    public void computeJoinDefinitionStepTables() {
        this.leftTables.clear();
        this.rightTables.clear();
        if (this.doOlap) {
            this.leftTables.add((Object)this.factTable);
            for (JoinTableModel table : this.selectedTables) {
                if (table.equals((Object)this.factTable)) continue;
                this.rightTables.add((Object)table);
            }
        } else {
            this.leftTables.addAll(this.selectedTables);
            this.rightTables.addAll(this.selectedTables);
        }
    }

    public void processAvailableTables(List<String> tables) {
        ArrayList<JoinTableModel> joinTables = new ArrayList<JoinTableModel>();
        if (tables.size() > 0) {
            block0: for (String table : tables) {
                JoinTableModel joinTable = new JoinTableModel();
                joinTable.setName(table);
                for (JoinTableModel selectedTable : this.selectedTables.getChildren()) {
                    if (!selectedTable.equals((Object)joinTable)) continue;
                    continue block0;
                }
                joinTables.add(joinTable);
            }
            Collections.sort(joinTables, new Comparator<JoinTableModel>(){

                @Override
                public int compare(JoinTableModel joinTableModel, JoinTableModel joinTableModel1) {
                    return joinTableModel.getName().compareTo(joinTableModel1.getName());
                }
            });
        }
        this.setAvailableTables((AbstractModelList<JoinTableModel>)new AbstractModelList(joinTables));
    }

    @Deprecated
    public List<LogicalRelationship> generateLogicalRelationships(List<JoinRelationshipModel> joins) {
        String locale = "en_US";
        ArrayList<LogicalRelationship> logicalRelationships = new ArrayList<LogicalRelationship>();
        for (JoinRelationshipModel join : joins) {
            LogicalTable fromTable = new LogicalTable();
            fromTable.setName(new LocalizedString(locale, join.getLeftKeyFieldModel().getParentTable().getName()));
            LogicalTable toTable = new LogicalTable();
            toTable.setName(new LocalizedString(locale, join.getRightKeyFieldModel().getParentTable().getName()));
            LogicalColumn fromColumn = new LogicalColumn();
            fromColumn.setName(new LocalizedString(locale, join.getLeftKeyFieldModel().getName()));
            LogicalColumn toColumn = new LogicalColumn();
            toColumn.setName(new LocalizedString(locale, join.getRightKeyFieldModel().getName()));
            LogicalRelationship logicalRelationship = new LogicalRelationship();
            logicalRelationship.setFromTable(fromTable);
            logicalRelationship.setToTable(toTable);
            logicalRelationship.setFromColumn(fromColumn);
            logicalRelationship.setToColumn(toColumn);
            logicalRelationships.add(logicalRelationship);
        }
        return logicalRelationships;
    }

    public MultiTableDatasourceDTO createMultiTableDatasourceDTO(String dsName) {
        MultiTableDatasourceDTO dto = new MultiTableDatasourceDTO();
        dto.setDoOlap(this.doOlap);
        dto.setDatasourceName(dsName);
        ArrayList<String> selectedTables = new ArrayList<String>();
        for (JoinTableModel tbl : this.selectedTables) {
            selectedTables.add(tbl.getName());
        }
        dto.setSelectedTables(selectedTables);
        SchemaModel schema = new SchemaModel();
        schema.setJoins(this.getJoins());
        schema.setFactTable(this.factTable);
        dto.setSchemaModel(schema);
        return dto;
    }

    public void populateJoinGuiModel(Domain domain, MultiTableDatasourceDTO dto, List tables) {
        this.selectedTables.clear();
        AbstractModelList selectedTablesList = new AbstractModelList();
        if (dto != null) {
            for (String selectedTable : dto.getSelectedTables()) {
                this.selectTable(selectedTable, (AbstractModelList<JoinTableModel>)selectedTablesList, tables);
            }
            this.selectedTables.addAll((Collection)selectedTablesList);
            this.computeJoins(dto);
            if (dto.isDoOlap()) {
                for (JoinTableModel table : this.selectedTables) {
                    if (!this.tablesAreEqual(table.getName(), dto.getSchemaModel().getFactTable().getName())) continue;
                    this.setFactTable(table);
                    break;
                }
            }
        }
        this.processAvailableTables(tables);
        if (domain != null) {
            this.addFieldsToTables(domain, this.availableTables);
        }
    }

    private void computeJoins(MultiTableDatasourceDTO dto) {
        this.joins.clear();
        for (JoinRelationshipModel join : dto.getSchemaModel().getJoins()) {
            for (JoinTableModel selectedTable : this.selectedTables) {
                if (this.tablesAreEqual(selectedTable.getName(), join.getLeftKeyFieldModel().getParentTable().getName())) {
                    join.getLeftKeyFieldModel().getParentTable().setName(selectedTable.getName());
                    continue;
                }
                if (!this.tablesAreEqual(selectedTable.getName(), join.getRightKeyFieldModel().getParentTable().getName())) continue;
                join.getRightKeyFieldModel().getParentTable().setName(selectedTable.getName());
            }
        }
        this.joins.addAll((Collection)dto.getSchemaModel().getJoins());
    }

    public int getTableIndex(JoinTableModel joinTable) {
        return this.getSelectedTables() == null || this.getSelectedTables().isEmpty() ? 0 : this.getSelectedTables().indexOf((Object)joinTable);
    }

    private void addFieldsToTables(Domain domain, AbstractModelList<JoinTableModel> availableTables) {
        String locale = "en_US";
        block0: for (JoinTableModel table : availableTables) {
            for (LogicalTable tbl : ((LogicalModel)domain.getLogicalModels().get(0)).getLogicalTables()) {
                if (!tbl.getPhysicalTable().getProperty("target_table").equals(table.getName())) continue;
                for (LogicalColumn col : tbl.getLogicalColumns()) {
                    JoinFieldModel field = new JoinFieldModel();
                    field.setName(col.getName(locale));
                    field.setParentTable(table);
                    table.getFields().add((Object)field);
                }
                continue block0;
            }
        }
    }

    private void selectTable(String selectedTable, AbstractModelList<JoinTableModel> selectedTablesList, List databaseTables) {
        for (Object table : databaseTables) {
            if (!this.tablesAreEqual(table.toString(), selectedTable) || selectedTablesList.contains(table)) continue;
            JoinTableModel joinTable = new JoinTableModel();
            joinTable.setName(table.toString());
            selectedTablesList.add((Object)joinTable);
        }
    }

    public void reset() {
        this.availableTables.clear();
        this.selectedTables.clear();
        this.joins.clear();
        this.schemas.clear();
        this.leftTables.clear();
        this.rightTables.clear();
        this.leftKeyField = null;
        this.rightKeyField = null;
        this.selectedJoin = null;
        this.factTable = null;
        this.leftJoinTable = null;
        this.rightJoinTable = null;
    }

    private boolean tablesAreEqual(String table1, String table2) {
        String tableName1 = this.getSchemaTablePair(table1)[1];
        String tableName2 = this.getSchemaTablePair(table2)[1];
        return tableName1.equals(tableName2);
    }

    private String[] getSchemaTablePair(String table) {
        if (table.indexOf(".") < 0) {
            return new String[]{"", table};
        }
        String[] pair = new String[2];
        String[] parts = table.split("\\.");
        pair[0] = parts[0];
        String tableName = "";
        for (int i = 1; i < parts.length; ++i) {
            tableName = tableName + "." + parts[i];
        }
        pair[1] = tableName.substring(1);
        return pair;
    }
}

