/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.metadata.model;

import java.io.Serializable;

public enum Operator implements Serializable
{
    GREATER_THAN(">", 1, true),
    LESS_THAN("<", 1, true),
    EQUAL("=", 1, true),
    GREATOR_OR_EQUAL(">=", 1, true),
    LESS_OR_EQUAL("<=", 1, true),
    EXACTLY_MATCHES("EXACTLY MATCHES", 0, true),
    CONTAINS("CONTAINS", 0, true),
    DOES_NOT_CONTAIN("DOES NOT CONTAIN", 0, true),
    BEGINS_WITH("BEGINS WITH", 0, true),
    ENDS_WITH("ENDS WITH", 0, true),
    IS_NULL("IS NULL", 2, false),
    IS_NOT_NULL("IS NOT NULL", 2, false);

    private String strVal;
    private int operatorType;
    private boolean requiresValue;

    private Operator(String str, int operatorType, boolean requiresValue) {
        this.strVal = str;
        this.operatorType = operatorType;
        this.requiresValue = requiresValue;
    }

    public String toString() {
        return this.strVal;
    }

    public static Operator parse(String val) {
        if (val == null || val.equals("")) {
            return EQUAL;
        }
        if ((val = val.toUpperCase()).equals(">")) {
            return GREATER_THAN;
        }
        if (val.equals(">=")) {
            return GREATOR_OR_EQUAL;
        }
        if (val.equals("=")) {
            return EQUAL;
        }
        if (val.equals("<")) {
            return LESS_THAN;
        }
        if (val.equals("<=")) {
            return LESS_OR_EQUAL;
        }
        if (val.equals("EXACTLY MATCHES")) {
            return EXACTLY_MATCHES;
        }
        if (val.equals("CONTAINS")) {
            return CONTAINS;
        }
        if (val.equals("DOES NOT CONTAIN")) {
            return DOES_NOT_CONTAIN;
        }
        if (val.equals("BEGINS WITH")) {
            return BEGINS_WITH;
        }
        if (val.equals("ENDS WITH")) {
            return ENDS_WITH;
        }
        if (val.equals("IS NULL")) {
            return IS_NULL;
        }
        if (val.equals("IS NOT NULL")) {
            return IS_NOT_NULL;
        }
        if (val.equals("CONTAINS")) {
            return CONTAINS;
        }
        if (val.equals("BEGINSWITH")) {
            return BEGINS_WITH;
        }
        if (val.equals("ENDSWITH")) {
            return ENDS_WITH;
        }
        if (val.equals("ISNA")) {
            return IS_NULL;
        }
        return EQUAL;
    }

    public boolean requiresValue() {
        return this.requiresValue;
    }

    public String formatCondition(String columnName, String paramName, String[] value, boolean parameterized) {
        if (parameterized) {
            value = new String[]{"[param:" + paramName.replaceAll("[\\{\\}]", "") + "]"};
        } else if (this.operatorType == 0 || this.operatorType == 2) {
            for (int idx = 0; idx < value.length; ++idx) {
                if (value[idx].startsWith("\"") || value[idx].endsWith("\"")) continue;
                value[idx] = "\"" + value[idx] + "\"";
            }
        }
        String retVal = "";
        switch (this) {
            case EXACTLY_MATCHES: {
                if (value.length == 1) {
                    retVal = retVal + columnName + " = " + value[0];
                    break;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("IN(").append(columnName).append("; ");
                for (int idx = 0; idx < value.length; ++idx) {
                    if (idx > 0) {
                        sb.append(";");
                    }
                    sb.append(value[idx]);
                }
                sb.append(")");
                retVal = sb.toString();
                break;
            }
            case CONTAINS: {
                retVal = retVal + "CONTAINS(" + columnName + ";" + value[0] + ")";
                break;
            }
            case DOES_NOT_CONTAIN: {
                retVal = retVal + "NOT(CONTAINS(" + columnName + ";" + value[0] + "))";
                break;
            }
            case BEGINS_WITH: {
                retVal = retVal + "BEGINSWITH(" + columnName + ";" + value[0] + ")";
                break;
            }
            case ENDS_WITH: {
                retVal = retVal + "ENDSWITH(" + columnName + ";" + value[0] + ")";
                break;
            }
            case IS_NULL: {
                retVal = retVal + "ISNA(" + columnName + ")";
                break;
            }
            case IS_NOT_NULL: {
                retVal = retVal + "NOT(ISNA(" + columnName + "))";
                break;
            }
            default: {
                retVal = columnName + " " + this.toString();
                if (!this.requiresValue) break;
                retVal = retVal + value[0];
            }
        }
        return retVal;
    }
}

