/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.plugins.common.ui;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.plugins.common.ui.ClusterTestDialog;
import org.pentaho.big.data.plugins.common.ui.ClusterTestResultsDialog;
import org.pentaho.big.data.plugins.common.ui.NamedClusterComposite;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.HelpUtils;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.runtime.test.RuntimeTestStatus;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;

public class NamedClusterDialogImpl
extends Dialog {
    private static final int RESULT_NO = 1;
    private static final int DIALOG_WIDTH = 459;
    private static Class<?> PKG = NamedClusterDialogImpl.class;
    private final NamedClusterService namedClusterService;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    private Shell shell;
    private PropsUI props;
    private NamedCluster originalNamedCluster;
    private NamedCluster namedCluster;
    private boolean newClusterCheck = false;
    private String result;

    public NamedClusterDialogImpl(Shell parent, NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester) {
        this(parent, namedClusterService, runtimeTestActionService, runtimeTester, null);
    }

    public NamedClusterDialogImpl(Shell parent, NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester, NamedCluster namedCluster) {
        super(parent);
        this.namedClusterService = namedClusterService;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
        this.props = PropsUI.getInstance();
        this.namedCluster = namedCluster;
        this.originalNamedCluster = namedCluster == null ? null : namedCluster.clone();
    }

    public NamedCluster getNamedCluster() {
        return this.namedCluster;
    }

    public void setNamedCluster(NamedCluster namedCluster) {
        this.namedCluster = namedCluster;
        this.originalNamedCluster = namedCluster.clone();
    }

    public boolean isNewClusterCheck() {
        return this.newClusterCheck;
    }

    public void setNewClusterCheck(boolean newClusterCheck) {
        this.newClusterCheck = newClusterCheck;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 2161);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        this.shell.setMinimumSize(459, 458);
        this.shell.setText(BaseMessages.getString(PKG, (String)"NamedClusterDialog.Shell.Title", (String[])new String[0]));
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        BaseStepDialog.setSize((Shell)this.shell);
        String docUrl = Const.getDocUrl((String)BaseMessages.getString(PKG, (String)"NamedClusterDialog.Shell.Doc", (String[])new String[0]));
        PluginInterface plugin = PluginRegistry.getInstance().findPluginWithId(LifecyclePluginType.class, "HadoopSpoonPlugin");
        HelpUtils.createHelpButton((Composite)this.shell, (String)HelpUtils.getHelpDialogTitle((PluginInterface)plugin), (String)docUrl, (String)BaseMessages.getString(PKG, (String)"NamedClusterDialog.Shell.Title", (String[])new String[0]));
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fd = new FormData();
        Button wOK = new Button((Composite)this.shell, 8);
        wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        Button wTest = new Button((Composite)this.shell, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"System.Button.Test", (String[])new String[0]));
        Button[] buttons = new Button[]{wTest, wOK, wCancel};
        BaseStepDialog.positionBottomRightButtons((Composite)this.shell, (Button[])buttons, (int)5, null);
        Label bottomSeparator = new Label((Composite)this.shell, 258);
        fd = new FormData();
        fd.bottom = new FormAttachment((Control)wCancel, -15);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        bottomSeparator.setLayoutData((Object)fd);
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.shell, 512);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment((Control)bottomSeparator, -15);
        scrolledComposite.setLayoutData((Object)fd);
        this.props.setLook((Control)scrolledComposite);
        NamedClusterComposite namedClusterComposite = new NamedClusterComposite((Composite)scrolledComposite, this.namedCluster, this.props, this.namedClusterService);
        scrolledComposite.setContent((Control)namedClusterComposite);
        namedClusterComposite.pack();
        wTest.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    RuntimeTestStatus testStatus = ClusterTestDialog.create(NamedClusterDialogImpl.this.shell, NamedClusterDialogImpl.this.getNamedCluster(), NamedClusterDialogImpl.this.runtimeTester).open();
                    if (testStatus != null) {
                        try {
                            new ClusterTestResultsDialog(NamedClusterDialogImpl.this.shell, NamedClusterDialogImpl.this.runtimeTestActionService, testStatus).open();
                        }
                        catch (KettleException ke) {
                            new ErrorDialog(NamedClusterDialogImpl.this.shell, BaseMessages.getString((Class)PKG, (String)"ClusterTestResultsDialog.FailedToOpen", (String[])new String[0]), ke.getMessage(), (Exception)((Object)ke));
                        }
                    }
                }
                catch (KettleException e) {
                    new ErrorDialog(NamedClusterDialogImpl.this.shell, BaseMessages.getString((Class)PKG, (String)"NamedClusterDialog.DialogError", (String[])new String[0]), e.getMessage(), (Exception)((Object)e));
                }
            }
        });
        wOK.addListener(13, e -> this.ok());
        wCancel.addListener(13, e -> this.cancel());
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                NamedClusterDialogImpl.this.cancel();
            }
        });
        namedClusterComposite.setStateChangeListener(() -> {
            boolean enabled;
            boolean bl = enabled = !this.namedCluster.isUseGateway() || StringUtils.isNotBlank((String)this.namedCluster.getName()) && StringUtils.isNotBlank((String)this.namedCluster.getGatewayUrl()) && StringUtils.isNotBlank((String)this.namedCluster.getGatewayUsername()) && StringUtils.isNotBlank((String)this.namedCluster.getGatewayPassword());
            if (wOK.isEnabled() != enabled) {
                wOK.setEnabled(enabled);
            }
        });
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void cancel() {
        this.result = null;
        this.dispose();
    }

    public void ok() {
        this.result = this.namedCluster.getName();
        if (StringUtils.isBlank((String)this.result)) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"NamedClusterDialog.Error", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"NamedClusterDialog.ClusterNameMissing", (String[])new String[0]));
            mb.open();
            return;
        }
        if (this.newClusterCheck || !this.originalNamedCluster.getName().equals(this.result)) {
            try {
                String doNotReplaceButton;
                String replaceButton;
                String message;
                String title;
                MessageDialog dialog;
                NamedCluster fetched = this.namedClusterService.read(this.result, (IMetaStore)Spoon.getInstance().getMetaStore());
                if (fetched != null && 1 == (dialog = new MessageDialog(this.shell, title = BaseMessages.getString(PKG, (String)"NamedClusterDialog.ClusterNameExists.Title", (String[])new String[0]), null, message = BaseMessages.getString(PKG, (String)"NamedClusterDialog.ClusterNameExists", (String[])new String[]{this.result}), 4, new String[]{replaceButton = BaseMessages.getString(PKG, (String)"NamedClusterDialog.ClusterNameExists.Replace", (String[])new String[0]), doNotReplaceButton = BaseMessages.getString(PKG, (String)"NamedClusterDialog.ClusterNameExists.DoNotReplace", (String[])new String[0])}, 0)).open()) {
                    return;
                }
            }
            catch (MetaStoreException metaStoreException) {
                // empty catch block
            }
        }
        this.dispose();
    }
}

