/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.impl.logicalLayer.schema.Schema;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FuncSpec
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2L;
    String className = null;
    String[] ctorArgs = null;
    Schema inputArgsSchema = null;

    public FuncSpec(String className, String ctorArg) {
        this.className = className;
        this.ctorArgs = new String[1];
        this.ctorArgs[0] = ctorArg;
    }

    public FuncSpec(String className, String[] ctorArgs) {
        this.className = className;
        this.ctorArgs = ctorArgs;
    }

    public FuncSpec(String className, String[] ctorArgs, Schema inputArgsSchema) {
        this(className, ctorArgs);
        this.inputArgsSchema = inputArgsSchema;
    }

    public FuncSpec(String funcSpec) {
        this.className = FuncSpec.getClassNameFromSpec(funcSpec);
        List<String> args = FuncSpec.parseArguments(FuncSpec.getArgStringFromSpec(funcSpec));
        if (args.size() > 0) {
            this.ctorArgs = new String[args.size()];
            int i = 0;
            Iterator<String> iterator = args.iterator();
            while (iterator.hasNext()) {
                this.ctorArgs[i++] = iterator.next();
            }
        }
    }

    public FuncSpec(String funcSpec, Schema inputArgsSchema) {
        this(funcSpec);
        this.inputArgsSchema = inputArgsSchema;
    }

    public static String getClassNameFromSpec(String funcSpec) {
        int paren = funcSpec.indexOf(40);
        if (paren != -1) {
            return funcSpec.substring(0, paren);
        }
        return funcSpec;
    }

    public static String getArgStringFromSpec(String funcSpec) {
        int paren = funcSpec.indexOf(40);
        if (paren != -1) {
            return funcSpec.substring(paren + 1);
        }
        return "";
    }

    public static List<String> parseArguments(String argString) {
        ArrayList<String> args = new ArrayList<String>();
        int startIndex = 0;
        while (startIndex < argString.length()) {
            int endIndex;
            while (startIndex < argString.length() && argString.charAt(startIndex++) != '\'') {
            }
            for (endIndex = startIndex; endIndex < argString.length() && argString.charAt(endIndex) != '\''; ++endIndex) {
                if (argString.charAt(endIndex) != '\\') continue;
                ++endIndex;
            }
            if (endIndex < argString.length()) {
                args.add(argString.substring(startIndex, endIndex));
            }
            startIndex = endIndex + 1;
        }
        return args;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String[] getCtorArgs() {
        return this.ctorArgs;
    }

    public void setCtorArgs(String[] ctorArgs) {
        this.ctorArgs = ctorArgs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.className);
        if (this.ctorArgs != null) {
            sb.append("(");
            for (int i = 0; i < this.ctorArgs.length; ++i) {
                sb.append("'");
                sb.append(this.ctorArgs[i]);
                sb.append("'");
                if (i == this.ctorArgs.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public Schema getInputArgsSchema() {
        return this.inputArgsSchema;
    }

    public void setInputArgsSchema(Schema inputArgsSchema) {
        this.inputArgsSchema = inputArgsSchema;
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof FuncSpec) {
            FuncSpec ofs = (FuncSpec)other;
            if (!this.className.equals(ofs.className)) {
                return false;
            }
            if (this.ctorArgs == null && ofs.ctorArgs != null || this.ctorArgs != null && ofs.ctorArgs == null) {
                return false;
            }
            if (this.ctorArgs != null && ofs.ctorArgs != null) {
                if (this.ctorArgs.length != ofs.ctorArgs.length) {
                    return false;
                }
                for (int i = 0; i < this.ctorArgs.length; ++i) {
                    if (this.ctorArgs[i].equals(ofs.ctorArgs[i])) continue;
                    return false;
                }
            }
            return Schema.equals(this.inputArgsSchema, ofs.inputArgsSchema, false, true);
        }
        return false;
    }

    public int hashCode() {
        return this.getClassName().hashCode() + this.ctorArgs.length;
    }

    public FuncSpec clone() throws CloneNotSupportedException {
        String[] args = null;
        if (this.ctorArgs != null) {
            args = new String[this.ctorArgs.length];
            for (int i = 0; i < this.ctorArgs.length; ++i) {
                args[i] = this.ctorArgs[i];
            }
        }
        Schema s = null;
        if (this.inputArgsSchema != null) {
            s = this.inputArgsSchema.clone();
        }
        return new FuncSpec(this.className, args, s);
    }
}

