/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.HDataType;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.NullableUnknownWritable;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class POMultiQueryPackage
extends POPackage {
    private static final long serialVersionUID = 1L;
    private static int idxPart = 127;
    private List<POPackage> packages = new ArrayList<POPackage>();
    private ArrayList<Boolean> isKeyWrapped = new ArrayList();
    private boolean sameMapKeyType = true;
    private boolean inCombiner = false;
    private transient PigNullableWritable myKey;

    public POMultiQueryPackage(OperatorKey k) {
        this(k, -1, null);
    }

    public POMultiQueryPackage(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POMultiQueryPackage(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public POMultiQueryPackage(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    @Override
    public String name() {
        return "MultiQuery Package [" + this.isKeyWrapped + "] - " + this.getOperatorKey().toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitMultiQueryPackage(this);
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public void attachInput(PigNullableWritable k, Iterator<NullableTuple> inp) {
        this.tupIter = inp;
        this.myKey = k;
    }

    @Override
    public void detachInput() {
        this.tupIter = null;
        this.myKey = null;
    }

    public void addPackage(POPackage pack) {
        this.packages.add(pack);
    }

    public void addPackage(POPackage pack, byte mapKeyType) {
        this.packages.add(pack);
        this.isKeyWrapped.add(mapKeyType != 110);
    }

    public List<POPackage> getPackages() {
        return this.packages;
    }

    @Override
    public Result getNextTuple() throws ExecException {
        byte by = this.myKey.getIndex();
        int index = by;
        if ((index &= idxPart) >= this.packages.size() || index < 0) {
            int errCode = 2140;
            String msg = "Invalid package index " + index + " should be in the range between 0 and " + this.packages.size();
            throw new ExecException(msg, errCode, 4);
        }
        POPackage pack = this.packages.get(index);
        PigNullableWritable curKey = this.myKey;
        if (!this.sameMapKeyType && !this.inCombiner && this.isKeyWrapped.get(index).booleanValue()) {
            Tuple tup = (Tuple)this.myKey.getValueAsPigType();
            curKey = HDataType.getWritableComparableTypes(tup.get(0), pack.getKeyType());
            curKey.setIndex(by);
        }
        pack.attachInput(curKey, this.tupIter);
        Result res = pack.getNextTuple();
        pack.detachInput();
        Tuple tuple = (Tuple)res.result;
        Object obj = tuple.get(0);
        if (obj instanceof PigNullableWritable) {
            ((PigNullableWritable)obj).setIndex(by);
        } else {
            PigNullableWritable myObj = null;
            if (obj == null) {
                myObj = new NullableUnknownWritable();
                myObj.setNull(true);
            } else {
                myObj = HDataType.getWritableComparableTypes(obj, HDataType.findTypeFromNullableWritable(curKey));
            }
            myObj.setIndex(by);
            tuple.set(0, myObj);
        }
        return res;
    }

    public List<Boolean> getIsKeyWrappedList() {
        return Collections.unmodifiableList(this.isKeyWrapped);
    }

    public void addIsKeyWrappedList(List<Boolean> lst) {
        for (Boolean b : lst) {
            this.isKeyWrapped.add(b);
        }
    }

    public void setInCombiner(boolean inCombiner) {
        this.inCombiner = inCombiner;
    }

    public boolean isInCombiner() {
        return this.inCombiner;
    }

    public void setSameMapKeyType(boolean sameMapKeyType) {
        this.sameMapKeyType = sameMapKeyType;
    }

    public boolean isSameMapKeyType() {
        return this.sameMapKeyType;
    }
}

