/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.io;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.pig.data.InterSedes;
import org.apache.pig.data.InterSedesFactory;
import org.apache.pig.data.Tuple;

public class TFileRecordReader
extends RecordReader<Text, Tuple> {
    private long start;
    private long end;
    TFile.Reader reader = null;
    TFile.Reader.Scanner scanner = null;
    private Tuple value = null;
    private FSDataInputStream fileIn = null;
    private static InterSedes sedes = InterSedesFactory.getInterSedesInstance();

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        FileSplit split = (FileSplit)genericSplit;
        Configuration job = context.getConfiguration();
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(job);
        this.fileIn = fs.open(split.getPath());
        this.reader = new TFile.Reader(this.fileIn, fs.getFileStatus(file).getLen(), job);
        this.scanner = this.reader.createScannerByByteRange(this.start, split.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextKeyValue() throws IOException {
        if (this.scanner.atEnd()) {
            this.value = null;
            return false;
        }
        DataInputStream in = this.scanner.entry().getValueStream();
        try {
            this.value = (Tuple)sedes.readDatum(in);
        }
        finally {
            in.close();
        }
        this.scanner.advance();
        return true;
    }

    public Text getCurrentKey() {
        return null;
    }

    public Tuple getCurrentValue() {
        return this.value;
    }

    public float getProgress() throws IOException {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.fileIn.getPos() - this.start) / (float)(this.end - this.start));
    }

    public synchronized void close() throws IOException {
        if (this.scanner != null) {
            this.scanner.close();
        }
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.fileIn != null) {
            this.fileIn.close();
        }
    }
}

