/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FsShell;
import org.apache.pig.PigServer;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.impl.PigContext;
import org.apache.pig.scripting.BoundScript;
import org.apache.pig.scripting.ScriptEngine;
import org.apache.pig.scripting.ScriptPigContext;
import org.apache.pig.tools.grunt.GruntParser;

public class Pig {
    private static final Log LOG = LogFactory.getLog(Pig.class);
    private static List<String> defineCache = new ArrayList<String>();
    private static List<String> scriptUDFCache = new ArrayList<String>();
    private String script = null;
    private ScriptPigContext scriptContext = null;
    private String name = null;

    public static int fs(String cmd) throws IOException {
        ScriptPigContext ctx = Pig.getScriptContext();
        FsShell shell = new FsShell(ConfigurationUtil.toConfiguration(ctx.getPigContext().getProperties()));
        int code = -1;
        if (cmd != null) {
            String[] cmdTokens = cmd.split("\\s+");
            if (!cmdTokens[0].startsWith("-")) {
                cmdTokens[0] = "-" + cmdTokens[0];
            }
            try {
                code = shell.run(cmdTokens);
            }
            catch (Exception e) {
                throw new IOException("Run filesystem command failed", e);
            }
        }
        return code;
    }

    public static int sql(String cmd) throws IOException {
        ScriptPigContext ctx = Pig.getScriptContext();
        if (!ctx.getPigContext().getProperties().get("pig.sql.type").equals("hcat")) {
            throw new IOException("sql command only support hcat currently");
        }
        if (ctx.getPigContext().getProperties().get("hcat.bin") == null) {
            throw new IOException("hcat.bin is not defined. Define it to be your hcat script (Usually $HCAT_HOME/bin/hcat");
        }
        String hcatBin = (String)ctx.getPigContext().getProperties().get("hcat.bin");
        if (new File("hcat.bin").exists()) {
            throw new IOException(hcatBin + " does not exist. Please check your 'hcat.bin' setting in pig.properties.");
        }
        int ret = GruntParser.runSQLCommand(hcatBin, cmd, false);
        return ret;
    }

    public static void registerJar(String jarfile) throws IOException {
        LOG.info((Object)("Register jar: " + jarfile));
        ScriptPigContext ctx = Pig.getScriptContext();
        PigServer pigServer = new PigServer(ctx.getPigContext(), false);
        pigServer.registerJar(jarfile);
    }

    public static void registerUDF(String udffile, String namespace) throws IOException {
        LOG.info((Object)("Register script UFD file: " + udffile));
        ScriptPigContext ctx = Pig.getScriptContext();
        ScriptEngine engine = ctx.getScriptEngine();
        if (namespace != null && namespace.isEmpty()) {
            namespace = null;
        }
        engine.registerFunctions(udffile, namespace, ctx.getPigContext());
        Pig.addRegisterScriptUDFClause(udffile, namespace);
    }

    public static void define(String alias, String definition) throws IOException {
        LOG.info((Object)("Add define clause: " + alias + " -- " + definition));
        Pig.addDefineClause(alias, definition);
    }

    public static void set(String var, String value) throws IOException {
        ScriptPigContext ctx = Pig.getScriptContext();
        PigServer pigServer = new PigServer(ctx.getPigContext(), false);
        pigServer.getPigContext().getProperties().setProperty(var, value);
    }

    public static Pig compile(String pl) throws IOException {
        return Pig.compile(null, pl);
    }

    public static Pig compile(String name, String pl) throws IOException {
        ScriptPigContext ctx = Pig.getScriptContext();
        StringBuilder sb = new StringBuilder();
        sb.append(Pig.getRegisterScriptUDFClauses()).append(Pig.getDefineClauses());
        sb.append(pl).append("\n");
        return new Pig(sb.toString(), ctx, name);
    }

    public static Pig compileFromFile(String filename) throws IOException {
        return Pig.compileFromFile(null, filename);
    }

    public static Pig compileFromFile(String name, String filename) throws IOException {
        return Pig.compile(name, Pig.getScriptFromFile(filename));
    }

    public BoundScript bind(Map<String, Object> vars) throws IOException {
        return new BoundScript(this.replaceParameters(this.script, vars), this.scriptContext, this.name);
    }

    public BoundScript bind(List<Map<String, Object>> vars) throws IOException {
        ArrayList<String> lst = new ArrayList<String>();
        for (Map<String, Object> var : vars) {
            lst.add(this.replaceParameters(this.script, var));
        }
        return new BoundScript(lst, this.scriptContext, this.name);
    }

    public BoundScript bind() throws IOException {
        ScriptEngine engine = this.scriptContext.getScriptEngine();
        int index = this.script.indexOf(36);
        if (index == -1) {
            return new BoundScript(this.script, this.scriptContext, this.name);
        }
        Map<String, Object> vars = engine.getParamsFromVariables();
        return this.bind(vars);
    }

    protected Pig(String script, ScriptPigContext scriptContext, String name) {
        this.script = script;
        this.scriptContext = scriptContext;
        this.name = name;
    }

    private String replaceParameters(String qstr, Map<String, Object> vars) throws IOException {
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : vars.entrySet()) {
            params.add(entry.getKey() + "=" + Pig.fixNonEscapedDollarSign(entry.getValue().toString()));
        }
        PigContext context = Pig.getScriptContext().getPigContext();
        List<String> contextParams = context.getParams();
        if (contextParams != null) {
            for (String param : contextParams) {
                params.add(param);
            }
        }
        BufferedReader reader = new BufferedReader(new StringReader(qstr));
        String substituted = context.doParamSubstitution(reader, params, context.getParamFiles());
        context.setParams(contextParams);
        return substituted;
    }

    private static String fixNonEscapedDollarSign(String s) {
        String[] tkns = s.split("\\$", -1);
        if (tkns.length == 1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tkns.length - 1; ++i) {
            if (tkns[i].isEmpty()) {
                sb.append("\\\\");
            } else {
                sb.append(tkns[i]);
                if (tkns[i].charAt(tkns[i].length() - 1) != '\\') {
                    sb.append("\\\\");
                }
            }
            sb.append("$");
        }
        sb.append(tkns[tkns.length - 1]);
        return sb.toString();
    }

    private static String getScriptFromFile(String filename) throws IOException {
        LineNumberReader rd = new LineNumberReader(new FileReader(filename));
        StringBuilder sb = new StringBuilder();
        String line = rd.readLine();
        while (line != null) {
            sb.append(line);
            sb.append("\n");
            line = rd.readLine();
        }
        rd.close();
        return sb.toString();
    }

    private static void addDefineClause(String alias, String definition) {
        defineCache.add("DEFINE " + alias + " " + definition + ";\n");
    }

    private static void addRegisterScriptUDFClause(String path, String namespace) throws IOException {
        ScriptPigContext ctx = Pig.getScriptContext();
        ScriptEngine engine = ctx.getScriptEngine();
        String clause = "REGISTER '" + path + "' USING " + engine.getScriptingLang();
        if (namespace != null && !namespace.isEmpty()) {
            clause = clause + " AS " + namespace;
        }
        scriptUDFCache.add(clause + ";\n");
    }

    private static String getDefineClauses() {
        StringBuilder sb = new StringBuilder();
        for (String def : defineCache) {
            sb.append(def);
        }
        return sb.toString();
    }

    private static String getRegisterScriptUDFClauses() {
        StringBuilder sb = new StringBuilder();
        for (String udf : scriptUDFCache) {
            sb.append(udf);
        }
        return sb.toString();
    }

    private static ScriptPigContext getScriptContext() throws IOException {
        ScriptPigContext ctx = ScriptPigContext.get();
        if (ctx == null) {
            throw new IOException("Script context is not set");
        }
        return ctx;
    }
}

