/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.kettle;

import javax.sql.DataSource;
import org.pentaho.di.core.database.DataSourceNamingException;
import org.pentaho.di.core.database.DataSourceProviderFactory;
import org.pentaho.di.core.database.DataSourceProviderInterface;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.data.IJndiDatasourceService;
import org.pentaho.platform.api.data.IPooledDatasourceService;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class PlatformKettleDataSourceProvider
implements DataSourceProviderInterface {
    protected static final PlatformKettleDataSourceProvider instance = new PlatformKettleDataSourceProvider();

    private PlatformKettleDataSourceProvider() {
    }

    public DataSourceProviderInterface getInstance() {
        return instance;
    }

    protected static void hookupProvider() {
        DataSourceProviderFactory.setDataSourceProviderInterface((DataSourceProviderInterface)instance);
    }

    protected <T extends IDBDatasourceService> DataSource getNamedDataSourceFromService(Class<T> dataSourceServiceInterface, String dataSourceName) throws DataSourceNamingException {
        IDBDatasourceService service;
        IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.get(dataSourceServiceInterface, null);
        IDBDatasourceService iDBDatasourceService = service = datasourceService == null ? (IDBDatasourceService)PentahoSystem.get(IDBDatasourceService.class, null) : datasourceService;
        if (service != null) {
            try {
                return service.getDataSource(dataSourceName);
            }
            catch (DBDatasourceServiceException ex) {
                throw new DataSourceNamingException((Throwable)ex);
            }
        }
        return null;
    }

    public DataSource getNamedDataSource(String dataSourceName) throws DataSourceNamingException {
        return this.getNamedDataSourceFromService(IDBDatasourceService.class, dataSourceName);
    }

    public DataSource getNamedDataSource(String dataSourceName, DataSourceProviderInterface.DatasourceType type) throws DataSourceNamingException {
        if (type != null) {
            switch (type) {
                case JNDI: {
                    return this.getNamedDataSourceFromService(IJndiDatasourceService.class, dataSourceName);
                }
                case POOLED: {
                    return this.getNamedDataSourceFromService(IPooledDatasourceService.class, dataSourceName);
                }
            }
        }
        throw new DataSourceNamingException(String.format("Unknown data source type [%s] for named data source [%s]", type, dataSourceName));
    }
}

