/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.windows;

import edu.stanford.ejalbert.launching.BrowserDescription;

public class WindowsBrowser
implements BrowserDescription {
    private final String displayName;
    private final String exe;
    private final String forceWindowArgs;
    private String pathToExe = null;
    private final String subDirName;

    WindowsBrowser(String delimChar, String configInfo) {
        String[] configItems = configInfo.split(delimChar, 4);
        this.displayName = configItems[0];
        this.exe = configItems[1];
        this.forceWindowArgs = configItems[2];
        this.subDirName = configItems[3];
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.displayName);
        buf.append(": ForceWindowArg=");
        buf.append(this.forceWindowArgs);
        buf.append("; SubDir name=");
        buf.append(this.subDirName);
        buf.append("; Path to exe=");
        if (this.pathToExe != null) {
            buf.append(this.pathToExe);
        }
        buf.append("; Exe name=");
        buf.append(this.exe);
        return buf.toString();
    }

    void setPathToExe(String path) {
        this.pathToExe = path;
        if (!this.pathToExe.endsWith("\\")) {
            StringBuffer buf = new StringBuffer(this.pathToExe.length() + 2);
            buf.append(this.pathToExe);
            buf.append('\\');
            this.pathToExe = buf.toString();
        }
    }

    String getPathToExe() {
        return this.pathToExe;
    }

    String getSubDirName() {
        return this.subDirName;
    }

    public String getBrowserDisplayName() {
        return this.displayName;
    }

    public String getBrowserApplicationName() {
        return this.exe;
    }

    public String getForceNewWindowArgs() {
        return this.forceWindowArgs;
    }
}

