/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.shell;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.gateway.shell.ClientContext;
import org.apache.hadoop.gateway.shell.ErrorResponse;
import org.apache.hadoop.gateway.shell.HadoopException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class Hadoop
implements Closeable {
    private static final String GATEWAY_CLIENT_TRUST_DEFAULT_PASS = "changeit";
    private static final String KNOX_CLIENT_TRUSTSTORE_PASS = "KNOX_CLIENT_TRUSTSTORE_PASS";
    private static final String GATEWAY_CLIENT_TRUST = "gateway-client-trust.jks";
    private static final String KNOX_CLIENT_TRUSTSTORE_FILENAME = "KNOX_CLIENT_TRUSTSTORE_FILENAME";
    private static final String KNOX_CLIENT_TRUSTSTORE_DIR = "KNOX_CLIENT_TRUSTSTORE_DIR";
    String base;
    HttpHost host;
    CloseableHttpClient client;
    BasicHttpContext context;
    ExecutorService executor;
    Map<String, String> headers = new HashMap<String, String>();

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public static Hadoop login(String url, Map<String, String> headers) throws URISyntaxException {
        Hadoop instance = new Hadoop(ClientContext.with(url));
        instance.setHeaders(headers);
        return instance;
    }

    public static Hadoop login(String url, String username, String password) throws URISyntaxException {
        return new Hadoop(ClientContext.with(username, password, url));
    }

    public static Hadoop loginInsecure(String url, String username, String password) throws URISyntaxException {
        return new Hadoop(ClientContext.with(username, password, url).connection().secure(false).end());
    }

    public Hadoop(ClientContext clientContext) throws HadoopException, URISyntaxException {
        this.executor = Executors.newCachedThreadPool();
        this.base = clientContext.url();
        try {
            this.client = this.createClient(clientContext);
        }
        catch (GeneralSecurityException e) {
            throw new HadoopException("Failed to create HTTP client.", e);
        }
    }

    private CloseableHttpClient createClient(ClientContext clientContext) throws GeneralSecurityException {
        Object hostnameVerifier = NoopHostnameVerifier.INSTANCE;
        TrustSelfSignedStrategy trustStrategy = null;
        if (clientContext.connection().secure()) {
            hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
        } else {
            trustStrategy = TrustSelfSignedStrategy.INSTANCE;
            System.out.println("**************** WARNING ******************\nThis is an insecure client instance and may\nleave the interactions subject to a man in\nthe middle attack. Please use the login()\nmethod instead of loginInsecure() for any\nsensitive or production usecases.\n*******************************************");
        }
        KeyStore trustStore = Hadoop.getTrustStore();
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(trustStore, (TrustStrategy)trustStrategy).build();
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier)).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(clientContext.pool().maxTotal());
        connectionManager.setDefaultMaxPerRoute(clientContext.pool().defaultMaxPerRoute());
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setBufferSize(clientContext.connection().bufferSize()).build();
        connectionManager.setDefaultConnectionConfig(connectionConfig);
        SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(clientContext.socket().keepalive()).setSoLinger(clientContext.socket().linger()).setSoReuseAddress(clientContext.socket().reuseAddress()).setSoTimeout(clientContext.socket().timeout()).setTcpNoDelay(clientContext.socket().tcpNoDelay()).build();
        connectionManager.setDefaultSocketConfig(socketConfig);
        URI uri = URI.create(clientContext.url());
        this.host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        BasicCredentialsProvider credentialsProvider = null;
        if (clientContext.username() != null && clientContext.password() != null) {
            credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.host.getHostName(), this.host.getPort()), (Credentials)new UsernamePasswordCredentials(clientContext.username(), clientContext.password()));
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme authScheme = new BasicScheme();
            authCache.put(this.host, (AuthScheme)authScheme);
            this.context = new BasicHttpContext();
            this.context.setAttribute("http.auth.auth-cache", (Object)authCache);
        }
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultCredentialsProvider(credentialsProvider).build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore getTrustStore() throws GeneralSecurityException {
        String truststorePass;
        String truststoreFileName;
        KeyStore ks = null;
        String truststoreDir = System.getenv(KNOX_CLIENT_TRUSTSTORE_DIR);
        if (truststoreDir == null) {
            truststoreDir = System.getProperty("user.home");
        }
        if ((truststoreFileName = System.getenv(KNOX_CLIENT_TRUSTSTORE_FILENAME)) == null) {
            truststoreFileName = GATEWAY_CLIENT_TRUST;
        }
        if ((truststorePass = System.getenv(KNOX_CLIENT_TRUSTSTORE_PASS)) == null) {
            truststorePass = GATEWAY_CLIENT_TRUST_DEFAULT_PASS;
        }
        FileInputStream is = null;
        try {
            ks = KeyStore.getInstance("JKS");
            File file = new File(truststoreDir, truststoreFileName);
            if (!file.exists()) {
                String truststore = System.getProperty("javax.net.ssl.trustStore");
                if (truststore == null) {
                    truststoreDir = System.getProperty("java.home");
                    truststore = truststoreDir + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
                    truststorePass = System.getProperty("javax.net.ssl.trustStorePassword", GATEWAY_CLIENT_TRUST_DEFAULT_PASS);
                }
                file = new File(truststore);
            }
            if (!file.exists()) throw new HadoopException("Unable to find a truststore for secure login.Please import the gateway-identity certificate into the JVM truststore or set the truststore location ENV variables.");
            is = new FileInputStream(file);
            ks.load(is, truststorePass.toCharArray());
        }
        catch (KeyStoreException e) {
            try {
                throw new HadoopException("Unable to create keystore of expected type.", e);
                catch (FileNotFoundException e2) {
                    throw new HadoopException("Unable to read truststore. Please import the gateway-identity certificate into the JVM truststore or set the truststore location ENV variables.", e2);
                }
                catch (NoSuchAlgorithmException e3) {
                    throw new HadoopException("Unable to load the truststore. Please import the gateway-identity certificate into the JVM truststore or set the truststore location ENV variables.", e3);
                }
                catch (CertificateException e4) {
                    throw new HadoopException("Certificate cannot be found in the truststore. Please import the gateway-identity certificate into the JVM truststore or set the truststore location ENV variables.", e4);
                }
                catch (IOException e5) {
                    throw new HadoopException("Unable to load truststore. May be related to password setting or truststore format.", e5);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return ks;
    }

    public String base() {
        return this.base;
    }

    public CloseableHttpResponse executeNow(HttpRequest request) throws IOException {
        CloseableHttpResponse response = this.client.execute(this.host, request, (HttpContext)this.context);
        if (response.getStatusLine().getStatusCode() < 400) {
            return response;
        }
        throw new ErrorResponse((HttpResponse)response);
    }

    public <T> Future<T> executeLater(Callable<T> callable) {
        return this.executor.submit(callable);
    }

    public void waitFor(Future<?> ... futures) throws ExecutionException, InterruptedException {
        if (futures != null) {
            for (Future<?> future : futures) {
                future.get();
            }
        }
    }

    public void waitFor(long timeout, TimeUnit units, Future<?> ... futures) throws ExecutionException, TimeoutException, InterruptedException {
        if (futures != null) {
            timeout = TimeUnit.MILLISECONDS.convert(timeout, units);
            for (Future<?> future : futures) {
                long start = System.currentTimeMillis();
                future.get(timeout, TimeUnit.MILLISECONDS);
                timeout -= System.currentTimeMillis() - start;
            }
        }
    }

    public void shutdown() throws InterruptedException {
        this.executor.shutdownNow();
    }

    public boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        this.executor.shutdown();
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public void close() throws IOException {
        try {
            this.shutdown();
        }
        catch (InterruptedException e) {
            throw new HadoopException("Can not shutdown underlying resources", e);
        }
        finally {
            this.client.close();
        }
    }
}

